/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.http.rest.ReflectionSerializable;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.ItemPage;
import com.azure.core.implementation.serializer.MalformedValueException;
import com.azure.core.util.Base64Url;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import reactor.core.publisher.Mono;

public final class HttpResponseBodyDecoder {
    private static final ClientLogger LOGGER = new ClientLogger(HttpResponseBodyDecoder.class);

    static Object decodeByteArray(byte[] body, HttpResponse httpResponse, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse.getStatusCode(), decodeData)) {
            try {
                return HttpResponseBodyDecoder.deserializeBody(body, decodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType(), null, serializer, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
            }
            catch (MalformedValueException | IOException | IllegalStateException ex) {
                LOGGER.warning("Failed to deserialize the error entity.", ex);
                return ex;
            }
        }
        if (!decodeData.isReturnTypeDecodeable()) {
            return null;
        }
        byte[] bodyAsByteArray = body == null ? httpResponse.getBodyAsBinaryData().toBytes() : body;
        try {
            return HttpResponseBodyDecoder.deserializeBody(bodyAsByteArray, HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData), decodeData.getReturnValueWireType(), serializer, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
        }
        catch (MalformedValueException e) {
            throw new HttpResponseException("HTTP response has a malformed body.", httpResponse, e);
        }
        catch (IOException e) {
            throw new HttpResponseException("Deserialization Failed.", httpResponse, e);
        }
    }

    static Type decodedType(HttpResponse httpResponse, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse.getStatusCode(), decodeData)) {
            return decodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType();
        }
        return decodeData.isReturnTypeDecodeable() ? HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData) : null;
    }

    static boolean isErrorStatus(int statusCode, HttpResponseDecodeData decodeData) {
        return !decodeData.isExpectedResponseStatusCode(statusCode);
    }

    private static Object deserializeBody(byte[] value, Type resultType, Type wireType, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        if (wireType == null) {
            return HttpResponseBodyDecoder.deserialize(value, resultType, serializer, encoding);
        }
        if (TypeUtil.isTypeOrSubTypeOf(wireType, Page.class)) {
            Type wireResponseType = wireType == Page.class ? TypeUtil.createParameterizedType(ItemPage.class, new Type[]{resultType}) : wireType;
            return HttpResponseBodyDecoder.deserialize(value, wireResponseType, serializer, encoding);
        }
        Type wireResponseType = HttpResponseBodyDecoder.constructWireResponseType(resultType, wireType);
        Object wireResponse = HttpResponseBodyDecoder.deserialize(value, wireResponseType, serializer, encoding);
        return HttpResponseBodyDecoder.convertToResultType(wireResponse, resultType, wireType);
    }

    private static Object deserialize(byte[] value, Type type, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        Class<?> rawType = TypeUtil.getRawClass(type);
        if (encoding == SerializerEncoding.JSON && ReflectionSerializable.supportsJsonSerializable(rawType)) {
            return ReflectionSerializable.deserializeAsJsonSerializable(rawType, value);
        }
        if (encoding == SerializerEncoding.XML && ReflectionSerializable.supportsXmlSerializable(rawType)) {
            return ReflectionSerializable.deserializeAsXmlSerializable(rawType, value);
        }
        return serializer.deserialize(value, type, encoding);
    }

    private static Type constructWireResponseType(Type resultType, Type wireType) {
        Objects.requireNonNull(wireType);
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                return Base64Url.class;
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                return DateTimeRfc1123.class;
            }
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                Type wireResponseElementType = HttpResponseBodyDecoder.constructWireResponseType(resultElementType, wireType);
                return TypeUtil.createParameterizedType(((ParameterizedType)resultType).getRawType(), wireResponseElementType);
            }
            if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type[] typeArguments = TypeUtil.getTypeArguments(resultType);
                Type resultValueType = typeArguments[1];
                Type wireResponseValueType = HttpResponseBodyDecoder.constructWireResponseType(resultValueType, wireType);
                return TypeUtil.createParameterizedType(((ParameterizedType)resultType).getRawType(), typeArguments[0], wireResponseValueType);
            }
        }
        return resultType;
    }

    private static Object convertToResultType(Object wireResponse, Type resultType, Type wireType) {
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                return ((Base64Url)wireResponse).decodedBytes();
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                return ((DateTimeRfc1123)wireResponse).getDateTime();
            }
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                List wireResponseList = (List)wireResponse;
                int wireResponseListSize = wireResponseList.size();
                for (int i = 0; i < wireResponseListSize; ++i) {
                    Object resultElement;
                    Object wireResponseElement = wireResponseList.get(i);
                    if (wireResponseElement == (resultElement = HttpResponseBodyDecoder.convertToResultType(wireResponseElement, resultElementType, wireType))) continue;
                    wireResponseList.set(i, resultElement);
                }
                return wireResponseList;
            }
            if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type resultValueType = TypeUtil.getTypeArguments(resultType)[1];
                Map wireResponseMap = (Map)wireResponse;
                Set wireResponseEntries = wireResponseMap.entrySet();
                for (Map.Entry wireResponseEntry : wireResponseEntries) {
                    Object resultValue;
                    Object wireResponseValue = wireResponseEntry.getValue();
                    if (wireResponseValue == (resultValue = HttpResponseBodyDecoder.convertToResultType(wireResponseValue, resultValueType, wireType))) continue;
                    wireResponseMap.put((String)wireResponseEntry.getKey(), resultValue);
                }
                return wireResponseMap;
            }
        }
        return wireResponse;
    }

    private static Type extractEntityTypeFromReturnType(HttpResponseDecodeData decodeData) {
        Type token = decodeData.getReturnType();
        if (TypeUtil.isTypeOrSubTypeOf(token, Mono.class)) {
            token = TypeUtil.getTypeArgument(token);
        }
        if (TypeUtil.isTypeOrSubTypeOf(token, Response.class)) {
            token = TypeUtil.getRestResponseBodyType(token);
        }
        return token;
    }

    private static void ensureRequestSet(HttpResponse httpResponse) {
        Objects.requireNonNull(httpResponse.getRequest());
        Objects.requireNonNull(httpResponse.getRequest().getHttpMethod());
    }
}

