/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections4.Predicate;

final class FunctorUtils {
    static <R extends java.util.function.Predicate<T>, P extends java.util.function.Predicate<? super T>, T> R coerce(P predicate) {
        return (R)predicate;
    }

    static <R extends Function<I, O>, P extends Function<? super I, ? extends O>, I, O> R coerce(P transformer) {
        return (R)transformer;
    }

    static <T extends Consumer<?>> T[] copy(T ... consumers) {
        if (consumers == null) {
            return null;
        }
        return (Consumer[])consumers.clone();
    }

    static <T extends java.util.function.Predicate<?>> T[] copy(T ... predicates) {
        if (predicates == null) {
            return null;
        }
        return (java.util.function.Predicate[])predicates.clone();
    }

    static <T extends Function<?, ?>> T[] copy(T ... transformers) {
        if (transformers == null) {
            return null;
        }
        return (Function[])transformers.clone();
    }

    static <T> Predicate<? super T>[] validate(Collection<? extends java.util.function.Predicate<? super T>> predicates) {
        Objects.requireNonNull(predicates, "predicates");
        Predicate[] preds = new Predicate[predicates.size()];
        int i = 0;
        for (java.util.function.Predicate<T> predicate : predicates) {
            preds[i] = (Predicate)predicate;
            if (preds[i] == null) {
                throw new NullPointerException("predicates[" + i + "]");
            }
            ++i;
        }
        return preds;
    }

    static void validate(Consumer<?> ... consumers) {
        Objects.requireNonNull(consumers, "closures");
        for (int i = 0; i < consumers.length; ++i) {
            if (consumers[i] != null) continue;
            throw new NullPointerException("closures[" + i + "]");
        }
    }

    static void validate(Function<?, ?> ... functions) {
        Objects.requireNonNull(functions, "functions");
        for (int i = 0; i < functions.length; ++i) {
            if (functions[i] != null) continue;
            throw new NullPointerException("functions[" + i + "]");
        }
    }

    static void validate(java.util.function.Predicate<?> ... predicates) {
        Objects.requireNonNull(predicates, "predicates");
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i] != null) continue;
            throw new NullPointerException("predicates[" + i + "]");
        }
    }

    private FunctorUtils() {
    }
}

