/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.azure.resourcemanager.network.fluent.models.RouteFilterPropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.RouteFilterRuleInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class RouteFilterInner
extends Resource {
    @JsonProperty(value="properties")
    private RouteFilterPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private RouteFilterPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public RouteFilterInner withId(String id) {
        this.id = id;
        return this;
    }

    public RouteFilterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RouteFilterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<RouteFilterRuleInner> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    public RouteFilterInner withRules(List<RouteFilterRuleInner> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteFilterPropertiesFormat();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    public List<ExpressRouteCircuitPeeringInner> peerings() {
        return this.innerProperties() == null ? null : this.innerProperties().peerings();
    }

    public List<ExpressRouteCircuitPeeringInner> ipv6Peerings() {
        return this.innerProperties() == null ? null : this.innerProperties().ipv6Peerings();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

