/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitAuthorizationInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.azure.resourcemanager.network.implementation.ExpressRouteCircuitPeeringImpl;
import com.azure.resourcemanager.network.implementation.ExpressRouteCircuitPeeringsImpl;
import com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.azure.resourcemanager.network.models.ExpressRouteCircuit;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeering;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeerings;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitServiceProviderProperties;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitSkuType;
import com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

class ExpressRouteCircuitImpl
extends GroupableParentResourceWithTagsImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl, NetworkManager>
implements ExpressRouteCircuit,
ExpressRouteCircuit.Definition,
ExpressRouteCircuit.Update {
    private ExpressRouteCircuitPeeringsImpl peerings;
    private Map<String, ExpressRouteCircuitPeering> expressRouteCircuitPeerings;

    ExpressRouteCircuitImpl(String name, ExpressRouteCircuitInner innerObject, NetworkManager manager) {
        super(name, innerObject, manager);
        this.initializeChildrenFromInner();
    }

    @Override
    public ExpressRouteCircuitImpl withServiceProvider(String serviceProviderName) {
        this.ensureServiceProviderProperties().withServiceProviderName(serviceProviderName);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withPeeringLocation(String location) {
        this.ensureServiceProviderProperties().withPeeringLocation(location);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withBandwidthInMbps(int bandwidthInMbps) {
        this.ensureServiceProviderProperties().withBandwidthInMbps(bandwidthInMbps);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withSku(ExpressRouteCircuitSkuType sku) {
        ((ExpressRouteCircuitInner)((Object)this.innerModel())).withSku(sku.sku());
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withClassicOperations() {
        ((ExpressRouteCircuitInner)((Object)this.innerModel())).withAllowClassicOperations(true);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withoutClassicOperations() {
        ((ExpressRouteCircuitInner)((Object)this.innerModel())).withAllowClassicOperations(false);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withAuthorization(String authorizationName) {
        this.ensureAuthorizations().add(new ExpressRouteCircuitAuthorizationInner().withName(authorizationName));
        return this;
    }

    private List<ExpressRouteCircuitAuthorizationInner> ensureAuthorizations() {
        if (((ExpressRouteCircuitInner)((Object)this.innerModel())).authorizations() == null) {
            ((ExpressRouteCircuitInner)((Object)this.innerModel())).withAuthorizations(new ArrayList<ExpressRouteCircuitAuthorizationInner>());
        }
        return ((ExpressRouteCircuitInner)((Object)this.innerModel())).authorizations();
    }

    private ExpressRouteCircuitServiceProviderProperties ensureServiceProviderProperties() {
        if (((ExpressRouteCircuitInner)((Object)this.innerModel())).serviceProviderProperties() == null) {
            ((ExpressRouteCircuitInner)((Object)this.innerModel())).withServiceProviderProperties(new ExpressRouteCircuitServiceProviderProperties());
        }
        return ((ExpressRouteCircuitInner)((Object)this.innerModel())).serviceProviderProperties();
    }

    protected Mono<ExpressRouteCircuitInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCircuits().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ExpressRouteCircuitInner)((Object)this.innerModel()));
    }

    protected void initializeChildrenFromInner() {
        this.expressRouteCircuitPeerings = new HashMap<String, ExpressRouteCircuitPeering>();
        if (((ExpressRouteCircuitInner)((Object)this.innerModel())).peerings() != null) {
            for (ExpressRouteCircuitPeeringInner peering : ((ExpressRouteCircuitInner)((Object)this.innerModel())).peerings()) {
                this.expressRouteCircuitPeerings.put(peering.name(), new ExpressRouteCircuitPeeringImpl(this, peering, ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCircuitPeerings(), peering.peeringType()));
            }
        }
    }

    protected Mono<ExpressRouteCircuitInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCircuits().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Mono<ExpressRouteCircuit> refreshAsync() {
        return super.refreshAsync().map(expressRouteCircuit -> {
            ExpressRouteCircuitImpl impl = (ExpressRouteCircuitImpl)expressRouteCircuit;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    @Override
    protected Mono<ExpressRouteCircuitInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCircuits().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((ExpressRouteCircuitInner)((Object)this.innerModel())).tags()));
    }

    @Override
    public ExpressRouteCircuitPeerings peerings() {
        if (this.peerings == null) {
            this.peerings = new ExpressRouteCircuitPeeringsImpl(this);
        }
        return this.peerings;
    }

    @Override
    public ExpressRouteCircuitSkuType sku() {
        return ExpressRouteCircuitSkuType.fromSku(((ExpressRouteCircuitInner)((Object)this.innerModel())).sku());
    }

    @Override
    public boolean isAllowClassicOperations() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ExpressRouteCircuitInner)((Object)this.innerModel())).allowClassicOperations());
    }

    @Override
    public String circuitProvisioningState() {
        return ((ExpressRouteCircuitInner)((Object)this.innerModel())).circuitProvisioningState();
    }

    @Override
    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return ((ExpressRouteCircuitInner)((Object)this.innerModel())).serviceProviderProvisioningState();
    }

    @Override
    public String serviceKey() {
        return ((ExpressRouteCircuitInner)((Object)this.innerModel())).serviceKey();
    }

    @Override
    public String serviceProviderNotes() {
        return ((ExpressRouteCircuitInner)((Object)this.innerModel())).serviceProviderNotes();
    }

    @Override
    public ExpressRouteCircuitServiceProviderProperties serviceProviderProperties() {
        return ((ExpressRouteCircuitInner)((Object)this.innerModel())).serviceProviderProperties();
    }

    @Override
    public String provisioningState() {
        return ((ExpressRouteCircuitInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public Map<String, ExpressRouteCircuitPeering> peeringsMap() {
        return this.expressRouteCircuitPeerings;
    }
}

