/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.service.model.TaskNode;
import org.apache.dolphinscheduler.service.process.WorkflowDag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DagHelper.class);

    public static DAG<Long, TaskNode, TaskNodeRelation> buildDagGraph(WorkflowDag workflowDag) {
        DAG dag = new DAG();
        if (CollectionUtils.isNotEmpty(workflowDag.getNodes())) {
            for (TaskNode node : workflowDag.getNodes()) {
                dag.addNode((Object)node.getCode(), (Object)node);
            }
        }
        if (CollectionUtils.isNotEmpty(workflowDag.getEdges())) {
            for (TaskNodeRelation edge : workflowDag.getEdges()) {
                dag.addEdge((Object)edge.getStartNode(), (Object)edge.getEndNode());
            }
        }
        return dag;
    }

    public static WorkflowDag getWorkflowDag(List<TaskNode> taskNodeList, List<WorkflowTaskRelation> workflowTaskRelations) {
        HashMap taskNodeMap = new HashMap();
        taskNodeList.forEach(taskNode -> taskNodeMap.putIfAbsent(taskNode.getCode(), taskNode));
        ArrayList<TaskNodeRelation> taskNodeRelations = new ArrayList<TaskNodeRelation>();
        for (WorkflowTaskRelation workflowTaskRelation : workflowTaskRelations) {
            long preTaskCode = workflowTaskRelation.getPreTaskCode();
            long postTaskCode = workflowTaskRelation.getPostTaskCode();
            if (workflowTaskRelation.getPreTaskCode() == 0L || !taskNodeMap.containsKey(preTaskCode) || !taskNodeMap.containsKey(postTaskCode)) continue;
            TaskNode preNode = (TaskNode)taskNodeMap.get(preTaskCode);
            TaskNode postNode = (TaskNode)taskNodeMap.get(postTaskCode);
            taskNodeRelations.add(new TaskNodeRelation(Long.valueOf(preNode.getCode()), Long.valueOf(postNode.getCode())));
        }
        WorkflowDag workflowDag = new WorkflowDag();
        workflowDag.setEdges(taskNodeRelations);
        workflowDag.setNodes(taskNodeList);
        return workflowDag;
    }
}

