/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.fluent.models.EHNamespaceProperties;
import com.azure.resourcemanager.eventhubs.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventhubs.models.Encryption;
import com.azure.resourcemanager.eventhubs.models.Identity;
import com.azure.resourcemanager.eventhubs.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class EHNamespaceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EHNamespaceInner.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="properties")
    private EHNamespaceProperties innerProperties;

    public Sku sku() {
        return this.sku;
    }

    public EHNamespaceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public EHNamespaceInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    private EHNamespaceProperties innerProperties() {
        return this.innerProperties;
    }

    public EHNamespaceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public EHNamespaceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    public String serviceBusEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBusEndpoint();
    }

    public String clusterArmId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterArmId();
    }

    public EHNamespaceInner withClusterArmId(String clusterArmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withClusterArmId(clusterArmId);
        return this;
    }

    public String metricId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricId();
    }

    public Boolean isAutoInflateEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isAutoInflateEnabled();
    }

    public EHNamespaceInner withIsAutoInflateEnabled(Boolean isAutoInflateEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withIsAutoInflateEnabled(isAutoInflateEnabled);
        return this;
    }

    public Integer maximumThroughputUnits() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumThroughputUnits();
    }

    public EHNamespaceInner withMaximumThroughputUnits(Integer maximumThroughputUnits) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withMaximumThroughputUnits(maximumThroughputUnits);
        return this;
    }

    public Boolean kafkaEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().kafkaEnabled();
    }

    public EHNamespaceInner withKafkaEnabled(Boolean kafkaEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withKafkaEnabled(kafkaEnabled);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public EHNamespaceInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public EHNamespaceInner withEncryption(Encryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public EHNamespaceInner withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public EHNamespaceInner withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public String alternateName() {
        return this.innerProperties() == null ? null : this.innerProperties().alternateName();
    }

    public EHNamespaceInner withAlternateName(String alternateName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withAlternateName(alternateName);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

