/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.HttpRequestLoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.ServiceRequestWrapper;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;

class AsyncLoadBalancerRequest
implements HttpRequestLoadBalancerRequest<ListenableFuture<ClientHttpResponse>> {
    private final LoadBalancerClient loadBalancer;
    private final ClientHttpRequestData clientHttpRequestData;

    AsyncLoadBalancerRequest(LoadBalancerClient loadBalancer, ClientHttpRequestData clientHttpRequestData) {
        this.loadBalancer = loadBalancer;
        this.clientHttpRequestData = clientHttpRequestData;
    }

    @Override
    public ListenableFuture<ClientHttpResponse> apply(ServiceInstance instance) throws Exception {
        ServiceRequestWrapper serviceRequest = new ServiceRequestWrapper(this.clientHttpRequestData.request, instance, this.loadBalancer);
        return this.clientHttpRequestData.execution.executeAsync((HttpRequest)serviceRequest, this.clientHttpRequestData.body);
    }

    @Override
    public HttpRequest getHttpRequest() {
        return this.clientHttpRequestData.request;
    }

    static class ClientHttpRequestData {
        private final HttpRequest request;
        private final byte[] body;
        private final AsyncClientHttpRequestExecution execution;

        ClientHttpRequestData(HttpRequest request, byte[] body, AsyncClientHttpRequestExecution execution) {
            this.request = request;
            this.body = body;
            this.execution = execution;
        }
    }
}

