/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngressFluent;
import io.kubernetes.client.openapi.models.V1PortStatus;
import io.kubernetes.client.openapi.models.V1PortStatusBuilder;
import io.kubernetes.client.openapi.models.V1PortStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1LoadBalancerIngressFluentImpl<A extends V1LoadBalancerIngressFluent<A>>
extends BaseFluent<A>
implements V1LoadBalancerIngressFluent<A> {
    private String hostname;
    private String ip;
    private List<V1PortStatusBuilder> ports;

    public V1LoadBalancerIngressFluentImpl() {
    }

    public V1LoadBalancerIngressFluentImpl(V1LoadBalancerIngress instance) {
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withPorts(instance.getPorts());
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    @Deprecated
    public A withNewHostname(String original) {
        return this.withHostname(new String(original));
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    @Deprecated
    public A withNewIp(String original) {
        return this.withIp(new String(original));
    }

    @Override
    public A addToPorts(int index, V1PortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1PortStatusBuilder>();
        }
        V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, V1PortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1PortStatusBuilder>();
        }
        V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(V1PortStatus ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1PortStatusBuilder>();
        }
        for (V1PortStatus item : items) {
            V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<V1PortStatus> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1PortStatusBuilder>();
        }
        for (V1PortStatus item : items) {
            V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(V1PortStatus ... items) {
        for (V1PortStatus item : items) {
            V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<V1PortStatus> items) {
        for (V1PortStatus item : items) {
            V1PortStatusBuilder builder = new V1PortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<V1PortStatusBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<V1PortStatusBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            V1PortStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PortStatus> getPorts() {
        return V1LoadBalancerIngressFluentImpl.build(this.ports);
    }

    @Override
    public List<V1PortStatus> buildPorts() {
        return V1LoadBalancerIngressFluentImpl.build(this.ports);
    }

    @Override
    public V1PortStatus buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public V1PortStatus buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public V1PortStatus buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public V1PortStatus buildMatchingPort(Predicate<V1PortStatusBuilder> predicate) {
        for (V1PortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<V1PortStatusBuilder> predicate) {
        for (V1PortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<V1PortStatus> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<V1PortStatusBuilder>();
            for (V1PortStatus item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(V1PortStatus ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (V1PortStatus item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public V1LoadBalancerIngressFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public V1LoadBalancerIngressFluent.PortsNested<A> addNewPortLike(V1PortStatus item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public V1LoadBalancerIngressFluent.PortsNested<A> setNewPortLike(int index, V1PortStatus item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public V1LoadBalancerIngressFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1LoadBalancerIngressFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public V1LoadBalancerIngressFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1LoadBalancerIngressFluent.PortsNested<A> editMatchingPort(Predicate<V1PortStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LoadBalancerIngressFluentImpl that = (V1LoadBalancerIngressFluentImpl)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.ports, super.hashCode());
    }

    public class PortsNestedImpl<N>
    extends V1PortStatusFluentImpl<V1LoadBalancerIngressFluent.PortsNested<N>>
    implements V1LoadBalancerIngressFluent.PortsNested<N>,
    Nested<N> {
        private final V1PortStatusBuilder builder;
        private final int index;

        PortsNestedImpl(int index, V1PortStatus item) {
            this.index = index;
            this.builder = new V1PortStatusBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new V1PortStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1LoadBalancerIngressFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

