/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oscar.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLArrayDataType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLValuesExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIntervalExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIntervalType;
import com.alibaba.druid.sql.dialect.oscar.ast.OscarTop;
import com.alibaba.druid.sql.dialect.oscar.parser.OscarLexer;
import com.alibaba.druid.sql.dialect.oscar.parser.OscarSelectParser;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGBoxExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCidrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCircleExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGDateField;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGExtractExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGInetExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGLineSegmentsExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGMacAddrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPointExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPolygonExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGTypeCastExpr;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class OscarExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public OscarExprParser(String sql) {
        this(new OscarLexer(sql, new SQLParserFeature[0]));
        this.lexer.nextToken();
        this.dbType = DbType.oscar;
    }

    public OscarExprParser(String sql, SQLParserFeature ... features) {
        this(new OscarLexer(sql, new SQLParserFeature[0]));
        this.lexer.nextToken();
        this.dbType = DbType.oscar;
    }

    public OscarExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
        this.dbType = DbType.oscar;
    }

    @Override
    public SQLDataType parseDataType() {
        if (this.lexer.token() == Token.TYPE) {
            this.lexer.nextToken();
        }
        return super.parseDataType();
    }

    @Override
    protected SQLDataType parseDataTypeRest(SQLDataType dataType) {
        dataType = super.parseDataTypeRest(dataType);
        if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            this.accept(Token.RBRACKET);
            dataType = new SQLArrayDataType(dataType);
        }
        return dataType;
    }

    @Override
    public OscarSelectParser createSelectParser() {
        return new OscarSelectParser(this);
    }

    @Override
    public SQLExpr primary() {
        if (this.lexer.token() == Token.ARRAY) {
            String ident = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                SQLIdentifierExpr array = new SQLIdentifierExpr(ident);
                return this.methodRest(array, true);
            }
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(new SQLIdentifierExpr(ident));
            this.accept(Token.LBRACKET);
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if (this.lexer.token() == Token.POUND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LBRACE) {
                this.lexer.nextToken();
                String varName = this.lexer.stringVal();
                this.lexer.nextToken();
                this.accept(Token.RBRACE);
                SQLVariantRefExpr expr = new SQLVariantRefExpr("#{" + varName + "}");
                return this.primaryRest(expr);
            }
            SQLExpr value = this.primary();
            SQLUnaryExpr expr = new SQLUnaryExpr(SQLUnaryOperator.Pound, value);
            return this.primaryRest(expr);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            SQLValuesExpr values = new SQLValuesExpr();
            while (true) {
                this.accept(Token.LPAREN);
                SQLListExpr listExpr = new SQLListExpr();
                this.exprList(listExpr.getItems(), listExpr);
                this.accept(Token.RPAREN);
                listExpr.setParent(values);
                values.getValues().add(listExpr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            return values;
        }
        if (this.lexer.token() == Token.WITH) {
            SQLQueryExpr queryExpr = new SQLQueryExpr(this.createSelectParser().select());
            return queryExpr;
        }
        return super.primary();
    }

    @Override
    protected SQLExpr parseInterval() {
        OracleIntervalType type;
        this.accept(Token.INTERVAL);
        OracleIntervalExpr interval = new OracleIntervalExpr();
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            interval.setValue(new SQLCharExpr(this.lexer.stringVal()));
        } else if (this.lexer.token() == Token.VARIANT) {
            interval.setValue(new SQLVariantRefExpr(this.lexer.stringVal()));
        } else if (this.lexer.token() == Token.QUES) {
            interval.setValue(new SQLVariantRefExpr("?"));
        } else {
            return new SQLIdentifierExpr("INTERVAL");
        }
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.YEAR)) {
            this.lexer.nextToken();
            type = OracleIntervalType.YEAR;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MONTH)) {
            this.lexer.nextToken();
            type = OracleIntervalType.MONTH;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.DAY)) {
            this.lexer.nextToken();
            type = OracleIntervalType.DAY;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.HOUR)) {
            this.lexer.nextToken();
            type = OracleIntervalType.HOUR;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MINUTE)) {
            this.lexer.nextToken();
            type = OracleIntervalType.MINUTE;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.SECOND)) {
            this.lexer.nextToken();
            type = OracleIntervalType.SECOND;
        } else {
            throw new ParserException("illegal interval type. " + this.lexer.info());
        }
        interval.setType(type);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.LITERAL_INT && this.lexer.token() != Token.VARIANT) {
                throw new ParserException("syntax error. " + this.lexer.info());
            }
            interval.setPrecision(this.primary());
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("syntax error. " + this.lexer.info());
                }
                interval.setFactionalSecondsPrecision(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("SECOND")) {
                this.lexer.nextToken();
                interval.setToType(OracleIntervalType.SECOND);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.LITERAL_INT && this.lexer.token() != Token.VARIANT) {
                        throw new ParserException("syntax error. " + this.lexer.info());
                    }
                    interval.setToFactionalSecondsPrecision(this.primary());
                    this.accept(Token.RPAREN);
                }
            } else {
                interval.setToType(OracleIntervalType.MONTH);
                this.lexer.nextToken();
            }
        }
        return interval;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.COLONCOLON) {
            this.lexer.nextToken();
            SQLDataType dataType = this.parseDataType();
            PGTypeCastExpr castExpr = new PGTypeCastExpr();
            castExpr.setExpr(expr);
            castExpr.setDataType(dataType);
            return this.primaryRest(castExpr);
        }
        if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if (expr.getClass() == SQLIdentifierExpr.class) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            String ident = identifierExpr.getName();
            long hash = identifierExpr.nameHashCode64();
            if (this.lexer.token() == Token.COMMA || this.lexer.token() == Token.RPAREN) {
                return super.primaryRest(expr);
            }
            if (FnvHash.Constants.TIMESTAMP == hash) {
                if (this.lexer.token() != Token.LITERAL_ALIAS && this.lexer.token() != Token.LITERAL_CHARS && this.lexer.token() != Token.WITH) {
                    return super.primaryRest(new SQLIdentifierExpr(ident));
                }
                SQLTimestampExpr timestamp = new SQLTimestampExpr();
                if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TIME");
                    this.acceptIdentifier("ZONE");
                    timestamp.setWithTimeZone(true);
                }
                String literal = this.lexer.stringVal();
                timestamp.setLiteral(literal);
                this.accept(Token.LITERAL_CHARS);
                if (this.lexer.identifierEquals("AT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TIME");
                    this.acceptIdentifier("ZONE");
                    String timezone = this.lexer.stringVal();
                    timestamp.setTimeZone(timezone);
                    this.accept(Token.LITERAL_CHARS);
                }
                return this.primaryRest(timestamp);
            }
            if (FnvHash.Constants.TIMESTAMPTZ == hash) {
                if (this.lexer.token() != Token.LITERAL_ALIAS && this.lexer.token() != Token.LITERAL_CHARS && this.lexer.token() != Token.WITH) {
                    return super.primaryRest(new SQLIdentifierExpr(ident));
                }
                SQLTimestampExpr timestamp = new SQLTimestampExpr();
                timestamp.setWithTimeZone(true);
                String literal = this.lexer.stringVal();
                timestamp.setLiteral(literal);
                this.accept(Token.LITERAL_CHARS);
                if (this.lexer.identifierEquals("AT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TIME");
                    this.acceptIdentifier("ZONE");
                    String timezone = this.lexer.stringVal();
                    timestamp.setTimeZone(timezone);
                    this.accept(Token.LITERAL_CHARS);
                }
                return this.primaryRest(timestamp);
            }
            if (FnvHash.Constants.EXTRACT == hash) {
                this.accept(Token.LPAREN);
                PGExtractExpr extract = new PGExtractExpr();
                String fieldName = this.lexer.stringVal();
                PGDateField field = PGDateField.valueOf(fieldName.toUpperCase());
                this.lexer.nextToken();
                extract.setField(field);
                this.accept(Token.FROM);
                SQLExpr source = this.expr();
                extract.setSource(source);
                this.accept(Token.RPAREN);
                return this.primaryRest(extract);
            }
            if (FnvHash.Constants.POINT == hash) {
                switch (this.lexer.token()) {
                    case DOT: 
                    case EQ: 
                    case LTGT: 
                    case GT: 
                    case GTEQ: 
                    case LT: 
                    case LTEQ: 
                    case SUB: 
                    case PLUS: 
                    case SUBGT: {
                        break;
                    }
                    default: {
                        SQLExpr value = this.primary();
                        PGPointExpr point = new PGPointExpr();
                        point.setValue(value);
                        return this.primaryRest(point);
                    }
                }
            } else {
                if (FnvHash.Constants.BOX == hash) {
                    SQLExpr value = this.primary();
                    PGBoxExpr box = new PGBoxExpr();
                    box.setValue(value);
                    return this.primaryRest(box);
                }
                if (FnvHash.Constants.MACADDR == hash) {
                    SQLExpr value = this.primary();
                    PGMacAddrExpr macaddr = new PGMacAddrExpr();
                    macaddr.setValue(value);
                    return this.primaryRest(macaddr);
                }
                if (FnvHash.Constants.INET == hash) {
                    SQLExpr value = this.primary();
                    PGInetExpr inet = new PGInetExpr();
                    inet.setValue(value);
                    return this.primaryRest(inet);
                }
                if (FnvHash.Constants.CIDR == hash) {
                    SQLExpr value = this.primary();
                    PGCidrExpr cidr = new PGCidrExpr();
                    cidr.setValue(value);
                    return this.primaryRest(cidr);
                }
                if (FnvHash.Constants.POLYGON == hash) {
                    SQLExpr value = this.primary();
                    PGPolygonExpr polygon = new PGPolygonExpr();
                    polygon.setValue(value);
                    return this.primaryRest(polygon);
                }
                if (FnvHash.Constants.CIRCLE == hash) {
                    SQLExpr value = this.primary();
                    PGCircleExpr circle = new PGCircleExpr();
                    circle.setValue(value);
                    return this.primaryRest(circle);
                }
                if (FnvHash.Constants.LSEG == hash) {
                    SQLExpr value = this.primary();
                    PGLineSegmentsExpr lseg = new PGLineSegmentsExpr();
                    lseg.setValue(value);
                    return this.primaryRest(lseg);
                }
                if (ident.equalsIgnoreCase("b") && this.lexer.token() == Token.LITERAL_CHARS) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr = new SQLBinaryExpr(charValue);
                    return this.primaryRest(expr);
                }
            }
        }
        return super.primaryRest(expr);
    }

    @Override
    protected String alias() {
        String alias = super.alias();
        if (alias != null) {
            return alias;
        }
        switch (this.lexer.token()) {
            case INTERSECT: {
                alias = this.lexer.stringVal();
                this.lexer.nextToken();
                return alias;
            }
        }
        return alias;
    }

    public OscarTop parseTop() {
        if (this.lexer.token() == Token.TOP) {
            OscarTop top = new OscarTop();
            this.lexer.nextToken();
            boolean paren = false;
            if (this.lexer.token() == Token.LPAREN) {
                paren = true;
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.LITERAL_INT) {
                top.setExpr(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
            } else {
                top.setExpr(this.primary());
            }
            if (paren) {
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.PERCENT) {
                this.lexer.nextToken();
                top.setPercent(true);
            }
            return top;
        }
        return null;
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "PERCENTILE_CONT", "PERCENTILE_DISC", "RANK", "DENSE_RANK", "PERCENT_RANK", "CUME_DIST"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            OscarExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

