/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelationLog;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TaskDefinitionDaoImpl
extends BaseDao<TaskDefinition, TaskDefinitionMapper>
implements TaskDefinitionDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskDefinitionDaoImpl.class);
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    private WorkflowTaskRelationLogMapper workflowTaskRelationLogMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;

    public TaskDefinitionDaoImpl(@NonNull TaskDefinitionMapper taskDefinitionMapper) {
        super(taskDefinitionMapper);
        if (taskDefinitionMapper == null) {
            throw new NullPointerException("taskDefinitionMapper is marked non-null but is null");
        }
    }

    @Override
    public List<TaskDefinition> getTaskDefinitionListByDefinition(long workflowDefinitionCode) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode);
        if (workflowDefinition == null) {
            log.error("Cannot find process definition, code: {}", (Object)workflowDefinitionCode);
            return Lists.newArrayList();
        }
        List<WorkflowTaskRelationLog> processTaskRelations = this.workflowTaskRelationLogMapper.queryByWorkflowCodeAndVersion(workflowDefinition.getCode(), workflowDefinition.getVersion());
        Set<TaskDefinition> taskDefinitionSet = processTaskRelations.stream().filter(p -> p.getPostTaskCode() > 0L).map(p -> new TaskDefinition(p.getPostTaskCode(), p.getPostTaskVersion())).collect(Collectors.toSet());
        if (taskDefinitionSet.isEmpty()) {
            return Lists.newArrayList();
        }
        List<TaskDefinitionLog> taskDefinitionLogs = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitionSet);
        return Lists.newArrayList(taskDefinitionLogs);
    }

    @Override
    public TaskDefinition findTaskDefinition(long taskCode, int taskDefinitionVersion) {
        return this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, taskDefinitionVersion);
    }

    @Override
    public void deleteByWorkflowDefinitionCodeAndVersion(long workflowDefinitionCode, int workflowDefinitionVersion) {
        ((TaskDefinitionMapper)this.mybatisMapper).deleteByWorkflowDefinitionCodeAndVersion(workflowDefinitionCode, workflowDefinitionVersion);
    }

    @Override
    public void deleteByTaskDefinitionCodes(Set<Long> needToDeleteTaskDefinitionCodes) {
        if (CollectionUtils.isEmpty(needToDeleteTaskDefinitionCodes)) {
            return;
        }
        ((TaskDefinitionMapper)this.mybatisMapper).deleteByBatchCodes(new ArrayList<Long>(needToDeleteTaskDefinitionCodes));
    }

    @Override
    public List<TaskDefinition> queryByCodes(Collection<Long> taskDefinitionCodes) {
        if (CollectionUtils.isEmpty(taskDefinitionCodes)) {
            return Collections.emptyList();
        }
        return ((TaskDefinitionMapper)this.mybatisMapper).queryByCodeList(taskDefinitionCodes);
    }

    @Override
    public TaskDefinition queryByCode(long taskCode) {
        return ((TaskDefinitionMapper)this.mybatisMapper).queryByCode(taskCode);
    }

    @Override
    public List<String> queryAllTaskDefinitionWorkerGroups(long projectCode) {
        return ((TaskDefinitionMapper)this.mybatisMapper).queryAllTaskDefinitionWorkerGroups(projectCode);
    }
}

