/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedPrivateEndpointResourceInner;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.ManagedPrivateEndpoint;
import com.azure.resourcemanager.datafactory.models.ManagedPrivateEndpointResource;

public final class ManagedPrivateEndpointResourceImpl
implements ManagedPrivateEndpointResource,
ManagedPrivateEndpointResource.Definition,
ManagedPrivateEndpointResource.Update {
    private ManagedPrivateEndpointResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String managedVirtualNetworkName;
    private String managedPrivateEndpointName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public ManagedPrivateEndpoint properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedPrivateEndpointResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedPrivateEndpointResourceImpl withExistingManagedVirtualNetwork(String resourceGroupName, String factoryName, String managedVirtualNetworkName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        this.managedVirtualNetworkName = managedVirtualNetworkName;
        return this;
    }

    @Override
    public ManagedPrivateEndpointResource create() {
        this.innerObject = (ManagedPrivateEndpointResourceInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.managedPrivateEndpointName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedPrivateEndpointResource create(Context context) {
        this.innerObject = (ManagedPrivateEndpointResourceInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.managedPrivateEndpointName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    ManagedPrivateEndpointResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new ManagedPrivateEndpointResourceInner();
        this.serviceManager = serviceManager;
        this.managedPrivateEndpointName = name;
        this.createIfMatch = null;
    }

    @Override
    public ManagedPrivateEndpointResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public ManagedPrivateEndpointResource apply() {
        this.innerObject = (ManagedPrivateEndpointResourceInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.managedPrivateEndpointName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedPrivateEndpointResource apply(Context context) {
        this.innerObject = (ManagedPrivateEndpointResourceInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.managedPrivateEndpointName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    ManagedPrivateEndpointResourceImpl(ManagedPrivateEndpointResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = Utils.getValueFromIdByName(innerObject.id(), "factories");
        this.managedVirtualNetworkName = Utils.getValueFromIdByName(innerObject.id(), "managedVirtualNetworks");
        this.managedPrivateEndpointName = Utils.getValueFromIdByName(innerObject.id(), "managedPrivateEndpoints");
    }

    @Override
    public ManagedPrivateEndpointResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (ManagedPrivateEndpointResourceInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().getWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.managedPrivateEndpointName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedPrivateEndpointResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (ManagedPrivateEndpointResourceInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().getWithResponse(this.resourceGroupName, this.factoryName, this.managedVirtualNetworkName, this.managedPrivateEndpointName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public ManagedPrivateEndpointResourceImpl withProperties(ManagedPrivateEndpoint properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ManagedPrivateEndpointResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

