/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datafactory.fluent.ManagedPrivateEndpointsClient;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedPrivateEndpointResourceInner;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientImpl;
import com.azure.resourcemanager.datafactory.models.ManagedPrivateEndpointListResponse;
import reactor.core.publisher.Mono;

public final class ManagedPrivateEndpointsClientImpl
implements ManagedPrivateEndpointsClient {
    private final ManagedPrivateEndpointsService service;
    private final DataFactoryManagementClientImpl client;

    ManagedPrivateEndpointsClientImpl(DataFactoryManagementClientImpl client) {
        this.service = (ManagedPrivateEndpointsService)RestProxy.create(ManagedPrivateEndpointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointResourceInner>> listByFactorySinglePageAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, managedVirtualNetworkName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointListResponse)res.getValue()).value(), ((ManagedPrivateEndpointListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointResourceInner>> listByFactorySinglePageAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, managedVirtualNetworkName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointListResponse)res.getValue()).value(), ((ManagedPrivateEndpointListResponse)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedPrivateEndpointResourceInner> listByFactoryAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName) {
        return new PagedFlux(() -> this.listByFactorySinglePageAsync(resourceGroupName, factoryName, managedVirtualNetworkName), nextLink -> this.listByFactoryNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedPrivateEndpointResourceInner> listByFactoryAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, Context context) {
        return new PagedFlux(() -> this.listByFactorySinglePageAsync(resourceGroupName, factoryName, managedVirtualNetworkName, context), nextLink -> this.listByFactoryNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedPrivateEndpointResourceInner> listByFactory(String resourceGroupName, String factoryName, String managedVirtualNetworkName) {
        return new PagedIterable(this.listByFactoryAsync(resourceGroupName, factoryName, managedVirtualNetworkName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedPrivateEndpointResourceInner> listByFactory(String resourceGroupName, String factoryName, String managedVirtualNetworkName, Context context) {
        return new PagedIterable(this.listByFactoryAsync(resourceGroupName, factoryName, managedVirtualNetworkName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedPrivateEndpointResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, ManagedPrivateEndpointResourceInner managedPrivateEndpoint, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        if (managedPrivateEndpoint == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedPrivateEndpoint is required and cannot be null."));
        }
        managedPrivateEndpoint.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, this.client.getApiVersion(), ifMatch, managedPrivateEndpoint, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedPrivateEndpointResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, ManagedPrivateEndpointResourceInner managedPrivateEndpoint, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        if (managedPrivateEndpoint == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedPrivateEndpoint is required and cannot be null."));
        }
        managedPrivateEndpoint.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, this.client.getApiVersion(), ifMatch, managedPrivateEndpoint, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedPrivateEndpointResourceInner> createOrUpdateAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, ManagedPrivateEndpointResourceInner managedPrivateEndpoint) {
        String ifMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, managedPrivateEndpoint, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ManagedPrivateEndpointResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedPrivateEndpointResourceInner> createOrUpdateWithResponse(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, ManagedPrivateEndpointResourceInner managedPrivateEndpoint, String ifMatch, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, managedPrivateEndpoint, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedPrivateEndpointResourceInner createOrUpdate(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, ManagedPrivateEndpointResourceInner managedPrivateEndpoint) {
        String ifMatch = null;
        return (ManagedPrivateEndpointResourceInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, managedPrivateEndpoint, ifMatch, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedPrivateEndpointResourceInner>> getWithResponseAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, this.client.getApiVersion(), ifNoneMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedPrivateEndpointResourceInner>> getWithResponseAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, this.client.getApiVersion(), ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedPrivateEndpointResourceInner> getAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName) {
        String ifNoneMatch = null;
        return this.getWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ManagedPrivateEndpointResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedPrivateEndpointResourceInner> getWithResponse(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, String ifNoneMatch, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, ifNoneMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedPrivateEndpointResourceInner get(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName) {
        String ifNoneMatch = null;
        return (ManagedPrivateEndpointResourceInner)((Object)this.getWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, ifNoneMatch, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName) {
        return this.deleteWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName) {
        this.deleteWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointResourceInner>> listByFactoryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFactoryNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointListResponse)res.getValue()).value(), ((ManagedPrivateEndpointListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointResourceInner>> listByFactoryNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByFactoryNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointListResponse)res.getValue()).value(), ((ManagedPrivateEndpointListResponse)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataFactoryManagemen")
    public static interface ManagedPrivateEndpointsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedPrivateEndpointListResponse>> listByFactory(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="managedVirtualNetworkName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedPrivateEndpointResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="managedVirtualNetworkName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="If-Match") String var8, @BodyParam(value="application/json") ManagedPrivateEndpointResourceInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedPrivateEndpointResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="managedVirtualNetworkName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="managedVirtualNetworkName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedPrivateEndpointListResponse>> listByFactoryNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

