/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureFunctionLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="AzureFunction")
public final class AzureFunctionLinkedService
extends LinkedService {
    @JsonProperty(value="typeProperties", required=true)
    private AzureFunctionLinkedServiceTypeProperties innerTypeProperties = new AzureFunctionLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureFunctionLinkedService.class);

    private AzureFunctionLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureFunctionLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureFunctionLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureFunctionLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureFunctionLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object functionAppUrl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().functionAppUrl();
    }

    public AzureFunctionLinkedService withFunctionAppUrl(Object functionAppUrl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFunctionAppUrl(functionAppUrl);
        return this;
    }

    public SecretBase functionKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().functionKey();
    }

    public AzureFunctionLinkedService withFunctionKey(SecretBase functionKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFunctionKey(functionKey);
        return this;
    }

    public Object encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AzureFunctionLinkedService withEncryptedCredential(Object encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public AzureFunctionLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    public Object resourceId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().resourceId();
    }

    public AzureFunctionLinkedService withResourceId(Object resourceId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withResourceId(resourceId);
        return this;
    }

    public Object authentication() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authentication();
    }

    public AzureFunctionLinkedService withAuthentication(Object authentication) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFunctionLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthentication(authentication);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureFunctionLinkedService"));
        }
        this.innerTypeProperties().validate();
    }
}

