/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import lombok.Generated;

public enum WorkflowExecutionStatus {
    SUBMITTED_SUCCESS(0, false, false, false, false, false, false),
    RUNNING_EXECUTION(1, true, false, true, false, false, true),
    READY_PAUSE(2, true, false, true, false, false, true),
    PAUSE(3, false, false, false, false, true, false),
    READY_STOP(4, true, false, false, false, false, true),
    STOP(5, false, false, false, false, true, false),
    FAILURE(6, false, false, false, false, true, false),
    SUCCESS(7, false, false, false, false, true, false),
    SERIAL_WAIT(14, true, true, true, true, false, false),
    FAILOVER(18, false, false, false, false, false, false);

    @EnumValue
    private final int code;
    private final boolean canStop;
    private final boolean canDirectStopInDB;
    private final boolean canPause;
    private final boolean canDirectPauseInDB;
    private final boolean needFailover;
    private final boolean finalState;
    public static final int[] NEED_FAILOVER_STATES;
    public static final int[] NOT_TERMINAL_STATES;

    private WorkflowExecutionStatus(int code, boolean canStop, boolean canDirectStopInDB, boolean canPause, boolean canDirectPauseInDB, boolean finalState, boolean needFailover) {
        this.code = code;
        this.canStop = canStop;
        this.canDirectStopInDB = canDirectStopInDB;
        this.canPause = canPause;
        this.canDirectPauseInDB = canDirectPauseInDB;
        this.finalState = finalState;
        this.needFailover = needFailover;
    }

    public boolean isSuccess() {
        return this == SUCCESS;
    }

    public boolean isFailure() {
        return this == FAILURE;
    }

    public boolean isPaused() {
        return this == PAUSE;
    }

    public boolean isStopped() {
        return this == STOP;
    }

    public String toString() {
        return this.name();
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public boolean isCanStop() {
        return this.canStop;
    }

    @Generated
    public boolean isCanDirectStopInDB() {
        return this.canDirectStopInDB;
    }

    @Generated
    public boolean isCanPause() {
        return this.canPause;
    }

    @Generated
    public boolean isCanDirectPauseInDB() {
        return this.canDirectPauseInDB;
    }

    @Generated
    public boolean isNeedFailover() {
        return this.needFailover;
    }

    @Generated
    public boolean isFinalState() {
        return this.finalState;
    }

    static {
        NEED_FAILOVER_STATES = Arrays.stream(WorkflowExecutionStatus.values()).filter(WorkflowExecutionStatus::isNeedFailover).mapToInt(WorkflowExecutionStatus::getCode).toArray();
        NOT_TERMINAL_STATES = Arrays.stream(WorkflowExecutionStatus.values()).filter(workflowExecutionStatus -> !workflowExecutionStatus.isFinalState()).mapToInt(WorkflowExecutionStatus::getCode).toArray();
    }
}

