/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster;

import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.server.master.cluster.IClusters;

public abstract class BaseServerMetadata
implements IClusters.IServerMetadata {
    private final int processId;
    private final long serverStartupTime;
    private final String address;
    private final double cpuUsage;
    private final double memoryUsage;
    private final ServerStatus serverStatus;

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    @Generated
    protected BaseServerMetadata(BaseServerMetadataBuilder<?, ?> b) {
        this.processId = ((BaseServerMetadataBuilder)b).processId;
        this.serverStartupTime = ((BaseServerMetadataBuilder)b).serverStartupTime;
        this.address = ((BaseServerMetadataBuilder)b).address;
        this.cpuUsage = ((BaseServerMetadataBuilder)b).cpuUsage;
        this.memoryUsage = ((BaseServerMetadataBuilder)b).memoryUsage;
        this.serverStatus = ((BaseServerMetadataBuilder)b).serverStatus;
    }

    @Generated
    public int getProcessId() {
        return this.processId;
    }

    @Generated
    public long getServerStartupTime() {
        return this.serverStartupTime;
    }

    @Generated
    public double getCpuUsage() {
        return this.cpuUsage;
    }

    @Generated
    public double getMemoryUsage() {
        return this.memoryUsage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseServerMetadata)) {
            return false;
        }
        BaseServerMetadata other = (BaseServerMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcessId() != other.getProcessId()) {
            return false;
        }
        if (this.getServerStartupTime() != other.getServerStartupTime()) {
            return false;
        }
        if (Double.compare(this.getCpuUsage(), other.getCpuUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryUsage(), other.getMemoryUsage()) != 0) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        ServerStatus this$serverStatus = this.getServerStatus();
        ServerStatus other$serverStatus = other.getServerStatus();
        return !(this$serverStatus == null ? other$serverStatus != null : !this$serverStatus.equals(other$serverStatus));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseServerMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProcessId();
        long $serverStartupTime = this.getServerStartupTime();
        result = result * 59 + (int)($serverStartupTime >>> 32 ^ $serverStartupTime);
        long $cpuUsage = Double.doubleToLongBits(this.getCpuUsage());
        result = result * 59 + (int)($cpuUsage >>> 32 ^ $cpuUsage);
        long $memoryUsage = Double.doubleToLongBits(this.getMemoryUsage());
        result = result * 59 + (int)($memoryUsage >>> 32 ^ $memoryUsage);
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        ServerStatus $serverStatus = this.getServerStatus();
        result = result * 59 + ($serverStatus == null ? 43 : $serverStatus.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseServerMetadata(processId=" + this.getProcessId() + ", serverStartupTime=" + this.getServerStartupTime() + ", address=" + this.getAddress() + ", cpuUsage=" + this.getCpuUsage() + ", memoryUsage=" + this.getMemoryUsage() + ", serverStatus=" + this.getServerStatus() + ")";
    }

    @Generated
    public static abstract class BaseServerMetadataBuilder<C extends BaseServerMetadata, B extends BaseServerMetadataBuilder<C, B>> {
        @Generated
        private int processId;
        @Generated
        private long serverStartupTime;
        @Generated
        private String address;
        @Generated
        private double cpuUsage;
        @Generated
        private double memoryUsage;
        @Generated
        private ServerStatus serverStatus;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B processId(int processId) {
            this.processId = processId;
            return this.self();
        }

        @Generated
        public B serverStartupTime(long serverStartupTime) {
            this.serverStartupTime = serverStartupTime;
            return this.self();
        }

        @Generated
        public B address(String address) {
            this.address = address;
            return this.self();
        }

        @Generated
        public B cpuUsage(double cpuUsage) {
            this.cpuUsage = cpuUsage;
            return this.self();
        }

        @Generated
        public B memoryUsage(double memoryUsage) {
            this.memoryUsage = memoryUsage;
            return this.self();
        }

        @Generated
        public B serverStatus(ServerStatus serverStatus) {
            this.serverStatus = serverStatus;
            return this.self();
        }

        @Generated
        public String toString() {
            return "BaseServerMetadata.BaseServerMetadataBuilder(processId=" + this.processId + ", serverStartupTime=" + this.serverStartupTime + ", address=" + this.address + ", cpuUsage=" + this.cpuUsage + ", memoryUsage=" + this.memoryUsage + ", serverStatus=" + this.serverStatus + ")";
        }
    }
}

