/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.model.MasterHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.server.master.cluster.AbstractClusterSubscribeListener;
import org.apache.dolphinscheduler.server.master.cluster.IClusters;
import org.apache.dolphinscheduler.server.master.cluster.MasterServerMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterClusters
extends AbstractClusterSubscribeListener<MasterServerMetadata>
implements IClusters<MasterServerMetadata> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterClusters.class);
    private final Map<String, MasterServerMetadata> masterServerMap = new ConcurrentHashMap<String, MasterServerMetadata>();
    private final List<IClusters.IClustersChangeListener<MasterServerMetadata>> masterClusterChangeListeners = new CopyOnWriteArrayList<IClusters.IClustersChangeListener<MasterServerMetadata>>();

    @Override
    public List<MasterServerMetadata> getServers() {
        return UnmodifiableList.unmodifiableList(new ArrayList<MasterServerMetadata>(this.masterServerMap.values()));
    }

    @Override
    public Optional<MasterServerMetadata> getServer(String address) {
        return Optional.ofNullable(this.masterServerMap.get(address));
    }

    public List<MasterServerMetadata> getNormalServers() {
        List normalMasterServers = this.masterServerMap.values().stream().filter(masterServer -> masterServer.getServerStatus() == ServerStatus.NORMAL).collect(Collectors.toList());
        return UnmodifiableList.unmodifiableList(normalMasterServers);
    }

    @Override
    public void registerListener(IClusters.IClustersChangeListener<MasterServerMetadata> listener) {
        this.masterClusterChangeListeners.add(listener);
    }

    @Override
    MasterServerMetadata parseServerFromHeartbeat(String masterHeartBeatJson) {
        MasterHeartBeat masterHeartBeat = (MasterHeartBeat)JSONUtils.parseObject((String)masterHeartBeatJson, MasterHeartBeat.class);
        if (masterHeartBeat == null) {
            return null;
        }
        return MasterServerMetadata.parseFromHeartBeat(masterHeartBeat);
    }

    @Override
    public void onServerAdded(MasterServerMetadata masterServer) {
        this.masterServerMap.put(masterServer.getAddress(), masterServer);
        for (IClusters.IClustersChangeListener<MasterServerMetadata> listener : this.masterClusterChangeListeners) {
            listener.onServerAdded(masterServer);
        }
    }

    @Override
    public void onServerRemove(MasterServerMetadata masterServer) {
        this.masterServerMap.remove(masterServer.getAddress());
        for (IClusters.IClustersChangeListener<MasterServerMetadata> listener : this.masterClusterChangeListeners) {
            listener.onServerRemove(masterServer);
        }
    }

    @Override
    public void onServerUpdate(MasterServerMetadata masterServer) {
        this.masterServerMap.put(masterServer.getAddress(), masterServer);
        for (IClusters.IClustersChangeListener<MasterServerMetadata> listener : this.masterClusterChangeListeners) {
            listener.onServerUpdate(masterServer);
        }
    }
}

