/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.logging;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class LoggingRebinder
implements ApplicationListener<EnvironmentChangeEvent>,
EnvironmentAware {
    private static final Bindable<Map<String, String>> STRING_STRING_MAP = Bindable.mapOf(String.class, String.class);
    private final Log logger = LogFactory.getLog(this.getClass());
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (this.environment == null) {
            return;
        }
        LoggingSystem system = LoggingSystem.get((ClassLoader)LoggingSystem.class.getClassLoader());
        this.setLogLevels(system, this.environment);
    }

    protected void setLogLevels(LoggingSystem system, Environment environment) {
        Map levels = (Map)Binder.get((Environment)environment).bind("logging.level", STRING_STRING_MAP).orElseGet(Collections::emptyMap);
        for (Map.Entry entry : levels.entrySet()) {
            this.setLogLevel(system, environment, (String)entry.getKey(), ((String)entry.getValue()).toString());
        }
    }

    private void setLogLevel(LoggingSystem system, Environment environment, String name, String level) {
        try {
            if (name.equalsIgnoreCase("root")) {
                name = null;
            }
            level = environment.resolvePlaceholders(level);
            system.setLogLevel(name, this.resolveLogLevel(level));
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)("Cannot set level: " + level + " for '" + name + "'"));
        }
    }

    private LogLevel resolveLogLevel(String level) {
        String trimmedLevel = level.trim();
        if ("false".equalsIgnoreCase(trimmedLevel)) {
            return LogLevel.OFF;
        }
        return LogLevel.valueOf((String)trimmedLevel.toUpperCase(Locale.ENGLISH));
    }
}

