/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.bootstrap.config.SimpleBootstrapPropertySource;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.logging.LoggingRebinder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={PropertySourceBootstrapProperties.class})
public class PropertySourceBootstrapConfiguration
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrapProperties";
    private static Log logger = LogFactory.getLog(PropertySourceBootstrapConfiguration.class);
    private int order = -2147483638;
    @Autowired(required=false)
    private List<PropertySourceLocator> propertySourceLocators = new ArrayList<PropertySourceLocator>();

    public int getOrder() {
        return this.order;
    }

    public void setPropertySourceLocators(Collection<PropertySourceLocator> propertySourceLocators) {
        this.propertySourceLocators = new ArrayList<PropertySourceLocator>(propertySourceLocators);
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ArrayList composite = new ArrayList();
        AnnotationAwareOrderComparator.sort(this.propertySourceLocators);
        boolean empty = true;
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        for (PropertySourceLocator locator : this.propertySourceLocators) {
            Collection<PropertySource<?>> source = locator.locateCollection((Environment)environment);
            if (source == null || source.size() == 0) continue;
            ArrayList<Object> sourceList = new ArrayList<Object>();
            for (PropertySource<?> p : source) {
                if (p instanceof EnumerablePropertySource) {
                    EnumerablePropertySource enumerable = (EnumerablePropertySource)p;
                    sourceList.add((Object)new BootstrapPropertySource(enumerable));
                    continue;
                }
                sourceList.add((Object)new SimpleBootstrapPropertySource(p));
            }
            logger.info((Object)("Located property source: " + sourceList));
            composite.addAll(sourceList);
            empty = false;
        }
        if (!empty) {
            MutablePropertySources propertySources = environment.getPropertySources();
            String logConfig = environment.resolvePlaceholders("${logging.config:}");
            LogFile logFile = LogFile.get((PropertyResolver)environment);
            for (PropertySource p : environment.getPropertySources()) {
                if (!p.getName().startsWith(BOOTSTRAP_PROPERTY_SOURCE_NAME)) continue;
                propertySources.remove(p.getName());
            }
            this.insertPropertySources(propertySources, composite);
            this.reinitializeLoggingSystem(environment, logConfig, logFile);
            this.setLogLevels(applicationContext, environment);
            this.handleIncludedProfiles(environment);
        }
    }

    private void reinitializeLoggingSystem(ConfigurableEnvironment environment, String oldLogConfig, LogFile oldLogFile) {
        Map props = (Map)Binder.get((Environment)environment).bind("logging", Bindable.mapOf(String.class, Object.class)).orElseGet(Collections::emptyMap);
        if (!props.isEmpty()) {
            String logConfig = environment.resolvePlaceholders("${logging.config:}");
            LogFile logFile = LogFile.get((PropertyResolver)environment);
            LoggingSystem system = LoggingSystem.get((ClassLoader)LoggingSystem.class.getClassLoader());
            try {
                system.cleanUp();
                system.beforeInitialize();
                system.initialize(new LoggingInitializationContext(environment), logConfig, logFile);
            }
            catch (Exception ex) {
                logger.warn((Object)("Error opening logging config file " + logConfig), (Throwable)ex);
            }
        }
    }

    private void setLogLevels(ConfigurableApplicationContext applicationContext, ConfigurableEnvironment environment) {
        LoggingRebinder rebinder = new LoggingRebinder();
        rebinder.setEnvironment((Environment)environment);
        rebinder.onApplicationEvent(new EnvironmentChangeEvent(applicationContext, Collections.emptySet()));
    }

    private void insertPropertySources(MutablePropertySources propertySources, List<PropertySource<?>> composite) {
        MutablePropertySources incoming = new MutablePropertySources();
        ArrayList reversedComposite = new ArrayList(composite);
        Collections.reverse(reversedComposite);
        for (PropertySource propertySource : reversedComposite) {
            incoming.addFirst(propertySource);
        }
        PropertySourceBootstrapProperties remoteProperties = new PropertySourceBootstrapProperties();
        Binder.get((Environment)this.environment(incoming)).bind("spring.cloud.config", Bindable.ofInstance((Object)remoteProperties));
        if (!remoteProperties.isAllowOverride() || !remoteProperties.isOverrideNone() && remoteProperties.isOverrideSystemProperties()) {
            for (PropertySource propertySource : reversedComposite) {
                propertySources.addFirst(propertySource);
            }
            return;
        }
        if (remoteProperties.isOverrideNone()) {
            for (PropertySource<?> propertySource : composite) {
                propertySources.addLast(propertySource);
            }
            return;
        }
        if (propertySources.contains("systemEnvironment")) {
            if (!remoteProperties.isOverrideSystemProperties()) {
                for (PropertySource propertySource : reversedComposite) {
                    propertySources.addAfter("systemEnvironment", propertySource);
                }
            } else {
                for (PropertySource<?> propertySource : composite) {
                    propertySources.addBefore("systemEnvironment", propertySource);
                }
            }
        } else {
            for (PropertySource<?> propertySource : composite) {
                propertySources.addLast(propertySource);
            }
        }
    }

    private Environment environment(MutablePropertySources incoming) {
        AbstractEnvironment environment = new AbstractEnvironment(){};
        for (PropertySource source : incoming) {
            environment.getPropertySources().addLast(source);
        }
        return environment;
    }

    private void handleIncludedProfiles(ConfigurableEnvironment environment) {
        TreeSet<String> includeProfiles = new TreeSet<String>();
        for (PropertySource propertySource : environment.getPropertySources()) {
            this.addIncludedProfilesTo(includeProfiles, propertySource);
        }
        ArrayList<String> activeProfiles = new ArrayList<String>();
        Collections.addAll(activeProfiles, environment.getActiveProfiles());
        includeProfiles.removeAll(activeProfiles);
        if (includeProfiles.isEmpty()) {
            return;
        }
        for (String profile : includeProfiles) {
            activeProfiles.add(0, profile);
        }
        environment.setActiveProfiles(activeProfiles.toArray(new String[activeProfiles.size()]));
    }

    private Set<String> addIncludedProfilesTo(Set<String> profiles, PropertySource<?> propertySource) {
        if (propertySource instanceof CompositePropertySource) {
            for (PropertySource nestedPropertySource : ((CompositePropertySource)propertySource).getPropertySources()) {
                this.addIncludedProfilesTo(profiles, nestedPropertySource);
            }
        } else {
            Collections.addAll(profiles, this.getProfilesForValue(propertySource.getProperty("spring.profiles.include")));
        }
        return profiles;
    }

    private String[] getProfilesForValue(Object property) {
        String value = property == null ? null : property.toString();
        return property == null ? new String[]{} : StringUtils.tokenizeToStringArray((String)value, (String)",");
    }
}

