/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.function.Supplier;
import lombok.Generated;

public final class AlertServerMetrics {
    private static final Counter alertSuccessCounter = Counter.builder((String)"ds.alert.send.count").tag("status", "success").description("Alert success count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter alertFailCounter = Counter.builder((String)"ds.alert.send.count").tag("status", "fail").description("Alert failure count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter alertHeartBeatCounter = Counter.builder((String)"ds.alert.heartbeat.count").description("alert heartbeat count").register((MeterRegistry)Metrics.globalRegistry);

    public static void registerPendingAlertGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.alert.pending", supplier).description("Number of pending alert").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerSendingAlertGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.alert.sending", supplier).description("Number of sending alert").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerUncachedException(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.alert.uncached.exception", supplier).description("number of uncached exception").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void incAlertSuccessCount() {
        alertSuccessCounter.increment();
    }

    public static void incAlertFailCount() {
        alertFailCounter.increment();
    }

    public static void incAlertHeartbeatCount() {
        alertHeartBeatCounter.increment();
    }

    @Generated
    private AlertServerMetrics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

