/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsSrvNameResolver
extends NameResolver {
    public static final String SCHEME = "dns+srv";
    private static final Logger LOGGER = LoggerFactory.getLogger(DnsSrvNameResolver.class);
    private static final String[] ATTRIBUTE_IDS = new String[]{"SRV"};
    private static final Hashtable<String, String> ENV = new Hashtable();
    private final Object lock = new Object();
    private final String authority;
    private final URI targetUri;
    private volatile boolean shutdown;
    private volatile boolean resolving;
    @GuardedBy(value="lock")
    private Executor executor;
    @GuardedBy(value="lock")
    private NameResolver.Listener listener;

    public DnsSrvNameResolver(URI targetUri) {
        this.targetUri = targetUri;
        this.authority = targetUri.getAuthority() != null ? targetUri.getAuthority() : SCHEME;
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(NameResolver.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
            this.executor = (Executor)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            this.resolve();
        }
    }

    public final synchronized void refresh() {
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor = (Executor)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR, (Object)this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.executor.execute(this::doResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResolve() {
        NameResolver.Listener savedListener;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.resolving = true;
            savedListener = this.listener;
        }
        try {
            ArrayList<EquivalentAddressGroup> groups = new ArrayList<EquivalentAddressGroup>();
            for (SocketAddress address : this.resolveAddresses()) {
                groups.add(new EquivalentAddressGroup(address, Attributes.EMPTY));
            }
            if (groups.isEmpty()) {
                throw EtcdExceptionFactory.newEtcdException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unable to resolve endpoint " + this.targetUri));
            }
            savedListener.onAddresses(groups, Attributes.EMPTY);
        }
        catch (Exception e) {
            LOGGER.warn("Error wile getting list of servers", (Throwable)e);
            savedListener.onError(Status.NOT_FOUND);
        }
        finally {
            this.resolving = false;
        }
    }

    private List<SocketAddress> resolveAddresses() {
        LinkedList<SocketAddress> addresses = new LinkedList<SocketAddress>();
        try {
            String address = this.targetUri.getPath();
            if (address.startsWith("/")) {
                address = address.substring(1);
            }
            InitialDirContext ctx = new InitialDirContext(ENV);
            javax.naming.directory.Attributes attributes = ctx.getAttributes(address, ATTRIBUTE_IDS);
            NamingEnumeration<?> resolved = attributes.get("srv").getAll();
            while (resolved.hasMore()) {
                String record = (String)resolved.next();
                List split = Splitter.on((char)' ').splitToList((CharSequence)record);
                if (split.size() < 4) continue;
                String host = ((String)split.get(3)).trim();
                String port = ((String)split.get(2)).trim();
                addresses.add(new InetSocketAddress(host, Integer.parseInt(port)));
            }
        }
        catch (Exception e) {
            throw EtcdExceptionFactory.toEtcdException((Throwable)e);
        }
        return addresses;
    }

    static {
        ENV.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        ENV.put("java.naming.provider.url", "dns:");
    }
}

