/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.resourcemanager.monitor.models.DataCollectionRuleDataSources;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDestinations;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleMetadata;
import com.azure.resourcemanager.monitor.models.DataFlow;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleProvisioningState;
import com.azure.resourcemanager.monitor.models.StreamDeclaration;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public class DataCollectionRule {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="immutableId", access=JsonProperty.Access.WRITE_ONLY)
    private String immutableId;
    @JsonProperty(value="dataCollectionEndpointId")
    private String dataCollectionEndpointId;
    @JsonProperty(value="metadata", access=JsonProperty.Access.WRITE_ONLY)
    private DataCollectionRuleMetadata metadata;
    @JsonProperty(value="streamDeclarations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, StreamDeclaration> streamDeclarations;
    @JsonProperty(value="dataSources")
    private DataCollectionRuleDataSources dataSources;
    @JsonProperty(value="destinations")
    private DataCollectionRuleDestinations destinations;
    @JsonProperty(value="dataFlows")
    private List<DataFlow> dataFlows;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private KnownDataCollectionRuleProvisioningState provisioningState;

    public String description() {
        return this.description;
    }

    public DataCollectionRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public String immutableId() {
        return this.immutableId;
    }

    public String dataCollectionEndpointId() {
        return this.dataCollectionEndpointId;
    }

    public DataCollectionRule withDataCollectionEndpointId(String dataCollectionEndpointId) {
        this.dataCollectionEndpointId = dataCollectionEndpointId;
        return this;
    }

    public DataCollectionRuleMetadata metadata() {
        return this.metadata;
    }

    public Map<String, StreamDeclaration> streamDeclarations() {
        return this.streamDeclarations;
    }

    public DataCollectionRule withStreamDeclarations(Map<String, StreamDeclaration> streamDeclarations) {
        this.streamDeclarations = streamDeclarations;
        return this;
    }

    public DataCollectionRuleDataSources dataSources() {
        return this.dataSources;
    }

    public DataCollectionRule withDataSources(DataCollectionRuleDataSources dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    public DataCollectionRuleDestinations destinations() {
        return this.destinations;
    }

    public DataCollectionRule withDestinations(DataCollectionRuleDestinations destinations) {
        this.destinations = destinations;
        return this;
    }

    public List<DataFlow> dataFlows() {
        return this.dataFlows;
    }

    public DataCollectionRule withDataFlows(List<DataFlow> dataFlows) {
        this.dataFlows = dataFlows;
        return this;
    }

    public KnownDataCollectionRuleProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().validate();
        }
        if (this.streamDeclarations() != null) {
            this.streamDeclarations().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.dataSources() != null) {
            this.dataSources().validate();
        }
        if (this.destinations() != null) {
            this.destinations().validate();
        }
        if (this.dataFlows() != null) {
            this.dataFlows().forEach(e -> e.validate());
        }
    }
}

