/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.meter.metrics;

import lombok.Generated;
import org.apache.dolphinscheduler.meter.metrics.BaseServerLoadProtectionConfig;
import org.apache.dolphinscheduler.meter.metrics.ServerLoadProtection;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseServerLoadProtection
implements ServerLoadProtection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseServerLoadProtection.class);
    protected final BaseServerLoadProtectionConfig baseServerLoadProtectionConfig;

    public BaseServerLoadProtection(BaseServerLoadProtectionConfig baseServerLoadProtectionConfig) {
        this.baseServerLoadProtectionConfig = baseServerLoadProtectionConfig;
    }

    @Override
    public boolean isOverload(SystemMetrics systemMetrics) {
        if (!this.baseServerLoadProtectionConfig.isEnabled()) {
            return false;
        }
        if (systemMetrics.getSystemCpuUsagePercentage() > this.baseServerLoadProtectionConfig.getMaxSystemCpuUsagePercentageThresholds()) {
            log.info("OverLoad: the system cpu usage: {} is over then the maxSystemCpuUsagePercentageThresholds {}", (Object)systemMetrics.getSystemCpuUsagePercentage(), (Object)this.baseServerLoadProtectionConfig.getMaxSystemCpuUsagePercentageThresholds());
            return true;
        }
        if (systemMetrics.getJvmCpuUsagePercentage() > this.baseServerLoadProtectionConfig.getMaxJvmCpuUsagePercentageThresholds()) {
            log.info("OverLoad: the jvm cpu usage: {} is over then the maxJvmCpuUsagePercentageThresholds {}", (Object)systemMetrics.getJvmCpuUsagePercentage(), (Object)this.baseServerLoadProtectionConfig.getMaxJvmCpuUsagePercentageThresholds());
            return true;
        }
        if (systemMetrics.getDiskUsedPercentage() > this.baseServerLoadProtectionConfig.getMaxDiskUsagePercentageThresholds()) {
            log.info("OverLoad: the DiskUsedPercentage: {} is over then the maxDiskUsagePercentageThresholds {}", (Object)systemMetrics.getDiskUsedPercentage(), (Object)this.baseServerLoadProtectionConfig.getMaxDiskUsagePercentageThresholds());
            return true;
        }
        if (systemMetrics.getSystemMemoryUsedPercentage() > this.baseServerLoadProtectionConfig.getMaxSystemMemoryUsagePercentageThresholds()) {
            log.info("OverLoad: the SystemMemoryUsedPercentage: {} is over then the maxSystemMemoryUsagePercentageThresholds {}", (Object)systemMetrics.getSystemMemoryUsedPercentage(), (Object)this.baseServerLoadProtectionConfig.getMaxSystemMemoryUsagePercentageThresholds());
            return true;
        }
        return false;
    }
}

