/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.manifests;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.spring.extended.manifests.annotation.FromConfigMap;
import io.kubernetes.client.spring.extended.manifests.config.KubernetesManifestsProperties;
import io.kubernetes.client.spring.extended.manifests.configmaps.ConfigMapGetter;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

public class KubernetesFromConfigMapProcessor
implements InstantiationAwareBeanPostProcessor,
BeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(KubernetesFromConfigMapProcessor.class);
    private ApplicationContext applicationContext;
    private final ScheduledExecutorService configMapKeyRefresher = Executors.newSingleThreadScheduledExecutor();
    @Autowired
    private KubernetesManifestsProperties manifestsProperties;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        for (Field field : bean.getClass().getDeclaredFields()) {
            FromConfigMap fromConfigMapAnnotation;
            block5: {
                fromConfigMapAnnotation = field.getAnnotation(FromConfigMap.class);
                if (fromConfigMapAnnotation == null) continue;
                ReflectionUtils.makeAccessible((Field)field);
                try {
                    if (field.get(bean) != null) {
                    }
                    break block5;
                }
                catch (IllegalAccessException e) {
                    log.warn("Failed inject resource for @FromConfigMap annotated field {}", (Object)field, (Object)e);
                }
                continue;
            }
            if (!Map.class.isAssignableFrom(field.getType())) {
                log.warn("Failed inject resource for @FromConfigMap annotated field {}, the declaring type should be Map<String, String>", (Object)field);
                continue;
            }
            ConfigMapGetter configMapGetter = this.getOrCreateConfigMapGetter(fromConfigMapAnnotation, this.applicationContext);
            LoadingCache configMapDataCache = Caffeine.newBuilder().expireAfterWrite(this.manifestsProperties.getRefreshInterval()).build((CacheLoader)new ConfigMapGetterCacheLoader(() -> configMapGetter.get(fromConfigMapAnnotation.namespace(), fromConfigMapAnnotation.name())));
            KubernetesFromConfigMapProcessor.fullyRefreshCache(configMapGetter, fromConfigMapAnnotation, (LoadingCache<String, String>)configMapDataCache);
            this.configMapKeyRefresher.scheduleAtFixedRate(() -> KubernetesFromConfigMapProcessor.fullyRefreshCache(configMapGetter, fromConfigMapAnnotation, (LoadingCache<String, String>)configMapDataCache), this.manifestsProperties.getRefreshInterval().getSeconds(), this.manifestsProperties.getRefreshInterval().getSeconds(), TimeUnit.SECONDS);
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)configMapDataCache.asMap());
        }
        return bean;
    }

    private static void fullyRefreshCache(ConfigMapGetter configMapGetter, FromConfigMap fromConfigMapAnnotation, LoadingCache<String, String> configMapDataCache) {
        V1ConfigMap configMap = configMapGetter.get(fromConfigMapAnnotation.namespace(), fromConfigMapAnnotation.name());
        if (configMap == null || configMap.getData() == null) {
            return;
        }
        configMap.getData().keySet().stream().forEach(key -> configMapDataCache.refresh(key));
    }

    private ConfigMapGetter getOrCreateConfigMapGetter(FromConfigMap fromConfigMapAnnotation, ApplicationContext applicationContext) {
        ConfigMapGetter configMapGetter;
        try {
            configMapGetter = (ConfigMapGetter)applicationContext.getAutowireCapableBeanFactory().getBean(fromConfigMapAnnotation.configMapGetter());
        }
        catch (NoSuchBeanDefinitionException ne) {
            try {
                configMapGetter = fromConfigMapAnnotation.configMapGetter().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new BeanCreationException("failed creating configmap getter instance", (Throwable)e);
            }
            applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)configMapGetter);
            applicationContext.getAutowireCapableBeanFactory().initializeBean((Object)configMapGetter, "configmap-getter-" + fromConfigMapAnnotation.configMapGetter().getSimpleName());
        }
        return configMapGetter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    static class ConfigMapGetterCacheLoader
    implements CacheLoader<String, String> {
        private final Supplier<V1ConfigMap> configMapSupplier;

        ConfigMapGetterCacheLoader(Supplier<V1ConfigMap> configMapSupplier) {
            this.configMapSupplier = configMapSupplier;
        }

        public @Nullable String load(@NonNull String key) throws Exception {
            V1ConfigMap configMap = this.configMapSupplier.get();
            if (configMap == null || configMap.getData() == null) {
                return null;
            }
            return (String)configMap.getData().get(key);
        }
    }
}

