/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.snapshot.CosSnapshotRequest;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotRequest;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SnapshotDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        SnapshotDemo.getSnapshot(client);
    }

    public static void getSnapshot(COSClient client) throws IOException {
        CosSnapshotRequest request = new CosSnapshotRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setObjectKey("1.mp4");
        request.setTime("15");
        request.setFormat("jpg");
        InputStream is = null;
        try {
            is = client.getSnapshot(request);
            SnapshotDemo.inputStream2File(is, new File("1.jpg"));
        }
        finally {
            SnapshotDemo.close(is);
        }
    }

    public static void generateSnapshot(COSClient client) {
        SnapshotRequest request = new SnapshotRequest();
        request.setBucketName("DemoBucket-123456789");
        request.getInput().setObject("1.mp4");
        request.getOutput().setBucket("DemoBucket-123456789");
        request.getOutput().setRegion("ap-chongqing");
        request.getOutput().setObject("test/1.jpg");
        request.setTime("15");
        SnapshotResponse response = client.generateSnapshot(request);
        System.out.println(response);
    }

    private static void inputStream2File(InputStream is, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int count;
            byte[] read = new byte[4096];
            while ((count = is.read(read)) != -1) {
                outputStream.write(read, 0, count);
            }
        }
    }

    private static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

