/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.authentication.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClientBuilder;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.authentication.aws.AWSCredentialsProviderFactor;

public final class AmazonElasticMapReduceClientFactory {
    public static AmazonElasticMapReduce createAmazonElasticMapReduceClient(Map<String, String> awsProperties) {
        AWSCredentialsProvider awsCredentialsProvider = AWSCredentialsProviderFactor.credentialsProvider(awsProperties);
        Regions regions = Regions.fromName((String)awsProperties.get("region"));
        String endpoint = awsProperties.get("endpoint");
        if (endpoint != null && !endpoint.isEmpty()) {
            return (AmazonElasticMapReduce)((AmazonElasticMapReduceClientBuilder)((AmazonElasticMapReduceClientBuilder)AmazonElasticMapReduceClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, regions.getName()))).withCredentials(awsCredentialsProvider)).build();
        }
        return (AmazonElasticMapReduce)((AmazonElasticMapReduceClientBuilder)((AmazonElasticMapReduceClientBuilder)AmazonElasticMapReduceClientBuilder.standard().withCredentials(awsCredentialsProvider)).withRegion(regions)).build();
    }

    @Generated
    private AmazonElasticMapReduceClientFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

