/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.workqueue.ratelimiter;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.Refill;
import io.github.bucket4j.local.LocalBucketBuilder;
import io.github.bucket4j.local.SynchronizationStrategy;
import io.kubernetes.client.extended.workqueue.ratelimiter.RateLimiter;
import java.time.Duration;

public class BucketRateLimiter<T>
implements RateLimiter<T> {
    private Bucket bucket;

    public BucketRateLimiter(long capacity, long tokensGeneratedInPeriod, Duration period) {
        Bandwidth bandwidth = Bandwidth.classic((long)capacity, (Refill)Refill.greedy((long)tokensGeneratedInPeriod, (Duration)period));
        this.bucket = ((LocalBucketBuilder)Bucket4j.builder().addLimit(bandwidth)).withSynchronizationStrategy(SynchronizationStrategy.SYNCHRONIZED).build();
    }

    @Override
    public Duration when(T item) {
        long overdraftNanos = this.bucket.consumeIgnoringRateLimits(1L);
        return Duration.ofNanos(overdraftNanos);
    }

    @Override
    public void forget(T item) {
    }

    @Override
    public int numRequeues(T item) {
        return 0;
    }
}

