/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster.loadbalancer;

import java.security.SecureRandom;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.server.master.cluster.WorkerClusters;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.IWorkerLoadBalancer;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.WorkerLoadBalancerType;
import org.jetbrains.annotations.NotNull;

public class RandomWorkerLoadBalancer
implements IWorkerLoadBalancer {
    private final WorkerClusters workerClusters;
    private final SecureRandom secureRandom;

    public RandomWorkerLoadBalancer(WorkerClusters workerClusters) {
        this.workerClusters = workerClusters;
        this.secureRandom = new SecureRandom();
    }

    @Override
    public Optional<String> select(@NotNull String workerGroup) {
        List<String> workerServerAddresses = this.workerClusters.getNormalWorkerServerAddressByGroup(workerGroup);
        if (CollectionUtils.isEmpty(workerServerAddresses)) {
            return Optional.empty();
        }
        int index = this.secureRandom.nextInt(workerServerAddresses.size());
        return Optional.of(workerServerAddresses.get(index));
    }

    @Override
    public WorkerLoadBalancerType getType() {
        return WorkerLoadBalancerType.RANDOM;
    }
}

