/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler;

import lombok.Generated;
import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.client.ITaskExecutorClient;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.TaskLifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRuntimeContextChangedEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler.AbstractTaskLifecycleEventHandler;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.ITaskStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorLifecycleEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskRuntimeContextChangedLifecycleEventHandler
extends AbstractTaskLifecycleEventHandler<TaskRuntimeContextChangedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskRuntimeContextChangedLifecycleEventHandler.class);
    private final ITaskExecutorClient taskExecutorClient;

    public TaskRuntimeContextChangedLifecycleEventHandler(ITaskExecutorClient taskExecutorClient) {
        this.taskExecutorClient = taskExecutorClient;
    }

    @Override
    public void handle(ITaskStateAction taskStateAction, IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskRuntimeContextChangedEvent event) {
        taskStateAction.onRuntimeContextChangedEvent(workflowExecutionRunnable, taskExecutionRunnable, event);
        this.taskExecutorClient.ackTaskExecutorLifecycleEvent(taskExecutionRunnable, new ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck(taskExecutionRunnable.getId(), TaskExecutorLifecycleEventType.RUNTIME_CONTEXT_CHANGE));
    }

    @Override
    public ILifecycleEventType matchEventType() {
        return TaskLifecycleEventType.RUNTIME_CONTEXT_CHANGED;
    }
}

