/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.metrics;

import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.extract.base.SyncRequestDto;
import org.apache.dolphinscheduler.extract.base.protocal.Transporter;

public class ClientSyncDurationMetrics {
    private Transporter transporter;
    private long milliseconds;
    private String clientHost;
    private String serverHost;

    public static ClientSyncDurationMetrics of(SyncRequestDto syncRequestDto) {
        return ClientSyncDurationMetrics.builder().transporter(syncRequestDto.getTransporter()).serverHost(syncRequestDto.getServerHost().getIp()).build();
    }

    public ClientSyncDurationMetrics withMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
        return this;
    }

    @Generated
    private static String $default$clientHost() {
        return NetUtils.getHost();
    }

    @Generated
    public static ClientSyncDurationMetricsBuilder builder() {
        return new ClientSyncDurationMetricsBuilder();
    }

    @Generated
    public Transporter getTransporter() {
        return this.transporter;
    }

    @Generated
    public long getMilliseconds() {
        return this.milliseconds;
    }

    @Generated
    public String getClientHost() {
        return this.clientHost;
    }

    @Generated
    public String getServerHost() {
        return this.serverHost;
    }

    @Generated
    public void setTransporter(Transporter transporter) {
        this.transporter = transporter;
    }

    @Generated
    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    @Generated
    public void setClientHost(String clientHost) {
        this.clientHost = clientHost;
    }

    @Generated
    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientSyncDurationMetrics)) {
            return false;
        }
        ClientSyncDurationMetrics other = (ClientSyncDurationMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMilliseconds() != other.getMilliseconds()) {
            return false;
        }
        Transporter this$transporter = this.getTransporter();
        Transporter other$transporter = other.getTransporter();
        if (this$transporter == null ? other$transporter != null : !((Object)this$transporter).equals(other$transporter)) {
            return false;
        }
        String this$clientHost = this.getClientHost();
        String other$clientHost = other.getClientHost();
        if (this$clientHost == null ? other$clientHost != null : !this$clientHost.equals(other$clientHost)) {
            return false;
        }
        String this$serverHost = this.getServerHost();
        String other$serverHost = other.getServerHost();
        return !(this$serverHost == null ? other$serverHost != null : !this$serverHost.equals(other$serverHost));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientSyncDurationMetrics;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $milliseconds = this.getMilliseconds();
        result = result * 59 + (int)($milliseconds >>> 32 ^ $milliseconds);
        Transporter $transporter = this.getTransporter();
        result = result * 59 + ($transporter == null ? 43 : ((Object)$transporter).hashCode());
        String $clientHost = this.getClientHost();
        result = result * 59 + ($clientHost == null ? 43 : $clientHost.hashCode());
        String $serverHost = this.getServerHost();
        result = result * 59 + ($serverHost == null ? 43 : $serverHost.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientSyncDurationMetrics(transporter=" + this.getTransporter() + ", milliseconds=" + this.getMilliseconds() + ", clientHost=" + this.getClientHost() + ", serverHost=" + this.getServerHost() + ")";
    }

    @Generated
    public ClientSyncDurationMetrics() {
        this.clientHost = ClientSyncDurationMetrics.$default$clientHost();
    }

    @Generated
    public ClientSyncDurationMetrics(Transporter transporter, long milliseconds, String clientHost, String serverHost) {
        this.transporter = transporter;
        this.milliseconds = milliseconds;
        this.clientHost = clientHost;
        this.serverHost = serverHost;
    }

    @Generated
    public static class ClientSyncDurationMetricsBuilder {
        @Generated
        private Transporter transporter;
        @Generated
        private long milliseconds;
        @Generated
        private boolean clientHost$set;
        @Generated
        private String clientHost$value;
        @Generated
        private String serverHost;

        @Generated
        ClientSyncDurationMetricsBuilder() {
        }

        @Generated
        public ClientSyncDurationMetricsBuilder transporter(Transporter transporter) {
            this.transporter = transporter;
            return this;
        }

        @Generated
        public ClientSyncDurationMetricsBuilder milliseconds(long milliseconds) {
            this.milliseconds = milliseconds;
            return this;
        }

        @Generated
        public ClientSyncDurationMetricsBuilder clientHost(String clientHost) {
            this.clientHost$value = clientHost;
            this.clientHost$set = true;
            return this;
        }

        @Generated
        public ClientSyncDurationMetricsBuilder serverHost(String serverHost) {
            this.serverHost = serverHost;
            return this;
        }

        @Generated
        public ClientSyncDurationMetrics build() {
            String clientHost$value = this.clientHost$value;
            if (!this.clientHost$set) {
                clientHost$value = ClientSyncDurationMetrics.$default$clientHost();
            }
            return new ClientSyncDurationMetrics(this.transporter, this.milliseconds, clientHost$value, this.serverHost);
        }

        @Generated
        public String toString() {
            return "ClientSyncDurationMetrics.ClientSyncDurationMetricsBuilder(transporter=" + this.transporter + ", milliseconds=" + this.milliseconds + ", clientHost$value=" + this.clientHost$value + ", serverHost=" + this.serverHost + ")";
        }
    }
}

