/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.audit.OperatorLog;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="SCHEDULE_TAG")
@RestController
@RequestMapping(value={"/projects/{projectCode}/schedules"})
public class SchedulerController
extends BaseController {
    public static final String DEFAULT_WARNING_TYPE = "NONE";
    public static final String DEFAULT_NOTIFY_GROUP_ID = "1";
    public static final String DEFAULT_FAILURE_POLICY = "CONTINUE";
    public static final String DEFAULT_WORKFLOW_INSTANCE_PRIORITY = "MEDIUM";
    @Autowired
    private SchedulerService schedulerService;

    @Operation(summary="createSchedule", description="CREATE_SCHEDULE_NOTES")
    @Parameters(value={@Parameter(name="workflowDefinitionCode", description="WORKFLOW_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="100")), @Parameter(name="schedule", description="SCHEDULE", schema=@Schema(implementation=String.class, example="{'startTime':'2019-06-10 00:00:00','endTime':'2019-06-13 00:00:00','timezoneId':'America/Phoenix','crontab':'0 0 3/6 * * ? *'}")), @Parameter(name="warningType", description="WARNING_TYPE", schema=@Schema(implementation=WarningType.class)), @Parameter(name="warningGroupId", description="WARNING_GROUP_ID", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="failureStrategy", description="FAILURE_STRATEGY", schema=@Schema(implementation=FailureStrategy.class)), @Parameter(name="workerGroup", description="WORKER_GROUP", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="tenantCode", description="TENANT_CODE", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="environmentCode", description="ENVIRONMENT_CODE", schema=@Schema(implementation=long.class)), @Parameter(name="workflowInstancePriority", description="WORKFLOW_INSTANCE_PRIORITY", schema=@Schema(implementation=Priority.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_SCHEDULE_ERROR)
    @OperatorLog(auditType=AuditType.SCHEDULE_CREATE)
    public Result createSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="workflowDefinitionCode") long workflowDefinitionCode, @RequestParam(value="schedule") String schedule, @RequestParam(value="warningType", required=false, defaultValue="NONE") WarningType warningType, @RequestParam(value="warningGroupId", required=false, defaultValue="1") int warningGroupId, @RequestParam(value="failureStrategy", required=false, defaultValue="CONTINUE") FailureStrategy failureStrategy, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="tenantCode", required=false, defaultValue="default") String tenantCode, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="workflowInstancePriority", required=false, defaultValue="MEDIUM") Priority workflowInstancePriority) {
        Map<String, Object> result = this.schedulerService.insertSchedule(loginUser, projectCode, workflowDefinitionCode, schedule, warningType, warningGroupId, failureStrategy, workflowInstancePriority, workerGroup, tenantCode, environmentCode);
        return this.returnDataList(result);
    }

    @Operation(summary="updateSchedule", description="UPDATE_SCHEDULE_NOTES")
    @Parameters(value={@Parameter(name="id", description="SCHEDULE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="schedule", description="SCHEDULE", schema=@Schema(implementation=String.class, example="{\"startTime\":\"1996-08-08 00:00:00\",\"endTime\":\"2200-08-08 00:00:00\",\"timezoneId\":\"America/Phoenix\",\"crontab\":\"0 0 3/6 * * ? *\"}")), @Parameter(name="warningType", description="WARNING_TYPE", schema=@Schema(implementation=WarningType.class)), @Parameter(name="warningGroupId", description="WARNING_GROUP_ID", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="failureStrategy", description="FAILURE_STRATEGY", schema=@Schema(implementation=FailureStrategy.class)), @Parameter(name="workerGroup", description="WORKER_GROUP", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="tenantCode", description="TENANT_CODE", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="workflowInstancePriority", description="WORKFLOW_INSTANCE_PRIORITY", schema=@Schema(implementation=Priority.class)), @Parameter(name="environmentCode", description="ENVIRONMENT_CODE", schema=@Schema(implementation=long.class))})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_SCHEDULE_ERROR)
    @OperatorLog(auditType=AuditType.SCHEDULE_UPDATE)
    public Result updateSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id, @RequestParam(value="schedule") String schedule, @RequestParam(value="warningType", required=false, defaultValue="NONE") WarningType warningType, @RequestParam(value="warningGroupId", required=false, defaultValue="1") int warningGroupId, @RequestParam(value="failureStrategy", required=false, defaultValue="END") FailureStrategy failureStrategy, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="tenantCode", required=false, defaultValue="default") String tenantCode, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="workflowInstancePriority", required=false, defaultValue="MEDIUM") Priority workflowInstancePriority) {
        Map<String, Object> result = this.schedulerService.updateSchedule(loginUser, projectCode, id, schedule, warningType, warningGroupId, failureStrategy, workflowInstancePriority, workerGroup, tenantCode, environmentCode);
        return this.returnDataList(result);
    }

    @Operation(summary="online", description="ONLINE_SCHEDULE_NOTES")
    @Parameters(value={@Parameter(name="id", description="SCHEDULE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @PostMapping(value={"/{id}/online"})
    @ApiException(value=Status.PUBLISH_SCHEDULE_ONLINE_ERROR)
    @OperatorLog(auditType=AuditType.SCHEDULE_ONLINE)
    public Result<Boolean> publishScheduleOnline(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        this.schedulerService.onlineScheduler(loginUser, projectCode, id);
        return Result.success(true);
    }

    @Operation(summary="offline", description="OFFLINE_SCHEDULE_NOTES")
    @Parameters(value={@Parameter(name="id", description="SCHEDULE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @PostMapping(value={"/{id}/offline"})
    @ApiException(value=Status.OFFLINE_SCHEDULE_ERROR)
    @OperatorLog(auditType=AuditType.SCHEDULE_OFFLINE)
    public Result<Boolean> offlineSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        this.schedulerService.offlineScheduler(loginUser, projectCode, id);
        return Result.success(true);
    }

    @Operation(summary="queryScheduleListPaging", description="QUERY_SCHEDULE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping
    @ApiException(value=Status.QUERY_SCHEDULE_LIST_PAGING_ERROR)
    public Result queryScheduleListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="workflowDefinitionCode", required=false, defaultValue="0") long workflowDefinitionCode, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.schedulerService.querySchedule(loginUser, projectCode, workflowDefinitionCode, searchVal, pageNo, pageSize);
    }

    @Operation(summary="deleteScheduleById", description="DELETE_SCHEDULE_NOTES")
    @Parameters(value={@Parameter(name="id", description="SCHEDULE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_SCHEDULE_BY_ID_ERROR)
    @OperatorLog(auditType=AuditType.SCHEDULE_DELETE)
    public Result deleteScheduleById(@RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        this.schedulerService.deleteSchedulesById(loginUser, id);
        return new Result(Status.SUCCESS);
    }

    @Operation(summary="queryScheduleList", description="QUERY_SCHEDULE_LIST_NOTES")
    @PostMapping(value={"/list"})
    @ApiException(value=Status.QUERY_SCHEDULE_LIST_ERROR)
    public Result queryScheduleList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        Map<String, Object> result = this.schedulerService.queryScheduleList(loginUser, projectCode);
        return this.returnDataList(result);
    }

    @Operation(summary="previewSchedule", description="PREVIEW_SCHEDULE_NOTES")
    @Parameters(value={@Parameter(name="schedule", description="SCHEDULE", schema=@Schema(implementation=String.class, example="{'startTime':'2019-06-10 00:00:00','endTime':'2019-06-13 00:00:00','crontab':'0 0 3/6 * * ? *'}"))})
    @PostMapping(value={"/preview"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.PREVIEW_SCHEDULE_ERROR)
    public Result previewSchedule(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="schedule") String schedule) {
        Map<String, Object> result = this.schedulerService.previewSchedule(loginUser, schedule);
        return this.returnDataList(result);
    }

    @Operation(summary="updateScheduleByWorkflowDefinitionCode", description="UPDATE_SCHEDULE_BY_WORKFLOW_DEFINITION_CODE_NOTES")
    @Parameters(value={@Parameter(name="workflowDefinitionCode", description="WORKFLOW_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="12345678")), @Parameter(name="schedule", description="SCHEDULE", schema=@Schema(implementation=String.class, example="{'startTime':'2019-06-10 00:00:00','endTime':'2019-06-13 00:00:00','crontab':'0 0 3/6 * * ? *'}")), @Parameter(name="warningType", description="WARNING_TYPE", schema=@Schema(implementation=WarningType.class)), @Parameter(name="warningGroupId", description="WARNING_GROUP_ID", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="failureStrategy", description="FAILURE_STRATEGY", schema=@Schema(implementation=FailureStrategy.class)), @Parameter(name="workerGroup", description="WORKER_GROUP", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="tenantCode", description="TENANT_CODE", schema=@Schema(implementation=String.class, example="default")), @Parameter(name="workflowInstancePriority", description="WORKFLOW_INSTANCE_PRIORITY", schema=@Schema(implementation=Priority.class)), @Parameter(name="environmentCode", description="ENVIRONMENT_CODE", schema=@Schema(implementation=long.class))})
    @PutMapping(value={"/update/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_SCHEDULE_ERROR)
    @OperatorLog(auditType=AuditType.SCHEDULE_UPDATE)
    public Result updateScheduleByWorkflowDefinitionCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long workflowDefinitionCode, @RequestParam(value="schedule") String schedule, @RequestParam(value="warningType", required=false, defaultValue="NONE") WarningType warningType, @RequestParam(value="warningGroupId", required=false) int warningGroupId, @RequestParam(value="failureStrategy", required=false, defaultValue="END") FailureStrategy failureStrategy, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="tenantCode", required=false, defaultValue="default") String tenantCode, @RequestParam(value="environmentCode", required=false, defaultValue="-1") long environmentCode, @RequestParam(value="workflowInstancePriority", required=false) Priority workflowInstancePriority) {
        Map<String, Object> result = this.schedulerService.updateScheduleByWorkflowDefinitionCode(loginUser, projectCode, workflowDefinitionCode, schedule, warningType, warningGroupId, failureStrategy, workflowInstancePriority, workerGroup, tenantCode, environmentCode);
        return this.returnDataList(result);
    }
}

