/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.task;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.utils.WorkerGroupUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;

public class TaskCreateRequest {
    @Schema(example="workflow-code", required=true)
    private long workflowCode;
    @Schema(example="task-name", required=true)
    private String name;
    @Schema(example="describe what this task actual do", required=true)
    private String description;
    @Schema(example="6816095515584", implementation=Long.class)
    private long projectCode;
    @Schema(example="SHELL", required=true)
    private String taskType;
    @Schema(example="{\"localParams\": [], \"rawScript\": \"echo 1\", \"resourceList\": []}", required=true, description="task definition params")
    private String taskParams;
    @Schema(example="YES", allowableValues={"YES,NO"}, description="default YES is not provided")
    private String flag;
    @Schema(example="MEDIUM", allowableValues={"HIGHEST,HIGH,MEDIUM,LOW,LOWEST"}, description="default MEDIUM is not provided")
    private String taskPriority;
    @Schema(example="default", description="default 'default' if not provided")
    private String workerGroup;
    @Schema(example="6563415109312", implementation=Long.class)
    private long environmentCode;
    @Schema(example="0", implementation=int.class, description="default 0 not provided")
    private int failRetryTimes;
    @Schema(example="1")
    private int failRetryInterval;
    @Schema(example="SHELL")
    private int timeout;
    @Schema(example="CLOSE", allowableValues={"CLOSE,OPEN"}, description="default CLOSE is not provided")
    private String timeoutFlag;
    @Schema(example="MEDIUM", allowableValues={"WARN,FAILED,WARNFAILED"}, description="default MEDIUM is not provided")
    private String timeoutNotifyStrategy;
    @Schema(example="1,2,3")
    private String resourceIds;
    @Schema(example="2")
    private int taskGroupId;
    @Schema(example="1", implementation=int.class, description="A priority number for execute task, the bigger the high priority, default null if not provided")
    private int taskGroupPriority;
    @Schema(example="1", implementation=Integer.class, description="default unlimited if not provided")
    private Integer cpuQuota;
    @Schema(example="0.1", implementation=Integer.class, description="default unlimited if not provided")
    private Integer memoryMax;
    @Schema(example="upstream-task-codes1,upstream-task-codes2", description="use , to split multiple upstream task codes")
    private String upstreamTasksCodes;

    public TaskDefinition convert2TaskDefinition() {
        TaskDefinition taskDefinition = new TaskDefinition();
        taskDefinition.setName(this.name);
        taskDefinition.setDescription(this.description);
        taskDefinition.setProjectCode(this.projectCode);
        taskDefinition.setTaskType(this.taskType);
        taskDefinition.setTaskParams(this.taskParams);
        taskDefinition.setWorkerGroup(WorkerGroupUtils.getWorkerGroupOrDefault((String)this.workerGroup));
        taskDefinition.setEnvironmentCode(this.environmentCode);
        taskDefinition.setFailRetryTimes(this.failRetryTimes);
        taskDefinition.setFailRetryInterval(this.failRetryInterval);
        taskDefinition.setTimeout(this.timeout);
        taskDefinition.setResourceIds(this.resourceIds);
        taskDefinition.setTaskGroupId(this.taskGroupId);
        taskDefinition.setTaskGroupPriority(this.taskGroupPriority);
        taskDefinition.setCpuQuota(this.cpuQuota);
        taskDefinition.setMemoryMax(this.memoryMax);
        Flag flagCreate = this.flag == null ? Flag.YES : Flag.valueOf((String)this.flag);
        taskDefinition.setFlag(flagCreate);
        TimeoutFlag timeoutFlagCreate = this.timeoutFlag == null ? TimeoutFlag.CLOSE : TimeoutFlag.valueOf((String)this.timeoutFlag);
        taskDefinition.setTimeoutFlag(timeoutFlagCreate);
        Priority taskPriorityCreate = this.taskPriority == null ? Priority.MEDIUM : Priority.valueOf((String)this.taskPriority);
        taskDefinition.setTaskPriority(taskPriorityCreate);
        TaskTimeoutStrategy taskTimeoutStrategyCreate = this.timeoutNotifyStrategy == null ? TaskTimeoutStrategy.WARN : TaskTimeoutStrategy.valueOf((String)this.timeoutNotifyStrategy);
        taskDefinition.setTimeoutNotifyStrategy(taskTimeoutStrategyCreate);
        taskDefinition.setVersion(1);
        Date date = new Date();
        taskDefinition.setCreateTime(date);
        taskDefinition.setUpdateTime(date);
        return taskDefinition;
    }

    @Generated
    public TaskCreateRequest() {
    }

    @Generated
    public long getWorkflowCode() {
        return this.workflowCode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public long getProjectCode() {
        return this.projectCode;
    }

    @Generated
    public String getTaskType() {
        return this.taskType;
    }

    @Generated
    public String getTaskParams() {
        return this.taskParams;
    }

    @Generated
    public String getFlag() {
        return this.flag;
    }

    @Generated
    public String getTaskPriority() {
        return this.taskPriority;
    }

    @Generated
    public String getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public long getEnvironmentCode() {
        return this.environmentCode;
    }

    @Generated
    public int getFailRetryTimes() {
        return this.failRetryTimes;
    }

    @Generated
    public int getFailRetryInterval() {
        return this.failRetryInterval;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getTimeoutFlag() {
        return this.timeoutFlag;
    }

    @Generated
    public String getTimeoutNotifyStrategy() {
        return this.timeoutNotifyStrategy;
    }

    @Generated
    public String getResourceIds() {
        return this.resourceIds;
    }

    @Generated
    public int getTaskGroupId() {
        return this.taskGroupId;
    }

    @Generated
    public int getTaskGroupPriority() {
        return this.taskGroupPriority;
    }

    @Generated
    public Integer getCpuQuota() {
        return this.cpuQuota;
    }

    @Generated
    public Integer getMemoryMax() {
        return this.memoryMax;
    }

    @Generated
    public String getUpstreamTasksCodes() {
        return this.upstreamTasksCodes;
    }

    @Generated
    public void setWorkflowCode(long workflowCode) {
        this.workflowCode = workflowCode;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProjectCode(long projectCode) {
        this.projectCode = projectCode;
    }

    @Generated
    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @Generated
    public void setTaskParams(String taskParams) {
        this.taskParams = taskParams;
    }

    @Generated
    public void setFlag(String flag) {
        this.flag = flag;
    }

    @Generated
    public void setTaskPriority(String taskPriority) {
        this.taskPriority = taskPriority;
    }

    @Generated
    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    @Generated
    public void setEnvironmentCode(long environmentCode) {
        this.environmentCode = environmentCode;
    }

    @Generated
    public void setFailRetryTimes(int failRetryTimes) {
        this.failRetryTimes = failRetryTimes;
    }

    @Generated
    public void setFailRetryInterval(int failRetryInterval) {
        this.failRetryInterval = failRetryInterval;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setTimeoutFlag(String timeoutFlag) {
        this.timeoutFlag = timeoutFlag;
    }

    @Generated
    public void setTimeoutNotifyStrategy(String timeoutNotifyStrategy) {
        this.timeoutNotifyStrategy = timeoutNotifyStrategy;
    }

    @Generated
    public void setResourceIds(String resourceIds) {
        this.resourceIds = resourceIds;
    }

    @Generated
    public void setTaskGroupId(int taskGroupId) {
        this.taskGroupId = taskGroupId;
    }

    @Generated
    public void setTaskGroupPriority(int taskGroupPriority) {
        this.taskGroupPriority = taskGroupPriority;
    }

    @Generated
    public void setCpuQuota(Integer cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    @Generated
    public void setMemoryMax(Integer memoryMax) {
        this.memoryMax = memoryMax;
    }

    @Generated
    public void setUpstreamTasksCodes(String upstreamTasksCodes) {
        this.upstreamTasksCodes = upstreamTasksCodes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskCreateRequest)) {
            return false;
        }
        TaskCreateRequest other = (TaskCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorkflowCode() != other.getWorkflowCode()) {
            return false;
        }
        if (this.getProjectCode() != other.getProjectCode()) {
            return false;
        }
        if (this.getEnvironmentCode() != other.getEnvironmentCode()) {
            return false;
        }
        if (this.getFailRetryTimes() != other.getFailRetryTimes()) {
            return false;
        }
        if (this.getFailRetryInterval() != other.getFailRetryInterval()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getTaskGroupId() != other.getTaskGroupId()) {
            return false;
        }
        if (this.getTaskGroupPriority() != other.getTaskGroupPriority()) {
            return false;
        }
        Integer this$cpuQuota = this.getCpuQuota();
        Integer other$cpuQuota = other.getCpuQuota();
        if (this$cpuQuota == null ? other$cpuQuota != null : !((Object)this$cpuQuota).equals(other$cpuQuota)) {
            return false;
        }
        Integer this$memoryMax = this.getMemoryMax();
        Integer other$memoryMax = other.getMemoryMax();
        if (this$memoryMax == null ? other$memoryMax != null : !((Object)this$memoryMax).equals(other$memoryMax)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$taskType = this.getTaskType();
        String other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
            return false;
        }
        String this$taskParams = this.getTaskParams();
        String other$taskParams = other.getTaskParams();
        if (this$taskParams == null ? other$taskParams != null : !this$taskParams.equals(other$taskParams)) {
            return false;
        }
        String this$flag = this.getFlag();
        String other$flag = other.getFlag();
        if (this$flag == null ? other$flag != null : !this$flag.equals(other$flag)) {
            return false;
        }
        String this$taskPriority = this.getTaskPriority();
        String other$taskPriority = other.getTaskPriority();
        if (this$taskPriority == null ? other$taskPriority != null : !this$taskPriority.equals(other$taskPriority)) {
            return false;
        }
        String this$workerGroup = this.getWorkerGroup();
        String other$workerGroup = other.getWorkerGroup();
        if (this$workerGroup == null ? other$workerGroup != null : !this$workerGroup.equals(other$workerGroup)) {
            return false;
        }
        String this$timeoutFlag = this.getTimeoutFlag();
        String other$timeoutFlag = other.getTimeoutFlag();
        if (this$timeoutFlag == null ? other$timeoutFlag != null : !this$timeoutFlag.equals(other$timeoutFlag)) {
            return false;
        }
        String this$timeoutNotifyStrategy = this.getTimeoutNotifyStrategy();
        String other$timeoutNotifyStrategy = other.getTimeoutNotifyStrategy();
        if (this$timeoutNotifyStrategy == null ? other$timeoutNotifyStrategy != null : !this$timeoutNotifyStrategy.equals(other$timeoutNotifyStrategy)) {
            return false;
        }
        String this$resourceIds = this.getResourceIds();
        String other$resourceIds = other.getResourceIds();
        if (this$resourceIds == null ? other$resourceIds != null : !this$resourceIds.equals(other$resourceIds)) {
            return false;
        }
        String this$upstreamTasksCodes = this.getUpstreamTasksCodes();
        String other$upstreamTasksCodes = other.getUpstreamTasksCodes();
        return !(this$upstreamTasksCodes == null ? other$upstreamTasksCodes != null : !this$upstreamTasksCodes.equals(other$upstreamTasksCodes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskCreateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $workflowCode = this.getWorkflowCode();
        result = result * 59 + (int)($workflowCode >>> 32 ^ $workflowCode);
        long $projectCode = this.getProjectCode();
        result = result * 59 + (int)($projectCode >>> 32 ^ $projectCode);
        long $environmentCode = this.getEnvironmentCode();
        result = result * 59 + (int)($environmentCode >>> 32 ^ $environmentCode);
        result = result * 59 + this.getFailRetryTimes();
        result = result * 59 + this.getFailRetryInterval();
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getTaskGroupId();
        result = result * 59 + this.getTaskGroupPriority();
        Integer $cpuQuota = this.getCpuQuota();
        result = result * 59 + ($cpuQuota == null ? 43 : ((Object)$cpuQuota).hashCode());
        Integer $memoryMax = this.getMemoryMax();
        result = result * 59 + ($memoryMax == null ? 43 : ((Object)$memoryMax).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
        String $taskParams = this.getTaskParams();
        result = result * 59 + ($taskParams == null ? 43 : $taskParams.hashCode());
        String $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : $flag.hashCode());
        String $taskPriority = this.getTaskPriority();
        result = result * 59 + ($taskPriority == null ? 43 : $taskPriority.hashCode());
        String $workerGroup = this.getWorkerGroup();
        result = result * 59 + ($workerGroup == null ? 43 : $workerGroup.hashCode());
        String $timeoutFlag = this.getTimeoutFlag();
        result = result * 59 + ($timeoutFlag == null ? 43 : $timeoutFlag.hashCode());
        String $timeoutNotifyStrategy = this.getTimeoutNotifyStrategy();
        result = result * 59 + ($timeoutNotifyStrategy == null ? 43 : $timeoutNotifyStrategy.hashCode());
        String $resourceIds = this.getResourceIds();
        result = result * 59 + ($resourceIds == null ? 43 : $resourceIds.hashCode());
        String $upstreamTasksCodes = this.getUpstreamTasksCodes();
        result = result * 59 + ($upstreamTasksCodes == null ? 43 : $upstreamTasksCodes.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskCreateRequest(workflowCode=" + this.getWorkflowCode() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", projectCode=" + this.getProjectCode() + ", taskType=" + this.getTaskType() + ", taskParams=" + this.getTaskParams() + ", flag=" + this.getFlag() + ", taskPriority=" + this.getTaskPriority() + ", workerGroup=" + this.getWorkerGroup() + ", environmentCode=" + this.getEnvironmentCode() + ", failRetryTimes=" + this.getFailRetryTimes() + ", failRetryInterval=" + this.getFailRetryInterval() + ", timeout=" + this.getTimeout() + ", timeoutFlag=" + this.getTimeoutFlag() + ", timeoutNotifyStrategy=" + this.getTimeoutNotifyStrategy() + ", resourceIds=" + this.getResourceIds() + ", taskGroupId=" + this.getTaskGroupId() + ", taskGroupPriority=" + this.getTaskGroupPriority() + ", cpuQuota=" + this.getCpuQuota() + ", memoryMax=" + this.getMemoryMax() + ", upstreamTasksCodes=" + this.getUpstreamTasksCodes() + ")";
    }
}

