/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security.impl.ldap;

import lombok.NonNull;
import org.apache.dolphinscheduler.api.dto.LdapLoginResult;
import org.apache.dolphinscheduler.api.security.impl.AbstractAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.ldap.LdapService;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;

public class LdapAuthenticator
extends AbstractAuthenticator {
    @Autowired
    LdapService ldapService;

    @Override
    public User login(@NonNull String userName, String password) {
        if (userName == null) {
            throw new NullPointerException("userName is marked non-null but is null");
        }
        User user = null;
        LdapLoginResult ldapLoginResult = this.ldapService.ldapLogin(userName, password);
        if (ldapLoginResult.isSuccess() && (user = this.userService.getUserByUserName(userName)) == null && this.ldapService.createIfUserNotExists()) {
            user = this.userService.createUser(ldapLoginResult.getUserType(), userName, ldapLoginResult.getLdapEmail());
        }
        return user;
    }
}

