/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.resources.CreateDirectoryDto;
import org.apache.dolphinscheduler.api.dto.resources.CreateDirectoryRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.validator.ITransformer;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateDirectoryRequestTransformer
implements ITransformer<CreateDirectoryRequest, CreateDirectoryDto> {
    @Autowired
    private TenantDao tenantDao;
    @Autowired
    private StorageOperator storageOperator;

    @Override
    public CreateDirectoryDto transform(CreateDirectoryRequest createDirectoryRequest) {
        this.validateCreateDirectoryRequest(createDirectoryRequest);
        return this.doTransform(createDirectoryRequest);
    }

    private CreateDirectoryDto doTransform(CreateDirectoryRequest createDirectoryRequest) {
        String directoryAbsolutePath = this.getDirectoryAbsolutePath(createDirectoryRequest);
        return CreateDirectoryDto.builder().loginUser(createDirectoryRequest.getLoginUser()).directoryAbsolutePath(directoryAbsolutePath).build();
    }

    private void validateCreateDirectoryRequest(CreateDirectoryRequest createDirectoryRequest) {
        Preconditions.checkNotNull((Object)createDirectoryRequest.getLoginUser(), (Object)"loginUser is null");
        Preconditions.checkNotNull((Object)createDirectoryRequest.getType(), (Object)"resource type is null");
        Preconditions.checkNotNull((Object)createDirectoryRequest.getDirectoryName(), (Object)"directory name is null");
        Preconditions.checkNotNull((Object)createDirectoryRequest.getParentAbsoluteDirectory(), (Object)"parent directory is null");
    }

    private String getDirectoryAbsolutePath(CreateDirectoryRequest createDirectoryRequest) {
        String tenantCode = ((Tenant)this.tenantDao.queryOptionalById((Serializable)Integer.valueOf(createDirectoryRequest.getLoginUser().getTenantId())).orElseThrow(() -> new ServiceException(Status.CURRENT_LOGIN_USER_TENANT_NOT_EXIST))).getTenantCode();
        String userResRootPath = this.storageOperator.getStorageBaseDirectory(tenantCode, createDirectoryRequest.getType());
        String parentDirectoryName = createDirectoryRequest.getParentAbsoluteDirectory();
        String directoryName = createDirectoryRequest.getDirectoryName();
        if (parentDirectoryName.equals("/")) {
            return FileUtils.concatFilePath((String[])new String[]{userResRootPath, directoryName});
        }
        if (!StringUtils.startsWith((CharSequence)parentDirectoryName, (CharSequence)userResRootPath)) {
            throw new ServiceException(Status.ILLEGAL_RESOURCE_PATH, parentDirectoryName);
        }
        return FileUtils.concatFilePath((String[])new String[]{parentDirectoryName, directoryName});
    }
}

