/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.model.TaskInstanceStatusCountDto;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;

public class TaskInstanceCountVO {
    private int totalCount;
    private List<TaskInstanceStatusCountDto> taskInstanceStatusCounts;

    public static TaskInstanceCountVO empty() {
        return TaskInstanceCountVO.of(Collections.emptyList());
    }

    public static TaskInstanceCountVO of(List<TaskInstanceStatusCountDto> taskInstanceStatusCounts) {
        taskInstanceStatusCounts = new ArrayList<TaskInstanceStatusCountDto>(taskInstanceStatusCounts);
        Map taskInstanceStatusCountMap = taskInstanceStatusCounts.stream().collect(Collectors.toMap(TaskInstanceStatusCountDto::getState, Function.identity()));
        for (TaskExecutionStatus value : TaskExecutionStatus.values()) {
            if (taskInstanceStatusCountMap.containsKey(value)) continue;
            taskInstanceStatusCounts.add(new TaskInstanceStatusCountDto(value, 0));
        }
        TaskInstanceCountVO taskInstanceCountVo = new TaskInstanceCountVO();
        taskInstanceCountVo.setTaskInstanceStatusCounts(taskInstanceStatusCounts);
        taskInstanceCountVo.setTotalCount(taskInstanceStatusCounts.stream().mapToInt(TaskInstanceStatusCountDto::getCount).sum());
        return taskInstanceCountVo;
    }

    @Generated
    public int getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public List<TaskInstanceStatusCountDto> getTaskInstanceStatusCounts() {
        return this.taskInstanceStatusCounts;
    }

    @Generated
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public void setTaskInstanceStatusCounts(List<TaskInstanceStatusCountDto> taskInstanceStatusCounts) {
        this.taskInstanceStatusCounts = taskInstanceStatusCounts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskInstanceCountVO)) {
            return false;
        }
        TaskInstanceCountVO other = (TaskInstanceCountVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        List<TaskInstanceStatusCountDto> this$taskInstanceStatusCounts = this.getTaskInstanceStatusCounts();
        List<TaskInstanceStatusCountDto> other$taskInstanceStatusCounts = other.getTaskInstanceStatusCounts();
        return !(this$taskInstanceStatusCounts == null ? other$taskInstanceStatusCounts != null : !((Object)this$taskInstanceStatusCounts).equals(other$taskInstanceStatusCounts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskInstanceCountVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalCount();
        List<TaskInstanceStatusCountDto> $taskInstanceStatusCounts = this.getTaskInstanceStatusCounts();
        result = result * 59 + ($taskInstanceStatusCounts == null ? 43 : ((Object)$taskInstanceStatusCounts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskInstanceCountVO(totalCount=" + this.getTotalCount() + ", taskInstanceStatusCounts=" + this.getTaskInstanceStatusCounts() + ")";
    }

    @Generated
    public TaskInstanceCountVO() {
    }

    @Generated
    public TaskInstanceCountVO(int totalCount, List<TaskInstanceStatusCountDto> taskInstanceStatusCounts) {
        this.totalCount = totalCount;
        this.taskInstanceStatusCounts = taskInstanceStatusCounts;
    }
}

