/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.tephra.distributed.thrift;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTransactionServer {

  public interface Iface {

    public TTransaction startLong() throws org.apache.thrift.TException;

    public TTransaction startShort() throws org.apache.thrift.TException;

    public TTransaction startLongClientId(String clientId) throws TGenericException, org.apache.thrift.TException;

    public TTransaction startShortTimeout(int timeout) throws org.apache.thrift.TException;

    public TTransaction startShortClientId(String clientId) throws TGenericException, org.apache.thrift.TException;

    public TTransaction startShortWithClientIdAndTimeOut(String clientId, int timeout) throws TGenericException, org.apache.thrift.TException;

    public TTransaction startShortWithTimeout(int timeout) throws TGenericException, org.apache.thrift.TException;

    public TBoolean canCommitTx(TTransaction tx, Set<ByteBuffer> changes) throws TTransactionNotInProgressException, org.apache.thrift.TException;

    public void canCommitOrThrow(long tx, Set<ByteBuffer> changes) throws TTransactionNotInProgressException, TTransactionConflictException, TGenericException, org.apache.thrift.TException;

    public TBoolean commitTx(TTransaction tx) throws TTransactionNotInProgressException, org.apache.thrift.TException;

    public void commitOrThrow(long txId, long wp) throws TTransactionNotInProgressException, TTransactionConflictException, TGenericException, org.apache.thrift.TException;

    public void abortTx(TTransaction tx) throws org.apache.thrift.TException;

    public boolean invalidateTx(long txid) throws org.apache.thrift.TException;

    public ByteBuffer getSnapshot() throws TTransactionCouldNotTakeSnapshotException, org.apache.thrift.TException;

    public void resetState() throws org.apache.thrift.TException;

    public String status() throws org.apache.thrift.TException;

    public TBoolean truncateInvalidTx(Set<Long> txns) throws org.apache.thrift.TException;

    public TBoolean truncateInvalidTxBefore(long time) throws TInvalidTruncateTimeException, org.apache.thrift.TException;

    public int invalidTxSize() throws org.apache.thrift.TException;

    public TTransaction checkpoint(TTransaction tx) throws TTransactionNotInProgressException, org.apache.thrift.TException;

    public void pruneNow() throws org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void startLong(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.startLong_call> resultHandler) throws org.apache.thrift.TException;

    public void startShort(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.startShort_call> resultHandler) throws org.apache.thrift.TException;

    public void startLongClientId(String clientId, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.startLongClientId_call> resultHandler) throws org.apache.thrift.TException;

    public void startShortTimeout(int timeout, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.startShortTimeout_call> resultHandler) throws org.apache.thrift.TException;

    public void startShortClientId(String clientId, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.startShortClientId_call> resultHandler) throws org.apache.thrift.TException;

    public void startShortWithClientIdAndTimeOut(String clientId, int timeout, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.startShortWithClientIdAndTimeOut_call> resultHandler) throws org.apache.thrift.TException;

    public void startShortWithTimeout(int timeout, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.startShortWithTimeout_call> resultHandler) throws org.apache.thrift.TException;

    public void canCommitTx(TTransaction tx, Set<ByteBuffer> changes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.canCommitTx_call> resultHandler) throws org.apache.thrift.TException;

    public void canCommitOrThrow(long tx, Set<ByteBuffer> changes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.canCommitOrThrow_call> resultHandler) throws org.apache.thrift.TException;

    public void commitTx(TTransaction tx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.commitTx_call> resultHandler) throws org.apache.thrift.TException;

    public void commitOrThrow(long txId, long wp, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.commitOrThrow_call> resultHandler) throws org.apache.thrift.TException;

    public void abortTx(TTransaction tx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.abortTx_call> resultHandler) throws org.apache.thrift.TException;

    public void invalidateTx(long txid, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.invalidateTx_call> resultHandler) throws org.apache.thrift.TException;

    public void getSnapshot(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getSnapshot_call> resultHandler) throws org.apache.thrift.TException;

    public void resetState(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.resetState_call> resultHandler) throws org.apache.thrift.TException;

    public void status(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.status_call> resultHandler) throws org.apache.thrift.TException;

    public void truncateInvalidTx(Set<Long> txns, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.truncateInvalidTx_call> resultHandler) throws org.apache.thrift.TException;

    public void truncateInvalidTxBefore(long time, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.truncateInvalidTxBefore_call> resultHandler) throws org.apache.thrift.TException;

    public void invalidTxSize(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.invalidTxSize_call> resultHandler) throws org.apache.thrift.TException;

    public void checkpoint(TTransaction tx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.checkpoint_call> resultHandler) throws org.apache.thrift.TException;

    public void pruneNow(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.pruneNow_call> resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public TTransaction startLong() throws org.apache.thrift.TException
    {
      send_startLong();
      return recv_startLong();
    }

    public void send_startLong() throws org.apache.thrift.TException
    {
      startLong_args args = new startLong_args();
      sendBase("startLong", args);
    }

    public TTransaction recv_startLong() throws org.apache.thrift.TException
    {
      startLong_result result = new startLong_result();
      receiveBase(result, "startLong");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startLong failed: unknown result");
    }

    public TTransaction startShort() throws org.apache.thrift.TException
    {
      send_startShort();
      return recv_startShort();
    }

    public void send_startShort() throws org.apache.thrift.TException
    {
      startShort_args args = new startShort_args();
      sendBase("startShort", args);
    }

    public TTransaction recv_startShort() throws org.apache.thrift.TException
    {
      startShort_result result = new startShort_result();
      receiveBase(result, "startShort");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startShort failed: unknown result");
    }

    public TTransaction startLongClientId(String clientId) throws TGenericException, org.apache.thrift.TException
    {
      send_startLongClientId(clientId);
      return recv_startLongClientId();
    }

    public void send_startLongClientId(String clientId) throws org.apache.thrift.TException
    {
      startLongClientId_args args = new startLongClientId_args();
      args.setClientId(clientId);
      sendBase("startLongClientId", args);
    }

    public TTransaction recv_startLongClientId() throws TGenericException, org.apache.thrift.TException
    {
      startLongClientId_result result = new startLongClientId_result();
      receiveBase(result, "startLongClientId");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startLongClientId failed: unknown result");
    }

    public TTransaction startShortTimeout(int timeout) throws org.apache.thrift.TException
    {
      send_startShortTimeout(timeout);
      return recv_startShortTimeout();
    }

    public void send_startShortTimeout(int timeout) throws org.apache.thrift.TException
    {
      startShortTimeout_args args = new startShortTimeout_args();
      args.setTimeout(timeout);
      sendBase("startShortTimeout", args);
    }

    public TTransaction recv_startShortTimeout() throws org.apache.thrift.TException
    {
      startShortTimeout_result result = new startShortTimeout_result();
      receiveBase(result, "startShortTimeout");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startShortTimeout failed: unknown result");
    }

    public TTransaction startShortClientId(String clientId) throws TGenericException, org.apache.thrift.TException
    {
      send_startShortClientId(clientId);
      return recv_startShortClientId();
    }

    public void send_startShortClientId(String clientId) throws org.apache.thrift.TException
    {
      startShortClientId_args args = new startShortClientId_args();
      args.setClientId(clientId);
      sendBase("startShortClientId", args);
    }

    public TTransaction recv_startShortClientId() throws TGenericException, org.apache.thrift.TException
    {
      startShortClientId_result result = new startShortClientId_result();
      receiveBase(result, "startShortClientId");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startShortClientId failed: unknown result");
    }

    public TTransaction startShortWithClientIdAndTimeOut(String clientId, int timeout) throws TGenericException, org.apache.thrift.TException
    {
      send_startShortWithClientIdAndTimeOut(clientId, timeout);
      return recv_startShortWithClientIdAndTimeOut();
    }

    public void send_startShortWithClientIdAndTimeOut(String clientId, int timeout) throws org.apache.thrift.TException
    {
      startShortWithClientIdAndTimeOut_args args = new startShortWithClientIdAndTimeOut_args();
      args.setClientId(clientId);
      args.setTimeout(timeout);
      sendBase("startShortWithClientIdAndTimeOut", args);
    }

    public TTransaction recv_startShortWithClientIdAndTimeOut() throws TGenericException, org.apache.thrift.TException
    {
      startShortWithClientIdAndTimeOut_result result = new startShortWithClientIdAndTimeOut_result();
      receiveBase(result, "startShortWithClientIdAndTimeOut");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startShortWithClientIdAndTimeOut failed: unknown result");
    }

    public TTransaction startShortWithTimeout(int timeout) throws TGenericException, org.apache.thrift.TException
    {
      send_startShortWithTimeout(timeout);
      return recv_startShortWithTimeout();
    }

    public void send_startShortWithTimeout(int timeout) throws org.apache.thrift.TException
    {
      startShortWithTimeout_args args = new startShortWithTimeout_args();
      args.setTimeout(timeout);
      sendBase("startShortWithTimeout", args);
    }

    public TTransaction recv_startShortWithTimeout() throws TGenericException, org.apache.thrift.TException
    {
      startShortWithTimeout_result result = new startShortWithTimeout_result();
      receiveBase(result, "startShortWithTimeout");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startShortWithTimeout failed: unknown result");
    }

    public TBoolean canCommitTx(TTransaction tx, Set<ByteBuffer> changes) throws TTransactionNotInProgressException, org.apache.thrift.TException
    {
      send_canCommitTx(tx, changes);
      return recv_canCommitTx();
    }

    public void send_canCommitTx(TTransaction tx, Set<ByteBuffer> changes) throws org.apache.thrift.TException
    {
      canCommitTx_args args = new canCommitTx_args();
      args.setTx(tx);
      args.setChanges(changes);
      sendBase("canCommitTx", args);
    }

    public TBoolean recv_canCommitTx() throws TTransactionNotInProgressException, org.apache.thrift.TException
    {
      canCommitTx_result result = new canCommitTx_result();
      receiveBase(result, "canCommitTx");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "canCommitTx failed: unknown result");
    }

    public void canCommitOrThrow(long tx, Set<ByteBuffer> changes) throws TTransactionNotInProgressException, TTransactionConflictException, TGenericException, org.apache.thrift.TException
    {
      send_canCommitOrThrow(tx, changes);
      recv_canCommitOrThrow();
    }

    public void send_canCommitOrThrow(long tx, Set<ByteBuffer> changes) throws org.apache.thrift.TException
    {
      canCommitOrThrow_args args = new canCommitOrThrow_args();
      args.setTx(tx);
      args.setChanges(changes);
      sendBase("canCommitOrThrow", args);
    }

    public void recv_canCommitOrThrow() throws TTransactionNotInProgressException, TTransactionConflictException, TGenericException, org.apache.thrift.TException
    {
      canCommitOrThrow_result result = new canCommitOrThrow_result();
      receiveBase(result, "canCommitOrThrow");
      if (result.e != null) {
        throw result.e;
      }
      if (result.c != null) {
        throw result.c;
      }
      if (result.g != null) {
        throw result.g;
      }
      return;
    }

    public TBoolean commitTx(TTransaction tx) throws TTransactionNotInProgressException, org.apache.thrift.TException
    {
      send_commitTx(tx);
      return recv_commitTx();
    }

    public void send_commitTx(TTransaction tx) throws org.apache.thrift.TException
    {
      commitTx_args args = new commitTx_args();
      args.setTx(tx);
      sendBase("commitTx", args);
    }

    public TBoolean recv_commitTx() throws TTransactionNotInProgressException, org.apache.thrift.TException
    {
      commitTx_result result = new commitTx_result();
      receiveBase(result, "commitTx");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "commitTx failed: unknown result");
    }

    public void commitOrThrow(long txId, long wp) throws TTransactionNotInProgressException, TTransactionConflictException, TGenericException, org.apache.thrift.TException
    {
      send_commitOrThrow(txId, wp);
      recv_commitOrThrow();
    }

    public void send_commitOrThrow(long txId, long wp) throws org.apache.thrift.TException
    {
      commitOrThrow_args args = new commitOrThrow_args();
      args.setTxId(txId);
      args.setWp(wp);
      sendBase("commitOrThrow", args);
    }

    public void recv_commitOrThrow() throws TTransactionNotInProgressException, TTransactionConflictException, TGenericException, org.apache.thrift.TException
    {
      commitOrThrow_result result = new commitOrThrow_result();
      receiveBase(result, "commitOrThrow");
      if (result.e != null) {
        throw result.e;
      }
      if (result.c != null) {
        throw result.c;
      }
      if (result.g != null) {
        throw result.g;
      }
      return;
    }

    public void abortTx(TTransaction tx) throws org.apache.thrift.TException
    {
      send_abortTx(tx);
      recv_abortTx();
    }

    public void send_abortTx(TTransaction tx) throws org.apache.thrift.TException
    {
      abortTx_args args = new abortTx_args();
      args.setTx(tx);
      sendBase("abortTx", args);
    }

    public void recv_abortTx() throws org.apache.thrift.TException
    {
      abortTx_result result = new abortTx_result();
      receiveBase(result, "abortTx");
      return;
    }

    public boolean invalidateTx(long txid) throws org.apache.thrift.TException
    {
      send_invalidateTx(txid);
      return recv_invalidateTx();
    }

    public void send_invalidateTx(long txid) throws org.apache.thrift.TException
    {
      invalidateTx_args args = new invalidateTx_args();
      args.setTxid(txid);
      sendBase("invalidateTx", args);
    }

    public boolean recv_invalidateTx() throws org.apache.thrift.TException
    {
      invalidateTx_result result = new invalidateTx_result();
      receiveBase(result, "invalidateTx");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "invalidateTx failed: unknown result");
    }

    public ByteBuffer getSnapshot() throws TTransactionCouldNotTakeSnapshotException, org.apache.thrift.TException
    {
      send_getSnapshot();
      return recv_getSnapshot();
    }

    public void send_getSnapshot() throws org.apache.thrift.TException
    {
      getSnapshot_args args = new getSnapshot_args();
      sendBase("getSnapshot", args);
    }

    public ByteBuffer recv_getSnapshot() throws TTransactionCouldNotTakeSnapshotException, org.apache.thrift.TException
    {
      getSnapshot_result result = new getSnapshot_result();
      receiveBase(result, "getSnapshot");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSnapshot failed: unknown result");
    }

    public void resetState() throws org.apache.thrift.TException
    {
      send_resetState();
      recv_resetState();
    }

    public void send_resetState() throws org.apache.thrift.TException
    {
      resetState_args args = new resetState_args();
      sendBase("resetState", args);
    }

    public void recv_resetState() throws org.apache.thrift.TException
    {
      resetState_result result = new resetState_result();
      receiveBase(result, "resetState");
      return;
    }

    public String status() throws org.apache.thrift.TException
    {
      send_status();
      return recv_status();
    }

    public void send_status() throws org.apache.thrift.TException
    {
      status_args args = new status_args();
      sendBase("status", args);
    }

    public String recv_status() throws org.apache.thrift.TException
    {
      status_result result = new status_result();
      receiveBase(result, "status");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "status failed: unknown result");
    }

    public TBoolean truncateInvalidTx(Set<Long> txns) throws org.apache.thrift.TException
    {
      send_truncateInvalidTx(txns);
      return recv_truncateInvalidTx();
    }

    public void send_truncateInvalidTx(Set<Long> txns) throws org.apache.thrift.TException
    {
      truncateInvalidTx_args args = new truncateInvalidTx_args();
      args.setTxns(txns);
      sendBase("truncateInvalidTx", args);
    }

    public TBoolean recv_truncateInvalidTx() throws org.apache.thrift.TException
    {
      truncateInvalidTx_result result = new truncateInvalidTx_result();
      receiveBase(result, "truncateInvalidTx");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "truncateInvalidTx failed: unknown result");
    }

    public TBoolean truncateInvalidTxBefore(long time) throws TInvalidTruncateTimeException, org.apache.thrift.TException
    {
      send_truncateInvalidTxBefore(time);
      return recv_truncateInvalidTxBefore();
    }

    public void send_truncateInvalidTxBefore(long time) throws org.apache.thrift.TException
    {
      truncateInvalidTxBefore_args args = new truncateInvalidTxBefore_args();
      args.setTime(time);
      sendBase("truncateInvalidTxBefore", args);
    }

    public TBoolean recv_truncateInvalidTxBefore() throws TInvalidTruncateTimeException, org.apache.thrift.TException
    {
      truncateInvalidTxBefore_result result = new truncateInvalidTxBefore_result();
      receiveBase(result, "truncateInvalidTxBefore");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "truncateInvalidTxBefore failed: unknown result");
    }

    public int invalidTxSize() throws org.apache.thrift.TException
    {
      send_invalidTxSize();
      return recv_invalidTxSize();
    }

    public void send_invalidTxSize() throws org.apache.thrift.TException
    {
      invalidTxSize_args args = new invalidTxSize_args();
      sendBase("invalidTxSize", args);
    }

    public int recv_invalidTxSize() throws org.apache.thrift.TException
    {
      invalidTxSize_result result = new invalidTxSize_result();
      receiveBase(result, "invalidTxSize");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "invalidTxSize failed: unknown result");
    }

    public TTransaction checkpoint(TTransaction tx) throws TTransactionNotInProgressException, org.apache.thrift.TException
    {
      send_checkpoint(tx);
      return recv_checkpoint();
    }

    public void send_checkpoint(TTransaction tx) throws org.apache.thrift.TException
    {
      checkpoint_args args = new checkpoint_args();
      args.setTx(tx);
      sendBase("checkpoint", args);
    }

    public TTransaction recv_checkpoint() throws TTransactionNotInProgressException, org.apache.thrift.TException
    {
      checkpoint_result result = new checkpoint_result();
      receiveBase(result, "checkpoint");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.e != null) {
        throw result.e;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "checkpoint failed: unknown result");
    }

    public void pruneNow() throws org.apache.thrift.TException
    {
      send_pruneNow();
      recv_pruneNow();
    }

    public void send_pruneNow() throws org.apache.thrift.TException
    {
      pruneNow_args args = new pruneNow_args();
      sendBase("pruneNow", args);
    }

    public void recv_pruneNow() throws org.apache.thrift.TException
    {
      pruneNow_result result = new pruneNow_result();
      receiveBase(result, "pruneNow");
      return;
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void startLong(org.apache.thrift.async.AsyncMethodCallback<startLong_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startLong_call method_call = new startLong_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startLong_call extends org.apache.thrift.async.TAsyncMethodCall {
      public startLong_call(org.apache.thrift.async.AsyncMethodCallback<startLong_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startLong", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startLong_args args = new startLong_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TTransaction getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startLong();
      }
    }

    public void startShort(org.apache.thrift.async.AsyncMethodCallback<startShort_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startShort_call method_call = new startShort_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startShort_call extends org.apache.thrift.async.TAsyncMethodCall {
      public startShort_call(org.apache.thrift.async.AsyncMethodCallback<startShort_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startShort", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startShort_args args = new startShort_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TTransaction getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startShort();
      }
    }

    public void startLongClientId(String clientId, org.apache.thrift.async.AsyncMethodCallback<startLongClientId_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startLongClientId_call method_call = new startLongClientId_call(clientId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startLongClientId_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String clientId;
      public startLongClientId_call(String clientId, org.apache.thrift.async.AsyncMethodCallback<startLongClientId_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.clientId = clientId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startLongClientId", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startLongClientId_args args = new startLongClientId_args();
        args.setClientId(clientId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TTransaction getResult() throws TGenericException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startLongClientId();
      }
    }

    public void startShortTimeout(int timeout, org.apache.thrift.async.AsyncMethodCallback<startShortTimeout_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startShortTimeout_call method_call = new startShortTimeout_call(timeout, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startShortTimeout_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int timeout;
      public startShortTimeout_call(int timeout, org.apache.thrift.async.AsyncMethodCallback<startShortTimeout_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.timeout = timeout;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startShortTimeout", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startShortTimeout_args args = new startShortTimeout_args();
        args.setTimeout(timeout);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TTransaction getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startShortTimeout();
      }
    }

    public void startShortClientId(String clientId, org.apache.thrift.async.AsyncMethodCallback<startShortClientId_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startShortClientId_call method_call = new startShortClientId_call(clientId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startShortClientId_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String clientId;
      public startShortClientId_call(String clientId, org.apache.thrift.async.AsyncMethodCallback<startShortClientId_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.clientId = clientId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startShortClientId", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startShortClientId_args args = new startShortClientId_args();
        args.setClientId(clientId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TTransaction getResult() throws TGenericException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startShortClientId();
      }
    }

    public void startShortWithClientIdAndTimeOut(String clientId, int timeout, org.apache.thrift.async.AsyncMethodCallback<startShortWithClientIdAndTimeOut_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startShortWithClientIdAndTimeOut_call method_call = new startShortWithClientIdAndTimeOut_call(clientId, timeout, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startShortWithClientIdAndTimeOut_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String clientId;
      private int timeout;
      public startShortWithClientIdAndTimeOut_call(String clientId, int timeout, org.apache.thrift.async.AsyncMethodCallback<startShortWithClientIdAndTimeOut_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.clientId = clientId;
        this.timeout = timeout;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startShortWithClientIdAndTimeOut", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startShortWithClientIdAndTimeOut_args args = new startShortWithClientIdAndTimeOut_args();
        args.setClientId(clientId);
        args.setTimeout(timeout);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TTransaction getResult() throws TGenericException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startShortWithClientIdAndTimeOut();
      }
    }

    public void startShortWithTimeout(int timeout, org.apache.thrift.async.AsyncMethodCallback<startShortWithTimeout_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startShortWithTimeout_call method_call = new startShortWithTimeout_call(timeout, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startShortWithTimeout_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int timeout;
      public startShortWithTimeout_call(int timeout, org.apache.thrift.async.AsyncMethodCallback<startShortWithTimeout_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.timeout = timeout;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startShortWithTimeout", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startShortWithTimeout_args args = new startShortWithTimeout_args();
        args.setTimeout(timeout);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TTransaction getResult() throws TGenericException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startShortWithTimeout();
      }
    }

    public void canCommitTx(TTransaction tx, Set<ByteBuffer> changes, org.apache.thrift.async.AsyncMethodCallback<canCommitTx_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      canCommitTx_call method_call = new canCommitTx_call(tx, changes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class canCommitTx_call extends org.apache.thrift.async.TAsyncMethodCall {
      private TTransaction tx;
      private Set<ByteBuffer> changes;
      public canCommitTx_call(TTransaction tx, Set<ByteBuffer> changes, org.apache.thrift.async.AsyncMethodCallback<canCommitTx_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tx = tx;
        this.changes = changes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("canCommitTx", org.apache.thrift.protocol.TMessageType.CALL, 0));
        canCommitTx_args args = new canCommitTx_args();
        args.setTx(tx);
        args.setChanges(changes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TBoolean getResult() throws TTransactionNotInProgressException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_canCommitTx();
      }
    }

    public void canCommitOrThrow(long tx, Set<ByteBuffer> changes, org.apache.thrift.async.AsyncMethodCallback<canCommitOrThrow_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      canCommitOrThrow_call method_call = new canCommitOrThrow_call(tx, changes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class canCommitOrThrow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long tx;
      private Set<ByteBuffer> changes;
      public canCommitOrThrow_call(long tx, Set<ByteBuffer> changes, org.apache.thrift.async.AsyncMethodCallback<canCommitOrThrow_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tx = tx;
        this.changes = changes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("canCommitOrThrow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        canCommitOrThrow_args args = new canCommitOrThrow_args();
        args.setTx(tx);
        args.setChanges(changes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws TTransactionNotInProgressException, TTransactionConflictException, TGenericException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_canCommitOrThrow();
      }
    }

    public void commitTx(TTransaction tx, org.apache.thrift.async.AsyncMethodCallback<commitTx_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      commitTx_call method_call = new commitTx_call(tx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class commitTx_call extends org.apache.thrift.async.TAsyncMethodCall {
      private TTransaction tx;
      public commitTx_call(TTransaction tx, org.apache.thrift.async.AsyncMethodCallback<commitTx_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tx = tx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("commitTx", org.apache.thrift.protocol.TMessageType.CALL, 0));
        commitTx_args args = new commitTx_args();
        args.setTx(tx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TBoolean getResult() throws TTransactionNotInProgressException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_commitTx();
      }
    }

    public void commitOrThrow(long txId, long wp, org.apache.thrift.async.AsyncMethodCallback<commitOrThrow_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      commitOrThrow_call method_call = new commitOrThrow_call(txId, wp, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class commitOrThrow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long txId;
      private long wp;
      public commitOrThrow_call(long txId, long wp, org.apache.thrift.async.AsyncMethodCallback<commitOrThrow_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.txId = txId;
        this.wp = wp;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("commitOrThrow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        commitOrThrow_args args = new commitOrThrow_args();
        args.setTxId(txId);
        args.setWp(wp);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws TTransactionNotInProgressException, TTransactionConflictException, TGenericException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_commitOrThrow();
      }
    }

    public void abortTx(TTransaction tx, org.apache.thrift.async.AsyncMethodCallback<abortTx_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      abortTx_call method_call = new abortTx_call(tx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class abortTx_call extends org.apache.thrift.async.TAsyncMethodCall {
      private TTransaction tx;
      public abortTx_call(TTransaction tx, org.apache.thrift.async.AsyncMethodCallback<abortTx_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tx = tx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("abortTx", org.apache.thrift.protocol.TMessageType.CALL, 0));
        abortTx_args args = new abortTx_args();
        args.setTx(tx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_abortTx();
      }
    }

    public void invalidateTx(long txid, org.apache.thrift.async.AsyncMethodCallback<invalidateTx_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      invalidateTx_call method_call = new invalidateTx_call(txid, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class invalidateTx_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long txid;
      public invalidateTx_call(long txid, org.apache.thrift.async.AsyncMethodCallback<invalidateTx_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.txid = txid;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("invalidateTx", org.apache.thrift.protocol.TMessageType.CALL, 0));
        invalidateTx_args args = new invalidateTx_args();
        args.setTxid(txid);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_invalidateTx();
      }
    }

    public void getSnapshot(org.apache.thrift.async.AsyncMethodCallback<getSnapshot_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSnapshot_call method_call = new getSnapshot_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSnapshot_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getSnapshot_call(org.apache.thrift.async.AsyncMethodCallback<getSnapshot_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSnapshot", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSnapshot_args args = new getSnapshot_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ByteBuffer getResult() throws TTransactionCouldNotTakeSnapshotException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSnapshot();
      }
    }

    public void resetState(org.apache.thrift.async.AsyncMethodCallback<resetState_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      resetState_call method_call = new resetState_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class resetState_call extends org.apache.thrift.async.TAsyncMethodCall {
      public resetState_call(org.apache.thrift.async.AsyncMethodCallback<resetState_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("resetState", org.apache.thrift.protocol.TMessageType.CALL, 0));
        resetState_args args = new resetState_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_resetState();
      }
    }

    public void status(org.apache.thrift.async.AsyncMethodCallback<status_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      status_call method_call = new status_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class status_call extends org.apache.thrift.async.TAsyncMethodCall {
      public status_call(org.apache.thrift.async.AsyncMethodCallback<status_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("status", org.apache.thrift.protocol.TMessageType.CALL, 0));
        status_args args = new status_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_status();
      }
    }

    public void truncateInvalidTx(Set<Long> txns, org.apache.thrift.async.AsyncMethodCallback<truncateInvalidTx_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      truncateInvalidTx_call method_call = new truncateInvalidTx_call(txns, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class truncateInvalidTx_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Set<Long> txns;
      public truncateInvalidTx_call(Set<Long> txns, org.apache.thrift.async.AsyncMethodCallback<truncateInvalidTx_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.txns = txns;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("truncateInvalidTx", org.apache.thrift.protocol.TMessageType.CALL, 0));
        truncateInvalidTx_args args = new truncateInvalidTx_args();
        args.setTxns(txns);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TBoolean getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_truncateInvalidTx();
      }
    }

    public void truncateInvalidTxBefore(long time, org.apache.thrift.async.AsyncMethodCallback<truncateInvalidTxBefore_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      truncateInvalidTxBefore_call method_call = new truncateInvalidTxBefore_call(time, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class truncateInvalidTxBefore_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long time;
      public truncateInvalidTxBefore_call(long time, org.apache.thrift.async.AsyncMethodCallback<truncateInvalidTxBefore_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.time = time;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("truncateInvalidTxBefore", org.apache.thrift.protocol.TMessageType.CALL, 0));
        truncateInvalidTxBefore_args args = new truncateInvalidTxBefore_args();
        args.setTime(time);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TBoolean getResult() throws TInvalidTruncateTimeException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_truncateInvalidTxBefore();
      }
    }

    public void invalidTxSize(org.apache.thrift.async.AsyncMethodCallback<invalidTxSize_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      invalidTxSize_call method_call = new invalidTxSize_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class invalidTxSize_call extends org.apache.thrift.async.TAsyncMethodCall {
      public invalidTxSize_call(org.apache.thrift.async.AsyncMethodCallback<invalidTxSize_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("invalidTxSize", org.apache.thrift.protocol.TMessageType.CALL, 0));
        invalidTxSize_args args = new invalidTxSize_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_invalidTxSize();
      }
    }

    public void checkpoint(TTransaction tx, org.apache.thrift.async.AsyncMethodCallback<checkpoint_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkpoint_call method_call = new checkpoint_call(tx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkpoint_call extends org.apache.thrift.async.TAsyncMethodCall {
      private TTransaction tx;
      public checkpoint_call(TTransaction tx, org.apache.thrift.async.AsyncMethodCallback<checkpoint_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tx = tx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkpoint", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkpoint_args args = new checkpoint_args();
        args.setTx(tx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TTransaction getResult() throws TTransactionNotInProgressException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_checkpoint();
      }
    }

    public void pruneNow(org.apache.thrift.async.AsyncMethodCallback<pruneNow_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      pruneNow_call method_call = new pruneNow_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class pruneNow_call extends org.apache.thrift.async.TAsyncMethodCall {
      public pruneNow_call(org.apache.thrift.async.AsyncMethodCallback<pruneNow_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("pruneNow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        pruneNow_args args = new pruneNow_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_pruneNow();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("startLong", new startLong());
      processMap.put("startShort", new startShort());
      processMap.put("startLongClientId", new startLongClientId());
      processMap.put("startShortTimeout", new startShortTimeout());
      processMap.put("startShortClientId", new startShortClientId());
      processMap.put("startShortWithClientIdAndTimeOut", new startShortWithClientIdAndTimeOut());
      processMap.put("startShortWithTimeout", new startShortWithTimeout());
      processMap.put("canCommitTx", new canCommitTx());
      processMap.put("canCommitOrThrow", new canCommitOrThrow());
      processMap.put("commitTx", new commitTx());
      processMap.put("commitOrThrow", new commitOrThrow());
      processMap.put("abortTx", new abortTx());
      processMap.put("invalidateTx", new invalidateTx());
      processMap.put("getSnapshot", new getSnapshot());
      processMap.put("resetState", new resetState());
      processMap.put("status", new status());
      processMap.put("truncateInvalidTx", new truncateInvalidTx());
      processMap.put("truncateInvalidTxBefore", new truncateInvalidTxBefore());
      processMap.put("invalidTxSize", new invalidTxSize());
      processMap.put("checkpoint", new checkpoint());
      processMap.put("pruneNow", new pruneNow());
      return processMap;
    }

    public static class startLong<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startLong_args> {
      public startLong() {
        super("startLong");
      }

      public startLong_args getEmptyArgsInstance() {
        return new startLong_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startLong_result getResult(I iface, startLong_args args) throws org.apache.thrift.TException {
        startLong_result result = new startLong_result();
        result.success = iface.startLong();
        return result;
      }
    }

    public static class startShort<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startShort_args> {
      public startShort() {
        super("startShort");
      }

      public startShort_args getEmptyArgsInstance() {
        return new startShort_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startShort_result getResult(I iface, startShort_args args) throws org.apache.thrift.TException {
        startShort_result result = new startShort_result();
        result.success = iface.startShort();
        return result;
      }
    }

    public static class startLongClientId<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startLongClientId_args> {
      public startLongClientId() {
        super("startLongClientId");
      }

      public startLongClientId_args getEmptyArgsInstance() {
        return new startLongClientId_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startLongClientId_result getResult(I iface, startLongClientId_args args) throws org.apache.thrift.TException {
        startLongClientId_result result = new startLongClientId_result();
        try {
          result.success = iface.startLongClientId(args.clientId);
        } catch (TGenericException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class startShortTimeout<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startShortTimeout_args> {
      public startShortTimeout() {
        super("startShortTimeout");
      }

      public startShortTimeout_args getEmptyArgsInstance() {
        return new startShortTimeout_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startShortTimeout_result getResult(I iface, startShortTimeout_args args) throws org.apache.thrift.TException {
        startShortTimeout_result result = new startShortTimeout_result();
        result.success = iface.startShortTimeout(args.timeout);
        return result;
      }
    }

    public static class startShortClientId<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startShortClientId_args> {
      public startShortClientId() {
        super("startShortClientId");
      }

      public startShortClientId_args getEmptyArgsInstance() {
        return new startShortClientId_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startShortClientId_result getResult(I iface, startShortClientId_args args) throws org.apache.thrift.TException {
        startShortClientId_result result = new startShortClientId_result();
        try {
          result.success = iface.startShortClientId(args.clientId);
        } catch (TGenericException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class startShortWithClientIdAndTimeOut<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startShortWithClientIdAndTimeOut_args> {
      public startShortWithClientIdAndTimeOut() {
        super("startShortWithClientIdAndTimeOut");
      }

      public startShortWithClientIdAndTimeOut_args getEmptyArgsInstance() {
        return new startShortWithClientIdAndTimeOut_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startShortWithClientIdAndTimeOut_result getResult(I iface, startShortWithClientIdAndTimeOut_args args) throws org.apache.thrift.TException {
        startShortWithClientIdAndTimeOut_result result = new startShortWithClientIdAndTimeOut_result();
        try {
          result.success = iface.startShortWithClientIdAndTimeOut(args.clientId, args.timeout);
        } catch (TGenericException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class startShortWithTimeout<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startShortWithTimeout_args> {
      public startShortWithTimeout() {
        super("startShortWithTimeout");
      }

      public startShortWithTimeout_args getEmptyArgsInstance() {
        return new startShortWithTimeout_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startShortWithTimeout_result getResult(I iface, startShortWithTimeout_args args) throws org.apache.thrift.TException {
        startShortWithTimeout_result result = new startShortWithTimeout_result();
        try {
          result.success = iface.startShortWithTimeout(args.timeout);
        } catch (TGenericException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class canCommitTx<I extends Iface> extends org.apache.thrift.ProcessFunction<I, canCommitTx_args> {
      public canCommitTx() {
        super("canCommitTx");
      }

      public canCommitTx_args getEmptyArgsInstance() {
        return new canCommitTx_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public canCommitTx_result getResult(I iface, canCommitTx_args args) throws org.apache.thrift.TException {
        canCommitTx_result result = new canCommitTx_result();
        try {
          result.success = iface.canCommitTx(args.tx, args.changes);
        } catch (TTransactionNotInProgressException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class canCommitOrThrow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, canCommitOrThrow_args> {
      public canCommitOrThrow() {
        super("canCommitOrThrow");
      }

      public canCommitOrThrow_args getEmptyArgsInstance() {
        return new canCommitOrThrow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public canCommitOrThrow_result getResult(I iface, canCommitOrThrow_args args) throws org.apache.thrift.TException {
        canCommitOrThrow_result result = new canCommitOrThrow_result();
        try {
          iface.canCommitOrThrow(args.tx, args.changes);
        } catch (TTransactionNotInProgressException e) {
          result.e = e;
        } catch (TTransactionConflictException c) {
          result.c = c;
        } catch (TGenericException g) {
          result.g = g;
        }
        return result;
      }
    }

    public static class commitTx<I extends Iface> extends org.apache.thrift.ProcessFunction<I, commitTx_args> {
      public commitTx() {
        super("commitTx");
      }

      public commitTx_args getEmptyArgsInstance() {
        return new commitTx_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public commitTx_result getResult(I iface, commitTx_args args) throws org.apache.thrift.TException {
        commitTx_result result = new commitTx_result();
        try {
          result.success = iface.commitTx(args.tx);
        } catch (TTransactionNotInProgressException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class commitOrThrow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, commitOrThrow_args> {
      public commitOrThrow() {
        super("commitOrThrow");
      }

      public commitOrThrow_args getEmptyArgsInstance() {
        return new commitOrThrow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public commitOrThrow_result getResult(I iface, commitOrThrow_args args) throws org.apache.thrift.TException {
        commitOrThrow_result result = new commitOrThrow_result();
        try {
          iface.commitOrThrow(args.txId, args.wp);
        } catch (TTransactionNotInProgressException e) {
          result.e = e;
        } catch (TTransactionConflictException c) {
          result.c = c;
        } catch (TGenericException g) {
          result.g = g;
        }
        return result;
      }
    }

    public static class abortTx<I extends Iface> extends org.apache.thrift.ProcessFunction<I, abortTx_args> {
      public abortTx() {
        super("abortTx");
      }

      public abortTx_args getEmptyArgsInstance() {
        return new abortTx_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public abortTx_result getResult(I iface, abortTx_args args) throws org.apache.thrift.TException {
        abortTx_result result = new abortTx_result();
        iface.abortTx(args.tx);
        return result;
      }
    }

    public static class invalidateTx<I extends Iface> extends org.apache.thrift.ProcessFunction<I, invalidateTx_args> {
      public invalidateTx() {
        super("invalidateTx");
      }

      public invalidateTx_args getEmptyArgsInstance() {
        return new invalidateTx_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public invalidateTx_result getResult(I iface, invalidateTx_args args) throws org.apache.thrift.TException {
        invalidateTx_result result = new invalidateTx_result();
        result.success = iface.invalidateTx(args.txid);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class getSnapshot<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getSnapshot_args> {
      public getSnapshot() {
        super("getSnapshot");
      }

      public getSnapshot_args getEmptyArgsInstance() {
        return new getSnapshot_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getSnapshot_result getResult(I iface, getSnapshot_args args) throws org.apache.thrift.TException {
        getSnapshot_result result = new getSnapshot_result();
        try {
          result.success = iface.getSnapshot();
        } catch (TTransactionCouldNotTakeSnapshotException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class resetState<I extends Iface> extends org.apache.thrift.ProcessFunction<I, resetState_args> {
      public resetState() {
        super("resetState");
      }

      public resetState_args getEmptyArgsInstance() {
        return new resetState_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public resetState_result getResult(I iface, resetState_args args) throws org.apache.thrift.TException {
        resetState_result result = new resetState_result();
        iface.resetState();
        return result;
      }
    }

    public static class status<I extends Iface> extends org.apache.thrift.ProcessFunction<I, status_args> {
      public status() {
        super("status");
      }

      public status_args getEmptyArgsInstance() {
        return new status_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public status_result getResult(I iface, status_args args) throws org.apache.thrift.TException {
        status_result result = new status_result();
        result.success = iface.status();
        return result;
      }
    }

    public static class truncateInvalidTx<I extends Iface> extends org.apache.thrift.ProcessFunction<I, truncateInvalidTx_args> {
      public truncateInvalidTx() {
        super("truncateInvalidTx");
      }

      public truncateInvalidTx_args getEmptyArgsInstance() {
        return new truncateInvalidTx_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public truncateInvalidTx_result getResult(I iface, truncateInvalidTx_args args) throws org.apache.thrift.TException {
        truncateInvalidTx_result result = new truncateInvalidTx_result();
        result.success = iface.truncateInvalidTx(args.txns);
        return result;
      }
    }

    public static class truncateInvalidTxBefore<I extends Iface> extends org.apache.thrift.ProcessFunction<I, truncateInvalidTxBefore_args> {
      public truncateInvalidTxBefore() {
        super("truncateInvalidTxBefore");
      }

      public truncateInvalidTxBefore_args getEmptyArgsInstance() {
        return new truncateInvalidTxBefore_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public truncateInvalidTxBefore_result getResult(I iface, truncateInvalidTxBefore_args args) throws org.apache.thrift.TException {
        truncateInvalidTxBefore_result result = new truncateInvalidTxBefore_result();
        try {
          result.success = iface.truncateInvalidTxBefore(args.time);
        } catch (TInvalidTruncateTimeException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class invalidTxSize<I extends Iface> extends org.apache.thrift.ProcessFunction<I, invalidTxSize_args> {
      public invalidTxSize() {
        super("invalidTxSize");
      }

      public invalidTxSize_args getEmptyArgsInstance() {
        return new invalidTxSize_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public invalidTxSize_result getResult(I iface, invalidTxSize_args args) throws org.apache.thrift.TException {
        invalidTxSize_result result = new invalidTxSize_result();
        result.success = iface.invalidTxSize();
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class checkpoint<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkpoint_args> {
      public checkpoint() {
        super("checkpoint");
      }

      public checkpoint_args getEmptyArgsInstance() {
        return new checkpoint_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public checkpoint_result getResult(I iface, checkpoint_args args) throws org.apache.thrift.TException {
        checkpoint_result result = new checkpoint_result();
        try {
          result.success = iface.checkpoint(args.tx);
        } catch (TTransactionNotInProgressException e) {
          result.e = e;
        }
        return result;
      }
    }

    public static class pruneNow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, pruneNow_args> {
      public pruneNow() {
        super("pruneNow");
      }

      public pruneNow_args getEmptyArgsInstance() {
        return new pruneNow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public pruneNow_result getResult(I iface, pruneNow_args args) throws org.apache.thrift.TException {
        pruneNow_result result = new pruneNow_result();
        iface.pruneNow();
        return result;
      }
    }

  }

  public static class startLong_args implements org.apache.thrift.TBase<startLong_args, startLong_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startLong_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startLong_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startLong_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startLong_args.class, metaDataMap);
    }

    public startLong_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startLong_args(startLong_args other) {
    }

    public startLong_args deepCopy() {
      return new startLong_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startLong_args)
        return this.equals((startLong_args)that);
      return false;
    }

    public boolean equals(startLong_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startLong_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startLong_args typedOther = (startLong_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startLong_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startLong_argsStandardSchemeFactory implements SchemeFactory {
      public startLong_argsStandardScheme getScheme() {
        return new startLong_argsStandardScheme();
      }
    }

    private static class startLong_argsStandardScheme extends StandardScheme<startLong_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startLong_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startLong_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startLong_argsTupleSchemeFactory implements SchemeFactory {
      public startLong_argsTupleScheme getScheme() {
        return new startLong_argsTupleScheme();
      }
    }

    private static class startLong_argsTupleScheme extends TupleScheme<startLong_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startLong_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startLong_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class startLong_result implements org.apache.thrift.TBase<startLong_result, startLong_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startLong_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startLong_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startLong_resultTupleSchemeFactory());
    }

    public TTransaction success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startLong_result.class, metaDataMap);
    }

    public startLong_result() {
    }

    public startLong_result(
      TTransaction success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startLong_result(startLong_result other) {
      if (other.isSetSuccess()) {
        this.success = new TTransaction(other.success);
      }
    }

    public startLong_result deepCopy() {
      return new startLong_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public TTransaction getSuccess() {
      return this.success;
    }

    public startLong_result setSuccess(TTransaction success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TTransaction)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startLong_result)
        return this.equals((startLong_result)that);
      return false;
    }

    public boolean equals(startLong_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startLong_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startLong_result typedOther = (startLong_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startLong_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startLong_resultStandardSchemeFactory implements SchemeFactory {
      public startLong_resultStandardScheme getScheme() {
        return new startLong_resultStandardScheme();
      }
    }

    private static class startLong_resultStandardScheme extends StandardScheme<startLong_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startLong_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TTransaction();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startLong_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startLong_resultTupleSchemeFactory implements SchemeFactory {
      public startLong_resultTupleScheme getScheme() {
        return new startLong_resultTupleScheme();
      }
    }

    private static class startLong_resultTupleScheme extends TupleScheme<startLong_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startLong_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startLong_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new TTransaction();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class startShort_args implements org.apache.thrift.TBase<startShort_args, startShort_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShort_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShort_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShort_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShort_args.class, metaDataMap);
    }

    public startShort_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShort_args(startShort_args other) {
    }

    public startShort_args deepCopy() {
      return new startShort_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShort_args)
        return this.equals((startShort_args)that);
      return false;
    }

    public boolean equals(startShort_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShort_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShort_args typedOther = (startShort_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShort_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShort_argsStandardSchemeFactory implements SchemeFactory {
      public startShort_argsStandardScheme getScheme() {
        return new startShort_argsStandardScheme();
      }
    }

    private static class startShort_argsStandardScheme extends StandardScheme<startShort_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShort_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShort_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShort_argsTupleSchemeFactory implements SchemeFactory {
      public startShort_argsTupleScheme getScheme() {
        return new startShort_argsTupleScheme();
      }
    }

    private static class startShort_argsTupleScheme extends TupleScheme<startShort_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShort_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShort_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class startShort_result implements org.apache.thrift.TBase<startShort_result, startShort_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShort_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShort_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShort_resultTupleSchemeFactory());
    }

    public TTransaction success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShort_result.class, metaDataMap);
    }

    public startShort_result() {
    }

    public startShort_result(
      TTransaction success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShort_result(startShort_result other) {
      if (other.isSetSuccess()) {
        this.success = new TTransaction(other.success);
      }
    }

    public startShort_result deepCopy() {
      return new startShort_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public TTransaction getSuccess() {
      return this.success;
    }

    public startShort_result setSuccess(TTransaction success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TTransaction)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShort_result)
        return this.equals((startShort_result)that);
      return false;
    }

    public boolean equals(startShort_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShort_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShort_result typedOther = (startShort_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShort_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShort_resultStandardSchemeFactory implements SchemeFactory {
      public startShort_resultStandardScheme getScheme() {
        return new startShort_resultStandardScheme();
      }
    }

    private static class startShort_resultStandardScheme extends StandardScheme<startShort_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShort_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TTransaction();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShort_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShort_resultTupleSchemeFactory implements SchemeFactory {
      public startShort_resultTupleScheme getScheme() {
        return new startShort_resultTupleScheme();
      }
    }

    private static class startShort_resultTupleScheme extends TupleScheme<startShort_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShort_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShort_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new TTransaction();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class startLongClientId_args implements org.apache.thrift.TBase<startLongClientId_args, startLongClientId_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startLongClientId_args");

    private static final org.apache.thrift.protocol.TField CLIENT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("clientId", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startLongClientId_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startLongClientId_argsTupleSchemeFactory());
    }

    public String clientId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CLIENT_ID((short)1, "clientId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CLIENT_ID
            return CLIENT_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CLIENT_ID, new org.apache.thrift.meta_data.FieldMetaData("clientId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startLongClientId_args.class, metaDataMap);
    }

    public startLongClientId_args() {
    }

    public startLongClientId_args(
      String clientId)
    {
      this();
      this.clientId = clientId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startLongClientId_args(startLongClientId_args other) {
      if (other.isSetClientId()) {
        this.clientId = other.clientId;
      }
    }

    public startLongClientId_args deepCopy() {
      return new startLongClientId_args(this);
    }

    @Override
    public void clear() {
      this.clientId = null;
    }

    public String getClientId() {
      return this.clientId;
    }

    public startLongClientId_args setClientId(String clientId) {
      this.clientId = clientId;
      return this;
    }

    public void unsetClientId() {
      this.clientId = null;
    }

    /** Returns true if field clientId is set (has been assigned a value) and false otherwise */
    public boolean isSetClientId() {
      return this.clientId != null;
    }

    public void setClientIdIsSet(boolean value) {
      if (!value) {
        this.clientId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CLIENT_ID:
        if (value == null) {
          unsetClientId();
        } else {
          setClientId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CLIENT_ID:
        return getClientId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CLIENT_ID:
        return isSetClientId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startLongClientId_args)
        return this.equals((startLongClientId_args)that);
      return false;
    }

    public boolean equals(startLongClientId_args that) {
      if (that == null)
        return false;

      boolean this_present_clientId = true && this.isSetClientId();
      boolean that_present_clientId = true && that.isSetClientId();
      if (this_present_clientId || that_present_clientId) {
        if (!(this_present_clientId && that_present_clientId))
          return false;
        if (!this.clientId.equals(that.clientId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startLongClientId_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startLongClientId_args typedOther = (startLongClientId_args)other;

      lastComparison = Boolean.valueOf(isSetClientId()).compareTo(typedOther.isSetClientId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClientId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.clientId, typedOther.clientId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startLongClientId_args(");
      boolean first = true;

      sb.append("clientId:");
      if (this.clientId == null) {
        sb.append("null");
      } else {
        sb.append(this.clientId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startLongClientId_argsStandardSchemeFactory implements SchemeFactory {
      public startLongClientId_argsStandardScheme getScheme() {
        return new startLongClientId_argsStandardScheme();
      }
    }

    private static class startLongClientId_argsStandardScheme extends StandardScheme<startLongClientId_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startLongClientId_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CLIENT_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.clientId = iprot.readString();
                struct.setClientIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startLongClientId_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.clientId != null) {
          oprot.writeFieldBegin(CLIENT_ID_FIELD_DESC);
          oprot.writeString(struct.clientId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startLongClientId_argsTupleSchemeFactory implements SchemeFactory {
      public startLongClientId_argsTupleScheme getScheme() {
        return new startLongClientId_argsTupleScheme();
      }
    }

    private static class startLongClientId_argsTupleScheme extends TupleScheme<startLongClientId_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startLongClientId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetClientId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetClientId()) {
          oprot.writeString(struct.clientId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startLongClientId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.clientId = iprot.readString();
          struct.setClientIdIsSet(true);
        }
      }
    }

  }

  public static class startLongClientId_result implements org.apache.thrift.TBase<startLongClientId_result, startLongClientId_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startLongClientId_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startLongClientId_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startLongClientId_resultTupleSchemeFactory());
    }

    public TTransaction success; // required
    public TGenericException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startLongClientId_result.class, metaDataMap);
    }

    public startLongClientId_result() {
    }

    public startLongClientId_result(
      TTransaction success,
      TGenericException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startLongClientId_result(startLongClientId_result other) {
      if (other.isSetSuccess()) {
        this.success = new TTransaction(other.success);
      }
      if (other.isSetE()) {
        this.e = new TGenericException(other.e);
      }
    }

    public startLongClientId_result deepCopy() {
      return new startLongClientId_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public TTransaction getSuccess() {
      return this.success;
    }

    public startLongClientId_result setSuccess(TTransaction success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TGenericException getE() {
      return this.e;
    }

    public startLongClientId_result setE(TGenericException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TTransaction)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TGenericException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startLongClientId_result)
        return this.equals((startLongClientId_result)that);
      return false;
    }

    public boolean equals(startLongClientId_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startLongClientId_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startLongClientId_result typedOther = (startLongClientId_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startLongClientId_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startLongClientId_resultStandardSchemeFactory implements SchemeFactory {
      public startLongClientId_resultStandardScheme getScheme() {
        return new startLongClientId_resultStandardScheme();
      }
    }

    private static class startLongClientId_resultStandardScheme extends StandardScheme<startLongClientId_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startLongClientId_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TTransaction();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TGenericException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startLongClientId_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startLongClientId_resultTupleSchemeFactory implements SchemeFactory {
      public startLongClientId_resultTupleScheme getScheme() {
        return new startLongClientId_resultTupleScheme();
      }
    }

    private static class startLongClientId_resultTupleScheme extends TupleScheme<startLongClientId_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startLongClientId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startLongClientId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TTransaction();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TGenericException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class startShortTimeout_args implements org.apache.thrift.TBase<startShortTimeout_args, startShortTimeout_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShortTimeout_args");

    private static final org.apache.thrift.protocol.TField TIMEOUT_FIELD_DESC = new org.apache.thrift.protocol.TField("timeout", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShortTimeout_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShortTimeout_argsTupleSchemeFactory());
    }

    public int timeout; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TIMEOUT((short)1, "timeout");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TIMEOUT
            return TIMEOUT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMEOUT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TIMEOUT, new org.apache.thrift.meta_data.FieldMetaData("timeout", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShortTimeout_args.class, metaDataMap);
    }

    public startShortTimeout_args() {
    }

    public startShortTimeout_args(
      int timeout)
    {
      this();
      this.timeout = timeout;
      setTimeoutIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShortTimeout_args(startShortTimeout_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.timeout = other.timeout;
    }

    public startShortTimeout_args deepCopy() {
      return new startShortTimeout_args(this);
    }

    @Override
    public void clear() {
      setTimeoutIsSet(false);
      this.timeout = 0;
    }

    public int getTimeout() {
      return this.timeout;
    }

    public startShortTimeout_args setTimeout(int timeout) {
      this.timeout = timeout;
      setTimeoutIsSet(true);
      return this;
    }

    public void unsetTimeout() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TIMEOUT_ISSET_ID);
    }

    /** Returns true if field timeout is set (has been assigned a value) and false otherwise */
    public boolean isSetTimeout() {
      return EncodingUtils.testBit(__isset_bitfield, __TIMEOUT_ISSET_ID);
    }

    public void setTimeoutIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TIMEOUT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TIMEOUT:
        if (value == null) {
          unsetTimeout();
        } else {
          setTimeout((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TIMEOUT:
        return Integer.valueOf(getTimeout());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TIMEOUT:
        return isSetTimeout();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShortTimeout_args)
        return this.equals((startShortTimeout_args)that);
      return false;
    }

    public boolean equals(startShortTimeout_args that) {
      if (that == null)
        return false;

      boolean this_present_timeout = true;
      boolean that_present_timeout = true;
      if (this_present_timeout || that_present_timeout) {
        if (!(this_present_timeout && that_present_timeout))
          return false;
        if (this.timeout != that.timeout)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShortTimeout_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShortTimeout_args typedOther = (startShortTimeout_args)other;

      lastComparison = Boolean.valueOf(isSetTimeout()).compareTo(typedOther.isSetTimeout());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimeout()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timeout, typedOther.timeout);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShortTimeout_args(");
      boolean first = true;

      sb.append("timeout:");
      sb.append(this.timeout);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShortTimeout_argsStandardSchemeFactory implements SchemeFactory {
      public startShortTimeout_argsStandardScheme getScheme() {
        return new startShortTimeout_argsStandardScheme();
      }
    }

    private static class startShortTimeout_argsStandardScheme extends StandardScheme<startShortTimeout_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShortTimeout_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TIMEOUT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.timeout = iprot.readI32();
                struct.setTimeoutIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShortTimeout_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(TIMEOUT_FIELD_DESC);
        oprot.writeI32(struct.timeout);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShortTimeout_argsTupleSchemeFactory implements SchemeFactory {
      public startShortTimeout_argsTupleScheme getScheme() {
        return new startShortTimeout_argsTupleScheme();
      }
    }

    private static class startShortTimeout_argsTupleScheme extends TupleScheme<startShortTimeout_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShortTimeout_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTimeout()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTimeout()) {
          oprot.writeI32(struct.timeout);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShortTimeout_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.timeout = iprot.readI32();
          struct.setTimeoutIsSet(true);
        }
      }
    }

  }

  public static class startShortTimeout_result implements org.apache.thrift.TBase<startShortTimeout_result, startShortTimeout_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShortTimeout_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShortTimeout_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShortTimeout_resultTupleSchemeFactory());
    }

    public TTransaction success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShortTimeout_result.class, metaDataMap);
    }

    public startShortTimeout_result() {
    }

    public startShortTimeout_result(
      TTransaction success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShortTimeout_result(startShortTimeout_result other) {
      if (other.isSetSuccess()) {
        this.success = new TTransaction(other.success);
      }
    }

    public startShortTimeout_result deepCopy() {
      return new startShortTimeout_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public TTransaction getSuccess() {
      return this.success;
    }

    public startShortTimeout_result setSuccess(TTransaction success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TTransaction)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShortTimeout_result)
        return this.equals((startShortTimeout_result)that);
      return false;
    }

    public boolean equals(startShortTimeout_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShortTimeout_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShortTimeout_result typedOther = (startShortTimeout_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShortTimeout_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShortTimeout_resultStandardSchemeFactory implements SchemeFactory {
      public startShortTimeout_resultStandardScheme getScheme() {
        return new startShortTimeout_resultStandardScheme();
      }
    }

    private static class startShortTimeout_resultStandardScheme extends StandardScheme<startShortTimeout_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShortTimeout_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TTransaction();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShortTimeout_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShortTimeout_resultTupleSchemeFactory implements SchemeFactory {
      public startShortTimeout_resultTupleScheme getScheme() {
        return new startShortTimeout_resultTupleScheme();
      }
    }

    private static class startShortTimeout_resultTupleScheme extends TupleScheme<startShortTimeout_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShortTimeout_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShortTimeout_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new TTransaction();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class startShortClientId_args implements org.apache.thrift.TBase<startShortClientId_args, startShortClientId_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShortClientId_args");

    private static final org.apache.thrift.protocol.TField CLIENT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("clientId", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShortClientId_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShortClientId_argsTupleSchemeFactory());
    }

    public String clientId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CLIENT_ID((short)1, "clientId");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CLIENT_ID
            return CLIENT_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CLIENT_ID, new org.apache.thrift.meta_data.FieldMetaData("clientId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShortClientId_args.class, metaDataMap);
    }

    public startShortClientId_args() {
    }

    public startShortClientId_args(
      String clientId)
    {
      this();
      this.clientId = clientId;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShortClientId_args(startShortClientId_args other) {
      if (other.isSetClientId()) {
        this.clientId = other.clientId;
      }
    }

    public startShortClientId_args deepCopy() {
      return new startShortClientId_args(this);
    }

    @Override
    public void clear() {
      this.clientId = null;
    }

    public String getClientId() {
      return this.clientId;
    }

    public startShortClientId_args setClientId(String clientId) {
      this.clientId = clientId;
      return this;
    }

    public void unsetClientId() {
      this.clientId = null;
    }

    /** Returns true if field clientId is set (has been assigned a value) and false otherwise */
    public boolean isSetClientId() {
      return this.clientId != null;
    }

    public void setClientIdIsSet(boolean value) {
      if (!value) {
        this.clientId = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CLIENT_ID:
        if (value == null) {
          unsetClientId();
        } else {
          setClientId((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CLIENT_ID:
        return getClientId();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CLIENT_ID:
        return isSetClientId();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShortClientId_args)
        return this.equals((startShortClientId_args)that);
      return false;
    }

    public boolean equals(startShortClientId_args that) {
      if (that == null)
        return false;

      boolean this_present_clientId = true && this.isSetClientId();
      boolean that_present_clientId = true && that.isSetClientId();
      if (this_present_clientId || that_present_clientId) {
        if (!(this_present_clientId && that_present_clientId))
          return false;
        if (!this.clientId.equals(that.clientId))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShortClientId_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShortClientId_args typedOther = (startShortClientId_args)other;

      lastComparison = Boolean.valueOf(isSetClientId()).compareTo(typedOther.isSetClientId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClientId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.clientId, typedOther.clientId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShortClientId_args(");
      boolean first = true;

      sb.append("clientId:");
      if (this.clientId == null) {
        sb.append("null");
      } else {
        sb.append(this.clientId);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShortClientId_argsStandardSchemeFactory implements SchemeFactory {
      public startShortClientId_argsStandardScheme getScheme() {
        return new startShortClientId_argsStandardScheme();
      }
    }

    private static class startShortClientId_argsStandardScheme extends StandardScheme<startShortClientId_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShortClientId_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CLIENT_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.clientId = iprot.readString();
                struct.setClientIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShortClientId_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.clientId != null) {
          oprot.writeFieldBegin(CLIENT_ID_FIELD_DESC);
          oprot.writeString(struct.clientId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShortClientId_argsTupleSchemeFactory implements SchemeFactory {
      public startShortClientId_argsTupleScheme getScheme() {
        return new startShortClientId_argsTupleScheme();
      }
    }

    private static class startShortClientId_argsTupleScheme extends TupleScheme<startShortClientId_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShortClientId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetClientId()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetClientId()) {
          oprot.writeString(struct.clientId);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShortClientId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.clientId = iprot.readString();
          struct.setClientIdIsSet(true);
        }
      }
    }

  }

  public static class startShortClientId_result implements org.apache.thrift.TBase<startShortClientId_result, startShortClientId_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShortClientId_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShortClientId_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShortClientId_resultTupleSchemeFactory());
    }

    public TTransaction success; // required
    public TGenericException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShortClientId_result.class, metaDataMap);
    }

    public startShortClientId_result() {
    }

    public startShortClientId_result(
      TTransaction success,
      TGenericException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShortClientId_result(startShortClientId_result other) {
      if (other.isSetSuccess()) {
        this.success = new TTransaction(other.success);
      }
      if (other.isSetE()) {
        this.e = new TGenericException(other.e);
      }
    }

    public startShortClientId_result deepCopy() {
      return new startShortClientId_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public TTransaction getSuccess() {
      return this.success;
    }

    public startShortClientId_result setSuccess(TTransaction success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TGenericException getE() {
      return this.e;
    }

    public startShortClientId_result setE(TGenericException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TTransaction)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TGenericException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShortClientId_result)
        return this.equals((startShortClientId_result)that);
      return false;
    }

    public boolean equals(startShortClientId_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShortClientId_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShortClientId_result typedOther = (startShortClientId_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShortClientId_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShortClientId_resultStandardSchemeFactory implements SchemeFactory {
      public startShortClientId_resultStandardScheme getScheme() {
        return new startShortClientId_resultStandardScheme();
      }
    }

    private static class startShortClientId_resultStandardScheme extends StandardScheme<startShortClientId_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShortClientId_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TTransaction();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TGenericException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShortClientId_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShortClientId_resultTupleSchemeFactory implements SchemeFactory {
      public startShortClientId_resultTupleScheme getScheme() {
        return new startShortClientId_resultTupleScheme();
      }
    }

    private static class startShortClientId_resultTupleScheme extends TupleScheme<startShortClientId_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShortClientId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShortClientId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TTransaction();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TGenericException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class startShortWithClientIdAndTimeOut_args implements org.apache.thrift.TBase<startShortWithClientIdAndTimeOut_args, startShortWithClientIdAndTimeOut_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShortWithClientIdAndTimeOut_args");

    private static final org.apache.thrift.protocol.TField CLIENT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("clientId", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TIMEOUT_FIELD_DESC = new org.apache.thrift.protocol.TField("timeout", org.apache.thrift.protocol.TType.I32, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShortWithClientIdAndTimeOut_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShortWithClientIdAndTimeOut_argsTupleSchemeFactory());
    }

    public String clientId; // required
    public int timeout; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CLIENT_ID((short)1, "clientId"),
      TIMEOUT((short)2, "timeout");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CLIENT_ID
            return CLIENT_ID;
          case 2: // TIMEOUT
            return TIMEOUT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMEOUT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CLIENT_ID, new org.apache.thrift.meta_data.FieldMetaData("clientId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TIMEOUT, new org.apache.thrift.meta_data.FieldMetaData("timeout", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShortWithClientIdAndTimeOut_args.class, metaDataMap);
    }

    public startShortWithClientIdAndTimeOut_args() {
    }

    public startShortWithClientIdAndTimeOut_args(
      String clientId,
      int timeout)
    {
      this();
      this.clientId = clientId;
      this.timeout = timeout;
      setTimeoutIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShortWithClientIdAndTimeOut_args(startShortWithClientIdAndTimeOut_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetClientId()) {
        this.clientId = other.clientId;
      }
      this.timeout = other.timeout;
    }

    public startShortWithClientIdAndTimeOut_args deepCopy() {
      return new startShortWithClientIdAndTimeOut_args(this);
    }

    @Override
    public void clear() {
      this.clientId = null;
      setTimeoutIsSet(false);
      this.timeout = 0;
    }

    public String getClientId() {
      return this.clientId;
    }

    public startShortWithClientIdAndTimeOut_args setClientId(String clientId) {
      this.clientId = clientId;
      return this;
    }

    public void unsetClientId() {
      this.clientId = null;
    }

    /** Returns true if field clientId is set (has been assigned a value) and false otherwise */
    public boolean isSetClientId() {
      return this.clientId != null;
    }

    public void setClientIdIsSet(boolean value) {
      if (!value) {
        this.clientId = null;
      }
    }

    public int getTimeout() {
      return this.timeout;
    }

    public startShortWithClientIdAndTimeOut_args setTimeout(int timeout) {
      this.timeout = timeout;
      setTimeoutIsSet(true);
      return this;
    }

    public void unsetTimeout() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TIMEOUT_ISSET_ID);
    }

    /** Returns true if field timeout is set (has been assigned a value) and false otherwise */
    public boolean isSetTimeout() {
      return EncodingUtils.testBit(__isset_bitfield, __TIMEOUT_ISSET_ID);
    }

    public void setTimeoutIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TIMEOUT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CLIENT_ID:
        if (value == null) {
          unsetClientId();
        } else {
          setClientId((String)value);
        }
        break;

      case TIMEOUT:
        if (value == null) {
          unsetTimeout();
        } else {
          setTimeout((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CLIENT_ID:
        return getClientId();

      case TIMEOUT:
        return Integer.valueOf(getTimeout());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CLIENT_ID:
        return isSetClientId();
      case TIMEOUT:
        return isSetTimeout();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShortWithClientIdAndTimeOut_args)
        return this.equals((startShortWithClientIdAndTimeOut_args)that);
      return false;
    }

    public boolean equals(startShortWithClientIdAndTimeOut_args that) {
      if (that == null)
        return false;

      boolean this_present_clientId = true && this.isSetClientId();
      boolean that_present_clientId = true && that.isSetClientId();
      if (this_present_clientId || that_present_clientId) {
        if (!(this_present_clientId && that_present_clientId))
          return false;
        if (!this.clientId.equals(that.clientId))
          return false;
      }

      boolean this_present_timeout = true;
      boolean that_present_timeout = true;
      if (this_present_timeout || that_present_timeout) {
        if (!(this_present_timeout && that_present_timeout))
          return false;
        if (this.timeout != that.timeout)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShortWithClientIdAndTimeOut_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShortWithClientIdAndTimeOut_args typedOther = (startShortWithClientIdAndTimeOut_args)other;

      lastComparison = Boolean.valueOf(isSetClientId()).compareTo(typedOther.isSetClientId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClientId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.clientId, typedOther.clientId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTimeout()).compareTo(typedOther.isSetTimeout());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimeout()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timeout, typedOther.timeout);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShortWithClientIdAndTimeOut_args(");
      boolean first = true;

      sb.append("clientId:");
      if (this.clientId == null) {
        sb.append("null");
      } else {
        sb.append(this.clientId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timeout:");
      sb.append(this.timeout);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShortWithClientIdAndTimeOut_argsStandardSchemeFactory implements SchemeFactory {
      public startShortWithClientIdAndTimeOut_argsStandardScheme getScheme() {
        return new startShortWithClientIdAndTimeOut_argsStandardScheme();
      }
    }

    private static class startShortWithClientIdAndTimeOut_argsStandardScheme extends StandardScheme<startShortWithClientIdAndTimeOut_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShortWithClientIdAndTimeOut_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CLIENT_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.clientId = iprot.readString();
                struct.setClientIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TIMEOUT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.timeout = iprot.readI32();
                struct.setTimeoutIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShortWithClientIdAndTimeOut_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.clientId != null) {
          oprot.writeFieldBegin(CLIENT_ID_FIELD_DESC);
          oprot.writeString(struct.clientId);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TIMEOUT_FIELD_DESC);
        oprot.writeI32(struct.timeout);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShortWithClientIdAndTimeOut_argsTupleSchemeFactory implements SchemeFactory {
      public startShortWithClientIdAndTimeOut_argsTupleScheme getScheme() {
        return new startShortWithClientIdAndTimeOut_argsTupleScheme();
      }
    }

    private static class startShortWithClientIdAndTimeOut_argsTupleScheme extends TupleScheme<startShortWithClientIdAndTimeOut_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShortWithClientIdAndTimeOut_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetClientId()) {
          optionals.set(0);
        }
        if (struct.isSetTimeout()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetClientId()) {
          oprot.writeString(struct.clientId);
        }
        if (struct.isSetTimeout()) {
          oprot.writeI32(struct.timeout);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShortWithClientIdAndTimeOut_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.clientId = iprot.readString();
          struct.setClientIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.timeout = iprot.readI32();
          struct.setTimeoutIsSet(true);
        }
      }
    }

  }

  public static class startShortWithClientIdAndTimeOut_result implements org.apache.thrift.TBase<startShortWithClientIdAndTimeOut_result, startShortWithClientIdAndTimeOut_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShortWithClientIdAndTimeOut_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShortWithClientIdAndTimeOut_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShortWithClientIdAndTimeOut_resultTupleSchemeFactory());
    }

    public TTransaction success; // required
    public TGenericException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShortWithClientIdAndTimeOut_result.class, metaDataMap);
    }

    public startShortWithClientIdAndTimeOut_result() {
    }

    public startShortWithClientIdAndTimeOut_result(
      TTransaction success,
      TGenericException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShortWithClientIdAndTimeOut_result(startShortWithClientIdAndTimeOut_result other) {
      if (other.isSetSuccess()) {
        this.success = new TTransaction(other.success);
      }
      if (other.isSetE()) {
        this.e = new TGenericException(other.e);
      }
    }

    public startShortWithClientIdAndTimeOut_result deepCopy() {
      return new startShortWithClientIdAndTimeOut_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public TTransaction getSuccess() {
      return this.success;
    }

    public startShortWithClientIdAndTimeOut_result setSuccess(TTransaction success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TGenericException getE() {
      return this.e;
    }

    public startShortWithClientIdAndTimeOut_result setE(TGenericException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TTransaction)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TGenericException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShortWithClientIdAndTimeOut_result)
        return this.equals((startShortWithClientIdAndTimeOut_result)that);
      return false;
    }

    public boolean equals(startShortWithClientIdAndTimeOut_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShortWithClientIdAndTimeOut_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShortWithClientIdAndTimeOut_result typedOther = (startShortWithClientIdAndTimeOut_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShortWithClientIdAndTimeOut_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShortWithClientIdAndTimeOut_resultStandardSchemeFactory implements SchemeFactory {
      public startShortWithClientIdAndTimeOut_resultStandardScheme getScheme() {
        return new startShortWithClientIdAndTimeOut_resultStandardScheme();
      }
    }

    private static class startShortWithClientIdAndTimeOut_resultStandardScheme extends StandardScheme<startShortWithClientIdAndTimeOut_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShortWithClientIdAndTimeOut_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TTransaction();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TGenericException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShortWithClientIdAndTimeOut_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShortWithClientIdAndTimeOut_resultTupleSchemeFactory implements SchemeFactory {
      public startShortWithClientIdAndTimeOut_resultTupleScheme getScheme() {
        return new startShortWithClientIdAndTimeOut_resultTupleScheme();
      }
    }

    private static class startShortWithClientIdAndTimeOut_resultTupleScheme extends TupleScheme<startShortWithClientIdAndTimeOut_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShortWithClientIdAndTimeOut_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShortWithClientIdAndTimeOut_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TTransaction();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TGenericException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class startShortWithTimeout_args implements org.apache.thrift.TBase<startShortWithTimeout_args, startShortWithTimeout_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShortWithTimeout_args");

    private static final org.apache.thrift.protocol.TField TIMEOUT_FIELD_DESC = new org.apache.thrift.protocol.TField("timeout", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShortWithTimeout_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShortWithTimeout_argsTupleSchemeFactory());
    }

    public int timeout; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TIMEOUT((short)1, "timeout");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TIMEOUT
            return TIMEOUT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMEOUT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TIMEOUT, new org.apache.thrift.meta_data.FieldMetaData("timeout", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShortWithTimeout_args.class, metaDataMap);
    }

    public startShortWithTimeout_args() {
    }

    public startShortWithTimeout_args(
      int timeout)
    {
      this();
      this.timeout = timeout;
      setTimeoutIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShortWithTimeout_args(startShortWithTimeout_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.timeout = other.timeout;
    }

    public startShortWithTimeout_args deepCopy() {
      return new startShortWithTimeout_args(this);
    }

    @Override
    public void clear() {
      setTimeoutIsSet(false);
      this.timeout = 0;
    }

    public int getTimeout() {
      return this.timeout;
    }

    public startShortWithTimeout_args setTimeout(int timeout) {
      this.timeout = timeout;
      setTimeoutIsSet(true);
      return this;
    }

    public void unsetTimeout() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TIMEOUT_ISSET_ID);
    }

    /** Returns true if field timeout is set (has been assigned a value) and false otherwise */
    public boolean isSetTimeout() {
      return EncodingUtils.testBit(__isset_bitfield, __TIMEOUT_ISSET_ID);
    }

    public void setTimeoutIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TIMEOUT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TIMEOUT:
        if (value == null) {
          unsetTimeout();
        } else {
          setTimeout((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TIMEOUT:
        return Integer.valueOf(getTimeout());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TIMEOUT:
        return isSetTimeout();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShortWithTimeout_args)
        return this.equals((startShortWithTimeout_args)that);
      return false;
    }

    public boolean equals(startShortWithTimeout_args that) {
      if (that == null)
        return false;

      boolean this_present_timeout = true;
      boolean that_present_timeout = true;
      if (this_present_timeout || that_present_timeout) {
        if (!(this_present_timeout && that_present_timeout))
          return false;
        if (this.timeout != that.timeout)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShortWithTimeout_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShortWithTimeout_args typedOther = (startShortWithTimeout_args)other;

      lastComparison = Boolean.valueOf(isSetTimeout()).compareTo(typedOther.isSetTimeout());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimeout()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timeout, typedOther.timeout);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShortWithTimeout_args(");
      boolean first = true;

      sb.append("timeout:");
      sb.append(this.timeout);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShortWithTimeout_argsStandardSchemeFactory implements SchemeFactory {
      public startShortWithTimeout_argsStandardScheme getScheme() {
        return new startShortWithTimeout_argsStandardScheme();
      }
    }

    private static class startShortWithTimeout_argsStandardScheme extends StandardScheme<startShortWithTimeout_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShortWithTimeout_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TIMEOUT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.timeout = iprot.readI32();
                struct.setTimeoutIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShortWithTimeout_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(TIMEOUT_FIELD_DESC);
        oprot.writeI32(struct.timeout);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShortWithTimeout_argsTupleSchemeFactory implements SchemeFactory {
      public startShortWithTimeout_argsTupleScheme getScheme() {
        return new startShortWithTimeout_argsTupleScheme();
      }
    }

    private static class startShortWithTimeout_argsTupleScheme extends TupleScheme<startShortWithTimeout_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShortWithTimeout_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTimeout()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTimeout()) {
          oprot.writeI32(struct.timeout);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShortWithTimeout_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.timeout = iprot.readI32();
          struct.setTimeoutIsSet(true);
        }
      }
    }

  }

  public static class startShortWithTimeout_result implements org.apache.thrift.TBase<startShortWithTimeout_result, startShortWithTimeout_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startShortWithTimeout_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startShortWithTimeout_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startShortWithTimeout_resultTupleSchemeFactory());
    }

    public TTransaction success; // required
    public TGenericException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startShortWithTimeout_result.class, metaDataMap);
    }

    public startShortWithTimeout_result() {
    }

    public startShortWithTimeout_result(
      TTransaction success,
      TGenericException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startShortWithTimeout_result(startShortWithTimeout_result other) {
      if (other.isSetSuccess()) {
        this.success = new TTransaction(other.success);
      }
      if (other.isSetE()) {
        this.e = new TGenericException(other.e);
      }
    }

    public startShortWithTimeout_result deepCopy() {
      return new startShortWithTimeout_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public TTransaction getSuccess() {
      return this.success;
    }

    public startShortWithTimeout_result setSuccess(TTransaction success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TGenericException getE() {
      return this.e;
    }

    public startShortWithTimeout_result setE(TGenericException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TTransaction)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TGenericException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startShortWithTimeout_result)
        return this.equals((startShortWithTimeout_result)that);
      return false;
    }

    public boolean equals(startShortWithTimeout_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(startShortWithTimeout_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      startShortWithTimeout_result typedOther = (startShortWithTimeout_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startShortWithTimeout_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startShortWithTimeout_resultStandardSchemeFactory implements SchemeFactory {
      public startShortWithTimeout_resultStandardScheme getScheme() {
        return new startShortWithTimeout_resultStandardScheme();
      }
    }

    private static class startShortWithTimeout_resultStandardScheme extends StandardScheme<startShortWithTimeout_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startShortWithTimeout_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TTransaction();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TGenericException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startShortWithTimeout_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startShortWithTimeout_resultTupleSchemeFactory implements SchemeFactory {
      public startShortWithTimeout_resultTupleScheme getScheme() {
        return new startShortWithTimeout_resultTupleScheme();
      }
    }

    private static class startShortWithTimeout_resultTupleScheme extends TupleScheme<startShortWithTimeout_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startShortWithTimeout_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startShortWithTimeout_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TTransaction();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TGenericException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class canCommitTx_args implements org.apache.thrift.TBase<canCommitTx_args, canCommitTx_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("canCommitTx_args");

    private static final org.apache.thrift.protocol.TField TX_FIELD_DESC = new org.apache.thrift.protocol.TField("tx", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CHANGES_FIELD_DESC = new org.apache.thrift.protocol.TField("changes", org.apache.thrift.protocol.TType.SET, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new canCommitTx_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new canCommitTx_argsTupleSchemeFactory());
    }

    public TTransaction tx; // required
    public Set<ByteBuffer> changes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TX((short)1, "tx"),
      CHANGES((short)2, "changes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TX
            return TX;
          case 2: // CHANGES
            return CHANGES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TX, new org.apache.thrift.meta_data.FieldMetaData("tx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      tmpMap.put(_Fields.CHANGES, new org.apache.thrift.meta_data.FieldMetaData("changes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(canCommitTx_args.class, metaDataMap);
    }

    public canCommitTx_args() {
    }

    public canCommitTx_args(
      TTransaction tx,
      Set<ByteBuffer> changes)
    {
      this();
      this.tx = tx;
      this.changes = changes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public canCommitTx_args(canCommitTx_args other) {
      if (other.isSetTx()) {
        this.tx = new TTransaction(other.tx);
      }
      if (other.isSetChanges()) {
        Set<ByteBuffer> __this__changes = new HashSet<ByteBuffer>();
        for (ByteBuffer other_element : other.changes) {
          ByteBuffer temp_binary_element = org.apache.thrift.TBaseHelper.copyBinary(other_element);
;
          __this__changes.add(temp_binary_element);
        }
        this.changes = __this__changes;
      }
    }

    public canCommitTx_args deepCopy() {
      return new canCommitTx_args(this);
    }

    @Override
    public void clear() {
      this.tx = null;
      this.changes = null;
    }

    public TTransaction getTx() {
      return this.tx;
    }

    public canCommitTx_args setTx(TTransaction tx) {
      this.tx = tx;
      return this;
    }

    public void unsetTx() {
      this.tx = null;
    }

    /** Returns true if field tx is set (has been assigned a value) and false otherwise */
    public boolean isSetTx() {
      return this.tx != null;
    }

    public void setTxIsSet(boolean value) {
      if (!value) {
        this.tx = null;
      }
    }

    public int getChangesSize() {
      return (this.changes == null) ? 0 : this.changes.size();
    }

    public java.util.Iterator<ByteBuffer> getChangesIterator() {
      return (this.changes == null) ? null : this.changes.iterator();
    }

    public void addToChanges(ByteBuffer elem) {
      if (this.changes == null) {
        this.changes = new HashSet<ByteBuffer>();
      }
      this.changes.add(elem);
    }

    public Set<ByteBuffer> getChanges() {
      return this.changes;
    }

    public canCommitTx_args setChanges(Set<ByteBuffer> changes) {
      this.changes = changes;
      return this;
    }

    public void unsetChanges() {
      this.changes = null;
    }

    /** Returns true if field changes is set (has been assigned a value) and false otherwise */
    public boolean isSetChanges() {
      return this.changes != null;
    }

    public void setChangesIsSet(boolean value) {
      if (!value) {
        this.changes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TX:
        if (value == null) {
          unsetTx();
        } else {
          setTx((TTransaction)value);
        }
        break;

      case CHANGES:
        if (value == null) {
          unsetChanges();
        } else {
          setChanges((Set<ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TX:
        return getTx();

      case CHANGES:
        return getChanges();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TX:
        return isSetTx();
      case CHANGES:
        return isSetChanges();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof canCommitTx_args)
        return this.equals((canCommitTx_args)that);
      return false;
    }

    public boolean equals(canCommitTx_args that) {
      if (that == null)
        return false;

      boolean this_present_tx = true && this.isSetTx();
      boolean that_present_tx = true && that.isSetTx();
      if (this_present_tx || that_present_tx) {
        if (!(this_present_tx && that_present_tx))
          return false;
        if (!this.tx.equals(that.tx))
          return false;
      }

      boolean this_present_changes = true && this.isSetChanges();
      boolean that_present_changes = true && that.isSetChanges();
      if (this_present_changes || that_present_changes) {
        if (!(this_present_changes && that_present_changes))
          return false;
        if (!this.changes.equals(that.changes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(canCommitTx_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      canCommitTx_args typedOther = (canCommitTx_args)other;

      lastComparison = Boolean.valueOf(isSetTx()).compareTo(typedOther.isSetTx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tx, typedOther.tx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetChanges()).compareTo(typedOther.isSetChanges());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetChanges()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.changes, typedOther.changes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("canCommitTx_args(");
      boolean first = true;

      sb.append("tx:");
      if (this.tx == null) {
        sb.append("null");
      } else {
        sb.append(this.tx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("changes:");
      if (this.changes == null) {
        sb.append("null");
      } else {
        sb.append(this.changes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tx != null) {
        tx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class canCommitTx_argsStandardSchemeFactory implements SchemeFactory {
      public canCommitTx_argsStandardScheme getScheme() {
        return new canCommitTx_argsStandardScheme();
      }
    }

    private static class canCommitTx_argsStandardScheme extends StandardScheme<canCommitTx_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, canCommitTx_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tx = new TTransaction();
                struct.tx.read(iprot);
                struct.setTxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CHANGES
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set24 = iprot.readSetBegin();
                  struct.changes = new HashSet<ByteBuffer>(2*_set24.size);
                  for (int _i25 = 0; _i25 < _set24.size; ++_i25)
                  {
                    ByteBuffer _elem26; // required
                    _elem26 = iprot.readBinary();
                    struct.changes.add(_elem26);
                  }
                  iprot.readSetEnd();
                }
                struct.setChangesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, canCommitTx_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tx != null) {
          oprot.writeFieldBegin(TX_FIELD_DESC);
          struct.tx.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.changes != null) {
          oprot.writeFieldBegin(CHANGES_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, struct.changes.size()));
            for (ByteBuffer _iter27 : struct.changes)
            {
              oprot.writeBinary(_iter27);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class canCommitTx_argsTupleSchemeFactory implements SchemeFactory {
      public canCommitTx_argsTupleScheme getScheme() {
        return new canCommitTx_argsTupleScheme();
      }
    }

    private static class canCommitTx_argsTupleScheme extends TupleScheme<canCommitTx_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, canCommitTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTx()) {
          optionals.set(0);
        }
        if (struct.isSetChanges()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTx()) {
          struct.tx.write(oprot);
        }
        if (struct.isSetChanges()) {
          {
            oprot.writeI32(struct.changes.size());
            for (ByteBuffer _iter28 : struct.changes)
            {
              oprot.writeBinary(_iter28);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, canCommitTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tx = new TTransaction();
          struct.tx.read(iprot);
          struct.setTxIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TSet _set29 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.changes = new HashSet<ByteBuffer>(2*_set29.size);
            for (int _i30 = 0; _i30 < _set29.size; ++_i30)
            {
              ByteBuffer _elem31; // required
              _elem31 = iprot.readBinary();
              struct.changes.add(_elem31);
            }
          }
          struct.setChangesIsSet(true);
        }
      }
    }

  }

  public static class canCommitTx_result implements org.apache.thrift.TBase<canCommitTx_result, canCommitTx_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("canCommitTx_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new canCommitTx_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new canCommitTx_resultTupleSchemeFactory());
    }

    public TBoolean success; // required
    public TTransactionNotInProgressException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TBoolean.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(canCommitTx_result.class, metaDataMap);
    }

    public canCommitTx_result() {
    }

    public canCommitTx_result(
      TBoolean success,
      TTransactionNotInProgressException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public canCommitTx_result(canCommitTx_result other) {
      if (other.isSetSuccess()) {
        this.success = new TBoolean(other.success);
      }
      if (other.isSetE()) {
        this.e = new TTransactionNotInProgressException(other.e);
      }
    }

    public canCommitTx_result deepCopy() {
      return new canCommitTx_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public TBoolean getSuccess() {
      return this.success;
    }

    public canCommitTx_result setSuccess(TBoolean success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TTransactionNotInProgressException getE() {
      return this.e;
    }

    public canCommitTx_result setE(TTransactionNotInProgressException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TBoolean)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TTransactionNotInProgressException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof canCommitTx_result)
        return this.equals((canCommitTx_result)that);
      return false;
    }

    public boolean equals(canCommitTx_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(canCommitTx_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      canCommitTx_result typedOther = (canCommitTx_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("canCommitTx_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class canCommitTx_resultStandardSchemeFactory implements SchemeFactory {
      public canCommitTx_resultStandardScheme getScheme() {
        return new canCommitTx_resultStandardScheme();
      }
    }

    private static class canCommitTx_resultStandardScheme extends StandardScheme<canCommitTx_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, canCommitTx_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TBoolean();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TTransactionNotInProgressException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, canCommitTx_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class canCommitTx_resultTupleSchemeFactory implements SchemeFactory {
      public canCommitTx_resultTupleScheme getScheme() {
        return new canCommitTx_resultTupleScheme();
      }
    }

    private static class canCommitTx_resultTupleScheme extends TupleScheme<canCommitTx_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, canCommitTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, canCommitTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TBoolean();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TTransactionNotInProgressException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class canCommitOrThrow_args implements org.apache.thrift.TBase<canCommitOrThrow_args, canCommitOrThrow_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("canCommitOrThrow_args");

    private static final org.apache.thrift.protocol.TField TX_FIELD_DESC = new org.apache.thrift.protocol.TField("tx", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField CHANGES_FIELD_DESC = new org.apache.thrift.protocol.TField("changes", org.apache.thrift.protocol.TType.SET, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new canCommitOrThrow_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new canCommitOrThrow_argsTupleSchemeFactory());
    }

    public long tx; // required
    public Set<ByteBuffer> changes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TX((short)1, "tx"),
      CHANGES((short)2, "changes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TX
            return TX;
          case 2: // CHANGES
            return CHANGES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TX_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TX, new org.apache.thrift.meta_data.FieldMetaData("tx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.CHANGES, new org.apache.thrift.meta_data.FieldMetaData("changes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(canCommitOrThrow_args.class, metaDataMap);
    }

    public canCommitOrThrow_args() {
    }

    public canCommitOrThrow_args(
      long tx,
      Set<ByteBuffer> changes)
    {
      this();
      this.tx = tx;
      setTxIsSet(true);
      this.changes = changes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public canCommitOrThrow_args(canCommitOrThrow_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.tx = other.tx;
      if (other.isSetChanges()) {
        Set<ByteBuffer> __this__changes = new HashSet<ByteBuffer>();
        for (ByteBuffer other_element : other.changes) {
          ByteBuffer temp_binary_element = org.apache.thrift.TBaseHelper.copyBinary(other_element);
;
          __this__changes.add(temp_binary_element);
        }
        this.changes = __this__changes;
      }
    }

    public canCommitOrThrow_args deepCopy() {
      return new canCommitOrThrow_args(this);
    }

    @Override
    public void clear() {
      setTxIsSet(false);
      this.tx = 0;
      this.changes = null;
    }

    public long getTx() {
      return this.tx;
    }

    public canCommitOrThrow_args setTx(long tx) {
      this.tx = tx;
      setTxIsSet(true);
      return this;
    }

    public void unsetTx() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TX_ISSET_ID);
    }

    /** Returns true if field tx is set (has been assigned a value) and false otherwise */
    public boolean isSetTx() {
      return EncodingUtils.testBit(__isset_bitfield, __TX_ISSET_ID);
    }

    public void setTxIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TX_ISSET_ID, value);
    }

    public int getChangesSize() {
      return (this.changes == null) ? 0 : this.changes.size();
    }

    public java.util.Iterator<ByteBuffer> getChangesIterator() {
      return (this.changes == null) ? null : this.changes.iterator();
    }

    public void addToChanges(ByteBuffer elem) {
      if (this.changes == null) {
        this.changes = new HashSet<ByteBuffer>();
      }
      this.changes.add(elem);
    }

    public Set<ByteBuffer> getChanges() {
      return this.changes;
    }

    public canCommitOrThrow_args setChanges(Set<ByteBuffer> changes) {
      this.changes = changes;
      return this;
    }

    public void unsetChanges() {
      this.changes = null;
    }

    /** Returns true if field changes is set (has been assigned a value) and false otherwise */
    public boolean isSetChanges() {
      return this.changes != null;
    }

    public void setChangesIsSet(boolean value) {
      if (!value) {
        this.changes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TX:
        if (value == null) {
          unsetTx();
        } else {
          setTx((Long)value);
        }
        break;

      case CHANGES:
        if (value == null) {
          unsetChanges();
        } else {
          setChanges((Set<ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TX:
        return Long.valueOf(getTx());

      case CHANGES:
        return getChanges();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TX:
        return isSetTx();
      case CHANGES:
        return isSetChanges();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof canCommitOrThrow_args)
        return this.equals((canCommitOrThrow_args)that);
      return false;
    }

    public boolean equals(canCommitOrThrow_args that) {
      if (that == null)
        return false;

      boolean this_present_tx = true;
      boolean that_present_tx = true;
      if (this_present_tx || that_present_tx) {
        if (!(this_present_tx && that_present_tx))
          return false;
        if (this.tx != that.tx)
          return false;
      }

      boolean this_present_changes = true && this.isSetChanges();
      boolean that_present_changes = true && that.isSetChanges();
      if (this_present_changes || that_present_changes) {
        if (!(this_present_changes && that_present_changes))
          return false;
        if (!this.changes.equals(that.changes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(canCommitOrThrow_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      canCommitOrThrow_args typedOther = (canCommitOrThrow_args)other;

      lastComparison = Boolean.valueOf(isSetTx()).compareTo(typedOther.isSetTx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tx, typedOther.tx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetChanges()).compareTo(typedOther.isSetChanges());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetChanges()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.changes, typedOther.changes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("canCommitOrThrow_args(");
      boolean first = true;

      sb.append("tx:");
      sb.append(this.tx);
      first = false;
      if (!first) sb.append(", ");
      sb.append("changes:");
      if (this.changes == null) {
        sb.append("null");
      } else {
        sb.append(this.changes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class canCommitOrThrow_argsStandardSchemeFactory implements SchemeFactory {
      public canCommitOrThrow_argsStandardScheme getScheme() {
        return new canCommitOrThrow_argsStandardScheme();
      }
    }

    private static class canCommitOrThrow_argsStandardScheme extends StandardScheme<canCommitOrThrow_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, canCommitOrThrow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TX
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.tx = iprot.readI64();
                struct.setTxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CHANGES
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set32 = iprot.readSetBegin();
                  struct.changes = new HashSet<ByteBuffer>(2*_set32.size);
                  for (int _i33 = 0; _i33 < _set32.size; ++_i33)
                  {
                    ByteBuffer _elem34; // required
                    _elem34 = iprot.readBinary();
                    struct.changes.add(_elem34);
                  }
                  iprot.readSetEnd();
                }
                struct.setChangesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, canCommitOrThrow_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(TX_FIELD_DESC);
        oprot.writeI64(struct.tx);
        oprot.writeFieldEnd();
        if (struct.changes != null) {
          oprot.writeFieldBegin(CHANGES_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, struct.changes.size()));
            for (ByteBuffer _iter35 : struct.changes)
            {
              oprot.writeBinary(_iter35);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class canCommitOrThrow_argsTupleSchemeFactory implements SchemeFactory {
      public canCommitOrThrow_argsTupleScheme getScheme() {
        return new canCommitOrThrow_argsTupleScheme();
      }
    }

    private static class canCommitOrThrow_argsTupleScheme extends TupleScheme<canCommitOrThrow_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, canCommitOrThrow_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTx()) {
          optionals.set(0);
        }
        if (struct.isSetChanges()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTx()) {
          oprot.writeI64(struct.tx);
        }
        if (struct.isSetChanges()) {
          {
            oprot.writeI32(struct.changes.size());
            for (ByteBuffer _iter36 : struct.changes)
            {
              oprot.writeBinary(_iter36);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, canCommitOrThrow_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tx = iprot.readI64();
          struct.setTxIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TSet _set37 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.changes = new HashSet<ByteBuffer>(2*_set37.size);
            for (int _i38 = 0; _i38 < _set37.size; ++_i38)
            {
              ByteBuffer _elem39; // required
              _elem39 = iprot.readBinary();
              struct.changes.add(_elem39);
            }
          }
          struct.setChangesIsSet(true);
        }
      }
    }

  }

  public static class canCommitOrThrow_result implements org.apache.thrift.TBase<canCommitOrThrow_result, canCommitOrThrow_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("canCommitOrThrow_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField C_FIELD_DESC = new org.apache.thrift.protocol.TField("c", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField G_FIELD_DESC = new org.apache.thrift.protocol.TField("g", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new canCommitOrThrow_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new canCommitOrThrow_resultTupleSchemeFactory());
    }

    public TTransactionNotInProgressException e; // required
    public TTransactionConflictException c; // required
    public TGenericException g; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      C((short)2, "c"),
      G((short)3, "g");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // C
            return C;
          case 3: // G
            return G;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.C, new org.apache.thrift.meta_data.FieldMetaData("c", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.G, new org.apache.thrift.meta_data.FieldMetaData("g", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(canCommitOrThrow_result.class, metaDataMap);
    }

    public canCommitOrThrow_result() {
    }

    public canCommitOrThrow_result(
      TTransactionNotInProgressException e,
      TTransactionConflictException c,
      TGenericException g)
    {
      this();
      this.e = e;
      this.c = c;
      this.g = g;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public canCommitOrThrow_result(canCommitOrThrow_result other) {
      if (other.isSetE()) {
        this.e = new TTransactionNotInProgressException(other.e);
      }
      if (other.isSetC()) {
        this.c = new TTransactionConflictException(other.c);
      }
      if (other.isSetG()) {
        this.g = new TGenericException(other.g);
      }
    }

    public canCommitOrThrow_result deepCopy() {
      return new canCommitOrThrow_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.c = null;
      this.g = null;
    }

    public TTransactionNotInProgressException getE() {
      return this.e;
    }

    public canCommitOrThrow_result setE(TTransactionNotInProgressException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public TTransactionConflictException getC() {
      return this.c;
    }

    public canCommitOrThrow_result setC(TTransactionConflictException c) {
      this.c = c;
      return this;
    }

    public void unsetC() {
      this.c = null;
    }

    /** Returns true if field c is set (has been assigned a value) and false otherwise */
    public boolean isSetC() {
      return this.c != null;
    }

    public void setCIsSet(boolean value) {
      if (!value) {
        this.c = null;
      }
    }

    public TGenericException getG() {
      return this.g;
    }

    public canCommitOrThrow_result setG(TGenericException g) {
      this.g = g;
      return this;
    }

    public void unsetG() {
      this.g = null;
    }

    /** Returns true if field g is set (has been assigned a value) and false otherwise */
    public boolean isSetG() {
      return this.g != null;
    }

    public void setGIsSet(boolean value) {
      if (!value) {
        this.g = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TTransactionNotInProgressException)value);
        }
        break;

      case C:
        if (value == null) {
          unsetC();
        } else {
          setC((TTransactionConflictException)value);
        }
        break;

      case G:
        if (value == null) {
          unsetG();
        } else {
          setG((TGenericException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return getE();

      case C:
        return getC();

      case G:
        return getG();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return isSetE();
      case C:
        return isSetC();
      case G:
        return isSetG();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof canCommitOrThrow_result)
        return this.equals((canCommitOrThrow_result)that);
      return false;
    }

    public boolean equals(canCommitOrThrow_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_c = true && this.isSetC();
      boolean that_present_c = true && that.isSetC();
      if (this_present_c || that_present_c) {
        if (!(this_present_c && that_present_c))
          return false;
        if (!this.c.equals(that.c))
          return false;
      }

      boolean this_present_g = true && this.isSetG();
      boolean that_present_g = true && that.isSetG();
      if (this_present_g || that_present_g) {
        if (!(this_present_g && that_present_g))
          return false;
        if (!this.g.equals(that.g))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(canCommitOrThrow_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      canCommitOrThrow_result typedOther = (canCommitOrThrow_result)other;

      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetC()).compareTo(typedOther.isSetC());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetC()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.c, typedOther.c);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetG()).compareTo(typedOther.isSetG());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetG()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.g, typedOther.g);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("canCommitOrThrow_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("c:");
      if (this.c == null) {
        sb.append("null");
      } else {
        sb.append(this.c);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("g:");
      if (this.g == null) {
        sb.append("null");
      } else {
        sb.append(this.g);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class canCommitOrThrow_resultStandardSchemeFactory implements SchemeFactory {
      public canCommitOrThrow_resultStandardScheme getScheme() {
        return new canCommitOrThrow_resultStandardScheme();
      }
    }

    private static class canCommitOrThrow_resultStandardScheme extends StandardScheme<canCommitOrThrow_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, canCommitOrThrow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TTransactionNotInProgressException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // C
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.c = new TTransactionConflictException();
                struct.c.read(iprot);
                struct.setCIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // G
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.g = new TGenericException();
                struct.g.read(iprot);
                struct.setGIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, canCommitOrThrow_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.c != null) {
          oprot.writeFieldBegin(C_FIELD_DESC);
          struct.c.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.g != null) {
          oprot.writeFieldBegin(G_FIELD_DESC);
          struct.g.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class canCommitOrThrow_resultTupleSchemeFactory implements SchemeFactory {
      public canCommitOrThrow_resultTupleScheme getScheme() {
        return new canCommitOrThrow_resultTupleScheme();
      }
    }

    private static class canCommitOrThrow_resultTupleScheme extends TupleScheme<canCommitOrThrow_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, canCommitOrThrow_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetE()) {
          optionals.set(0);
        }
        if (struct.isSetC()) {
          optionals.set(1);
        }
        if (struct.isSetG()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
        if (struct.isSetC()) {
          struct.c.write(oprot);
        }
        if (struct.isSetG()) {
          struct.g.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, canCommitOrThrow_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.e = new TTransactionNotInProgressException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
        if (incoming.get(1)) {
          struct.c = new TTransactionConflictException();
          struct.c.read(iprot);
          struct.setCIsSet(true);
        }
        if (incoming.get(2)) {
          struct.g = new TGenericException();
          struct.g.read(iprot);
          struct.setGIsSet(true);
        }
      }
    }

  }

  public static class commitTx_args implements org.apache.thrift.TBase<commitTx_args, commitTx_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("commitTx_args");

    private static final org.apache.thrift.protocol.TField TX_FIELD_DESC = new org.apache.thrift.protocol.TField("tx", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new commitTx_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new commitTx_argsTupleSchemeFactory());
    }

    public TTransaction tx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TX((short)1, "tx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TX
            return TX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TX, new org.apache.thrift.meta_data.FieldMetaData("tx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(commitTx_args.class, metaDataMap);
    }

    public commitTx_args() {
    }

    public commitTx_args(
      TTransaction tx)
    {
      this();
      this.tx = tx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public commitTx_args(commitTx_args other) {
      if (other.isSetTx()) {
        this.tx = new TTransaction(other.tx);
      }
    }

    public commitTx_args deepCopy() {
      return new commitTx_args(this);
    }

    @Override
    public void clear() {
      this.tx = null;
    }

    public TTransaction getTx() {
      return this.tx;
    }

    public commitTx_args setTx(TTransaction tx) {
      this.tx = tx;
      return this;
    }

    public void unsetTx() {
      this.tx = null;
    }

    /** Returns true if field tx is set (has been assigned a value) and false otherwise */
    public boolean isSetTx() {
      return this.tx != null;
    }

    public void setTxIsSet(boolean value) {
      if (!value) {
        this.tx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TX:
        if (value == null) {
          unsetTx();
        } else {
          setTx((TTransaction)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TX:
        return getTx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TX:
        return isSetTx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof commitTx_args)
        return this.equals((commitTx_args)that);
      return false;
    }

    public boolean equals(commitTx_args that) {
      if (that == null)
        return false;

      boolean this_present_tx = true && this.isSetTx();
      boolean that_present_tx = true && that.isSetTx();
      if (this_present_tx || that_present_tx) {
        if (!(this_present_tx && that_present_tx))
          return false;
        if (!this.tx.equals(that.tx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(commitTx_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      commitTx_args typedOther = (commitTx_args)other;

      lastComparison = Boolean.valueOf(isSetTx()).compareTo(typedOther.isSetTx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tx, typedOther.tx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("commitTx_args(");
      boolean first = true;

      sb.append("tx:");
      if (this.tx == null) {
        sb.append("null");
      } else {
        sb.append(this.tx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tx != null) {
        tx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class commitTx_argsStandardSchemeFactory implements SchemeFactory {
      public commitTx_argsStandardScheme getScheme() {
        return new commitTx_argsStandardScheme();
      }
    }

    private static class commitTx_argsStandardScheme extends StandardScheme<commitTx_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, commitTx_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tx = new TTransaction();
                struct.tx.read(iprot);
                struct.setTxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, commitTx_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tx != null) {
          oprot.writeFieldBegin(TX_FIELD_DESC);
          struct.tx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class commitTx_argsTupleSchemeFactory implements SchemeFactory {
      public commitTx_argsTupleScheme getScheme() {
        return new commitTx_argsTupleScheme();
      }
    }

    private static class commitTx_argsTupleScheme extends TupleScheme<commitTx_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, commitTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTx()) {
          struct.tx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, commitTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tx = new TTransaction();
          struct.tx.read(iprot);
          struct.setTxIsSet(true);
        }
      }
    }

  }

  public static class commitTx_result implements org.apache.thrift.TBase<commitTx_result, commitTx_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("commitTx_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new commitTx_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new commitTx_resultTupleSchemeFactory());
    }

    public TBoolean success; // required
    public TTransactionNotInProgressException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TBoolean.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(commitTx_result.class, metaDataMap);
    }

    public commitTx_result() {
    }

    public commitTx_result(
      TBoolean success,
      TTransactionNotInProgressException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public commitTx_result(commitTx_result other) {
      if (other.isSetSuccess()) {
        this.success = new TBoolean(other.success);
      }
      if (other.isSetE()) {
        this.e = new TTransactionNotInProgressException(other.e);
      }
    }

    public commitTx_result deepCopy() {
      return new commitTx_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public TBoolean getSuccess() {
      return this.success;
    }

    public commitTx_result setSuccess(TBoolean success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TTransactionNotInProgressException getE() {
      return this.e;
    }

    public commitTx_result setE(TTransactionNotInProgressException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TBoolean)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TTransactionNotInProgressException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof commitTx_result)
        return this.equals((commitTx_result)that);
      return false;
    }

    public boolean equals(commitTx_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(commitTx_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      commitTx_result typedOther = (commitTx_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("commitTx_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class commitTx_resultStandardSchemeFactory implements SchemeFactory {
      public commitTx_resultStandardScheme getScheme() {
        return new commitTx_resultStandardScheme();
      }
    }

    private static class commitTx_resultStandardScheme extends StandardScheme<commitTx_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, commitTx_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TBoolean();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TTransactionNotInProgressException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, commitTx_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class commitTx_resultTupleSchemeFactory implements SchemeFactory {
      public commitTx_resultTupleScheme getScheme() {
        return new commitTx_resultTupleScheme();
      }
    }

    private static class commitTx_resultTupleScheme extends TupleScheme<commitTx_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, commitTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, commitTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TBoolean();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TTransactionNotInProgressException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class commitOrThrow_args implements org.apache.thrift.TBase<commitOrThrow_args, commitOrThrow_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("commitOrThrow_args");

    private static final org.apache.thrift.protocol.TField TX_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("txId", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField WP_FIELD_DESC = new org.apache.thrift.protocol.TField("wp", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new commitOrThrow_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new commitOrThrow_argsTupleSchemeFactory());
    }

    public long txId; // required
    public long wp; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TX_ID((short)1, "txId"),
      WP((short)2, "wp");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TX_ID
            return TX_ID;
          case 2: // WP
            return WP;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TXID_ISSET_ID = 0;
    private static final int __WP_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TX_ID, new org.apache.thrift.meta_data.FieldMetaData("txId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.WP, new org.apache.thrift.meta_data.FieldMetaData("wp", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(commitOrThrow_args.class, metaDataMap);
    }

    public commitOrThrow_args() {
    }

    public commitOrThrow_args(
      long txId,
      long wp)
    {
      this();
      this.txId = txId;
      setTxIdIsSet(true);
      this.wp = wp;
      setWpIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public commitOrThrow_args(commitOrThrow_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.txId = other.txId;
      this.wp = other.wp;
    }

    public commitOrThrow_args deepCopy() {
      return new commitOrThrow_args(this);
    }

    @Override
    public void clear() {
      setTxIdIsSet(false);
      this.txId = 0;
      setWpIsSet(false);
      this.wp = 0;
    }

    public long getTxId() {
      return this.txId;
    }

    public commitOrThrow_args setTxId(long txId) {
      this.txId = txId;
      setTxIdIsSet(true);
      return this;
    }

    public void unsetTxId() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TXID_ISSET_ID);
    }

    /** Returns true if field txId is set (has been assigned a value) and false otherwise */
    public boolean isSetTxId() {
      return EncodingUtils.testBit(__isset_bitfield, __TXID_ISSET_ID);
    }

    public void setTxIdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TXID_ISSET_ID, value);
    }

    public long getWp() {
      return this.wp;
    }

    public commitOrThrow_args setWp(long wp) {
      this.wp = wp;
      setWpIsSet(true);
      return this;
    }

    public void unsetWp() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __WP_ISSET_ID);
    }

    /** Returns true if field wp is set (has been assigned a value) and false otherwise */
    public boolean isSetWp() {
      return EncodingUtils.testBit(__isset_bitfield, __WP_ISSET_ID);
    }

    public void setWpIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __WP_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TX_ID:
        if (value == null) {
          unsetTxId();
        } else {
          setTxId((Long)value);
        }
        break;

      case WP:
        if (value == null) {
          unsetWp();
        } else {
          setWp((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TX_ID:
        return Long.valueOf(getTxId());

      case WP:
        return Long.valueOf(getWp());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TX_ID:
        return isSetTxId();
      case WP:
        return isSetWp();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof commitOrThrow_args)
        return this.equals((commitOrThrow_args)that);
      return false;
    }

    public boolean equals(commitOrThrow_args that) {
      if (that == null)
        return false;

      boolean this_present_txId = true;
      boolean that_present_txId = true;
      if (this_present_txId || that_present_txId) {
        if (!(this_present_txId && that_present_txId))
          return false;
        if (this.txId != that.txId)
          return false;
      }

      boolean this_present_wp = true;
      boolean that_present_wp = true;
      if (this_present_wp || that_present_wp) {
        if (!(this_present_wp && that_present_wp))
          return false;
        if (this.wp != that.wp)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(commitOrThrow_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      commitOrThrow_args typedOther = (commitOrThrow_args)other;

      lastComparison = Boolean.valueOf(isSetTxId()).compareTo(typedOther.isSetTxId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTxId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.txId, typedOther.txId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetWp()).compareTo(typedOther.isSetWp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetWp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.wp, typedOther.wp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("commitOrThrow_args(");
      boolean first = true;

      sb.append("txId:");
      sb.append(this.txId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("wp:");
      sb.append(this.wp);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class commitOrThrow_argsStandardSchemeFactory implements SchemeFactory {
      public commitOrThrow_argsStandardScheme getScheme() {
        return new commitOrThrow_argsStandardScheme();
      }
    }

    private static class commitOrThrow_argsStandardScheme extends StandardScheme<commitOrThrow_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, commitOrThrow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TX_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.txId = iprot.readI64();
                struct.setTxIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // WP
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.wp = iprot.readI64();
                struct.setWpIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, commitOrThrow_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(TX_ID_FIELD_DESC);
        oprot.writeI64(struct.txId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(WP_FIELD_DESC);
        oprot.writeI64(struct.wp);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class commitOrThrow_argsTupleSchemeFactory implements SchemeFactory {
      public commitOrThrow_argsTupleScheme getScheme() {
        return new commitOrThrow_argsTupleScheme();
      }
    }

    private static class commitOrThrow_argsTupleScheme extends TupleScheme<commitOrThrow_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, commitOrThrow_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTxId()) {
          optionals.set(0);
        }
        if (struct.isSetWp()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTxId()) {
          oprot.writeI64(struct.txId);
        }
        if (struct.isSetWp()) {
          oprot.writeI64(struct.wp);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, commitOrThrow_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.txId = iprot.readI64();
          struct.setTxIdIsSet(true);
        }
        if (incoming.get(1)) {
          struct.wp = iprot.readI64();
          struct.setWpIsSet(true);
        }
      }
    }

  }

  public static class commitOrThrow_result implements org.apache.thrift.TBase<commitOrThrow_result, commitOrThrow_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("commitOrThrow_result");

    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField C_FIELD_DESC = new org.apache.thrift.protocol.TField("c", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField G_FIELD_DESC = new org.apache.thrift.protocol.TField("g", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new commitOrThrow_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new commitOrThrow_resultTupleSchemeFactory());
    }

    public TTransactionNotInProgressException e; // required
    public TTransactionConflictException c; // required
    public TGenericException g; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      E((short)1, "e"),
      C((short)2, "c"),
      G((short)3, "g");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // E
            return E;
          case 2: // C
            return C;
          case 3: // G
            return G;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.C, new org.apache.thrift.meta_data.FieldMetaData("c", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.G, new org.apache.thrift.meta_data.FieldMetaData("g", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(commitOrThrow_result.class, metaDataMap);
    }

    public commitOrThrow_result() {
    }

    public commitOrThrow_result(
      TTransactionNotInProgressException e,
      TTransactionConflictException c,
      TGenericException g)
    {
      this();
      this.e = e;
      this.c = c;
      this.g = g;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public commitOrThrow_result(commitOrThrow_result other) {
      if (other.isSetE()) {
        this.e = new TTransactionNotInProgressException(other.e);
      }
      if (other.isSetC()) {
        this.c = new TTransactionConflictException(other.c);
      }
      if (other.isSetG()) {
        this.g = new TGenericException(other.g);
      }
    }

    public commitOrThrow_result deepCopy() {
      return new commitOrThrow_result(this);
    }

    @Override
    public void clear() {
      this.e = null;
      this.c = null;
      this.g = null;
    }

    public TTransactionNotInProgressException getE() {
      return this.e;
    }

    public commitOrThrow_result setE(TTransactionNotInProgressException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public TTransactionConflictException getC() {
      return this.c;
    }

    public commitOrThrow_result setC(TTransactionConflictException c) {
      this.c = c;
      return this;
    }

    public void unsetC() {
      this.c = null;
    }

    /** Returns true if field c is set (has been assigned a value) and false otherwise */
    public boolean isSetC() {
      return this.c != null;
    }

    public void setCIsSet(boolean value) {
      if (!value) {
        this.c = null;
      }
    }

    public TGenericException getG() {
      return this.g;
    }

    public commitOrThrow_result setG(TGenericException g) {
      this.g = g;
      return this;
    }

    public void unsetG() {
      this.g = null;
    }

    /** Returns true if field g is set (has been assigned a value) and false otherwise */
    public boolean isSetG() {
      return this.g != null;
    }

    public void setGIsSet(boolean value) {
      if (!value) {
        this.g = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TTransactionNotInProgressException)value);
        }
        break;

      case C:
        if (value == null) {
          unsetC();
        } else {
          setC((TTransactionConflictException)value);
        }
        break;

      case G:
        if (value == null) {
          unsetG();
        } else {
          setG((TGenericException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case E:
        return getE();

      case C:
        return getC();

      case G:
        return getG();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case E:
        return isSetE();
      case C:
        return isSetC();
      case G:
        return isSetG();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof commitOrThrow_result)
        return this.equals((commitOrThrow_result)that);
      return false;
    }

    public boolean equals(commitOrThrow_result that) {
      if (that == null)
        return false;

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      boolean this_present_c = true && this.isSetC();
      boolean that_present_c = true && that.isSetC();
      if (this_present_c || that_present_c) {
        if (!(this_present_c && that_present_c))
          return false;
        if (!this.c.equals(that.c))
          return false;
      }

      boolean this_present_g = true && this.isSetG();
      boolean that_present_g = true && that.isSetG();
      if (this_present_g || that_present_g) {
        if (!(this_present_g && that_present_g))
          return false;
        if (!this.g.equals(that.g))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(commitOrThrow_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      commitOrThrow_result typedOther = (commitOrThrow_result)other;

      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetC()).compareTo(typedOther.isSetC());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetC()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.c, typedOther.c);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetG()).compareTo(typedOther.isSetG());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetG()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.g, typedOther.g);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("commitOrThrow_result(");
      boolean first = true;

      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("c:");
      if (this.c == null) {
        sb.append("null");
      } else {
        sb.append(this.c);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("g:");
      if (this.g == null) {
        sb.append("null");
      } else {
        sb.append(this.g);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class commitOrThrow_resultStandardSchemeFactory implements SchemeFactory {
      public commitOrThrow_resultStandardScheme getScheme() {
        return new commitOrThrow_resultStandardScheme();
      }
    }

    private static class commitOrThrow_resultStandardScheme extends StandardScheme<commitOrThrow_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, commitOrThrow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TTransactionNotInProgressException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // C
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.c = new TTransactionConflictException();
                struct.c.read(iprot);
                struct.setCIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // G
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.g = new TGenericException();
                struct.g.read(iprot);
                struct.setGIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, commitOrThrow_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.c != null) {
          oprot.writeFieldBegin(C_FIELD_DESC);
          struct.c.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.g != null) {
          oprot.writeFieldBegin(G_FIELD_DESC);
          struct.g.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class commitOrThrow_resultTupleSchemeFactory implements SchemeFactory {
      public commitOrThrow_resultTupleScheme getScheme() {
        return new commitOrThrow_resultTupleScheme();
      }
    }

    private static class commitOrThrow_resultTupleScheme extends TupleScheme<commitOrThrow_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, commitOrThrow_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetE()) {
          optionals.set(0);
        }
        if (struct.isSetC()) {
          optionals.set(1);
        }
        if (struct.isSetG()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
        if (struct.isSetC()) {
          struct.c.write(oprot);
        }
        if (struct.isSetG()) {
          struct.g.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, commitOrThrow_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.e = new TTransactionNotInProgressException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
        if (incoming.get(1)) {
          struct.c = new TTransactionConflictException();
          struct.c.read(iprot);
          struct.setCIsSet(true);
        }
        if (incoming.get(2)) {
          struct.g = new TGenericException();
          struct.g.read(iprot);
          struct.setGIsSet(true);
        }
      }
    }

  }

  public static class abortTx_args implements org.apache.thrift.TBase<abortTx_args, abortTx_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("abortTx_args");

    private static final org.apache.thrift.protocol.TField TX_FIELD_DESC = new org.apache.thrift.protocol.TField("tx", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new abortTx_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new abortTx_argsTupleSchemeFactory());
    }

    public TTransaction tx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TX((short)1, "tx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TX
            return TX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TX, new org.apache.thrift.meta_data.FieldMetaData("tx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(abortTx_args.class, metaDataMap);
    }

    public abortTx_args() {
    }

    public abortTx_args(
      TTransaction tx)
    {
      this();
      this.tx = tx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public abortTx_args(abortTx_args other) {
      if (other.isSetTx()) {
        this.tx = new TTransaction(other.tx);
      }
    }

    public abortTx_args deepCopy() {
      return new abortTx_args(this);
    }

    @Override
    public void clear() {
      this.tx = null;
    }

    public TTransaction getTx() {
      return this.tx;
    }

    public abortTx_args setTx(TTransaction tx) {
      this.tx = tx;
      return this;
    }

    public void unsetTx() {
      this.tx = null;
    }

    /** Returns true if field tx is set (has been assigned a value) and false otherwise */
    public boolean isSetTx() {
      return this.tx != null;
    }

    public void setTxIsSet(boolean value) {
      if (!value) {
        this.tx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TX:
        if (value == null) {
          unsetTx();
        } else {
          setTx((TTransaction)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TX:
        return getTx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TX:
        return isSetTx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof abortTx_args)
        return this.equals((abortTx_args)that);
      return false;
    }

    public boolean equals(abortTx_args that) {
      if (that == null)
        return false;

      boolean this_present_tx = true && this.isSetTx();
      boolean that_present_tx = true && that.isSetTx();
      if (this_present_tx || that_present_tx) {
        if (!(this_present_tx && that_present_tx))
          return false;
        if (!this.tx.equals(that.tx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(abortTx_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      abortTx_args typedOther = (abortTx_args)other;

      lastComparison = Boolean.valueOf(isSetTx()).compareTo(typedOther.isSetTx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tx, typedOther.tx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("abortTx_args(");
      boolean first = true;

      sb.append("tx:");
      if (this.tx == null) {
        sb.append("null");
      } else {
        sb.append(this.tx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tx != null) {
        tx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class abortTx_argsStandardSchemeFactory implements SchemeFactory {
      public abortTx_argsStandardScheme getScheme() {
        return new abortTx_argsStandardScheme();
      }
    }

    private static class abortTx_argsStandardScheme extends StandardScheme<abortTx_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, abortTx_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tx = new TTransaction();
                struct.tx.read(iprot);
                struct.setTxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, abortTx_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tx != null) {
          oprot.writeFieldBegin(TX_FIELD_DESC);
          struct.tx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class abortTx_argsTupleSchemeFactory implements SchemeFactory {
      public abortTx_argsTupleScheme getScheme() {
        return new abortTx_argsTupleScheme();
      }
    }

    private static class abortTx_argsTupleScheme extends TupleScheme<abortTx_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, abortTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTx()) {
          struct.tx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, abortTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tx = new TTransaction();
          struct.tx.read(iprot);
          struct.setTxIsSet(true);
        }
      }
    }

  }

  public static class abortTx_result implements org.apache.thrift.TBase<abortTx_result, abortTx_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("abortTx_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new abortTx_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new abortTx_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(abortTx_result.class, metaDataMap);
    }

    public abortTx_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public abortTx_result(abortTx_result other) {
    }

    public abortTx_result deepCopy() {
      return new abortTx_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof abortTx_result)
        return this.equals((abortTx_result)that);
      return false;
    }

    public boolean equals(abortTx_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(abortTx_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      abortTx_result typedOther = (abortTx_result)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("abortTx_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class abortTx_resultStandardSchemeFactory implements SchemeFactory {
      public abortTx_resultStandardScheme getScheme() {
        return new abortTx_resultStandardScheme();
      }
    }

    private static class abortTx_resultStandardScheme extends StandardScheme<abortTx_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, abortTx_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, abortTx_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class abortTx_resultTupleSchemeFactory implements SchemeFactory {
      public abortTx_resultTupleScheme getScheme() {
        return new abortTx_resultTupleScheme();
      }
    }

    private static class abortTx_resultTupleScheme extends TupleScheme<abortTx_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, abortTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, abortTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class invalidateTx_args implements org.apache.thrift.TBase<invalidateTx_args, invalidateTx_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("invalidateTx_args");

    private static final org.apache.thrift.protocol.TField TXID_FIELD_DESC = new org.apache.thrift.protocol.TField("txid", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new invalidateTx_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new invalidateTx_argsTupleSchemeFactory());
    }

    public long txid; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TXID((short)1, "txid");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TXID
            return TXID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TXID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TXID, new org.apache.thrift.meta_data.FieldMetaData("txid", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(invalidateTx_args.class, metaDataMap);
    }

    public invalidateTx_args() {
    }

    public invalidateTx_args(
      long txid)
    {
      this();
      this.txid = txid;
      setTxidIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public invalidateTx_args(invalidateTx_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.txid = other.txid;
    }

    public invalidateTx_args deepCopy() {
      return new invalidateTx_args(this);
    }

    @Override
    public void clear() {
      setTxidIsSet(false);
      this.txid = 0;
    }

    public long getTxid() {
      return this.txid;
    }

    public invalidateTx_args setTxid(long txid) {
      this.txid = txid;
      setTxidIsSet(true);
      return this;
    }

    public void unsetTxid() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TXID_ISSET_ID);
    }

    /** Returns true if field txid is set (has been assigned a value) and false otherwise */
    public boolean isSetTxid() {
      return EncodingUtils.testBit(__isset_bitfield, __TXID_ISSET_ID);
    }

    public void setTxidIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TXID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TXID:
        if (value == null) {
          unsetTxid();
        } else {
          setTxid((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TXID:
        return Long.valueOf(getTxid());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TXID:
        return isSetTxid();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof invalidateTx_args)
        return this.equals((invalidateTx_args)that);
      return false;
    }

    public boolean equals(invalidateTx_args that) {
      if (that == null)
        return false;

      boolean this_present_txid = true;
      boolean that_present_txid = true;
      if (this_present_txid || that_present_txid) {
        if (!(this_present_txid && that_present_txid))
          return false;
        if (this.txid != that.txid)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(invalidateTx_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      invalidateTx_args typedOther = (invalidateTx_args)other;

      lastComparison = Boolean.valueOf(isSetTxid()).compareTo(typedOther.isSetTxid());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTxid()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.txid, typedOther.txid);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("invalidateTx_args(");
      boolean first = true;

      sb.append("txid:");
      sb.append(this.txid);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class invalidateTx_argsStandardSchemeFactory implements SchemeFactory {
      public invalidateTx_argsStandardScheme getScheme() {
        return new invalidateTx_argsStandardScheme();
      }
    }

    private static class invalidateTx_argsStandardScheme extends StandardScheme<invalidateTx_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, invalidateTx_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TXID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.txid = iprot.readI64();
                struct.setTxidIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, invalidateTx_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(TXID_FIELD_DESC);
        oprot.writeI64(struct.txid);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class invalidateTx_argsTupleSchemeFactory implements SchemeFactory {
      public invalidateTx_argsTupleScheme getScheme() {
        return new invalidateTx_argsTupleScheme();
      }
    }

    private static class invalidateTx_argsTupleScheme extends TupleScheme<invalidateTx_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, invalidateTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTxid()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTxid()) {
          oprot.writeI64(struct.txid);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, invalidateTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.txid = iprot.readI64();
          struct.setTxidIsSet(true);
        }
      }
    }

  }

  public static class invalidateTx_result implements org.apache.thrift.TBase<invalidateTx_result, invalidateTx_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("invalidateTx_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new invalidateTx_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new invalidateTx_resultTupleSchemeFactory());
    }

    public boolean success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(invalidateTx_result.class, metaDataMap);
    }

    public invalidateTx_result() {
    }

    public invalidateTx_result(
      boolean success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public invalidateTx_result(invalidateTx_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    public invalidateTx_result deepCopy() {
      return new invalidateTx_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public invalidateTx_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof invalidateTx_result)
        return this.equals((invalidateTx_result)that);
      return false;
    }

    public boolean equals(invalidateTx_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(invalidateTx_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      invalidateTx_result typedOther = (invalidateTx_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("invalidateTx_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class invalidateTx_resultStandardSchemeFactory implements SchemeFactory {
      public invalidateTx_resultStandardScheme getScheme() {
        return new invalidateTx_resultStandardScheme();
      }
    }

    private static class invalidateTx_resultStandardScheme extends StandardScheme<invalidateTx_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, invalidateTx_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, invalidateTx_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class invalidateTx_resultTupleSchemeFactory implements SchemeFactory {
      public invalidateTx_resultTupleScheme getScheme() {
        return new invalidateTx_resultTupleScheme();
      }
    }

    private static class invalidateTx_resultTupleScheme extends TupleScheme<invalidateTx_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, invalidateTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, invalidateTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getSnapshot_args implements org.apache.thrift.TBase<getSnapshot_args, getSnapshot_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getSnapshot_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getSnapshot_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getSnapshot_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getSnapshot_args.class, metaDataMap);
    }

    public getSnapshot_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getSnapshot_args(getSnapshot_args other) {
    }

    public getSnapshot_args deepCopy() {
      return new getSnapshot_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getSnapshot_args)
        return this.equals((getSnapshot_args)that);
      return false;
    }

    public boolean equals(getSnapshot_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getSnapshot_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getSnapshot_args typedOther = (getSnapshot_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getSnapshot_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getSnapshot_argsStandardSchemeFactory implements SchemeFactory {
      public getSnapshot_argsStandardScheme getScheme() {
        return new getSnapshot_argsStandardScheme();
      }
    }

    private static class getSnapshot_argsStandardScheme extends StandardScheme<getSnapshot_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getSnapshot_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getSnapshot_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getSnapshot_argsTupleSchemeFactory implements SchemeFactory {
      public getSnapshot_argsTupleScheme getScheme() {
        return new getSnapshot_argsTupleScheme();
      }
    }

    private static class getSnapshot_argsTupleScheme extends TupleScheme<getSnapshot_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getSnapshot_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getSnapshot_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getSnapshot_result implements org.apache.thrift.TBase<getSnapshot_result, getSnapshot_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getSnapshot_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getSnapshot_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getSnapshot_resultTupleSchemeFactory());
    }

    public ByteBuffer success; // required
    public TTransactionCouldNotTakeSnapshotException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getSnapshot_result.class, metaDataMap);
    }

    public getSnapshot_result() {
    }

    public getSnapshot_result(
      ByteBuffer success,
      TTransactionCouldNotTakeSnapshotException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getSnapshot_result(getSnapshot_result other) {
      if (other.isSetSuccess()) {
        this.success = org.apache.thrift.TBaseHelper.copyBinary(other.success);
;
      }
      if (other.isSetE()) {
        this.e = new TTransactionCouldNotTakeSnapshotException(other.e);
      }
    }

    public getSnapshot_result deepCopy() {
      return new getSnapshot_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public byte[] getSuccess() {
      setSuccess(org.apache.thrift.TBaseHelper.rightSize(success));
      return success == null ? null : success.array();
    }

    public ByteBuffer bufferForSuccess() {
      return success;
    }

    public getSnapshot_result setSuccess(byte[] success) {
      setSuccess(success == null ? (ByteBuffer)null : ByteBuffer.wrap(success));
      return this;
    }

    public getSnapshot_result setSuccess(ByteBuffer success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TTransactionCouldNotTakeSnapshotException getE() {
      return this.e;
    }

    public getSnapshot_result setE(TTransactionCouldNotTakeSnapshotException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ByteBuffer)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TTransactionCouldNotTakeSnapshotException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getSnapshot_result)
        return this.equals((getSnapshot_result)that);
      return false;
    }

    public boolean equals(getSnapshot_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(getSnapshot_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getSnapshot_result typedOther = (getSnapshot_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getSnapshot_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.success, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getSnapshot_resultStandardSchemeFactory implements SchemeFactory {
      public getSnapshot_resultStandardScheme getScheme() {
        return new getSnapshot_resultStandardScheme();
      }
    }

    private static class getSnapshot_resultStandardScheme extends StandardScheme<getSnapshot_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getSnapshot_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readBinary();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TTransactionCouldNotTakeSnapshotException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getSnapshot_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBinary(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getSnapshot_resultTupleSchemeFactory implements SchemeFactory {
      public getSnapshot_resultTupleScheme getScheme() {
        return new getSnapshot_resultTupleScheme();
      }
    }

    private static class getSnapshot_resultTupleScheme extends TupleScheme<getSnapshot_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getSnapshot_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBinary(struct.success);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getSnapshot_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBinary();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TTransactionCouldNotTakeSnapshotException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class resetState_args implements org.apache.thrift.TBase<resetState_args, resetState_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resetState_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resetState_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resetState_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resetState_args.class, metaDataMap);
    }

    public resetState_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resetState_args(resetState_args other) {
    }

    public resetState_args deepCopy() {
      return new resetState_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resetState_args)
        return this.equals((resetState_args)that);
      return false;
    }

    public boolean equals(resetState_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(resetState_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      resetState_args typedOther = (resetState_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resetState_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resetState_argsStandardSchemeFactory implements SchemeFactory {
      public resetState_argsStandardScheme getScheme() {
        return new resetState_argsStandardScheme();
      }
    }

    private static class resetState_argsStandardScheme extends StandardScheme<resetState_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resetState_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resetState_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resetState_argsTupleSchemeFactory implements SchemeFactory {
      public resetState_argsTupleScheme getScheme() {
        return new resetState_argsTupleScheme();
      }
    }

    private static class resetState_argsTupleScheme extends TupleScheme<resetState_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resetState_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resetState_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class resetState_result implements org.apache.thrift.TBase<resetState_result, resetState_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resetState_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new resetState_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new resetState_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resetState_result.class, metaDataMap);
    }

    public resetState_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public resetState_result(resetState_result other) {
    }

    public resetState_result deepCopy() {
      return new resetState_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof resetState_result)
        return this.equals((resetState_result)that);
      return false;
    }

    public boolean equals(resetState_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(resetState_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      resetState_result typedOther = (resetState_result)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("resetState_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class resetState_resultStandardSchemeFactory implements SchemeFactory {
      public resetState_resultStandardScheme getScheme() {
        return new resetState_resultStandardScheme();
      }
    }

    private static class resetState_resultStandardScheme extends StandardScheme<resetState_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, resetState_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, resetState_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class resetState_resultTupleSchemeFactory implements SchemeFactory {
      public resetState_resultTupleScheme getScheme() {
        return new resetState_resultTupleScheme();
      }
    }

    private static class resetState_resultTupleScheme extends TupleScheme<resetState_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, resetState_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, resetState_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class status_args implements org.apache.thrift.TBase<status_args, status_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("status_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new status_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new status_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(status_args.class, metaDataMap);
    }

    public status_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public status_args(status_args other) {
    }

    public status_args deepCopy() {
      return new status_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof status_args)
        return this.equals((status_args)that);
      return false;
    }

    public boolean equals(status_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(status_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      status_args typedOther = (status_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("status_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class status_argsStandardSchemeFactory implements SchemeFactory {
      public status_argsStandardScheme getScheme() {
        return new status_argsStandardScheme();
      }
    }

    private static class status_argsStandardScheme extends StandardScheme<status_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, status_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, status_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class status_argsTupleSchemeFactory implements SchemeFactory {
      public status_argsTupleScheme getScheme() {
        return new status_argsTupleScheme();
      }
    }

    private static class status_argsTupleScheme extends TupleScheme<status_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, status_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, status_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class status_result implements org.apache.thrift.TBase<status_result, status_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("status_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new status_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new status_resultTupleSchemeFactory());
    }

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(status_result.class, metaDataMap);
    }

    public status_result() {
    }

    public status_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public status_result(status_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public status_result deepCopy() {
      return new status_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public status_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof status_result)
        return this.equals((status_result)that);
      return false;
    }

    public boolean equals(status_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(status_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      status_result typedOther = (status_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("status_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class status_resultStandardSchemeFactory implements SchemeFactory {
      public status_resultStandardScheme getScheme() {
        return new status_resultStandardScheme();
      }
    }

    private static class status_resultStandardScheme extends StandardScheme<status_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, status_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, status_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class status_resultTupleSchemeFactory implements SchemeFactory {
      public status_resultTupleScheme getScheme() {
        return new status_resultTupleScheme();
      }
    }

    private static class status_resultTupleScheme extends TupleScheme<status_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, status_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, status_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class truncateInvalidTx_args implements org.apache.thrift.TBase<truncateInvalidTx_args, truncateInvalidTx_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("truncateInvalidTx_args");

    private static final org.apache.thrift.protocol.TField TXNS_FIELD_DESC = new org.apache.thrift.protocol.TField("txns", org.apache.thrift.protocol.TType.SET, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new truncateInvalidTx_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new truncateInvalidTx_argsTupleSchemeFactory());
    }

    public Set<Long> txns; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TXNS((short)1, "txns");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TXNS
            return TXNS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TXNS, new org.apache.thrift.meta_data.FieldMetaData("txns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(truncateInvalidTx_args.class, metaDataMap);
    }

    public truncateInvalidTx_args() {
    }

    public truncateInvalidTx_args(
      Set<Long> txns)
    {
      this();
      this.txns = txns;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public truncateInvalidTx_args(truncateInvalidTx_args other) {
      if (other.isSetTxns()) {
        Set<Long> __this__txns = new HashSet<Long>();
        for (Long other_element : other.txns) {
          __this__txns.add(other_element);
        }
        this.txns = __this__txns;
      }
    }

    public truncateInvalidTx_args deepCopy() {
      return new truncateInvalidTx_args(this);
    }

    @Override
    public void clear() {
      this.txns = null;
    }

    public int getTxnsSize() {
      return (this.txns == null) ? 0 : this.txns.size();
    }

    public java.util.Iterator<Long> getTxnsIterator() {
      return (this.txns == null) ? null : this.txns.iterator();
    }

    public void addToTxns(long elem) {
      if (this.txns == null) {
        this.txns = new HashSet<Long>();
      }
      this.txns.add(elem);
    }

    public Set<Long> getTxns() {
      return this.txns;
    }

    public truncateInvalidTx_args setTxns(Set<Long> txns) {
      this.txns = txns;
      return this;
    }

    public void unsetTxns() {
      this.txns = null;
    }

    /** Returns true if field txns is set (has been assigned a value) and false otherwise */
    public boolean isSetTxns() {
      return this.txns != null;
    }

    public void setTxnsIsSet(boolean value) {
      if (!value) {
        this.txns = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TXNS:
        if (value == null) {
          unsetTxns();
        } else {
          setTxns((Set<Long>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TXNS:
        return getTxns();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TXNS:
        return isSetTxns();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof truncateInvalidTx_args)
        return this.equals((truncateInvalidTx_args)that);
      return false;
    }

    public boolean equals(truncateInvalidTx_args that) {
      if (that == null)
        return false;

      boolean this_present_txns = true && this.isSetTxns();
      boolean that_present_txns = true && that.isSetTxns();
      if (this_present_txns || that_present_txns) {
        if (!(this_present_txns && that_present_txns))
          return false;
        if (!this.txns.equals(that.txns))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(truncateInvalidTx_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      truncateInvalidTx_args typedOther = (truncateInvalidTx_args)other;

      lastComparison = Boolean.valueOf(isSetTxns()).compareTo(typedOther.isSetTxns());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTxns()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.txns, typedOther.txns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("truncateInvalidTx_args(");
      boolean first = true;

      sb.append("txns:");
      if (this.txns == null) {
        sb.append("null");
      } else {
        sb.append(this.txns);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class truncateInvalidTx_argsStandardSchemeFactory implements SchemeFactory {
      public truncateInvalidTx_argsStandardScheme getScheme() {
        return new truncateInvalidTx_argsStandardScheme();
      }
    }

    private static class truncateInvalidTx_argsStandardScheme extends StandardScheme<truncateInvalidTx_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, truncateInvalidTx_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TXNS
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set40 = iprot.readSetBegin();
                  struct.txns = new HashSet<Long>(2*_set40.size);
                  for (int _i41 = 0; _i41 < _set40.size; ++_i41)
                  {
                    long _elem42; // required
                    _elem42 = iprot.readI64();
                    struct.txns.add(_elem42);
                  }
                  iprot.readSetEnd();
                }
                struct.setTxnsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, truncateInvalidTx_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.txns != null) {
          oprot.writeFieldBegin(TXNS_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I64, struct.txns.size()));
            for (long _iter43 : struct.txns)
            {
              oprot.writeI64(_iter43);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class truncateInvalidTx_argsTupleSchemeFactory implements SchemeFactory {
      public truncateInvalidTx_argsTupleScheme getScheme() {
        return new truncateInvalidTx_argsTupleScheme();
      }
    }

    private static class truncateInvalidTx_argsTupleScheme extends TupleScheme<truncateInvalidTx_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, truncateInvalidTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTxns()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTxns()) {
          {
            oprot.writeI32(struct.txns.size());
            for (long _iter44 : struct.txns)
            {
              oprot.writeI64(_iter44);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, truncateInvalidTx_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TSet _set45 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I64, iprot.readI32());
            struct.txns = new HashSet<Long>(2*_set45.size);
            for (int _i46 = 0; _i46 < _set45.size; ++_i46)
            {
              long _elem47; // required
              _elem47 = iprot.readI64();
              struct.txns.add(_elem47);
            }
          }
          struct.setTxnsIsSet(true);
        }
      }
    }

  }

  public static class truncateInvalidTx_result implements org.apache.thrift.TBase<truncateInvalidTx_result, truncateInvalidTx_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("truncateInvalidTx_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new truncateInvalidTx_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new truncateInvalidTx_resultTupleSchemeFactory());
    }

    public TBoolean success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TBoolean.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(truncateInvalidTx_result.class, metaDataMap);
    }

    public truncateInvalidTx_result() {
    }

    public truncateInvalidTx_result(
      TBoolean success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public truncateInvalidTx_result(truncateInvalidTx_result other) {
      if (other.isSetSuccess()) {
        this.success = new TBoolean(other.success);
      }
    }

    public truncateInvalidTx_result deepCopy() {
      return new truncateInvalidTx_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public TBoolean getSuccess() {
      return this.success;
    }

    public truncateInvalidTx_result setSuccess(TBoolean success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TBoolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof truncateInvalidTx_result)
        return this.equals((truncateInvalidTx_result)that);
      return false;
    }

    public boolean equals(truncateInvalidTx_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(truncateInvalidTx_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      truncateInvalidTx_result typedOther = (truncateInvalidTx_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("truncateInvalidTx_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class truncateInvalidTx_resultStandardSchemeFactory implements SchemeFactory {
      public truncateInvalidTx_resultStandardScheme getScheme() {
        return new truncateInvalidTx_resultStandardScheme();
      }
    }

    private static class truncateInvalidTx_resultStandardScheme extends StandardScheme<truncateInvalidTx_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, truncateInvalidTx_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TBoolean();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, truncateInvalidTx_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class truncateInvalidTx_resultTupleSchemeFactory implements SchemeFactory {
      public truncateInvalidTx_resultTupleScheme getScheme() {
        return new truncateInvalidTx_resultTupleScheme();
      }
    }

    private static class truncateInvalidTx_resultTupleScheme extends TupleScheme<truncateInvalidTx_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, truncateInvalidTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, truncateInvalidTx_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = new TBoolean();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class truncateInvalidTxBefore_args implements org.apache.thrift.TBase<truncateInvalidTxBefore_args, truncateInvalidTxBefore_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("truncateInvalidTxBefore_args");

    private static final org.apache.thrift.protocol.TField TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("time", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new truncateInvalidTxBefore_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new truncateInvalidTxBefore_argsTupleSchemeFactory());
    }

    public long time; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TIME((short)1, "time");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TIME
            return TIME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIME_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TIME, new org.apache.thrift.meta_data.FieldMetaData("time", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(truncateInvalidTxBefore_args.class, metaDataMap);
    }

    public truncateInvalidTxBefore_args() {
    }

    public truncateInvalidTxBefore_args(
      long time)
    {
      this();
      this.time = time;
      setTimeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public truncateInvalidTxBefore_args(truncateInvalidTxBefore_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.time = other.time;
    }

    public truncateInvalidTxBefore_args deepCopy() {
      return new truncateInvalidTxBefore_args(this);
    }

    @Override
    public void clear() {
      setTimeIsSet(false);
      this.time = 0;
    }

    public long getTime() {
      return this.time;
    }

    public truncateInvalidTxBefore_args setTime(long time) {
      this.time = time;
      setTimeIsSet(true);
      return this;
    }

    public void unsetTime() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TIME_ISSET_ID);
    }

    /** Returns true if field time is set (has been assigned a value) and false otherwise */
    public boolean isSetTime() {
      return EncodingUtils.testBit(__isset_bitfield, __TIME_ISSET_ID);
    }

    public void setTimeIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TIME_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TIME:
        if (value == null) {
          unsetTime();
        } else {
          setTime((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TIME:
        return Long.valueOf(getTime());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TIME:
        return isSetTime();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof truncateInvalidTxBefore_args)
        return this.equals((truncateInvalidTxBefore_args)that);
      return false;
    }

    public boolean equals(truncateInvalidTxBefore_args that) {
      if (that == null)
        return false;

      boolean this_present_time = true;
      boolean that_present_time = true;
      if (this_present_time || that_present_time) {
        if (!(this_present_time && that_present_time))
          return false;
        if (this.time != that.time)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(truncateInvalidTxBefore_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      truncateInvalidTxBefore_args typedOther = (truncateInvalidTxBefore_args)other;

      lastComparison = Boolean.valueOf(isSetTime()).compareTo(typedOther.isSetTime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.time, typedOther.time);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("truncateInvalidTxBefore_args(");
      boolean first = true;

      sb.append("time:");
      sb.append(this.time);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class truncateInvalidTxBefore_argsStandardSchemeFactory implements SchemeFactory {
      public truncateInvalidTxBefore_argsStandardScheme getScheme() {
        return new truncateInvalidTxBefore_argsStandardScheme();
      }
    }

    private static class truncateInvalidTxBefore_argsStandardScheme extends StandardScheme<truncateInvalidTxBefore_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, truncateInvalidTxBefore_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TIME
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.time = iprot.readI64();
                struct.setTimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, truncateInvalidTxBefore_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(TIME_FIELD_DESC);
        oprot.writeI64(struct.time);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class truncateInvalidTxBefore_argsTupleSchemeFactory implements SchemeFactory {
      public truncateInvalidTxBefore_argsTupleScheme getScheme() {
        return new truncateInvalidTxBefore_argsTupleScheme();
      }
    }

    private static class truncateInvalidTxBefore_argsTupleScheme extends TupleScheme<truncateInvalidTxBefore_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, truncateInvalidTxBefore_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTime()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTime()) {
          oprot.writeI64(struct.time);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, truncateInvalidTxBefore_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.time = iprot.readI64();
          struct.setTimeIsSet(true);
        }
      }
    }

  }

  public static class truncateInvalidTxBefore_result implements org.apache.thrift.TBase<truncateInvalidTxBefore_result, truncateInvalidTxBefore_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("truncateInvalidTxBefore_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new truncateInvalidTxBefore_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new truncateInvalidTxBefore_resultTupleSchemeFactory());
    }

    public TBoolean success; // required
    public TInvalidTruncateTimeException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TBoolean.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(truncateInvalidTxBefore_result.class, metaDataMap);
    }

    public truncateInvalidTxBefore_result() {
    }

    public truncateInvalidTxBefore_result(
      TBoolean success,
      TInvalidTruncateTimeException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public truncateInvalidTxBefore_result(truncateInvalidTxBefore_result other) {
      if (other.isSetSuccess()) {
        this.success = new TBoolean(other.success);
      }
      if (other.isSetE()) {
        this.e = new TInvalidTruncateTimeException(other.e);
      }
    }

    public truncateInvalidTxBefore_result deepCopy() {
      return new truncateInvalidTxBefore_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public TBoolean getSuccess() {
      return this.success;
    }

    public truncateInvalidTxBefore_result setSuccess(TBoolean success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TInvalidTruncateTimeException getE() {
      return this.e;
    }

    public truncateInvalidTxBefore_result setE(TInvalidTruncateTimeException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TBoolean)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TInvalidTruncateTimeException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof truncateInvalidTxBefore_result)
        return this.equals((truncateInvalidTxBefore_result)that);
      return false;
    }

    public boolean equals(truncateInvalidTxBefore_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(truncateInvalidTxBefore_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      truncateInvalidTxBefore_result typedOther = (truncateInvalidTxBefore_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("truncateInvalidTxBefore_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class truncateInvalidTxBefore_resultStandardSchemeFactory implements SchemeFactory {
      public truncateInvalidTxBefore_resultStandardScheme getScheme() {
        return new truncateInvalidTxBefore_resultStandardScheme();
      }
    }

    private static class truncateInvalidTxBefore_resultStandardScheme extends StandardScheme<truncateInvalidTxBefore_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, truncateInvalidTxBefore_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TBoolean();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TInvalidTruncateTimeException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, truncateInvalidTxBefore_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class truncateInvalidTxBefore_resultTupleSchemeFactory implements SchemeFactory {
      public truncateInvalidTxBefore_resultTupleScheme getScheme() {
        return new truncateInvalidTxBefore_resultTupleScheme();
      }
    }

    private static class truncateInvalidTxBefore_resultTupleScheme extends TupleScheme<truncateInvalidTxBefore_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, truncateInvalidTxBefore_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, truncateInvalidTxBefore_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TBoolean();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TInvalidTruncateTimeException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class invalidTxSize_args implements org.apache.thrift.TBase<invalidTxSize_args, invalidTxSize_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("invalidTxSize_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new invalidTxSize_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new invalidTxSize_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(invalidTxSize_args.class, metaDataMap);
    }

    public invalidTxSize_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public invalidTxSize_args(invalidTxSize_args other) {
    }

    public invalidTxSize_args deepCopy() {
      return new invalidTxSize_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof invalidTxSize_args)
        return this.equals((invalidTxSize_args)that);
      return false;
    }

    public boolean equals(invalidTxSize_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(invalidTxSize_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      invalidTxSize_args typedOther = (invalidTxSize_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("invalidTxSize_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class invalidTxSize_argsStandardSchemeFactory implements SchemeFactory {
      public invalidTxSize_argsStandardScheme getScheme() {
        return new invalidTxSize_argsStandardScheme();
      }
    }

    private static class invalidTxSize_argsStandardScheme extends StandardScheme<invalidTxSize_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, invalidTxSize_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, invalidTxSize_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class invalidTxSize_argsTupleSchemeFactory implements SchemeFactory {
      public invalidTxSize_argsTupleScheme getScheme() {
        return new invalidTxSize_argsTupleScheme();
      }
    }

    private static class invalidTxSize_argsTupleScheme extends TupleScheme<invalidTxSize_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, invalidTxSize_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, invalidTxSize_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class invalidTxSize_result implements org.apache.thrift.TBase<invalidTxSize_result, invalidTxSize_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("invalidTxSize_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new invalidTxSize_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new invalidTxSize_resultTupleSchemeFactory());
    }

    public int success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(invalidTxSize_result.class, metaDataMap);
    }

    public invalidTxSize_result() {
    }

    public invalidTxSize_result(
      int success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public invalidTxSize_result(invalidTxSize_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    public invalidTxSize_result deepCopy() {
      return new invalidTxSize_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
    }

    public int getSuccess() {
      return this.success;
    }

    public invalidTxSize_result setSuccess(int success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Integer.valueOf(getSuccess());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof invalidTxSize_result)
        return this.equals((invalidTxSize_result)that);
      return false;
    }

    public boolean equals(invalidTxSize_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(invalidTxSize_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      invalidTxSize_result typedOther = (invalidTxSize_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("invalidTxSize_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class invalidTxSize_resultStandardSchemeFactory implements SchemeFactory {
      public invalidTxSize_resultStandardScheme getScheme() {
        return new invalidTxSize_resultStandardScheme();
      }
    }

    private static class invalidTxSize_resultStandardScheme extends StandardScheme<invalidTxSize_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, invalidTxSize_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.success = iprot.readI32();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, invalidTxSize_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI32(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class invalidTxSize_resultTupleSchemeFactory implements SchemeFactory {
      public invalidTxSize_resultTupleScheme getScheme() {
        return new invalidTxSize_resultTupleScheme();
      }
    }

    private static class invalidTxSize_resultTupleScheme extends TupleScheme<invalidTxSize_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, invalidTxSize_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeI32(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, invalidTxSize_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readI32();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class checkpoint_args implements org.apache.thrift.TBase<checkpoint_args, checkpoint_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("checkpoint_args");

    private static final org.apache.thrift.protocol.TField TX_FIELD_DESC = new org.apache.thrift.protocol.TField("tx", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new checkpoint_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new checkpoint_argsTupleSchemeFactory());
    }

    public TTransaction tx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TX((short)1, "tx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TX
            return TX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TX, new org.apache.thrift.meta_data.FieldMetaData("tx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(checkpoint_args.class, metaDataMap);
    }

    public checkpoint_args() {
    }

    public checkpoint_args(
      TTransaction tx)
    {
      this();
      this.tx = tx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public checkpoint_args(checkpoint_args other) {
      if (other.isSetTx()) {
        this.tx = new TTransaction(other.tx);
      }
    }

    public checkpoint_args deepCopy() {
      return new checkpoint_args(this);
    }

    @Override
    public void clear() {
      this.tx = null;
    }

    public TTransaction getTx() {
      return this.tx;
    }

    public checkpoint_args setTx(TTransaction tx) {
      this.tx = tx;
      return this;
    }

    public void unsetTx() {
      this.tx = null;
    }

    /** Returns true if field tx is set (has been assigned a value) and false otherwise */
    public boolean isSetTx() {
      return this.tx != null;
    }

    public void setTxIsSet(boolean value) {
      if (!value) {
        this.tx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TX:
        if (value == null) {
          unsetTx();
        } else {
          setTx((TTransaction)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TX:
        return getTx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TX:
        return isSetTx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof checkpoint_args)
        return this.equals((checkpoint_args)that);
      return false;
    }

    public boolean equals(checkpoint_args that) {
      if (that == null)
        return false;

      boolean this_present_tx = true && this.isSetTx();
      boolean that_present_tx = true && that.isSetTx();
      if (this_present_tx || that_present_tx) {
        if (!(this_present_tx && that_present_tx))
          return false;
        if (!this.tx.equals(that.tx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(checkpoint_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      checkpoint_args typedOther = (checkpoint_args)other;

      lastComparison = Boolean.valueOf(isSetTx()).compareTo(typedOther.isSetTx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tx, typedOther.tx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("checkpoint_args(");
      boolean first = true;

      sb.append("tx:");
      if (this.tx == null) {
        sb.append("null");
      } else {
        sb.append(this.tx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tx != null) {
        tx.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class checkpoint_argsStandardSchemeFactory implements SchemeFactory {
      public checkpoint_argsStandardScheme getScheme() {
        return new checkpoint_argsStandardScheme();
      }
    }

    private static class checkpoint_argsStandardScheme extends StandardScheme<checkpoint_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, checkpoint_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TX
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tx = new TTransaction();
                struct.tx.read(iprot);
                struct.setTxIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, checkpoint_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tx != null) {
          oprot.writeFieldBegin(TX_FIELD_DESC);
          struct.tx.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class checkpoint_argsTupleSchemeFactory implements SchemeFactory {
      public checkpoint_argsTupleScheme getScheme() {
        return new checkpoint_argsTupleScheme();
      }
    }

    private static class checkpoint_argsTupleScheme extends TupleScheme<checkpoint_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, checkpoint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTx()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTx()) {
          struct.tx.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, checkpoint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tx = new TTransaction();
          struct.tx.read(iprot);
          struct.setTxIsSet(true);
        }
      }
    }

  }

  public static class checkpoint_result implements org.apache.thrift.TBase<checkpoint_result, checkpoint_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("checkpoint_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField E_FIELD_DESC = new org.apache.thrift.protocol.TField("e", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new checkpoint_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new checkpoint_resultTupleSchemeFactory());
    }

    public TTransaction success; // required
    public TTransactionNotInProgressException e; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      E((short)1, "e");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // E
            return E;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TTransaction.class)));
      tmpMap.put(_Fields.E, new org.apache.thrift.meta_data.FieldMetaData("e", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(checkpoint_result.class, metaDataMap);
    }

    public checkpoint_result() {
    }

    public checkpoint_result(
      TTransaction success,
      TTransactionNotInProgressException e)
    {
      this();
      this.success = success;
      this.e = e;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public checkpoint_result(checkpoint_result other) {
      if (other.isSetSuccess()) {
        this.success = new TTransaction(other.success);
      }
      if (other.isSetE()) {
        this.e = new TTransactionNotInProgressException(other.e);
      }
    }

    public checkpoint_result deepCopy() {
      return new checkpoint_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.e = null;
    }

    public TTransaction getSuccess() {
      return this.success;
    }

    public checkpoint_result setSuccess(TTransaction success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public TTransactionNotInProgressException getE() {
      return this.e;
    }

    public checkpoint_result setE(TTransactionNotInProgressException e) {
      this.e = e;
      return this;
    }

    public void unsetE() {
      this.e = null;
    }

    /** Returns true if field e is set (has been assigned a value) and false otherwise */
    public boolean isSetE() {
      return this.e != null;
    }

    public void setEIsSet(boolean value) {
      if (!value) {
        this.e = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TTransaction)value);
        }
        break;

      case E:
        if (value == null) {
          unsetE();
        } else {
          setE((TTransactionNotInProgressException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case E:
        return getE();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case E:
        return isSetE();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof checkpoint_result)
        return this.equals((checkpoint_result)that);
      return false;
    }

    public boolean equals(checkpoint_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_e = true && this.isSetE();
      boolean that_present_e = true && that.isSetE();
      if (this_present_e || that_present_e) {
        if (!(this_present_e && that_present_e))
          return false;
        if (!this.e.equals(that.e))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(checkpoint_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      checkpoint_result typedOther = (checkpoint_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetE()).compareTo(typedOther.isSetE());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetE()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.e, typedOther.e);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("checkpoint_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("e:");
      if (this.e == null) {
        sb.append("null");
      } else {
        sb.append(this.e);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class checkpoint_resultStandardSchemeFactory implements SchemeFactory {
      public checkpoint_resultStandardScheme getScheme() {
        return new checkpoint_resultStandardScheme();
      }
    }

    private static class checkpoint_resultStandardScheme extends StandardScheme<checkpoint_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, checkpoint_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TTransaction();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // E
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.e = new TTransactionNotInProgressException();
                struct.e.read(iprot);
                struct.setEIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, checkpoint_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.e != null) {
          oprot.writeFieldBegin(E_FIELD_DESC);
          struct.e.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class checkpoint_resultTupleSchemeFactory implements SchemeFactory {
      public checkpoint_resultTupleScheme getScheme() {
        return new checkpoint_resultTupleScheme();
      }
    }

    private static class checkpoint_resultTupleScheme extends TupleScheme<checkpoint_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, checkpoint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetE()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetE()) {
          struct.e.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, checkpoint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TTransaction();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.e = new TTransactionNotInProgressException();
          struct.e.read(iprot);
          struct.setEIsSet(true);
        }
      }
    }

  }

  public static class pruneNow_args implements org.apache.thrift.TBase<pruneNow_args, pruneNow_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("pruneNow_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new pruneNow_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new pruneNow_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(pruneNow_args.class, metaDataMap);
    }

    public pruneNow_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public pruneNow_args(pruneNow_args other) {
    }

    public pruneNow_args deepCopy() {
      return new pruneNow_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof pruneNow_args)
        return this.equals((pruneNow_args)that);
      return false;
    }

    public boolean equals(pruneNow_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(pruneNow_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      pruneNow_args typedOther = (pruneNow_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("pruneNow_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class pruneNow_argsStandardSchemeFactory implements SchemeFactory {
      public pruneNow_argsStandardScheme getScheme() {
        return new pruneNow_argsStandardScheme();
      }
    }

    private static class pruneNow_argsStandardScheme extends StandardScheme<pruneNow_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, pruneNow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, pruneNow_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class pruneNow_argsTupleSchemeFactory implements SchemeFactory {
      public pruneNow_argsTupleScheme getScheme() {
        return new pruneNow_argsTupleScheme();
      }
    }

    private static class pruneNow_argsTupleScheme extends TupleScheme<pruneNow_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, pruneNow_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, pruneNow_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class pruneNow_result implements org.apache.thrift.TBase<pruneNow_result, pruneNow_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("pruneNow_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new pruneNow_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new pruneNow_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(pruneNow_result.class, metaDataMap);
    }

    public pruneNow_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public pruneNow_result(pruneNow_result other) {
    }

    public pruneNow_result deepCopy() {
      return new pruneNow_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof pruneNow_result)
        return this.equals((pruneNow_result)that);
      return false;
    }

    public boolean equals(pruneNow_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      return 0;
    }

    public int compareTo(pruneNow_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      pruneNow_result typedOther = (pruneNow_result)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("pruneNow_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class pruneNow_resultStandardSchemeFactory implements SchemeFactory {
      public pruneNow_resultStandardScheme getScheme() {
        return new pruneNow_resultStandardScheme();
      }
    }

    private static class pruneNow_resultStandardScheme extends StandardScheme<pruneNow_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, pruneNow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, pruneNow_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class pruneNow_resultTupleSchemeFactory implements SchemeFactory {
      public pruneNow_resultTupleScheme getScheme() {
        return new pruneNow_resultTupleScheme();
      }
    }

    private static class pruneNow_resultTupleScheme extends TupleScheme<pruneNow_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, pruneNow_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, pruneNow_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

}
