/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.flex.tools.FlexTool;
import org.apache.royale.compiler.asdoc.IASDocDelegate;
import org.apache.royale.compiler.clients.JSCompilerEntryPoint;
import org.apache.royale.compiler.clients.JSConfiguration;
import org.apache.royale.compiler.clients.MXMLC;
import org.apache.royale.compiler.clients.MXMLJSCNative;
import org.apache.royale.compiler.clients.MXMLJSCNode;
import org.apache.royale.compiler.clients.MXMLJSCNodeModule;
import org.apache.royale.compiler.clients.MXMLJSCRoyale;
import org.apache.royale.compiler.clients.MXMLJSCRoyaleCordova;
import org.apache.royale.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.ProblemQueryProvider;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.CommandLineConfigurator;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.ConfigurationBuffer;
import org.apache.royale.compiler.config.ConfigurationValue;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.config.ICompilerProblemSettings;
import org.apache.royale.compiler.driver.js.IJSApplication;
import org.apache.royale.compiler.internal.config.FlashBuilderConfigurator;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.parsing.as.RoyaleASDocDelegate;
import org.apache.royale.compiler.internal.projects.ISourceFileHandler;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.projects.RoyaleProjectConfigurator;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.SWF;
import org.apache.royale.swf.types.RGB;
import org.apache.royale.swf.types.Rect;
import org.apache.royale.utils.ArgumentUtil;

public class MXMLJSC
implements JSCompilerEntryPoint,
ProblemQueryProvider,
FlexTool {
    static final String NEWLINE = System.getProperty("line.separator");
    private static final String DEFAULT_VAR = "file-specs";
    private static final String L10N_CONFIG_PREFIX = "org.apache.royale.compiler.internal.config.configuration";
    protected Workspace workspace = new Workspace();
    protected RoyaleJSProject project;
    protected ProblemQuery problems;
    protected ISourceFileHandler asFileHandler;
    public JSConfiguration config;
    protected Configurator projectConfigurator;
    private ConfigurationBuffer configBuffer;
    protected ITarget target;
    protected ITargetSettings targetSettings;
    protected IJSApplication jsTarget;
    protected MXMLC mxmlc;
    protected JSCompilerEntryPoint lastCompiler;
    public boolean noLink;
    public OutputStream err;
    public Class<? extends Configuration> configurationClass = JSGoogConfiguration.class;

    public ProblemQuery getProblemQuery() {
        return this.problems;
    }

    public String getName() {
        return "MXMLC";
    }

    protected String getProgramName() {
        return "mxmljsc";
    }

    public int execute(String[] args) {
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        return this.mainNoExit(args, problems, true);
    }

    public static void main(String[] args) {
        int exitCode = MXMLJSC.staticMainNoExit(args);
        if (exitCode != ExitCode.WATCHING.getCode()) {
            System.exit(exitCode);
        }
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        System.out.println("MXMLJSC");
        for (String arg : args) {
            System.out.println(arg);
        }
        MXMLJSC mxmlc = new MXMLJSC();
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        int exitCode = mxmlc.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        System.out.println((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    public MXMLJSC() {
        this.workspace.setASDocDelegate((IASDocDelegate)new RoyaleASDocDelegate());
        this.project = new RoyaleJSProject(this.workspace, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mainNoExit(String[] args, List<ICompilerProblem> problems, Boolean printProblems) {
        int exitCode = -1;
        try {
            exitCode = this._mainNoExit(ArgumentUtil.fixArgs((String[])args), problems);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        finally {
            if (problems != null && !problems.isEmpty() && printProblems.booleanValue()) {
                WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace, this.createProblemCategorizer());
                ProblemPrinter printer = new ProblemPrinter((ProblemFormatter)formatter);
                printer.printProblems(problems);
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _mainNoExit(String[] args, List<ICompilerProblem> outProblems) {
        ExitCode exitCode;
        block22: {
            Iterator<String> iterator;
            block21: {
                exitCode = ExitCode.SUCCESS;
                try {
                    boolean continueCompilation = this.configure(args);
                    CompilerDiagnosticsConstants.diagnostics = this.config.getDiagnosticsLevel();
                    if (continueCompilation) {
                        iterator = this.config.getCompilerTargets().iterator();
                        break block21;
                    }
                    exitCode = this.problems.hasFilteredProblems() ? ExitCode.FAILED_WITH_CONFIG_PROBLEMS : ExitCode.PRINT_HELP;
                    break block22;
                }
                catch (Exception e) {
                    if (outProblems == null) {
                        System.err.println(e.getMessage());
                    } else {
                        UnexpectedExceptionProblem unexpectedExceptionProblem = new UnexpectedExceptionProblem((Throwable)e);
                        this.problems.add((ICompilerProblem)unexpectedExceptionProblem);
                    }
                    exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
                    return (int)exitCode;
                }
                finally {
                    if (!this.config.getWatch() || !ExitCode.SUCCESS.equals((Object)exitCode)) {
                        this.waitAndClose();
                    }
                    if (outProblems != null && this.problems.hasFilteredProblems()) {
                        for (ICompilerProblem problem : this.problems.getFilteredProblems()) {
                            outProblems.add(problem);
                        }
                    }
                    break block22;
                }
            }
            block14: while (iterator.hasNext()) {
                String target = iterator.next();
                int result = 0;
                switch (JSTargetType.fromString(target)) {
                    case SWF: {
                        this.mxmlc = new MXMLC();
                        this.mxmlc.configurationClass = this.configurationClass;
                        result = this.noLink ? this.mxmlc.mainCompileOnly(this.removeJSArgs(args), this.err) : this.mxmlc.mainNoExit(this.removeJSArgs(args));
                        if (result == MXMLC.ExitCode.SUCCESS.getCode() || result == MXMLC.ExitCode.WATCHING.getCode()) break;
                        this.problems.addAll((Iterable)this.mxmlc.problems.getProblems());
                        break block14;
                    }
                    case JS_ROYALE: {
                        MXMLJSCRoyale royale = new MXMLJSCRoyale();
                        this.lastCompiler = royale;
                        result = royale.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                        if (result == MXMLJSCRoyale.ExitCode.SUCCESS.getCode() || result == MXMLJSCRoyale.ExitCode.WATCHING.getCode()) break;
                        break block14;
                    }
                    case JS_ROYALE_CORDOVA: {
                        MXMLJSCRoyaleCordova royaleCordova = new MXMLJSCRoyaleCordova();
                        this.lastCompiler = royaleCordova;
                        result = royaleCordova.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                        if (result == MXMLJSCRoyaleCordova.ExitCode.SUCCESS.getCode() || result == MXMLJSCRoyaleCordova.ExitCode.WATCHING.getCode()) break;
                        break block14;
                    }
                    case JS_NODE: {
                        MXMLJSCNode node = new MXMLJSCNode();
                        this.lastCompiler = node;
                        result = node.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                        if (result == MXMLJSCNode.ExitCode.SUCCESS.getCode() || result == MXMLJSCNode.ExitCode.WATCHING.getCode()) break;
                        break block14;
                    }
                    case JS_NODE_MODULE: {
                        MXMLJSCNodeModule nodeModule = new MXMLJSCNodeModule();
                        this.lastCompiler = nodeModule;
                        result = nodeModule.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                        if (result == MXMLJSCNode.ExitCode.SUCCESS.getCode() || result == MXMLJSCNode.ExitCode.WATCHING.getCode()) break;
                        break block14;
                    }
                    case JS_NATIVE: {
                        MXMLJSCNative jsc = new MXMLJSCNative();
                        this.lastCompiler = jsc;
                        result = jsc.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                        if (result != MXMLJSCNative.ExitCode.SUCCESS.getCode() && result != MXMLJSCNative.ExitCode.WATCHING.getCode()) break block14;
                    }
                }
            }
            if (this.problems.hasFilteredProblems() && this.problems.hasErrors()) {
                exitCode = ExitCode.FAILED_WITH_ERRORS;
            }
        }
        if (!this.config.getWatch()) return exitCode.getCode();
        if (!ExitCode.SUCCESS.equals((Object)exitCode)) return exitCode.getCode();
        exitCode = ExitCode.WATCHING;
        return exitCode.getCode();
    }

    protected String[] removeJSArgs(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-compiler.targets") || arg.startsWith("-closure-lib") || arg.startsWith("-remove-circulars") || arg.startsWith("-compiler.js-external-library-path") || arg.startsWith("-compiler.js-library-path") || arg.startsWith("-compiler.js-define") || arg.startsWith("-js-output") || arg.startsWith("-js-vector-emulation-class") || arg.startsWith("-externs-report") || arg.startsWith("-js-load-config") || arg.startsWith("-warn-public-vars") || arg.startsWith("-export-protected-symbols") || arg.startsWith("-source-map")) continue;
            list.add(arg);
        }
        return list.toArray(new String[0]);
    }

    protected String[] removeASArgs(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        boolean hasJSLoadConfig = false;
        for (String arg : args) {
            if (!arg.startsWith("-js-load-config")) continue;
            hasJSLoadConfig = true;
        }
        if (!hasJSLoadConfig) {
            return args;
        }
        for (String arg : args) {
            if (arg.startsWith("-load-config")) continue;
            if (arg.startsWith("-js-load-config")) {
                arg = arg.substring(3);
            }
            list.add(arg);
        }
        return list.toArray(new String[0]);
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(null);
        }
        return this.targetSettings;
    }

    protected Configurator createConfigurator() {
        return this.project.getBackend().createConfigurator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configure(String[] args) {
        Object problem;
        this.projectConfigurator = new RoyaleProjectConfigurator(this.configurationClass);
        try {
            if (args.length == 0) {
                String usage = CommandLineConfigurator.brief((String)this.getProgramName(), (String)DEFAULT_VAR, (LocalizationManager)LocalizationManager.get(), (String)L10N_CONFIG_PREFIX);
                this.println(this.getStartMessage());
                if (usage != null) {
                    this.println(usage);
                }
            }
            if (this.useFlashBuilderProjectFiles(args)) {
                this.projectConfigurator.setConfiguration(FlashBuilderConfigurator.computeFlashBuilderArgs((String[])args, (String)this.getTargetType().getExtension()), DEFAULT_VAR);
            } else {
                this.projectConfigurator.setConfiguration(args, DEFAULT_VAR);
            }
            this.projectConfigurator.applyToProject((ICompilerProject)this.project);
            this.problems = new ProblemQuery(this.projectConfigurator.getCompilerProblemSettings());
            this.problems.addAll((Iterable)this.projectConfigurator.getConfigurationProblems());
            this.config = (JSConfiguration)this.projectConfigurator.getConfiguration();
            this.configBuffer = this.projectConfigurator.getConfigurationBuffer();
            if (this.configBuffer.getVar("version") != null) {
                System.out.println(VersionInfo.buildMessage());
                boolean usage = false;
                return usage;
            }
            List helpVar = this.configBuffer.getVar("help");
            if (helpVar != null) {
                this.processHelp(helpVar);
                boolean bl = false;
                return bl;
            }
            if (this.config.getWatch() && !this.config.debug()) {
                problem = new ConfigurationProblem(null, -1, -1, -1, -1, "configuration variable 'debug' must be true if configuration variable 'watch' is true");
                this.problems.add((ICompilerProblem)problem);
            }
            for (String target : this.config.getCompilerTargets()) {
                JSTargetType jsTargetType = JSTargetType.fromString(target);
                if (jsTargetType != null) continue;
                Object message = "configuration variable 'targets' must be one of the following: ";
                for (JSTargetType type : JSTargetType.values()) {
                    message = (String)message + "'" + type.text + "', ";
                }
                message = (String)message + "got '" + target + "'";
                ConfigurationProblem problem2 = new ConfigurationProblem(null, -1, -1, -1, -1, (String)message);
                this.problems.add((ICompilerProblem)problem2);
            }
            if (this.problems.hasErrors()) {
                boolean problem3 = false;
                return problem3;
            }
            DefinitionBase.setPerformanceCachingEnabled((!this.config.getWatch() ? 1 : 0) != 0);
            boolean problem3 = true;
            return problem3;
        }
        catch (Exception e) {
            problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            this.problems.add((ICompilerProblem)problem);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.config == null) {
                this.config = new JSConfiguration();
                this.configBuffer = new ConfigurationBuffer(Configuration.class, Configuration.getAliases());
            }
        }
    }

    private boolean useFlashBuilderProjectFiles(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-fb") && !arg.equals("-use-flashbuilder-project-files")) continue;
            return true;
        }
        return false;
    }

    public void println(String msg) {
        System.out.println(msg);
    }

    protected String getStartMessage() {
        String message = "Apache Royale MXML and ActionScript Compiler (mxmlc)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE;
        return message;
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        for (ConfigurationValue val : helpVar) {
            for (Object element : val.getArgs()) {
                String keyword = (String)element;
                while (keyword.startsWith("-")) {
                    keyword = keyword.substring(1);
                }
                keywords.add(keyword);
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage((String)this.getProgramName(), (String)DEFAULT_VAR, (ConfigurationBuffer)this.configBuffer, keywords, (LocalizationManager)LocalizationManager.get(), (String)L10N_CONFIG_PREFIX);
        this.println(this.getStartMessage());
        this.println(usages);
    }

    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWF;
    }

    protected void waitAndClose() {
        this.workspace.startIdleState();
        try {
            this.workspace.close();
        }
        finally {
            this.workspace.endIdleState(Collections.emptyMap());
        }
    }

    protected void close() {
        this.workspace.close();
    }

    @Override
    public List<String> getSourceList() {
        if (this.lastCompiler != null) {
            return this.lastCompiler.getSourceList();
        }
        if (this.mxmlc != null) {
            return this.mxmlc.getSourceList();
        }
        return null;
    }

    @Override
    public String getMainSource() {
        if (this.lastCompiler != null) {
            return this.lastCompiler.getMainSource();
        }
        if (this.mxmlc != null) {
            return this.mxmlc.getMainSource();
        }
        return null;
    }

    public ISWF getSWFTarget() {
        SWF swf = new SWF();
        Rect rect = new Rect(this.getTargetSettings().getDefaultWidth(), this.getTargetSettings().getDefaultHeight());
        swf.setFrameSize(rect);
        swf.setBackgroundColor(new RGB(255, 255, 255));
        swf.setTopLevelClass(this.config.getTargetFile());
        return swf;
    }

    public long writeSWF(OutputStream output) {
        if (this.mxmlc != null) {
            return this.mxmlc.writeSWF(output);
        }
        return 0L;
    }

    public static boolean isFatalFailure(int code) {
        return code == ExitCode.FAILED_WITH_ERRORS.getCode() || code == ExitCode.FAILED_WITH_EXCEPTIONS.getCode() || code == ExitCode.FAILED_WITH_CONFIG_PROBLEMS.getCode();
    }

    private CompilerProblemCategorizer createProblemCategorizer() {
        ICompilerProblemSettings problemSettings = null;
        try {
            problemSettings = this.projectConfigurator.getCompilerProblemSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new CompilerProblemCategorizer(problemSettings);
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_ERRORS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4),
        WATCHING(1000);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }

    public static enum JSTargetType {
        SWF("SWF"),
        JS_ROYALE("JSRoyale"),
        JS_ROYALE_CORDOVA("JSRoyaleCordova"),
        JS_NATIVE("JS"),
        JS_NODE("JSNode"),
        JS_NODE_MODULE("JSNodeModule");

        private String text;

        private JSTargetType(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static JSTargetType fromString(String text) {
            for (JSTargetType jsTargetType : JSTargetType.values()) {
                if (!text.equalsIgnoreCase(jsTargetType.text)) continue;
                return jsTargetType;
            }
            return null;
        }
    }
}

