/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Tracing;
import brave.context.log4j12.MDCScopeDecorator;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalCurrentTraceContext;
import java.text.MessageFormat;
import org.apache.servicecomb.config.DynamicProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

@Configuration
class TracingConfiguration {
    private String apiVersion = "v2";

    TracingConfiguration() {
    }

    @Bean
    Sender sender(DynamicProperties dynamicProperties) {
        this.apiVersion = dynamicProperties.getStringProperty("servicecomb.tracing.collector.apiVersion", "v2").toLowerCase();
        if (this.apiVersion.compareTo("v1") != 0) {
            this.apiVersion = "v2";
        }
        String path = MessageFormat.format("/api/{0}/spans", this.apiVersion);
        return OkHttpSender.create((String)dynamicProperties.getStringProperty("servicecomb.tracing.collector.address", "http://127.0.0.1:9411").trim().replaceAll("/+$", "").concat(path));
    }

    @Bean
    Reporter<Span> zipkinReporter(Sender sender) {
        if (this.apiVersion.compareTo("v1") == 0) {
            return AsyncReporter.builder((Sender)sender).build((BytesEncoder)SpanBytesEncoder.JSON_V1);
        }
        return AsyncReporter.builder((Sender)sender).build();
    }

    @Bean
    Tracing tracing(Reporter<Span> reporter, DynamicProperties dynamicProperties, CurrentTraceContext currentTraceContext) {
        return Tracing.newBuilder().localServiceName(dynamicProperties.getStringProperty("service_description.name", "defaultMicroservice")).currentTraceContext(currentTraceContext).spanReporter(reporter).build();
    }

    @Bean
    CurrentTraceContext currentTraceContext() {
        return ThreadLocalCurrentTraceContext.newBuilder().addScopeDecorator(MDCScopeDecorator.create()).build();
    }

    @Bean
    HttpTracing httpTracing(Tracing tracing) {
        return HttpTracing.create((Tracing)tracing);
    }
}

