/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.springboot.common;

import java.util.ArrayList;
import java.util.Map;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceDiscoveryFilter
implements DiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceDiscoveryFilter.class);
    InstanceFactory instanceFactory;

    public InstanceDiscoveryFilter(InstanceFactory factory) {
        this.instanceFactory = factory;
    }

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    public DiscoveryTreeNode discovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        return parent.children().computeIfAbsent(context.getInputParameters(), etn -> this.createDiscoveryTreeNode(context, parent));
    }

    protected DiscoveryTreeNode createDiscoveryTreeNode(DiscoveryContext context, DiscoveryTreeNode parent) {
        String serviceName = (String)context.getInputParameters();
        ArrayList<Object> instances = new ArrayList<Object>();
        for (MicroserviceInstance instance : ((Map)parent.data()).values()) {
            for (String endpoint : instance.getEndpoints()) {
                String scheme = endpoint.split(":", 2)[0];
                if (!scheme.equalsIgnoreCase("rest")) {
                    LOGGER.info("Endpoint {} is not supported in Spring Cloud, ignoring.", (Object)endpoint);
                    continue;
                }
                URIEndpointObject uri = new URIEndpointObject(endpoint);
                instances.add(this.instanceFactory.createInstance(instance.getInstanceId(), instance.getServiceId(), uri));
            }
        }
        return (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, serviceName).data(instances);
    }

    public static interface InstanceFactory {
        public Object createInstance(String var1, String var2, URIEndpointObject var3);
    }
}

