/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.NettyWebSocketSessionSupport;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.NettyPipeline;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyWebSocketSession
extends NettyWebSocketSessionSupport<WebSocketConnection> {
    private final int maxFramePayloadLength;

    public ReactorNettyWebSocketSession(WebsocketInbound inbound, WebsocketOutbound outbound, HandshakeInfo info, NettyDataBufferFactory bufferFactory) {
        this(inbound, outbound, info, bufferFactory, 65536);
    }

    public ReactorNettyWebSocketSession(WebsocketInbound inbound, WebsocketOutbound outbound, HandshakeInfo info, NettyDataBufferFactory bufferFactory, int maxFramePayloadLength) {
        super(new WebSocketConnection(inbound, outbound), info, bufferFactory);
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    @Override
    public Flux<WebSocketMessage> receive() {
        return ((WebSocketConnection)this.getDelegate()).getInbound().aggregateFrames(this.maxFramePayloadLength).receiveFrames().map(x$0 -> super.toMessage((WebSocketFrame)x$0)).doOnNext(message -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this.getLogPrefix() + "Received " + message));
            }
        });
    }

    @Override
    public Mono<Void> send(Publisher<WebSocketMessage> messages) {
        Flux frames = Flux.from(messages).doOnNext(message -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this.getLogPrefix() + "Sending " + message));
            }
        }).map(this::toFrame);
        return ((WebSocketConnection)this.getDelegate()).getOutbound().options(NettyPipeline.SendOptions::flushOnEach).sendObject((Publisher)frames).then();
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        return ((WebSocketConnection)this.getDelegate()).getOutbound().sendClose(status.getCode(), status.getReason());
    }

    public static class WebSocketConnection {
        private final WebsocketInbound inbound;
        private final WebsocketOutbound outbound;

        public WebSocketConnection(WebsocketInbound inbound, WebsocketOutbound outbound) {
            this.inbound = inbound;
            this.outbound = outbound;
        }

        public WebsocketInbound getInbound() {
            return this.inbound;
        }

        public WebsocketOutbound getOutbound() {
            return this.outbound;
        }
    }
}

