/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.util;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class HttpVerbUriRegexPropertyValue {
    private static final String METHOD_SEPARATOR = " ";
    private Verb verb = Verb.ANY_VERB;
    private String uriRegex = null;

    public HttpVerbUriRegexPropertyValue(Verb verb, String uriRegex) {
        this.verb = verb;
        this.uriRegex = uriRegex;
    }

    public static HttpVerbUriRegexPropertyValue getVerbUriRegex(String propValue) {
        HttpVerbUriRegexPropertyValue returnValue = null;
        if (propValue != null) {
            propValue = propValue.trim();
            int methodSeparatorIndex = propValue.indexOf(METHOD_SEPARATOR);
            String uriRegex = propValue;
            Verb verb = Verb.ANY_VERB;
            if (methodSeparatorIndex != -1 && (verb = HttpVerbUriRegexPropertyValue.getVerb(propValue.substring(0, methodSeparatorIndex))) != Verb.ANY_VERB) {
                uriRegex = propValue.substring(methodSeparatorIndex + 1);
            }
            returnValue = new HttpVerbUriRegexPropertyValue(verb, uriRegex);
        }
        return returnValue;
    }

    private static Verb getVerb(String verbName) {
        if (verbName != null) {
            Verb v = Verb.get(verbName.trim().toUpperCase());
            return v == null ? Verb.ANY_VERB : v;
        }
        return Verb.ANY_VERB;
    }

    public Verb getVerb() {
        return this.verb;
    }

    public String getUriRegex() {
        return this.uriRegex;
    }

    public static String getMethodSeparator() {
        return METHOD_SEPARATOR;
    }

    public static enum Verb {
        GET("GET"),
        PUT("PUT"),
        POST("POST"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS"),
        HEAD("HEAD"),
        ANY_VERB("ANY");

        private final String verb;
        private static final Map<String, Verb> lookup;

        private Verb(String verb) {
            this.verb = verb;
        }

        public String toString() {
            return this.verb;
        }

        public static Verb get(String verbName) {
            return lookup.get(verbName.toUpperCase());
        }

        static {
            lookup = new HashMap<String, Verb>();
            for (Verb v : EnumSet.allOf(Verb.class)) {
                lookup.put(v.name(), v);
            }
        }
    }
}

