/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.annotation;

import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.netflix.feign.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.PathVariable;

public class PathVariableParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<PathVariable> ANNOTATION = PathVariable.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation, Method method) {
        String name = ANNOTATION.cast(annotation).value();
        Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"PathVariable annotation was empty on param %s.", (Object[])new Object[]{context.getParameterIndex()});
        context.setParameterName(name);
        MethodMetadata data = context.getMethodMetadata();
        String varName = '{' + name + '}';
        if (!(data.template().url().contains(varName) || this.searchMapValues(data.template().queries(), varName) || this.searchMapValues(data.template().headers(), varName))) {
            data.formParams().add(name);
        }
        return true;
    }

    private <K, V> boolean searchMapValues(Map<K, Collection<V>> map, V search) {
        Collection<Collection<V>> values = map.values();
        if (values == null) {
            return false;
        }
        for (Collection<V> entry : values) {
            if (!entry.contains(search)) continue;
            return true;
        }
        return false;
    }
}

