/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.support;

import feign.FeignException;
import feign.Response;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ResponseEntityDecoder
implements Decoder {
    private Decoder decoder;

    public ResponseEntityDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        if (this.isParameterizeHttpEntity(type)) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
            Object decodedObject = this.decoder.decode(response, type);
            return this.createResponse(decodedObject, response);
        }
        if (this.isHttpEntity(type)) {
            return this.createResponse(null, response);
        }
        return this.decoder.decode(response, type);
    }

    private boolean isParameterizeHttpEntity(Type type) {
        if (type instanceof ParameterizedType) {
            return this.isHttpEntity(((ParameterizedType)type).getRawType());
        }
        return false;
    }

    private boolean isHttpEntity(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return HttpEntity.class.isAssignableFrom(c);
        }
        return false;
    }

    private <T> ResponseEntity<T> createResponse(Object instance, Response response) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        for (String key : response.headers().keySet()) {
            headers.put((Object)key, new LinkedList((Collection)response.headers().get(key)));
        }
        return new ResponseEntity(instance, (MultiValueMap)headers, HttpStatus.valueOf((int)response.status()));
    }
}

