/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.hystrix;

import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.ribbon.hystrix.ResultCommandPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public class HystrixObservableCommandChain<T> {
    private final List<HystrixObservableCommand<T>> hystrixCommands;

    public HystrixObservableCommandChain(List<HystrixObservableCommand<T>> hystrixCommands) {
        this.hystrixCommands = hystrixCommands;
    }

    public HystrixObservableCommandChain(HystrixObservableCommand<T> ... commands) {
        this.hystrixCommands = new ArrayList<HystrixObservableCommand<T>>(commands.length);
        Collections.addAll(this.hystrixCommands, commands);
    }

    public Observable<ResultCommandPair<T>> toResultCommandPairObservable() {
        Observable rootObservable = null;
        for (final HystrixObservableCommand<T> command : this.hystrixCommands) {
            Observable observable = command.toObservable().map(new Func1<T, ResultCommandPair<T>>(){

                public ResultCommandPair<T> call(T result) {
                    return new ResultCommandPair(result, command);
                }
            });
            rootObservable = rootObservable == null ? observable : rootObservable.onErrorResumeNext(observable);
        }
        return rootObservable;
    }

    public Observable<T> toObservable() {
        Observable rootObservable = null;
        for (HystrixObservableCommand<T> command : this.hystrixCommands) {
            Observable observable = command.toObservable();
            rootObservable = rootObservable == null ? observable : rootObservable.onErrorResumeNext(observable);
        }
        return rootObservable;
    }

    public List<HystrixObservableCommand<T>> getCommands() {
        return Collections.unmodifiableList(this.hystrixCommands);
    }

    public HystrixObservableCommand getLastCommand() {
        return this.hystrixCommands.get(this.hystrixCommands.size() - 1);
    }
}

