/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class Log4jLogDelegate
implements LogDelegate {
    private static final String FQCN = Logger.class.getCanonicalName();
    private final org.apache.log4j.Logger logger;

    Log4jLogDelegate(String name) {
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.FATAL, message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    @Override
    public void error(Object message) {
        this.log(Level.ERROR, message);
    }

    @Override
    public void error(Object message, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    @Override
    public void error(Object message, Throwable t, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARN, message);
    }

    @Override
    public void warn(Object message, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    @Override
    public void warn(Object message, Throwable t, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(Object message, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public void info(Object message, Throwable t, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void debug(Object message) {
        this.log(Level.DEBUG, message);
    }

    @Override
    public void debug(Object message, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    @Override
    public void debug(Object message, Throwable t, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void trace(Object message) {
        this.log(Level.TRACE, message);
    }

    @Override
    public void trace(Object message, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(Level.TRACE, message, t);
    }

    @Override
    public void trace(Object message, Throwable t, Object ... params) {
        this.throwUnsupportedOperationException();
    }

    private void log(Level level, Object message) {
        this.log(level, message, null);
    }

    private void log(Level level, Object message, Throwable t) {
        this.logger.log(FQCN, (Priority)level, message, t);
    }

    private void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException("Log4j version used in Vertx doesn't support parameterized logging.");
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

