/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.library.vertexmanager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TaskAttemptIdentifier;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class InputReadyVertexManager
extends VertexManagerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(InputReadyVertexManager.class);
    Map<String, SourceVertexInfo> srcVertexInfo = Maps.newHashMap();
    boolean[] taskIsStarted;
    int[] oneToOneSrcTasksDoneCount;
    TaskLocationHint[] oneToOneLocationHints;
    int numOneToOneEdges;
    int numConfiguredSources;
    List<TaskAttemptIdentifier> pendingCompletions = Lists.newLinkedList();
    AtomicBoolean configured;
    AtomicBoolean started;

    public InputReadyVertexManager(VertexManagerPluginContext context) {
        super(context);
    }

    private void configure() {
        Preconditions.checkState((!this.configured.get() ? 1 : 0) != 0, (Object)("Vertex: " + this.getContext().getVertexName()));
        int numManagedTasks = this.getContext().getVertexNumTasks(this.getContext().getVertexName());
        LOG.info("Managing " + numManagedTasks + " tasks for vertex: " + this.getContext().getVertexName());
        Map edges = this.getContext().getInputVertexEdgeProperties();
        int oneToOneSrcTaskCount = 0;
        this.numOneToOneEdges = 0;
        for (Map.Entry entry : edges.entrySet()) {
            EdgeProperty edgeProp = (EdgeProperty)entry.getValue();
            String srcVertex = (String)entry.getKey();
            int numSrcTasks = this.getContext().getVertexNumTasks(srcVertex);
            switch (edgeProp.getDataMovementType()) {
                case CUSTOM: {
                    throw new TezUncheckedException("Cannot handle custom edge");
                }
                case ONE_TO_ONE: {
                    ++this.numOneToOneEdges;
                    if (oneToOneSrcTaskCount == 0) {
                        oneToOneSrcTaskCount = numSrcTasks;
                        break;
                    }
                    if (oneToOneSrcTaskCount == numSrcTasks) break;
                    throw new TezUncheckedException("All 1-1 source vertices must have identical concurrency");
                }
                case SCATTER_GATHER: 
                case BROADCAST: {
                    break;
                }
                default: {
                    throw new TezUncheckedException("Unknown edge type: " + edgeProp.getDataMovementType());
                }
            }
            this.srcVertexInfo.put(srcVertex, new SourceVertexInfo(numSrcTasks, edgeProp));
        }
        if (this.numOneToOneEdges > 0) {
            Preconditions.checkState((oneToOneSrcTaskCount >= 0 ? 1 : 0) != 0, (Object)("Vertex: " + this.getContext().getVertexName()));
            if (oneToOneSrcTaskCount != numManagedTasks) {
                numManagedTasks = oneToOneSrcTaskCount;
                LOG.info("Update parallelism of vertex: " + this.getContext().getVertexName() + " to " + oneToOneSrcTaskCount + " to match source 1-1 vertices.");
                this.getContext().reconfigureVertex(oneToOneSrcTaskCount, null, null);
            }
            this.oneToOneSrcTasksDoneCount = new int[oneToOneSrcTaskCount];
            this.oneToOneLocationHints = new TaskLocationHint[oneToOneSrcTaskCount];
        }
        Preconditions.checkState((numManagedTasks >= 0 ? 1 : 0) != 0, (Object)("Vertex: " + this.getContext().getVertexName()));
        this.taskIsStarted = new boolean[numManagedTasks];
        this.configured.set(true);
        this.getContext().doneReconfiguringVertex();
        this.trySchedulingPendingCompletions();
    }

    private boolean readyToSchedule() {
        return this.configured.get() && this.started.get();
    }

    private void trySchedulingPendingCompletions() {
        if (this.readyToSchedule() && !this.pendingCompletions.isEmpty()) {
            for (TaskAttemptIdentifier attempt : this.pendingCompletions) {
                this.onSourceTaskCompleted(attempt);
            }
        }
    }

    public void initialize() {
        this.getContext().vertexReconfigurationPlanned();
        Map edges = this.getContext().getInputVertexEdgeProperties();
        this.numConfiguredSources = 0;
        this.configured = new AtomicBoolean(false);
        this.started = new AtomicBoolean(false);
        for (String entry : edges.keySet()) {
            this.getContext().registerForVertexStateUpdates(entry, EnumSet.of(VertexState.CONFIGURED));
        }
    }

    public synchronized void onVertexStateUpdated(VertexStateUpdate stateUpdate) throws Exception {
        ++this.numConfiguredSources;
        int target = this.getContext().getInputVertexEdgeProperties().size();
        LOG.info("For vertex: " + this.getContext().getVertexName() + " Received configured signal from: " + stateUpdate.getVertexName() + " numConfiguredSources: " + this.numConfiguredSources + " needed: " + target);
        Preconditions.checkState((this.numConfiguredSources <= target ? 1 : 0) != 0, (Object)("Vertex: " + this.getContext().getVertexName()));
        if (this.numConfiguredSources == target) {
            this.configure();
        }
    }

    public synchronized void onVertexStarted(List<TaskAttemptIdentifier> completions) {
        if (completions != null) {
            this.pendingCompletions.addAll(completions);
        }
        this.started.set(true);
        this.trySchedulingPendingCompletions();
    }

    public synchronized void onSourceTaskCompleted(TaskAttemptIdentifier attempt) {
        String srcVertexName = attempt.getTaskIdentifier().getVertexIdentifier().getName();
        int taskId = attempt.getTaskIdentifier().getIdentifier();
        if (this.readyToSchedule()) {
            this.handleSourceTaskFinished(srcVertexName, taskId);
        } else {
            this.pendingCompletions.add(attempt);
        }
    }

    public synchronized void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    public synchronized void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
    }

    void handleSourceTaskFinished(String vertex, Integer taskId) {
        SourceVertexInfo srcInfo = this.srcVertexInfo.get(vertex);
        if (srcInfo.taskIsFinished[taskId] == null) {
            srcInfo.taskIsFinished[taskId.intValue()] = true;
            ++srcInfo.numFinishedTasks;
            if (srcInfo.edgeProperty.getDataMovementType() == EdgeProperty.DataMovementType.ONE_TO_ONE) {
                int n = taskId;
                this.oneToOneSrcTasksDoneCount[n] = this.oneToOneSrcTasksDoneCount[n] + 1;
                this.oneToOneLocationHints[taskId.intValue()] = TaskLocationHint.createTaskLocationHint((String)vertex, (int)taskId);
            }
        }
        if (srcInfo.edgeProperty.getDataMovementType() != EdgeProperty.DataMovementType.ONE_TO_ONE && srcInfo.numTasks != srcInfo.numFinishedTasks) {
            return;
        }
        for (SourceVertexInfo vInfo : this.srcVertexInfo.values()) {
            if (vInfo.edgeProperty.getDataMovementType() == EdgeProperty.DataMovementType.ONE_TO_ONE || vInfo.numTasks == vInfo.numFinishedTasks) continue;
            return;
        }
        AbstractList tasksToStart = null;
        if (this.numOneToOneEdges == 0) {
            int numTasks = this.taskIsStarted.length;
            LOG.info("Starting all " + numTasks + "tasks for vertex: " + this.getContext().getVertexName());
            tasksToStart = Lists.newArrayListWithCapacity((int)numTasks);
            for (int i = 0; i < numTasks; ++i) {
                this.taskIsStarted[i] = true;
                tasksToStart.add(VertexManagerPluginContext.ScheduleTaskRequest.create((int)i, null));
            }
        } else {
            tasksToStart = Lists.newLinkedList();
            for (int i = 0; i < this.taskIsStarted.length; ++i) {
                if (this.taskIsStarted[i] || this.oneToOneSrcTasksDoneCount[i] != this.numOneToOneEdges) continue;
                this.taskIsStarted[i] = true;
                TaskLocationHint locationHint = null;
                if (this.oneToOneLocationHints[i] != null) {
                    locationHint = this.oneToOneLocationHints[i];
                }
                LOG.info("Starting task " + i + " for vertex: " + this.getContext().getVertexName() + " with location: " + (locationHint != null ? locationHint.getAffinitizedTask() : "null"));
                tasksToStart.add(VertexManagerPluginContext.ScheduleTaskRequest.create((int)i, (TaskLocationHint)locationHint));
            }
        }
        if (tasksToStart != null && !tasksToStart.isEmpty()) {
            this.getContext().scheduleTasks((List)tasksToStart);
        }
    }

    static class SourceVertexInfo {
        EdgeProperty edgeProperty;
        int numTasks;
        int numFinishedTasks;
        Boolean[] taskIsFinished;

        SourceVertexInfo(int numTasks, EdgeProperty edgeProperty) {
            this.numTasks = numTasks;
            this.numFinishedTasks = 0;
            this.edgeProperty = edgeProperty;
            this.taskIsFinished = new Boolean[numTasks];
        }
    }
}

