/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

A method for estimation of a surface from a binary volume.



This filter implements a surface-fitting method for estimation of a
surface from a binary volume. This process can be used to reduce
aliasing artifacts which result in visualization of binary partitioned
surfaces.

The binary volume (filter input) is used as a set of constraints in an
iterative relaxation process of an estimated ND surface. The surface
is described implicitly as the zero level set of a volume $ \\phi $ and allowed to deform under curvature flow. A set of constraints is
imposed on this movement as follows:

\\[ u_{i,j,k}^{n+1} = \\left\\{ \\begin{array}{ll}
\\mbox{max} (u_{i,j,k}^{n} + \\Delta t H_{i,j,k}^{n}, 0) &amp;
\\mbox{\\f$B_{i,j,k} = 1\\f$} \\\\ \\mbox{min}
(u_{i,j,k}^{n} + \\Delta t H_{i,j,k}^{n}, 0) &amp;
\\mbox{\\f$B_{i,j,k} = -1\\f$} \\end{array}\\right. \\]

where $ u_{i,j,k}^{n} $ is the value of $ \\phi $ at discrete index $ (i,j,k) $ and iteration $ n $ , $ H $ is the gradient magnitude times mean curvature of $ \\phi $ , and $ B $ is the binary input volume, with 1 denoting an inside pixel and -1
denoting an outside pixel.
NOTES
This implementation uses a sparse field level set solver instead of
the narrow band implementation described in the reference below, which
may introduce some differences in how fast and how accurately (in
terms of RMS error) the solution converges.
REFERENCES
Whitaker, Ross. "Reducing Aliasing Artifacts In Iso-Surfaces of
Binary Volumes" IEEE Volume Visualization and Graphics Symposium,
October 2000, pp.23-32.
PARAMETERS
The MaximumRMSChange parameter is used to determine when the solution
has converged. A lower value will result in a tighter-fitting
solution, but will require more computations. Too low a value could
put the solver into an infinite loop. Values should always be less
than 1.0. A value of 0.07 is a good starting estimate.

The MaximumIterations parameter can be used to halt the solution after
a specified number of iterations.
INPUT
The input is an N-dimensional image of any type. It is assumed to be a
binary image. The filter will use an isosurface value that is halfway
between the min and max values in the image. A signed data type is not
necessary for the input.
OUTPUT
The filter will output a level set image of real, signed values. The
zero crossings of this (N-dimensional) image represent the position of
the isosurface value of interest. Values outside the zero level set
are negative and values inside the zero level set are positive values.
IMPORTANT!
The output image type you use to instantiate this filter should be a
real valued scalar type. In other words: doubles or floats.
USING THIS FILTER
The filter is relatively straightforward to use. Tests and examples
exist to illustrate. The important thing is to understand the input
and output types so you can properly interpret your results.

In the common case, the only parameter that will need to be set is the
MaximumRMSChange parameter, which determines when the solver halts.

See:
 itk::simple::AntiAliasBinary for the procedural interface

 itk::AntiAliasBinaryImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAntiAliasBinaryImageFilter.h
*/
public class AntiAliasBinaryImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AntiAliasBinaryImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AntiAliasBinaryImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AntiAliasBinaryImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AntiAliasBinaryImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AntiAliasBinaryImageFilter::~AntiAliasBinaryImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AntiAliasBinaryImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AntiAliasBinaryImageFilter::AntiAliasBinaryImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AntiAliasBinaryImageFilter() {
    this(SimpleITKJNI.new_AntiAliasBinaryImageFilter(), true);
  }

  /**
Self&amp; itk::simple::AntiAliasBinaryImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.AntiAliasBinaryImageFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::AntiAliasBinaryImageFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.AntiAliasBinaryImageFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AntiAliasBinaryImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.AntiAliasBinaryImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::AntiAliasBinaryImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.AntiAliasBinaryImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
uint32_t itk::simple::AntiAliasBinaryImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.AntiAliasBinaryImageFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::AntiAliasBinaryImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.AntiAliasBinaryImageFilter_getRMSChange(swigCPtr, this);
  }

  /**
std::string itk::simple::AntiAliasBinaryImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AntiAliasBinaryImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AntiAliasBinaryImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AntiAliasBinaryImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AntiAliasBinaryImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.AntiAliasBinaryImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
