\name{ChangeLabelLabelMapFilter}
\alias{ChangeLabelLabelMapFilter}
\title{ChangeLabelLabelMapFilter}
\Rdversion{1.1}
\docType{class}
\description{
Replace the label Ids of selected LabelObjects with new label Ids.
ChangeLabelLabelMapFilter}
\details{
This filter takes as input a label map and a list of pairs of Label Ids, to produce as output a new label map where the label Ids have
been replaced according to the pairs in the list.
Labels that are relabeled to the same label Id are automatically
merged and optimized into a single LabelObject . The background label can also be changed. Any object relabeled to
the output background will automatically be removed.
This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
ShapeLabelObject , RelabelComponentImageFilter , ChangeLabelImageFilter
ChangeLabelLabelMapFilter for the procedural interface
itk::ChangeLabelLabelMapFilter for the Doxygen on the original ITK class.
ChangeLabelLabelMapFilter}
%C++ includes: sitkChangeLabelLabelMapFilter.h
\section{Methods}{
\describe{
\item{ ChangeLabelLabelMapFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::map< double, double > GetChangeMap() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetChangeMap(std::map< double, double > ChangeMap):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ChangeLabelLabelMapFilter():}{
Destructor
}
}
}
