/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkVectorMagnitudeImageFilter_h
#define sitkVectorMagnitudeImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class VectorMagnitudeImageFilter
\brief Take an image of vectors as input and produce an image with the magnitude of those vectors.

The filter expects the input image pixel type to be a vector and the output image pixel type to be a scalar.

This filter assumes that the PixelType of the input image is a VectorType that provides a GetNorm() method.
\sa itk::simple::VectorMagnitude for the procedural interface
\sa itk::VectorMagnitudeImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT VectorMagnitudeImageFilter : public ImageFilter {
    public:
      using Self = VectorMagnitudeImageFilter;

      /** Destructor */
      virtual ~VectorMagnitudeImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      VectorMagnitudeImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = VectorPixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("VectorMagnitudeImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



      bool m_InPlace{false};
    };

    /**\
     * \brief Take an image of vectors as input and produce an image with the magnitude of those vectors.
     *
     * This function directly calls the execute method of VectorMagnitudeImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::VectorMagnitudeImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image VectorMagnitude ( Image&& image1 );
#endif
     SITKBasicFilters_EXPORT Image VectorMagnitude ( const Image& image1 );

     /** @} */
}
#endif
