/* Generated by wayland-scanner 1.23.1 */

#ifndef EFL_AUX_HINTS_SERVER_PROTOCOL_H
#define EFL_AUX_HINTS_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_efl_aux_hints The efl_aux_hints protocol
 * @section page_ifaces_efl_aux_hints Interfaces
 * - @subpage page_iface_efl_aux_hints - 
 */
struct efl_aux_hints;
struct wl_surface;

#ifndef EFL_AUX_HINTS_INTERFACE
#define EFL_AUX_HINTS_INTERFACE
/**
 * @page page_iface_efl_aux_hints efl_aux_hints
 * @section page_iface_efl_aux_hints_api API
 * See @ref iface_efl_aux_hints.
 */
/**
 * @defgroup iface_efl_aux_hints The efl_aux_hints interface
 */
extern const struct wl_interface efl_aux_hints_interface;
#endif

/**
 * @ingroup iface_efl_aux_hints
 * @struct efl_aux_hints_interface
 */
struct efl_aux_hints_interface {
	/**
	 */
	void (*add_aux_hint)(struct wl_client *client,
			     struct wl_resource *resource,
			     struct wl_resource *surface,
			     int32_t id,
			     const char *hint,
			     const char *val);
	/**
	 */
	void (*change_aux_hint)(struct wl_client *client,
				struct wl_resource *resource,
				struct wl_resource *surface,
				int32_t id,
				const char *val);
	/**
	 */
	void (*del_aux_hint)(struct wl_client *client,
			     struct wl_resource *resource,
			     struct wl_resource *surface,
			     int32_t id);
	/**
	 */
	void (*get_supported_aux_hints)(struct wl_client *client,
					struct wl_resource *resource,
					struct wl_resource *surface);
	/**
	 */
	void (*add_aux_hint_fd)(struct wl_client *client,
				struct wl_resource *resource,
				struct wl_resource *surface,
				int32_t id,
				const char *hint,
				int32_t val);
	/**
	 */
	void (*change_aux_hint_fd)(struct wl_client *client,
				   struct wl_resource *resource,
				   struct wl_resource *surface,
				   int32_t id,
				   int32_t val);
};

#define EFL_AUX_HINTS_SUPPORTED_AUX_HINTS 0
#define EFL_AUX_HINTS_ALLOWED_AUX_HINT 1
#define EFL_AUX_HINTS_AUX_MESSAGE 2

/**
 * @ingroup iface_efl_aux_hints
 */
#define EFL_AUX_HINTS_SUPPORTED_AUX_HINTS_SINCE_VERSION 1
/**
 * @ingroup iface_efl_aux_hints
 */
#define EFL_AUX_HINTS_ALLOWED_AUX_HINT_SINCE_VERSION 1
/**
 * @ingroup iface_efl_aux_hints
 */
#define EFL_AUX_HINTS_AUX_MESSAGE_SINCE_VERSION 1

/**
 * @ingroup iface_efl_aux_hints
 */
#define EFL_AUX_HINTS_ADD_AUX_HINT_SINCE_VERSION 1
/**
 * @ingroup iface_efl_aux_hints
 */
#define EFL_AUX_HINTS_CHANGE_AUX_HINT_SINCE_VERSION 1
/**
 * @ingroup iface_efl_aux_hints
 */
#define EFL_AUX_HINTS_DEL_AUX_HINT_SINCE_VERSION 1
/**
 * @ingroup iface_efl_aux_hints
 */
#define EFL_AUX_HINTS_GET_SUPPORTED_AUX_HINTS_SINCE_VERSION 1
/**
 * @ingroup iface_efl_aux_hints
 */
#define EFL_AUX_HINTS_ADD_AUX_HINT_FD_SINCE_VERSION 1
/**
 * @ingroup iface_efl_aux_hints
 */
#define EFL_AUX_HINTS_CHANGE_AUX_HINT_FD_SINCE_VERSION 1

/**
 * @ingroup iface_efl_aux_hints
 * Sends an supported_aux_hints event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
efl_aux_hints_send_supported_aux_hints(struct wl_resource *resource_, struct wl_resource *surface, struct wl_array *hints, uint32_t num_hints)
{
	wl_resource_post_event(resource_, EFL_AUX_HINTS_SUPPORTED_AUX_HINTS, surface, hints, num_hints);
}

/**
 * @ingroup iface_efl_aux_hints
 * Sends an allowed_aux_hint event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
efl_aux_hints_send_allowed_aux_hint(struct wl_resource *resource_, struct wl_resource *surface, int32_t id)
{
	wl_resource_post_event(resource_, EFL_AUX_HINTS_ALLOWED_AUX_HINT, surface, id);
}

/**
 * @ingroup iface_efl_aux_hints
 * Sends an aux_message event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
efl_aux_hints_send_aux_message(struct wl_resource *resource_, struct wl_resource *surface, const char *key, const char *val, struct wl_array *options)
{
	wl_resource_post_event(resource_, EFL_AUX_HINTS_AUX_MESSAGE, surface, key, val, options);
}

#ifdef  __cplusplus
}
#endif

#endif
