/* Categories.c generated by valac 0.56.18, the Vala compiler
 * generated from Categories.vala, do not modify */

/* Categories.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include "font-manager.h"
#include <glib/gi18n-lib.h>
#include <sqlite3.h>

#define FONT_MANAGER_SELECT_FROM_FONTS "SELECT DISTINCT family, description FROM Fonts"
#define FONT_MANAGER_SELECT_FROM_METADATA_WHERE "SELECT DISTINCT Fonts.family, Fonts.description FROM Fonts JOIN Metada" \
"ta USING (filepath, findex) WHERE"
#define FONT_MANAGER_SELECT_FROM_PANOSE_WHERE "SELECT DISTINCT Fonts.family, Fonts.description FROM Fonts JOIN Panose" \
" USING (filepath, findex) WHERE"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	FONT_MANAGER_CATEGORY_INDEX_ALL,
	FONT_MANAGER_CATEGORY_INDEX_SYSTEM,
	FONT_MANAGER_CATEGORY_INDEX_USER,
	FONT_MANAGER_CATEGORY_INDEX_PANOSE,
	FONT_MANAGER_CATEGORY_INDEX_WIDTH,
	FONT_MANAGER_CATEGORY_INDEX_WEIGHT,
	FONT_MANAGER_CATEGORY_INDEX_SLANT,
	FONT_MANAGER_CATEGORY_INDEX_SPACING,
	FONT_MANAGER_CATEGORY_INDEX_LICENSE,
	FONT_MANAGER_CATEGORY_INDEX_VENDOR,
	FONT_MANAGER_CATEGORY_INDEX_FILETYPE,
	FONT_MANAGER_CATEGORY_INDEX_UNSORTED,
	FONT_MANAGER_CATEGORY_INDEX_DISABLED,
	FONT_MANAGER_CATEGORY_INDEX_LANGUAGE,
	FONT_MANAGER_CATEGORY_INDEX_N_CATEGORIES
} FontManagerCategoryIndex;

#define FONT_MANAGER_TYPE_CATEGORY_INDEX (font_manager_category_index_get_type ())

#define FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL (font_manager_font_list_filter_model_get_type ())
#define FONT_MANAGER_FONT_LIST_FILTER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, FontManagerFontListFilterModel))
#define FONT_MANAGER_FONT_LIST_FILTER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, FontManagerFontListFilterModelClass))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL))
#define FONT_MANAGER_FONT_LIST_FILTER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, FontManagerFontListFilterModelClass))

typedef struct _FontManagerFontListFilterModel FontManagerFontListFilterModel;
typedef struct _FontManagerFontListFilterModelClass FontManagerFontListFilterModelClass;
typedef struct _FontManagerFontListFilterModelPrivate FontManagerFontListFilterModelPrivate;

#define FONT_MANAGER_TYPE_CACHEABLE (font_manager_cacheable_get_type ())
#define FONT_MANAGER_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheable))
#define FONT_MANAGER_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))
#define FONT_MANAGER_IS_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_IS_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_CACHEABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))

typedef struct _FontManagerCacheable FontManagerCacheable;
typedef struct _FontManagerCacheableClass FontManagerCacheableClass;

#define FONT_MANAGER_TYPE_FONT_LIST_FILTER (font_manager_font_list_filter_get_type ())
#define FONT_MANAGER_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter))
#define FONT_MANAGER_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))
#define FONT_MANAGER_IS_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_FONT_LIST_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))

typedef struct _FontManagerFontListFilter FontManagerFontListFilter;
typedef struct _FontManagerFontListFilterClass FontManagerFontListFilterClass;

#define FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL (font_manager_category_list_model_get_type ())
#define FONT_MANAGER_CATEGORY_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModel))
#define FONT_MANAGER_CATEGORY_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModelClass))
#define FONT_MANAGER_IS_CATEGORY_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL))
#define FONT_MANAGER_IS_CATEGORY_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL))
#define FONT_MANAGER_CATEGORY_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModelClass))

typedef struct _FontManagerCategoryListModel FontManagerCategoryListModel;
typedef struct _FontManagerCategoryListModelClass FontManagerCategoryListModelClass;
typedef struct _FontManagerCategoryListModelPrivate FontManagerCategoryListModelPrivate;
enum  {
	FONT_MANAGER_CATEGORY_LIST_MODEL_0_PROPERTY,
	FONT_MANAGER_CATEGORY_LIST_MODEL_NUM_PROPERTIES
};
static GParamSpec* font_manager_category_list_model_properties[FONT_MANAGER_CATEGORY_LIST_MODEL_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_CATEGORY (font_manager_category_get_type ())
#define FONT_MANAGER_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory))
#define FONT_MANAGER_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategoryClass))
#define FONT_MANAGER_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CATEGORY))
#define FONT_MANAGER_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CATEGORY))
#define FONT_MANAGER_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategoryClass))

typedef struct _FontManagerCategory FontManagerCategory;
typedef struct _FontManagerCategoryClass FontManagerCategoryClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FONT_MANAGER_TYPE_LIST_ITEM_ROW (font_manager_list_item_row_get_type ())
#define FONT_MANAGER_LIST_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_LIST_ITEM_ROW, FontManagerListItemRow))
#define FONT_MANAGER_LIST_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_LIST_ITEM_ROW, FontManagerListItemRowClass))
#define FONT_MANAGER_IS_LIST_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_LIST_ITEM_ROW))
#define FONT_MANAGER_IS_LIST_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_LIST_ITEM_ROW))
#define FONT_MANAGER_LIST_ITEM_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_LIST_ITEM_ROW, FontManagerListItemRowClass))

typedef struct _FontManagerListItemRow FontManagerListItemRow;
typedef struct _FontManagerListItemRowClass FontManagerListItemRowClass;
typedef struct _FontManagerListItemRowPrivate FontManagerListItemRowPrivate;

#define FONT_MANAGER_TYPE_TREE_LIST_ITEM_ROW (font_manager_tree_list_item_row_get_type ())
#define FONT_MANAGER_TREE_LIST_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_TREE_LIST_ITEM_ROW, FontManagerTreeListItemRow))
#define FONT_MANAGER_TREE_LIST_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_TREE_LIST_ITEM_ROW, FontManagerTreeListItemRowClass))
#define FONT_MANAGER_IS_TREE_LIST_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_TREE_LIST_ITEM_ROW))
#define FONT_MANAGER_IS_TREE_LIST_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_TREE_LIST_ITEM_ROW))
#define FONT_MANAGER_TREE_LIST_ITEM_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_TREE_LIST_ITEM_ROW, FontManagerTreeListItemRowClass))

typedef struct _FontManagerTreeListItemRow FontManagerTreeListItemRow;
typedef struct _FontManagerTreeListItemRowClass FontManagerTreeListItemRowClass;
typedef struct _FontManagerTreeListItemRowPrivate FontManagerTreeListItemRowPrivate;

#define FONT_MANAGER_TYPE_CATEGORY_LIST_ROW (font_manager_category_list_row_get_type ())
#define FONT_MANAGER_CATEGORY_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_ROW, FontManagerCategoryListRow))
#define FONT_MANAGER_CATEGORY_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_ROW, FontManagerCategoryListRowClass))
#define FONT_MANAGER_IS_CATEGORY_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_ROW))
#define FONT_MANAGER_IS_CATEGORY_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_ROW))
#define FONT_MANAGER_CATEGORY_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_ROW, FontManagerCategoryListRowClass))

typedef struct _FontManagerCategoryListRow FontManagerCategoryListRow;
typedef struct _FontManagerCategoryListRowClass FontManagerCategoryListRowClass;
typedef struct _FontManagerCategoryListRowPrivate FontManagerCategoryListRowPrivate;
enum  {
	FONT_MANAGER_CATEGORY_LIST_ROW_0_PROPERTY,
	FONT_MANAGER_CATEGORY_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* font_manager_category_list_row_properties[FONT_MANAGER_CATEGORY_LIST_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define FONT_MANAGER_TYPE_FILTER_LIST_VIEW (font_manager_filter_list_view_get_type ())
#define FONT_MANAGER_FILTER_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FILTER_LIST_VIEW, FontManagerFilterListView))
#define FONT_MANAGER_FILTER_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FILTER_LIST_VIEW, FontManagerFilterListViewClass))
#define FONT_MANAGER_IS_FILTER_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FILTER_LIST_VIEW))
#define FONT_MANAGER_IS_FILTER_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FILTER_LIST_VIEW))
#define FONT_MANAGER_FILTER_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FILTER_LIST_VIEW, FontManagerFilterListViewClass))

typedef struct _FontManagerFilterListView FontManagerFilterListView;
typedef struct _FontManagerFilterListViewClass FontManagerFilterListViewClass;
typedef struct _FontManagerFilterListViewPrivate FontManagerFilterListViewPrivate;

#define FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW (font_manager_category_list_view_get_type ())
#define FONT_MANAGER_CATEGORY_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW, FontManagerCategoryListView))
#define FONT_MANAGER_CATEGORY_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW, FontManagerCategoryListViewClass))
#define FONT_MANAGER_IS_CATEGORY_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW))
#define FONT_MANAGER_IS_CATEGORY_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW))
#define FONT_MANAGER_CATEGORY_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW, FontManagerCategoryListViewClass))

typedef struct _FontManagerCategoryListView FontManagerCategoryListView;
typedef struct _FontManagerCategoryListViewClass FontManagerCategoryListViewClass;
typedef struct _FontManagerCategoryListViewPrivate FontManagerCategoryListViewPrivate;

#define FONT_MANAGER_TYPE_DISABLED (font_manager_disabled_get_type ())
#define FONT_MANAGER_DISABLED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_DISABLED, FontManagerDisabled))
#define FONT_MANAGER_DISABLED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_DISABLED, FontManagerDisabledClass))
#define FONT_MANAGER_IS_DISABLED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_DISABLED))
#define FONT_MANAGER_IS_DISABLED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_DISABLED))
#define FONT_MANAGER_DISABLED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_DISABLED, FontManagerDisabledClass))

typedef struct _FontManagerDisabled FontManagerDisabled;
typedef struct _FontManagerDisabledClass FontManagerDisabledClass;

#define FONT_MANAGER_TYPE_UNSORTED (font_manager_unsorted_get_type ())
#define FONT_MANAGER_UNSORTED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_UNSORTED, FontManagerUnsorted))
#define FONT_MANAGER_UNSORTED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_UNSORTED, FontManagerUnsortedClass))
#define FONT_MANAGER_IS_UNSORTED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_UNSORTED))
#define FONT_MANAGER_IS_UNSORTED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_UNSORTED))
#define FONT_MANAGER_UNSORTED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_UNSORTED, FontManagerUnsortedClass))

typedef struct _FontManagerUnsorted FontManagerUnsorted;
typedef struct _FontManagerUnsortedClass FontManagerUnsortedClass;

#define FONT_MANAGER_TYPE_LANGUAGE_FILTER (font_manager_language_filter_get_type ())
#define FONT_MANAGER_LANGUAGE_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilter))
#define FONT_MANAGER_LANGUAGE_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilterClass))
#define FONT_MANAGER_IS_LANGUAGE_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER))
#define FONT_MANAGER_IS_LANGUAGE_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_LANGUAGE_FILTER))
#define FONT_MANAGER_LANGUAGE_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilterClass))

typedef struct _FontManagerLanguageFilter FontManagerLanguageFilter;
typedef struct _FontManagerLanguageFilterClass FontManagerLanguageFilterClass;
enum  {
	FONT_MANAGER_CATEGORY_LIST_VIEW_0_PROPERTY,
	FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_FAMILIES_PROPERTY,
	FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_PROPERTY,
	FONT_MANAGER_CATEGORY_LIST_VIEW_SORTED_PROPERTY,
	FONT_MANAGER_CATEGORY_LIST_VIEW_UNSORTED_PROPERTY,
	FONT_MANAGER_CATEGORY_LIST_VIEW_LANGUAGE_FILTER_PROPERTY,
	FONT_MANAGER_CATEGORY_LIST_VIEW_NUM_PROPERTIES
};
static GParamSpec* font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_FILTER_DATA (font_manager_filter_data_get_type ())
typedef struct _FontManagerFilterData FontManagerFilterData;

#define FONT_MANAGER_TYPE_USER_FONTS (font_manager_user_fonts_get_type ())
#define FONT_MANAGER_USER_FONTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_USER_FONTS, FontManagerUserFonts))
#define FONT_MANAGER_USER_FONTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_USER_FONTS, FontManagerUserFontsClass))
#define FONT_MANAGER_IS_USER_FONTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_USER_FONTS))
#define FONT_MANAGER_IS_USER_FONTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_USER_FONTS))
#define FONT_MANAGER_USER_FONTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_USER_FONTS, FontManagerUserFontsClass))

typedef struct _FontManagerUserFonts FontManagerUserFonts;
typedef struct _FontManagerUserFontsClass FontManagerUserFontsClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerFontListFilterModel {
	GObject parent_instance;
	FontManagerFontListFilterModelPrivate * priv;
};

struct _FontManagerFontListFilterModelClass {
	GObjectClass parent_class;
	void (*add_item) (FontManagerFontListFilterModel* self, FontManagerFontListFilter* item);
	void (*remove_item) (FontManagerFontListFilterModel* self, FontManagerFontListFilter* item);
};

struct _FontManagerCategoryListModel {
	FontManagerFontListFilterModel parent_instance;
	FontManagerCategoryListModelPrivate * priv;
};

struct _FontManagerCategoryListModelClass {
	FontManagerFontListFilterModelClass parent_class;
};

struct _FontManagerListItemRow {
	GtkBox parent_instance;
	FontManagerListItemRowPrivate * priv;
};

struct _FontManagerListItemRowClass {
	GtkBoxClass parent_class;
	void (*on_item_set) (FontManagerListItemRow* self);
	void (*reset) (FontManagerListItemRow* self);
};

struct _FontManagerTreeListItemRow {
	FontManagerListItemRow parent_instance;
	FontManagerTreeListItemRowPrivate * priv;
};

struct _FontManagerTreeListItemRowClass {
	FontManagerListItemRowClass parent_class;
	void (*show_context_menu) (FontManagerTreeListItemRow* self, GdkEvent* event, gdouble x, gdouble y);
};

struct _FontManagerCategoryListRow {
	FontManagerTreeListItemRow parent_instance;
	FontManagerCategoryListRowPrivate * priv;
};

struct _FontManagerCategoryListRowClass {
	FontManagerTreeListItemRowClass parent_class;
};

struct _FontManagerCategoryListRowPrivate {
	gulong handler_id;
};

struct _FontManagerFilterListView {
	GtkBox parent_instance;
	FontManagerFilterListViewPrivate * priv;
	GtkListView* listview;
};

struct _FontManagerFilterListViewClass {
	GtkBoxClass parent_class;
	void (*on_show_context_menu) (FontManagerFilterListView* self, gint n_press, gdouble x, gdouble y);
	void (*setup_list_row) (FontManagerFilterListView* self, GtkSignalListItemFactory* factory, GObject* item);
	void (*bind_list_row) (FontManagerFilterListView* self, GtkSignalListItemFactory* factory, GObject* item);
	void (*collapse_all) (FontManagerFilterListView* self);
	void (*on_row_selected) (FontManagerFilterListView* self, GtkTreeListRow* row);
	void (*on_selection_changed) (FontManagerFilterListView* self, guint position, guint n_items);
};

struct _FontManagerCategoryListView {
	FontManagerFilterListView parent_instance;
	FontManagerCategoryListViewPrivate * priv;
};

struct _FontManagerCategoryListViewClass {
	FontManagerFilterListViewClass parent_class;
};

struct _FontManagerCategoryListViewPrivate {
	FontManagerReject* _disabled_families;
	FontManagerDisabled* _disabled;
	FontManagerStringSet* _sorted;
	FontManagerUnsorted* _unsorted;
	FontManagerLanguageFilter* _language_filter;
};

struct _FontManagerFilterData {
	gint index;
	gchar* name;
	gchar* comment;
	gchar* column;
};

static gpointer font_manager_category_list_model_parent_class = NULL;
static gint FontManagerCategoryListRow_private_offset;
static gpointer font_manager_category_list_row_parent_class = NULL;
static gint FontManagerCategoryListView_private_offset;
static gpointer font_manager_category_list_view_parent_class = NULL;

VALA_EXTERN GType font_manager_category_index_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType font_manager_font_list_filter_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListFilterModel, g_object_unref)
VALA_EXTERN GType font_manager_cacheable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCacheable, g_object_unref)
VALA_EXTERN GType font_manager_font_list_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListFilter, g_object_unref)
VALA_EXTERN GType font_manager_category_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCategoryListModel, g_object_unref)
VALA_EXTERN FontManagerCategoryListModel* font_manager_category_list_model_new (void);
VALA_EXTERN FontManagerCategoryListModel* font_manager_category_list_model_construct (GType object_type);
VALA_EXTERN FontManagerFontListFilterModel* font_manager_font_list_filter_model_new (void);
VALA_EXTERN FontManagerFontListFilterModel* font_manager_font_list_filter_model_construct (GType object_type);
VALA_EXTERN GType font_manager_category_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCategory, g_object_unref)
VALA_EXTERN GPtrArray* font_manager_get_base_categories (void);
VALA_EXTERN void font_manager_font_list_filter_model_set_items (FontManagerFontListFilterModel* self,
                                                    GPtrArray* value);
static void font_manager_category_list_model_on_categories_updated (GObject* source,
                                                             GTask* task);
VALA_EXTERN void font_manager_category_list_model_update_items (FontManagerCategoryListModel* self);
static void _font_manager_category_list_model_on_categories_updated_gasync_ready_callback (GObject* source_object,
                                                                                    GTask* task,
                                                                                    gpointer self);
VALA_EXTERN void font_manager_get_default_categories (GTask* task,
                                          GObject* source,
                                          void* data,
                                          GCancellable* cancellable);
static void _font_manager_get_default_categories_gtask_thread_func (GTask* task,
                                                             GObject* source_object,
                                                             void* task_data,
                                                             GCancellable* cancellable);
VALA_EXTERN GListModel* font_manager_category_list_model_get_child_model (GObject* item);
VALA_EXTERN GPtrArray* font_manager_category_get_children (FontManagerCategory* self);
static GType font_manager_category_list_model_get_type_once (void);
VALA_EXTERN GType font_manager_list_item_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerListItemRow, g_object_unref)
VALA_EXTERN GType font_manager_tree_list_item_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerTreeListItemRow, g_object_unref)
VALA_EXTERN GType font_manager_category_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCategoryListRow, g_object_unref)
VALA_EXTERN void font_manager_list_item_row_reset (FontManagerListItemRow* self);
VALA_EXTERN void font_manager_list_item_row_on_item_set (FontManagerListItemRow* self);
static void font_manager_category_list_row_real_reset (FontManagerListItemRow* base);
VALA_EXTERN GtkLabel* font_manager_list_item_row_get_item_label (FontManagerListItemRow* self);
VALA_EXTERN GtkLabel* font_manager_list_item_row_get_item_count (FontManagerListItemRow* self);
VALA_EXTERN GObject* font_manager_list_item_row_get_item (FontManagerListItemRow* self);
static void font_manager_category_list_row_real_on_item_set (FontManagerListItemRow* base);
static void _font_manager_list_item_row_on_item_set_font_manager_cacheable_changed (FontManagerCacheable* _sender,
                                                                             gpointer self);
VALA_EXTERN gint font_manager_font_list_filter_get_index (FontManagerFontListFilter* self);
VALA_EXTERN gint font_manager_font_list_filter_get_depth (FontManagerFontListFilter* self);
VALA_EXTERN gchar* font_manager_font_list_filter_get_name (FontManagerFontListFilter* self);
VALA_EXTERN GtkImage* font_manager_list_item_row_get_item_icon (FontManagerListItemRow* self);
VALA_EXTERN gchar* font_manager_font_list_filter_get_icon (FontManagerFontListFilter* self);
VALA_EXTERN gint font_manager_font_list_filter_get_size (FontManagerFontListFilter* self);
VALA_EXTERN gchar* font_manager_font_list_filter_get_comment (FontManagerFontListFilter* self);
VALA_EXTERN FontManagerCategoryListRow* font_manager_category_list_row_new (void);
VALA_EXTERN FontManagerCategoryListRow* font_manager_category_list_row_construct (GType object_type);
VALA_EXTERN FontManagerTreeListItemRow* font_manager_tree_list_item_row_new (void);
VALA_EXTERN FontManagerTreeListItemRow* font_manager_tree_list_item_row_construct (GType object_type);
static void font_manager_category_list_row_finalize (GObject * obj);
static GType font_manager_category_list_row_get_type_once (void);
VALA_EXTERN GType font_manager_filter_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFilterListView, g_object_unref)
VALA_EXTERN GType font_manager_category_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCategoryListView, g_object_unref)
VALA_EXTERN GType font_manager_disabled_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerDisabled, g_object_unref)
VALA_EXTERN GType font_manager_unsorted_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUnsorted, g_object_unref)
VALA_EXTERN GType font_manager_language_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLanguageFilter, g_object_unref)
VALA_EXTERN void font_manager_filter_list_view_on_selection_changed (FontManagerFilterListView* self,
                                                         guint position,
                                                         guint n_items);
VALA_EXTERN void font_manager_filter_list_view_setup_list_row (FontManagerFilterListView* self,
                                                   GtkSignalListItemFactory* factory,
                                                   GObject* item);
VALA_EXTERN void font_manager_filter_list_view_bind_list_row (FontManagerFilterListView* self,
                                                  GtkSignalListItemFactory* factory,
                                                  GObject* item);
VALA_EXTERN void font_manager_category_list_view_select_item (FontManagerCategoryListView* self,
                                                  guint position);
static void font_manager_category_list_view_real_on_selection_changed (FontManagerFilterListView* base,
                                                                guint position,
                                                                guint n_items);
VALA_EXTERN GtkSingleSelection* font_manager_filter_list_view_get_selection (FontManagerFilterListView* self);
VALA_EXTERN GtkTreeListModel* font_manager_filter_list_view_get_treemodel (FontManagerFilterListView* self);
VALA_EXTERN FontManagerFontListFilter* font_manager_filter_list_view_get_selected_item (FontManagerFilterListView* self);
VALA_EXTERN void font_manager_font_list_filter_update (FontManagerFontListFilter* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void font_manager_font_list_filter_update_finish (FontManagerFontListFilter* self,
                                                  GAsyncResult* _res_);
static void font_manager_category_list_view_real_setup_list_row (FontManagerFilterListView* base,
                                                          GtkSignalListItemFactory* factory,
                                                          GObject* item);
VALA_EXTERN void font_manager_tree_list_item_row_set_expander (FontManagerTreeListItemRow* self,
                                                   GtkTreeExpander* value);
VALA_EXTERN void font_manager_tree_list_item_row_set_selection (FontManagerTreeListItemRow* self,
                                                    GtkSelectionModel* value);
static void font_manager_category_list_view_update_disabled (FontManagerCategoryListView* self);
VALA_EXTERN FontManagerDisabled* font_manager_category_list_view_get_disabled (FontManagerCategoryListView* self);
VALA_EXTERN FontManagerReject* font_manager_category_list_view_get_disabled_families (FontManagerCategoryListView* self);
static void __lambda32_ (FontManagerCategoryListView* self,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN FontManagerFontListFilterModel* font_manager_filter_list_view_get_model (FontManagerFilterListView* self);
static void ___lambda32__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void font_manager_category_list_view_update_unsorted (FontManagerCategoryListView* self);
VALA_EXTERN FontManagerUnsorted* font_manager_category_list_view_get_unsorted (FontManagerCategoryListView* self);
VALA_EXTERN void font_manager_unsorted_update (FontManagerUnsorted* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void font_manager_unsorted_update_finish (FontManagerUnsorted* self,
                                          GAsyncResult* _res_);
static void __lambda33_ (FontManagerCategoryListView* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda33__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void font_manager_category_list_view_real_bind_list_row (FontManagerFilterListView* base,
                                                         GtkSignalListItemFactory* factory,
                                                         GObject* item);
VALA_EXTERN void font_manager_list_item_row_set_item (FontManagerListItemRow* self,
                                          GObject* value);
VALA_EXTERN void font_manager_category_list_view_set_disabled (FontManagerCategoryListView* self,
                                                   FontManagerDisabled* value);
VALA_EXTERN void font_manager_category_list_view_set_unsorted (FontManagerCategoryListView* self,
                                                   FontManagerUnsorted* value);
VALA_EXTERN void font_manager_category_list_view_set_language_filter (FontManagerCategoryListView* self,
                                                          FontManagerLanguageFilter* value);
VALA_EXTERN FontManagerLanguageFilter* font_manager_category_list_view_get_language_filter (FontManagerCategoryListView* self);
static void ______lambda34_ (FontManagerCategoryListView* self);
static void _______lambda34__font_manager_cacheable_changed (FontManagerCacheable* _sender,
                                                      gpointer self);
VALA_EXTERN FontManagerCategoryListView* font_manager_category_list_view_new (void);
VALA_EXTERN FontManagerCategoryListView* font_manager_category_list_view_construct (GType object_type);
VALA_EXTERN FontManagerFilterListView* font_manager_filter_list_view_new (void);
VALA_EXTERN FontManagerFilterListView* font_manager_filter_list_view_construct (GType object_type);
VALA_EXTERN void font_manager_category_list_view_set_disabled_families (FontManagerCategoryListView* self,
                                                            FontManagerReject* value);
VALA_EXTERN FontManagerStringSet* font_manager_category_list_view_get_sorted (FontManagerCategoryListView* self);
VALA_EXTERN void font_manager_category_list_view_set_sorted (FontManagerCategoryListView* self,
                                                 FontManagerStringSet* value);
static GObject * font_manager_category_list_view_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static GListModel* _font_manager_category_list_model_get_child_model_gtk_tree_list_model_create_model_func (GObject* item,
                                                                                                     gpointer self);
VALA_EXTERN void font_manager_filter_list_view_set_treemodel (FontManagerFilterListView* self,
                                                  GtkTreeListModel* value);
VALA_EXTERN void font_manager_filter_list_view_set_selection (FontManagerFilterListView* self,
                                                  GtkSingleSelection* value);
static void _font_manager_category_list_view___lambda38_ (FontManagerCategoryListView* self);
static void __font_manager_category_list_view___lambda38__g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void _font_manager_category_list_view___lambda39_ (FontManagerCategoryListView* self);
static void __font_manager_category_list_view___lambda39__g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void _font_manager_category_list_view___lambda40_ (FontManagerCategoryListView* self);
static void ___lambda41_ (FontManagerCategoryListView* self);
static void ____lambda41__font_manager_string_set_changed (FontManagerStringSet* _sender,
                                                    gpointer self);
static void __font_manager_category_list_view___lambda40__g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void font_manager_category_list_view_finalize (GObject * obj);
static GType font_manager_category_list_view_get_type_once (void);
static void _vala_font_manager_category_list_view_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_font_manager_category_list_view_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
VALA_EXTERN GType font_manager_filter_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FontManagerFilterData* font_manager_filter_data_dup (const FontManagerFilterData* self);
VALA_EXTERN void font_manager_filter_data_free (FontManagerFilterData* self);
VALA_EXTERN void font_manager_filter_data_copy (const FontManagerFilterData* self,
                                    FontManagerFilterData* dest);
VALA_EXTERN void font_manager_filter_data_destroy (FontManagerFilterData* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FontManagerFilterData, font_manager_filter_data_destroy)
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN FontManagerCategory* font_manager_category_new (const gchar* name,
                                                const gchar* comment,
                                                const gchar* icon,
                                                const gchar* sql,
                                                gint index);
VALA_EXTERN FontManagerCategory* font_manager_category_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* comment,
                                                      const gchar* icon,
                                                      const gchar* sql,
                                                      gint index);
VALA_EXTERN FontManagerUserFonts* font_manager_user_fonts_new (void);
VALA_EXTERN FontManagerUserFonts* font_manager_user_fonts_construct (GType object_type);
VALA_EXTERN GType font_manager_user_fonts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserFonts, g_object_unref)
VALA_EXTERN FontManagerDatabase* font_manager_database_proxy_get_default_db (void);
VALA_EXTERN FontManagerCategory* font_manager_construct_panose_filter (void);
VALA_EXTERN FontManagerCategory* font_manager_construct_attribute_filter (FontManagerDatabase* db,
                                                              FontManagerFilterData* data);
VALA_EXTERN FontManagerCategory* font_manager_construct_info_filter (FontManagerDatabase* db,
                                                         FontManagerFilterData* data);
VALA_EXTERN FontManagerUnsorted* font_manager_unsorted_new (void);
VALA_EXTERN FontManagerUnsorted* font_manager_unsorted_construct (GType object_type);
VALA_EXTERN FontManagerDisabled* font_manager_disabled_new (void);
VALA_EXTERN FontManagerDisabled* font_manager_disabled_construct (GType object_type);
VALA_EXTERN FontManagerLanguageFilter* font_manager_language_filter_new (void);
VALA_EXTERN FontManagerLanguageFilter* font_manager_language_filter_construct (GType object_type);
static void __lambda35_ (FontManagerCategory* child);
VALA_EXTERN void font_manager_font_list_filter_set_depth (FontManagerFontListFilter* self,
                                              gint value);
static void ___lambda35__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda36_ (FontManagerCategory* child);
static void ___lambda36__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda37_ (FontManagerCategory* child);
static void ___lambda37__gfunc (gconstpointer data,
                         gpointer self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const FontManagerFilterData FONT_MANAGER_attributes[4] = {{(gint) FONT_MANAGER_CATEGORY_INDEX_WIDTH, N_ ("Width"), N_ ("Grouped by font width"), "width"}, {(gint) FONT_MANAGER_CATEGORY_INDEX_WEIGHT, N_ ("Weight"), N_ ("Grouped by font weight"), "weight"}, {(gint) FONT_MANAGER_CATEGORY_INDEX_SLANT, N_ ("Slant"), N_ ("Grouped by font angle"), "slant"}, {(gint) FONT_MANAGER_CATEGORY_INDEX_SPACING, N_ ("Spacing"), N_ ("Grouped by font spacing"), "spacing"}};
const FontManagerFilterData FONT_MANAGER_metadata[3] = {{(gint) FONT_MANAGER_CATEGORY_INDEX_LICENSE, N_ ("License"), N_ ("Grouped by license type"), "license-type"}, {(gint) FONT_MANAGER_CATEGORY_INDEX_VENDOR, N_ ("Vendor"), N_ ("Grouped by vendor"), "vendor"}, {(gint) FONT_MANAGER_CATEGORY_INDEX_FILETYPE, N_ ("Filetype"), N_ ("Grouped by filetype"), "filetype"}};

 G_GNUC_NO_INLINE static GType
font_manager_category_index_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_CATEGORY_INDEX_ALL, "FONT_MANAGER_CATEGORY_INDEX_ALL", "all"}, {FONT_MANAGER_CATEGORY_INDEX_SYSTEM, "FONT_MANAGER_CATEGORY_INDEX_SYSTEM", "system"}, {FONT_MANAGER_CATEGORY_INDEX_USER, "FONT_MANAGER_CATEGORY_INDEX_USER", "user"}, {FONT_MANAGER_CATEGORY_INDEX_PANOSE, "FONT_MANAGER_CATEGORY_INDEX_PANOSE", "panose"}, {FONT_MANAGER_CATEGORY_INDEX_WIDTH, "FONT_MANAGER_CATEGORY_INDEX_WIDTH", "width"}, {FONT_MANAGER_CATEGORY_INDEX_WEIGHT, "FONT_MANAGER_CATEGORY_INDEX_WEIGHT", "weight"}, {FONT_MANAGER_CATEGORY_INDEX_SLANT, "FONT_MANAGER_CATEGORY_INDEX_SLANT", "slant"}, {FONT_MANAGER_CATEGORY_INDEX_SPACING, "FONT_MANAGER_CATEGORY_INDEX_SPACING", "spacing"}, {FONT_MANAGER_CATEGORY_INDEX_LICENSE, "FONT_MANAGER_CATEGORY_INDEX_LICENSE", "license"}, {FONT_MANAGER_CATEGORY_INDEX_VENDOR, "FONT_MANAGER_CATEGORY_INDEX_VENDOR", "vendor"}, {FONT_MANAGER_CATEGORY_INDEX_FILETYPE, "FONT_MANAGER_CATEGORY_INDEX_FILETYPE", "filetype"}, {FONT_MANAGER_CATEGORY_INDEX_UNSORTED, "FONT_MANAGER_CATEGORY_INDEX_UNSORTED", "unsorted"}, {FONT_MANAGER_CATEGORY_INDEX_DISABLED, "FONT_MANAGER_CATEGORY_INDEX_DISABLED", "disabled"}, {FONT_MANAGER_CATEGORY_INDEX_LANGUAGE, "FONT_MANAGER_CATEGORY_INDEX_LANGUAGE", "language"}, {FONT_MANAGER_CATEGORY_INDEX_N_CATEGORIES, "FONT_MANAGER_CATEGORY_INDEX_N_CATEGORIES", "n-categories"}, {0, NULL, NULL}};
	GType font_manager_category_index_type_id;
	font_manager_category_index_type_id = g_enum_register_static ("FontManagerCategoryIndex", values);
	return font_manager_category_index_type_id;
}

GType
font_manager_category_index_get_type (void)
{
	static volatile gsize font_manager_category_index_type_id__once = 0;
	if (g_once_init_enter (&font_manager_category_index_type_id__once)) {
		GType font_manager_category_index_type_id;
		font_manager_category_index_type_id = font_manager_category_index_get_type_once ();
		g_once_init_leave (&font_manager_category_index_type_id__once, font_manager_category_index_type_id);
	}
	return font_manager_category_index_type_id__once;
}

FontManagerCategoryListModel*
font_manager_category_list_model_construct (GType object_type)
{
	FontManagerCategoryListModel * self = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	self = (FontManagerCategoryListModel*) font_manager_font_list_filter_model_construct (object_type);
	_tmp0_ = font_manager_get_base_categories ();
	_tmp1_ = _tmp0_;
	font_manager_font_list_filter_model_set_items ((FontManagerFontListFilterModel*) self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) self));
	return self;
}

FontManagerCategoryListModel*
font_manager_category_list_model_new (void)
{
	return font_manager_category_list_model_construct (FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
font_manager_category_list_model_on_categories_updated (GObject* source,
                                                        GTask* task)
{
	FontManagerCategoryListModel* model = NULL;
	FontManagerCategoryListModel* _tmp0_;
	GValue _result_ = {0};
	GValue _tmp1_ = {0};
	guint n_items = 0U;
	void* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (task != NULL);
	g_return_if_fail (FONT_MANAGER_IS_CATEGORY_LIST_MODEL (source));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModel));
	model = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_PTR_ARRAY);
	_result_ = _tmp1_;
	{
		GValue _tmp2_ = {0};
		g_task_propagate_value (task, &_tmp2_, &_inner_error0_);
		G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
		_result_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e->message;
		g_critical ("Categories.vala:55: Failed to generate default categories : %s", _tmp3_);
		g_return_if_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	n_items = g_list_model_get_n_items ((GListModel*) model);
	font_manager_font_list_filter_model_set_items ((FontManagerFontListFilterModel*) model, NULL);
	g_list_model_items_changed ((GListModel*) model, (guint) 0, n_items, (guint) 0);
	_tmp4_ = g_value_get_boxed (&_result_);
	font_manager_font_list_filter_model_set_items ((FontManagerFontListFilterModel*) model, (GPtrArray*) _tmp4_);
	g_list_model_items_changed ((GListModel*) model, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) model));
	G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
	_g_object_unref0 (model);
	return;
}

static void
_font_manager_category_list_model_on_categories_updated_gasync_ready_callback (GObject* source_object,
                                                                               GTask* task,
                                                                               gpointer self)
{
	font_manager_category_list_model_on_categories_updated (source_object, task);
}

static void
_font_manager_get_default_categories_gtask_thread_func (GTask* task,
                                                        GObject* source_object,
                                                        void* task_data,
                                                        GCancellable* cancellable)
{
	font_manager_get_default_categories (task, source_object, task_data, cancellable);
}

void
font_manager_category_list_model_update_items (FontManagerCategoryListModel* self)
{
	GTask* task = NULL;
	GTask* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_task_new ((GObject*) self, NULL, _font_manager_category_list_model_on_categories_updated_gasync_ready_callback, NULL);
	task = _tmp0_;
	g_task_run_in_thread (task, _font_manager_get_default_categories_gtask_thread_func);
	_g_object_unref0 (task);
	return;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

GListModel*
font_manager_category_list_model_get_child_model (GObject* item)
{
	FontManagerCategory* category = NULL;
	FontManagerCategory* _tmp0_;
	FontManagerCategory* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	FontManagerCategoryListModel* child = NULL;
	FontManagerCategoryListModel* _tmp6_;
	FontManagerCategoryListModel* _tmp7_;
	FontManagerCategory* _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp10_;
	GListModel* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory));
	category = _tmp0_;
	_tmp1_ = category;
	_tmp2_ = font_manager_category_get_children (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ < 1) {
		result = NULL;
		_g_object_unref0 (category);
		return result;
	}
	_tmp6_ = font_manager_category_list_model_new ();
	child = _tmp6_;
	_tmp7_ = child;
	_tmp8_ = category;
	_tmp9_ = font_manager_category_get_children (_tmp8_);
	_tmp10_ = _tmp9_;
	font_manager_font_list_filter_model_set_items ((FontManagerFontListFilterModel*) _tmp7_, _tmp10_);
	result = (GListModel*) child;
	_g_object_unref0 (category);
	return result;
}

static void
font_manager_category_list_model_class_init (FontManagerCategoryListModelClass * klass,
                                             gpointer klass_data)
{
	font_manager_category_list_model_parent_class = g_type_class_peek_parent (klass);
}

static void
font_manager_category_list_model_instance_init (FontManagerCategoryListModel * self,
                                                gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
font_manager_category_list_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerCategoryListModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_category_list_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerCategoryListModel), 0, (GInstanceInitFunc) font_manager_category_list_model_instance_init, NULL };
	GType font_manager_category_list_model_type_id;
	font_manager_category_list_model_type_id = g_type_register_static (FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, "FontManagerCategoryListModel", &g_define_type_info, 0);
	return font_manager_category_list_model_type_id;
}

GType
font_manager_category_list_model_get_type (void)
{
	static volatile gsize font_manager_category_list_model_type_id__once = 0;
	if (g_once_init_enter (&font_manager_category_list_model_type_id__once)) {
		GType font_manager_category_list_model_type_id;
		font_manager_category_list_model_type_id = font_manager_category_list_model_get_type_once ();
		g_once_init_leave (&font_manager_category_list_model_type_id__once, font_manager_category_list_model_type_id);
	}
	return font_manager_category_list_model_type_id__once;
}

static inline gpointer
font_manager_category_list_row_get_instance_private (FontManagerCategoryListRow* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerCategoryListRow_private_offset);
}

static void
font_manager_category_list_row_real_reset (FontManagerListItemRow* base)
{
	FontManagerCategoryListRow * self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	self = (FontManagerCategoryListRow*) base;
	_tmp0_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
	_tmp1_ = _tmp0_;
	gtk_label_set_text (_tmp1_, "");
	_tmp2_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp3_ = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp5_, "");
	if (self->priv->handler_id != ((gulong) 0)) {
		GObject* _tmp6_;
		GObject* _tmp7_;
		_tmp6_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
		_tmp7_ = _tmp6_;
		g_signal_handler_disconnect (_tmp7_, self->priv->handler_id);
	}
	return;
}

static void
_font_manager_list_item_row_on_item_set_font_manager_cacheable_changed (FontManagerCacheable* _sender,
                                                                        gpointer self)
{
	font_manager_list_item_row_on_item_set ((FontManagerListItemRow*) self);
}

static void
font_manager_category_list_row_real_on_item_set (FontManagerListItemRow* base)
{
	FontManagerCategoryListRow * self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	FontManagerCategory* category = NULL;
	GObject* _tmp2_;
	GObject* _tmp3_;
	FontManagerCategory* _tmp4_;
	FontManagerCategory* _tmp5_;
	gulong _tmp6_;
	gint index = 0;
	FontManagerCategory* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean root_node = FALSE;
	FontManagerCategory* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean root_count = FALSE;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	FontManagerCategory* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_ = FALSE;
	GtkImage* _tmp23_;
	GtkImage* _tmp24_;
	gboolean _tmp25_ = FALSE;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	gboolean _tmp30_ = FALSE;
	GtkImage* _tmp36_;
	GtkImage* _tmp37_;
	FontManagerCategory* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GtkLabel* _tmp42_;
	GtkLabel* _tmp43_;
	FontManagerCategory* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_ = NULL;
	FontManagerCategory* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gboolean _tmp54_;
	self = (FontManagerCategoryListRow*) base;
	font_manager_list_item_row_reset ((FontManagerListItemRow*) self);
	_tmp0_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory));
	category = _tmp4_;
	_tmp5_ = category;
	_tmp6_ = g_signal_connect_object ((FontManagerCacheable*) _tmp5_, "changed", (GCallback) _font_manager_list_item_row_on_item_set_font_manager_cacheable_changed, (FontManagerListItemRow*) self, 0);
	self->priv->handler_id = _tmp6_;
	_tmp7_ = category;
	_tmp8_ = font_manager_font_list_filter_get_index ((FontManagerFontListFilter*) _tmp7_);
	_tmp9_ = _tmp8_;
	index = _tmp9_;
	_tmp10_ = category;
	_tmp11_ = font_manager_font_list_filter_get_depth ((FontManagerFontListFilter*) _tmp10_);
	_tmp12_ = _tmp11_;
	root_node = _tmp12_ < 1;
	if (root_node) {
		gboolean _tmp14_ = FALSE;
		if (index < ((gint) FONT_MANAGER_CATEGORY_INDEX_PANOSE)) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = index > ((gint) FONT_MANAGER_CATEGORY_INDEX_FILETYPE);
		}
		_tmp13_ = _tmp14_;
	} else {
		_tmp13_ = FALSE;
	}
	root_count = _tmp13_;
	_tmp15_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = category;
	_tmp18_ = font_manager_font_list_filter_get_name ((FontManagerFontListFilter*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	gtk_label_set_text (_tmp16_, _tmp20_);
	_g_free0 (_tmp20_);
	if (root_count) {
		_tmp21_ = TRUE;
	} else {
		gboolean _tmp22_ = FALSE;
		if (root_node) {
			_tmp22_ = index == ((gint) FONT_MANAGER_CATEGORY_INDEX_LANGUAGE);
		} else {
			_tmp22_ = FALSE;
		}
		_tmp21_ = _tmp22_;
	}
	_tmp23_ = font_manager_list_item_row_get_item_icon ((FontManagerListItemRow*) self);
	_tmp24_ = _tmp23_;
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, _tmp21_);
	if (!root_node) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = root_count;
	}
	_tmp26_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp27_ = _tmp26_;
	gtk_widget_set_visible ((GtkWidget*) _tmp27_, _tmp25_);
	if (index == ((gint) FONT_MANAGER_CATEGORY_INDEX_LANGUAGE)) {
		GtkLabel* _tmp28_;
		GtkLabel* _tmp29_;
		_tmp28_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
		_tmp29_ = _tmp28_;
		gtk_label_set_ellipsize (_tmp29_, PANGO_ELLIPSIZE_NONE);
	}
	if (root_node) {
		gboolean _tmp31_ = FALSE;
		if (index >= ((gint) FONT_MANAGER_CATEGORY_INDEX_PANOSE)) {
			_tmp31_ = index <= ((gint) FONT_MANAGER_CATEGORY_INDEX_FILETYPE);
		} else {
			_tmp31_ = FALSE;
		}
		_tmp30_ = _tmp31_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GtkLabel* _tmp32_;
		GtkLabel* _tmp33_;
		_tmp32_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
		_tmp33_ = _tmp32_;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp33_, 3);
	} else {
		if (!root_node) {
			GtkLabel* _tmp34_;
			GtkLabel* _tmp35_;
			_tmp34_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
			_tmp35_ = _tmp34_;
			gtk_widget_set_margin_start ((GtkWidget*) _tmp35_, 0);
		}
	}
	_tmp36_ = font_manager_list_item_row_get_item_icon ((FontManagerListItemRow*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = category;
	_tmp39_ = font_manager_font_list_filter_get_icon ((FontManagerFontListFilter*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = _tmp40_;
	gtk_image_set_from_icon_name (_tmp37_, _tmp41_);
	_g_free0 (_tmp41_);
	_tmp42_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = category;
	_tmp45_ = font_manager_font_list_filter_get_size ((FontManagerFontListFilter*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_strdup_printf ("%i", _tmp46_);
	_tmp48_ = _tmp47_;
	gtk_label_set_label (_tmp43_, _tmp48_);
	_g_free0 (_tmp48_);
	_tmp50_ = category;
	_tmp51_ = font_manager_font_list_filter_get_comment ((FontManagerFontListFilter*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = _tmp52_;
	_tmp54_ = _tmp53_ != NULL;
	_g_free0 (_tmp53_);
	if (_tmp54_) {
		FontManagerCategory* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp55_ = category;
		_tmp56_ = font_manager_font_list_filter_get_comment ((FontManagerFontListFilter*) _tmp55_);
		_tmp57_ = _tmp56_;
		_g_free0 (_tmp49_);
		_tmp49_ = _tmp57_;
	} else {
		FontManagerCategory* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp58_ = category;
		_tmp59_ = font_manager_font_list_filter_get_name ((FontManagerFontListFilter*) _tmp58_);
		_tmp60_ = _tmp59_;
		_g_free0 (_tmp49_);
		_tmp49_ = _tmp60_;
	}
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp49_);
	_g_free0 (_tmp49_);
	_g_object_unref0 (category);
	return;
}

FontManagerCategoryListRow*
font_manager_category_list_row_construct (GType object_type)
{
	FontManagerCategoryListRow * self = NULL;
	self = (FontManagerCategoryListRow*) font_manager_tree_list_item_row_construct (object_type);
	return self;
}

FontManagerCategoryListRow*
font_manager_category_list_row_new (void)
{
	return font_manager_category_list_row_construct (FONT_MANAGER_TYPE_CATEGORY_LIST_ROW);
}

static void
font_manager_category_list_row_class_init (FontManagerCategoryListRowClass * klass,
                                           gpointer klass_data)
{
	font_manager_category_list_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerCategoryListRow_private_offset);
	((FontManagerListItemRowClass *) klass)->reset = (void (*) (FontManagerListItemRow*)) font_manager_category_list_row_real_reset;
	((FontManagerListItemRowClass *) klass)->on_item_set = (void (*) (FontManagerListItemRow*)) font_manager_category_list_row_real_on_item_set;
	G_OBJECT_CLASS (klass)->finalize = font_manager_category_list_row_finalize;
}

static void
font_manager_category_list_row_instance_init (FontManagerCategoryListRow * self,
                                              gpointer klass)
{
	self->priv = font_manager_category_list_row_get_instance_private (self);
	self->priv->handler_id = (gulong) 0;
}

static void
font_manager_category_list_row_finalize (GObject * obj)
{
	FontManagerCategoryListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_CATEGORY_LIST_ROW, FontManagerCategoryListRow);
	G_OBJECT_CLASS (font_manager_category_list_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_category_list_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerCategoryListRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_category_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerCategoryListRow), 0, (GInstanceInitFunc) font_manager_category_list_row_instance_init, NULL };
	GType font_manager_category_list_row_type_id;
	font_manager_category_list_row_type_id = g_type_register_static (FONT_MANAGER_TYPE_TREE_LIST_ITEM_ROW, "FontManagerCategoryListRow", &g_define_type_info, 0);
	FontManagerCategoryListRow_private_offset = g_type_add_instance_private (font_manager_category_list_row_type_id, sizeof (FontManagerCategoryListRowPrivate));
	return font_manager_category_list_row_type_id;
}

GType
font_manager_category_list_row_get_type (void)
{
	static volatile gsize font_manager_category_list_row_type_id__once = 0;
	if (g_once_init_enter (&font_manager_category_list_row_type_id__once)) {
		GType font_manager_category_list_row_type_id;
		font_manager_category_list_row_type_id = font_manager_category_list_row_get_type_once ();
		g_once_init_leave (&font_manager_category_list_row_type_id__once, font_manager_category_list_row_type_id);
	}
	return font_manager_category_list_row_type_id__once;
}

static inline gpointer
font_manager_category_list_view_get_instance_private (FontManagerCategoryListView* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerCategoryListView_private_offset);
}

void
font_manager_category_list_view_select_item (FontManagerCategoryListView* self,
                                             guint position)
{
	GtkListView* _tmp0_;
	GtkListView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FontManagerFilterListView*) self)->listview;
	gtk_widget_activate_action ((GtkWidget*) _tmp0_, "list.select-item", "(ubb)", position, FALSE, FALSE, NULL);
	_tmp1_ = ((FontManagerFilterListView*) self)->listview;
	gtk_widget_activate_action ((GtkWidget*) _tmp1_, "list.scroll-to-item", "u", position, NULL);
	return;
}

static void
font_manager_category_list_view_real_on_selection_changed (FontManagerFilterListView* base,
                                                           guint position,
                                                           guint n_items)
{
	FontManagerCategoryListView * self;
	GtkSingleSelection* _tmp0_;
	GtkSingleSelection* _tmp1_;
	GtkTreeListModel* _tmp2_;
	GtkTreeListModel* _tmp3_;
	FontManagerFontListFilter* _tmp4_;
	FontManagerFontListFilter* _tmp5_;
	FontManagerCategory* category = NULL;
	FontManagerFontListFilter* _tmp6_;
	FontManagerFontListFilter* _tmp7_;
	FontManagerCategory* _tmp8_;
	gboolean _tmp9_ = FALSE;
	FontManagerCategory* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	self = (FontManagerCategoryListView*) base;
	_tmp0_ = font_manager_filter_list_view_get_selection ((FontManagerFilterListView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = font_manager_filter_list_view_get_treemodel ((FontManagerFilterListView*) self);
	_tmp3_ = _tmp2_;
	_vala_return_if_fail ((_tmp1_ != NULL) && (_tmp3_ != NULL), "selection != null && treemodel != null");
	FONT_MANAGER_FILTER_LIST_VIEW_CLASS (font_manager_category_list_view_parent_class)->on_selection_changed (G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_FILTER_LIST_VIEW, FontManagerFilterListView), position, n_items);
	_tmp4_ = font_manager_filter_list_view_get_selected_item ((FontManagerFilterListView*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		return;
	}
	_tmp6_ = font_manager_filter_list_view_get_selected_item ((FontManagerFilterListView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory));
	category = _tmp8_;
	_tmp10_ = category;
	_tmp11_ = font_manager_font_list_filter_get_index ((FontManagerFontListFilter*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ >= ((gint) FONT_MANAGER_CATEGORY_INDEX_PANOSE)) {
		_tmp9_ = TRUE;
	} else {
		FontManagerCategory* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp13_ = category;
		_tmp14_ = font_manager_font_list_filter_get_index ((FontManagerFontListFilter*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp9_ = _tmp15_ <= ((gint) FONT_MANAGER_CATEGORY_INDEX_FILETYPE);
	}
	if (_tmp9_) {
		FontManagerCategory* _tmp16_;
		_tmp16_ = category;
		font_manager_font_list_filter_update ((FontManagerFontListFilter*) _tmp16_, NULL, NULL);
	}
	_g_object_unref0 (category);
	return;
}

static void
font_manager_category_list_view_real_setup_list_row (FontManagerFilterListView* base,
                                                     GtkSignalListItemFactory* factory,
                                                     GObject* item)
{
	FontManagerCategoryListView * self;
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GtkTreeExpander* tree_expander = NULL;
	GtkTreeExpander* _tmp1_;
	FontManagerCategoryListRow* row = NULL;
	FontManagerCategoryListRow* _tmp2_;
	GtkSingleSelection* _tmp3_;
	GtkSingleSelection* _tmp4_;
	self = (FontManagerCategoryListView*) base;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = (GtkTreeExpander*) gtk_tree_expander_new ();
	g_object_ref_sink (_tmp1_);
	tree_expander = _tmp1_;
	gtk_tree_expander_set_indent_for_icon (tree_expander, FALSE);
	_tmp2_ = font_manager_category_list_row_new ();
	g_object_ref_sink (_tmp2_);
	row = _tmp2_;
	font_manager_tree_list_item_row_set_expander ((FontManagerTreeListItemRow*) row, tree_expander);
	_tmp3_ = font_manager_filter_list_view_get_selection ((FontManagerFilterListView*) self);
	_tmp4_ = _tmp3_;
	font_manager_tree_list_item_row_set_selection ((FontManagerTreeListItemRow*) row, (GtkSelectionModel*) _tmp4_);
	gtk_tree_expander_set_child (tree_expander, (GtkWidget*) row);
	gtk_list_item_set_child (list_item, (GtkWidget*) tree_expander);
	_g_object_unref0 (row);
	_g_object_unref0 (tree_expander);
	_g_object_unref0 (list_item);
	return;
}

static void
__lambda32_ (FontManagerCategoryListView* self,
             GObject* obj,
             GAsyncResult* res)
{
	FontManagerDisabled* _tmp0_;
	FontManagerFontListFilterModel* _tmp1_;
	FontManagerFontListFilterModel* _tmp2_;
	FontManagerFontListFilter* _tmp3_;
	FontManagerFontListFilter* _tmp4_;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->_disabled;
	font_manager_font_list_filter_update_finish ((FontManagerFontListFilter*) _tmp0_, res);
	_tmp1_ = font_manager_filter_list_view_get_model ((FontManagerFilterListView*) self);
	_tmp2_ = _tmp1_;
	g_list_model_items_changed ((GListModel*) _tmp2_, (guint) 0, (guint) 0, (guint) 0);
	_tmp3_ = font_manager_filter_list_view_get_selected_item ((FontManagerFilterListView*) self);
	_tmp4_ = _tmp3_;
	if (FONT_MANAGER_IS_DISABLED (_tmp4_)) {
		FontManagerFontListFilter* _tmp5_;
		FontManagerFontListFilter* _tmp6_;
		g_signal_emit_by_name ((FontManagerFilterListView*) self, "selection-changed", NULL);
		_tmp5_ = font_manager_filter_list_view_get_selected_item ((FontManagerFilterListView*) self);
		_tmp6_ = _tmp5_;
		g_signal_emit_by_name ((FontManagerFilterListView*) self, "selection-changed", _tmp6_);
	}
}

static void
___lambda32__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda32_ ((FontManagerCategoryListView*) self, source_object, res);
	g_object_unref (self);
}

static void
font_manager_category_list_view_update_disabled (FontManagerCategoryListView* self)
{
	gboolean _tmp0_ = FALSE;
	FontManagerDisabled* _tmp1_;
	FontManagerDisabled* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_disabled;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FontManagerReject* _tmp2_;
		_tmp2_ = self->priv->_disabled_families;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->_disabled;
	font_manager_font_list_filter_update ((FontManagerFontListFilter*) _tmp3_, ___lambda32__gasync_ready_callback, g_object_ref (self));
	return;
}

static void
__lambda33_ (FontManagerCategoryListView* self,
             GObject* obj,
             GAsyncResult* res)
{
	FontManagerUnsorted* _tmp0_;
	FontManagerFontListFilterModel* _tmp1_;
	FontManagerFontListFilterModel* _tmp2_;
	FontManagerFontListFilter* _tmp3_;
	FontManagerFontListFilter* _tmp4_;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->_unsorted;
	font_manager_unsorted_update_finish (_tmp0_, res);
	_tmp1_ = font_manager_filter_list_view_get_model ((FontManagerFilterListView*) self);
	_tmp2_ = _tmp1_;
	g_list_model_items_changed ((GListModel*) _tmp2_, (guint) 0, (guint) 0, (guint) 0);
	_tmp3_ = font_manager_filter_list_view_get_selected_item ((FontManagerFilterListView*) self);
	_tmp4_ = _tmp3_;
	if (FONT_MANAGER_IS_UNSORTED (_tmp4_)) {
		FontManagerFontListFilter* _tmp5_;
		FontManagerFontListFilter* _tmp6_;
		g_signal_emit_by_name ((FontManagerFilterListView*) self, "selection-changed", NULL);
		_tmp5_ = font_manager_filter_list_view_get_selected_item ((FontManagerFilterListView*) self);
		_tmp6_ = _tmp5_;
		g_signal_emit_by_name ((FontManagerFilterListView*) self, "selection-changed", _tmp6_);
	}
}

static void
___lambda33__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda33_ ((FontManagerCategoryListView*) self, source_object, res);
	g_object_unref (self);
}

static void
font_manager_category_list_view_update_unsorted (FontManagerCategoryListView* self)
{
	FontManagerUnsorted* _tmp0_;
	FontManagerUnsorted* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_unsorted;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_unsorted;
	font_manager_unsorted_update (_tmp1_, ___lambda33__gasync_ready_callback, g_object_ref (self));
	return;
}

static void
______lambda34_ (FontManagerCategoryListView* self)
{
	FontManagerFontListFilter* _tmp0_;
	FontManagerFontListFilter* _tmp1_;
	_tmp0_ = font_manager_filter_list_view_get_selected_item ((FontManagerFilterListView*) self);
	_tmp1_ = _tmp0_;
	if (FONT_MANAGER_IS_LANGUAGE_FILTER (_tmp1_)) {
		FontManagerFontListFilter* _tmp2_;
		FontManagerFontListFilter* _tmp3_;
		g_signal_emit_by_name ((FontManagerFilterListView*) self, "selection-changed", NULL);
		_tmp2_ = font_manager_filter_list_view_get_selected_item ((FontManagerFilterListView*) self);
		_tmp3_ = _tmp2_;
		g_signal_emit_by_name ((FontManagerFilterListView*) self, "selection-changed", _tmp3_);
	}
}

static void
_______lambda34__font_manager_cacheable_changed (FontManagerCacheable* _sender,
                                                 gpointer self)
{
	______lambda34_ ((FontManagerCategoryListView*) self);
}

static void
font_manager_category_list_view_real_bind_list_row (FontManagerFilterListView* base,
                                                    GtkSignalListItemFactory* factory,
                                                    GObject* item)
{
	FontManagerCategoryListView * self;
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GtkTreeListRow* list_row = NULL;
	GtkTreeListModel* _tmp1_;
	GtkTreeListModel* _tmp2_;
	GtkListItem* _tmp3_;
	GtkTreeListRow* _tmp4_;
	GtkTreeExpander* tree_expander = NULL;
	GtkListItem* _tmp5_;
	GtkWidget* _tmp6_;
	GtkTreeExpander* _tmp7_;
	GtkTreeExpander* _tmp8_;
	GtkTreeExpander* _tmp9_;
	GtkTreeListRow* _tmp10_;
	FontManagerCategoryListRow* row = NULL;
	GtkTreeExpander* _tmp11_;
	GtkWidget* _tmp12_;
	FontManagerCategoryListRow* _tmp13_;
	GObject* _item = NULL;
	GtkTreeListRow* _tmp14_;
	GObject* _tmp15_;
	FontManagerCategoryListRow* _tmp16_;
	GObject* _tmp17_;
	GObject* _tmp18_;
	FontManagerCategory* category = NULL;
	GObject* _tmp19_;
	FontManagerCategory* _tmp20_;
	FontManagerCategory* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	self = (FontManagerCategoryListView*) base;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = font_manager_filter_list_view_get_treemodel ((FontManagerFilterListView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = list_item;
	_tmp4_ = gtk_tree_list_model_get_row (_tmp2_, gtk_list_item_get_position (_tmp3_));
	list_row = _tmp4_;
	_tmp5_ = list_item;
	_tmp6_ = gtk_list_item_get_child (_tmp5_);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_expander_get_type (), GtkTreeExpander));
	tree_expander = _tmp7_;
	_tmp8_ = tree_expander;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 2);
	_tmp9_ = tree_expander;
	_tmp10_ = list_row;
	gtk_tree_expander_set_list_row (_tmp9_, _tmp10_);
	_tmp11_ = tree_expander;
	_tmp12_ = gtk_tree_expander_get_child (_tmp11_);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, FONT_MANAGER_TYPE_CATEGORY_LIST_ROW, FontManagerCategoryListRow));
	row = _tmp13_;
	_tmp14_ = list_row;
	_tmp15_ = gtk_tree_list_row_get_item (_tmp14_);
	_item = _tmp15_;
	_tmp16_ = row;
	_tmp17_ = _item;
	font_manager_list_item_row_set_item ((FontManagerListItemRow*) _tmp16_, _tmp17_);
	_tmp18_ = _item;
	g_return_if_fail (_tmp18_ != NULL);
	_tmp19_ = _item;
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory));
	category = _tmp20_;
	_tmp21_ = category;
	_tmp22_ = font_manager_font_list_filter_get_index ((FontManagerFontListFilter*) _tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ < ((gint) FONT_MANAGER_CATEGORY_INDEX_PANOSE)) {
		FontManagerCategory* _tmp24_;
		_tmp24_ = category;
		font_manager_font_list_filter_update ((FontManagerFontListFilter*) _tmp24_, NULL, NULL);
	} else {
		FontManagerCategory* _tmp25_;
		_tmp25_ = category;
		if (FONT_MANAGER_IS_DISABLED (_tmp25_)) {
			FontManagerCategory* _tmp26_;
			GBindingFlags flags = 0U;
			FontManagerDisabled* _tmp27_;
			_tmp26_ = category;
			font_manager_category_list_view_set_disabled (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, FONT_MANAGER_TYPE_DISABLED, FontManagerDisabled));
			flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
			_tmp27_ = self->priv->_disabled;
			g_object_bind_property_with_closures ((GObject*) self, "disabled-families", (GObject*) _tmp27_, "disabled-families", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		} else {
			FontManagerCategory* _tmp28_;
			_tmp28_ = category;
			if (FONT_MANAGER_IS_UNSORTED (_tmp28_)) {
				FontManagerCategory* _tmp29_;
				GBindingFlags flags = 0U;
				FontManagerUnsorted* _tmp30_;
				_tmp29_ = category;
				font_manager_category_list_view_set_unsorted (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, FONT_MANAGER_TYPE_UNSORTED, FontManagerUnsorted));
				flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
				_tmp30_ = self->priv->_unsorted;
				g_object_bind_property_with_closures ((GObject*) self, "sorted", (GObject*) _tmp30_, "sorted", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
				font_manager_category_list_view_update_unsorted (self);
			} else {
				FontManagerCategory* _tmp31_;
				_tmp31_ = category;
				if (FONT_MANAGER_IS_LANGUAGE_FILTER (_tmp31_)) {
					FontManagerCategory* _tmp32_;
					FontManagerLanguageFilter* _tmp33_;
					_tmp32_ = category;
					font_manager_category_list_view_set_language_filter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, FONT_MANAGER_TYPE_LANGUAGE_FILTER, FontManagerLanguageFilter));
					_tmp33_ = self->priv->_language_filter;
					g_signal_connect_object ((FontManagerCacheable*) _tmp33_, "changed", (GCallback) _______lambda34__font_manager_cacheable_changed, self, 0);
				}
			}
		}
	}
	_g_object_unref0 (category);
	_g_object_unref0 (_item);
	_g_object_unref0 (row);
	_g_object_unref0 (tree_expander);
	_g_object_unref0 (list_row);
	_g_object_unref0 (list_item);
	return;
}

FontManagerCategoryListView*
font_manager_category_list_view_construct (GType object_type)
{
	FontManagerCategoryListView * self = NULL;
	self = (FontManagerCategoryListView*) font_manager_filter_list_view_construct (object_type);
	return self;
}

FontManagerCategoryListView*
font_manager_category_list_view_new (void)
{
	return font_manager_category_list_view_construct (FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW);
}

FontManagerReject*
font_manager_category_list_view_get_disabled_families (FontManagerCategoryListView* self)
{
	FontManagerReject* result;
	FontManagerReject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disabled_families;
	result = _tmp0_;
	return result;
}

void
font_manager_category_list_view_set_disabled_families (FontManagerCategoryListView* self,
                                                       FontManagerReject* value)
{
	FontManagerReject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_list_view_get_disabled_families (self);
	if (old_value != value) {
		FontManagerReject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_disabled_families);
		self->priv->_disabled_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_FAMILIES_PROPERTY]);
	}
}

FontManagerDisabled*
font_manager_category_list_view_get_disabled (FontManagerCategoryListView* self)
{
	FontManagerDisabled* result;
	FontManagerDisabled* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disabled;
	result = _tmp0_;
	return result;
}

void
font_manager_category_list_view_set_disabled (FontManagerCategoryListView* self,
                                              FontManagerDisabled* value)
{
	FontManagerDisabled* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_list_view_get_disabled (self);
	if (old_value != value) {
		FontManagerDisabled* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_disabled);
		self->priv->_disabled = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_PROPERTY]);
	}
}

FontManagerStringSet*
font_manager_category_list_view_get_sorted (FontManagerCategoryListView* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sorted;
	result = _tmp0_;
	return result;
}

void
font_manager_category_list_view_set_sorted (FontManagerCategoryListView* self,
                                            FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_list_view_get_sorted (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sorted);
		self->priv->_sorted = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_SORTED_PROPERTY]);
	}
}

FontManagerUnsorted*
font_manager_category_list_view_get_unsorted (FontManagerCategoryListView* self)
{
	FontManagerUnsorted* result;
	FontManagerUnsorted* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_unsorted;
	result = _tmp0_;
	return result;
}

void
font_manager_category_list_view_set_unsorted (FontManagerCategoryListView* self,
                                              FontManagerUnsorted* value)
{
	FontManagerUnsorted* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_list_view_get_unsorted (self);
	if (old_value != value) {
		FontManagerUnsorted* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_unsorted);
		self->priv->_unsorted = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_UNSORTED_PROPERTY]);
	}
}

FontManagerLanguageFilter*
font_manager_category_list_view_get_language_filter (FontManagerCategoryListView* self)
{
	FontManagerLanguageFilter* result;
	FontManagerLanguageFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_language_filter;
	result = _tmp0_;
	return result;
}

void
font_manager_category_list_view_set_language_filter (FontManagerCategoryListView* self,
                                                     FontManagerLanguageFilter* value)
{
	FontManagerLanguageFilter* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_category_list_view_get_language_filter (self);
	if (old_value != value) {
		FontManagerLanguageFilter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_language_filter);
		self->priv->_language_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_LANGUAGE_FILTER_PROPERTY]);
	}
}

static GListModel*
_font_manager_category_list_model_get_child_model_gtk_tree_list_model_create_model_func (GObject* item,
                                                                                         gpointer self)
{
	GListModel* result;
	result = font_manager_category_list_model_get_child_model (item);
	return result;
}

static void
_font_manager_category_list_view___lambda38_ (FontManagerCategoryListView* self)
{
	font_manager_category_list_view_update_disabled (self);
}

static void
__font_manager_category_list_view___lambda38__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	_font_manager_category_list_view___lambda38_ ((FontManagerCategoryListView*) self);
}

static void
_font_manager_category_list_view___lambda39_ (FontManagerCategoryListView* self)
{
	font_manager_category_list_view_update_unsorted (self);
}

static void
__font_manager_category_list_view___lambda39__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	_font_manager_category_list_view___lambda39_ ((FontManagerCategoryListView*) self);
}

static void
___lambda41_ (FontManagerCategoryListView* self)
{
	font_manager_category_list_view_update_disabled (self);
}

static void
____lambda41__font_manager_string_set_changed (FontManagerStringSet* _sender,
                                               gpointer self)
{
	___lambda41_ ((FontManagerCategoryListView*) self);
}

static void
_font_manager_category_list_view___lambda40_ (FontManagerCategoryListView* self)
{
	FontManagerReject* _tmp0_;
	_tmp0_ = self->priv->_disabled_families;
	if (_tmp0_ != NULL) {
		FontManagerReject* _tmp1_;
		_tmp1_ = self->priv->_disabled_families;
		g_signal_connect_object ((FontManagerStringSet*) _tmp1_, "changed", (GCallback) ____lambda41__font_manager_string_set_changed, self, 0);
	}
	font_manager_category_list_view_update_disabled (self);
}

static void
__font_manager_category_list_view___lambda40__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	_font_manager_category_list_view___lambda40_ ((FontManagerCategoryListView*) self);
}

static GObject *
font_manager_category_list_view_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerCategoryListView * self;
	GtkListView* _tmp0_;
	FontManagerCategoryListModel* _tmp1_;
	GtkTreeListModel* _tmp2_;
	GtkTreeListModel* _tmp3_;
	GtkTreeListModel* _tmp4_;
	GtkTreeListModel* _tmp5_;
	GListModel* _tmp6_;
	GtkSingleSelection* _tmp7_;
	GtkSingleSelection* _tmp8_;
	GtkSingleSelection* _tmp9_;
	GtkSingleSelection* _tmp10_;
	parent_class = G_OBJECT_CLASS (font_manager_category_list_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW, FontManagerCategoryListView);
	_tmp0_ = ((FontManagerFilterListView*) self)->listview;
	font_manager_widget_set_name ((GtkWidget*) _tmp0_, "FontManagerCategoryListView");
	_tmp1_ = font_manager_category_list_model_new ();
	_tmp2_ = gtk_tree_list_model_new ((GListModel*) _tmp1_, FALSE, FALSE, _font_manager_category_list_model_get_child_model_gtk_tree_list_model_create_model_func, NULL, NULL);
	_tmp3_ = _tmp2_;
	font_manager_filter_list_view_set_treemodel ((FontManagerFilterListView*) self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = font_manager_filter_list_view_get_treemodel ((FontManagerFilterListView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 ((GListModel*) _tmp5_);
	_tmp7_ = gtk_single_selection_new (_tmp6_);
	_tmp8_ = _tmp7_;
	font_manager_filter_list_view_set_selection ((FontManagerFilterListView*) self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_signal_connect_object ((GObject*) self, "notify::disabled", (GCallback) __font_manager_category_list_view___lambda38__g_object_notify, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GObject*) self, "notify::sorted", (GCallback) __font_manager_category_list_view___lambda39__g_object_notify, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GObject*) self, "notify::disabled-families", (GCallback) __font_manager_category_list_view___lambda40__g_object_notify, self, G_CONNECT_AFTER);
	_tmp9_ = font_manager_filter_list_view_get_selection ((FontManagerFilterListView*) self);
	_tmp10_ = _tmp9_;
	gtk_single_selection_set_selected (_tmp10_, GTK_INVALID_LIST_POSITION);
	return obj;
}

static void
font_manager_category_list_view_class_init (FontManagerCategoryListViewClass * klass,
                                            gpointer klass_data)
{
	font_manager_category_list_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerCategoryListView_private_offset);
	((FontManagerFilterListViewClass *) klass)->on_selection_changed = (void (*) (FontManagerFilterListView*, guint, guint)) font_manager_category_list_view_real_on_selection_changed;
	((FontManagerFilterListViewClass *) klass)->setup_list_row = (void (*) (FontManagerFilterListView*, GtkSignalListItemFactory*, GObject*)) font_manager_category_list_view_real_setup_list_row;
	((FontManagerFilterListViewClass *) klass)->bind_list_row = (void (*) (FontManagerFilterListView*, GtkSignalListItemFactory*, GObject*)) font_manager_category_list_view_real_bind_list_row;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_category_list_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_category_list_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_category_list_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_category_list_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_FAMILIES_PROPERTY, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_FAMILIES_PROPERTY] = g_param_spec_object ("disabled-families", "disabled-families", "disabled-families", font_manager_reject_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_PROPERTY, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_PROPERTY] = g_param_spec_object ("disabled", "disabled", "disabled", FONT_MANAGER_TYPE_DISABLED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_LIST_VIEW_SORTED_PROPERTY, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_SORTED_PROPERTY] = g_param_spec_object ("sorted", "sorted", "sorted", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_LIST_VIEW_UNSORTED_PROPERTY, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_UNSORTED_PROPERTY] = g_param_spec_object ("unsorted", "unsorted", "unsorted", FONT_MANAGER_TYPE_UNSORTED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_CATEGORY_LIST_VIEW_LANGUAGE_FILTER_PROPERTY, font_manager_category_list_view_properties[FONT_MANAGER_CATEGORY_LIST_VIEW_LANGUAGE_FILTER_PROPERTY] = g_param_spec_object ("language-filter", "language-filter", "language-filter", FONT_MANAGER_TYPE_LANGUAGE_FILTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_category_list_view_instance_init (FontManagerCategoryListView * self,
                                               gpointer klass)
{
	FontManagerStringSet* _tmp0_;
	self->priv = font_manager_category_list_view_get_instance_private (self);
	self->priv->_disabled_families = NULL;
	self->priv->_disabled = NULL;
	_tmp0_ = font_manager_string_set_new ();
	self->priv->_sorted = _tmp0_;
	self->priv->_unsorted = NULL;
	self->priv->_language_filter = NULL;
}

static void
font_manager_category_list_view_finalize (GObject * obj)
{
	FontManagerCategoryListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW, FontManagerCategoryListView);
	_g_object_unref0 (self->priv->_disabled_families);
	_g_object_unref0 (self->priv->_disabled);
	_g_object_unref0 (self->priv->_sorted);
	_g_object_unref0 (self->priv->_unsorted);
	_g_object_unref0 (self->priv->_language_filter);
	G_OBJECT_CLASS (font_manager_category_list_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_category_list_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerCategoryListViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_category_list_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerCategoryListView), 0, (GInstanceInitFunc) font_manager_category_list_view_instance_init, NULL };
	GType font_manager_category_list_view_type_id;
	font_manager_category_list_view_type_id = g_type_register_static (FONT_MANAGER_TYPE_FILTER_LIST_VIEW, "FontManagerCategoryListView", &g_define_type_info, 0);
	FontManagerCategoryListView_private_offset = g_type_add_instance_private (font_manager_category_list_view_type_id, sizeof (FontManagerCategoryListViewPrivate));
	return font_manager_category_list_view_type_id;
}

GType
font_manager_category_list_view_get_type (void)
{
	static volatile gsize font_manager_category_list_view_type_id__once = 0;
	if (g_once_init_enter (&font_manager_category_list_view_type_id__once)) {
		GType font_manager_category_list_view_type_id;
		font_manager_category_list_view_type_id = font_manager_category_list_view_get_type_once ();
		g_once_init_leave (&font_manager_category_list_view_type_id__once, font_manager_category_list_view_type_id);
	}
	return font_manager_category_list_view_type_id__once;
}

static void
_vala_font_manager_category_list_view_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	FontManagerCategoryListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW, FontManagerCategoryListView);
	switch (property_id) {
		case FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_FAMILIES_PROPERTY:
		g_value_set_object (value, font_manager_category_list_view_get_disabled_families (self));
		break;
		case FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_PROPERTY:
		g_value_set_object (value, font_manager_category_list_view_get_disabled (self));
		break;
		case FONT_MANAGER_CATEGORY_LIST_VIEW_SORTED_PROPERTY:
		g_value_set_object (value, font_manager_category_list_view_get_sorted (self));
		break;
		case FONT_MANAGER_CATEGORY_LIST_VIEW_UNSORTED_PROPERTY:
		g_value_set_object (value, font_manager_category_list_view_get_unsorted (self));
		break;
		case FONT_MANAGER_CATEGORY_LIST_VIEW_LANGUAGE_FILTER_PROPERTY:
		g_value_set_object (value, font_manager_category_list_view_get_language_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_category_list_view_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	FontManagerCategoryListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_CATEGORY_LIST_VIEW, FontManagerCategoryListView);
	switch (property_id) {
		case FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_FAMILIES_PROPERTY:
		font_manager_category_list_view_set_disabled_families (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_CATEGORY_LIST_VIEW_DISABLED_PROPERTY:
		font_manager_category_list_view_set_disabled (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_CATEGORY_LIST_VIEW_SORTED_PROPERTY:
		font_manager_category_list_view_set_sorted (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_CATEGORY_LIST_VIEW_UNSORTED_PROPERTY:
		font_manager_category_list_view_set_unsorted (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_CATEGORY_LIST_VIEW_LANGUAGE_FILTER_PROPERTY:
		font_manager_category_list_view_set_language_filter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
font_manager_filter_data_copy (const FontManagerFilterData* self,
                               FontManagerFilterData* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	(*dest).index = (*self).index;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).comment;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).comment);
	(*dest).comment = _tmp3_;
	_tmp4_ = (*self).column;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).column);
	(*dest).column = _tmp5_;
}

void
font_manager_filter_data_destroy (FontManagerFilterData* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).comment);
	_g_free0 ((*self).column);
}

FontManagerFilterData*
font_manager_filter_data_dup (const FontManagerFilterData* self)
{
	FontManagerFilterData* dup;
	dup = g_new0 (FontManagerFilterData, 1);
	font_manager_filter_data_copy (self, dup);
	return dup;
}

void
font_manager_filter_data_free (FontManagerFilterData* self)
{
	font_manager_filter_data_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
font_manager_filter_data_get_type_once (void)
{
	GType font_manager_filter_data_type_id;
	font_manager_filter_data_type_id = g_boxed_type_register_static ("FontManagerFilterData", (GBoxedCopyFunc) font_manager_filter_data_dup, (GBoxedFreeFunc) font_manager_filter_data_free);
	return font_manager_filter_data_type_id;
}

GType
font_manager_filter_data_get_type (void)
{
	static volatile gsize font_manager_filter_data_type_id__once = 0;
	if (g_once_init_enter (&font_manager_filter_data_type_id__once)) {
		GType font_manager_filter_data_type_id;
		font_manager_filter_data_type_id = font_manager_filter_data_get_type_once ();
		g_once_init_leave (&font_manager_filter_data_type_id__once, font_manager_filter_data_type_id);
	}
	return font_manager_filter_data_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

GPtrArray*
font_manager_get_base_categories (void)
{
	GPtrArray* filters = NULL;
	GPtrArray* _tmp0_;
	const gchar* _tmp1_;
	FontManagerCategory* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FontManagerCategory* _tmp6_;
	FontManagerUserFonts* _tmp7_;
	GPtrArray* result;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	filters = _tmp0_;
	_tmp1_ = string_to_string (FONT_MANAGER_SELECT_FROM_FONTS);
	_tmp2_ = font_manager_category_new (_ ("All"), _ ("All Fonts"), "edit-select-all-symbolic", _tmp1_, (gint) FONT_MANAGER_CATEGORY_INDEX_ALL);
	g_ptr_array_add (filters, _tmp2_);
	_tmp3_ = string_to_string (FONT_MANAGER_SELECT_FROM_METADATA_WHERE);
	_tmp4_ = g_strconcat (_tmp3_, " owner!=0 AND filepath LIKE '/usr%';", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = font_manager_category_new (_ ("System"), _ ("Fonts available to all users"), "computer-symbolic", _tmp5_, (gint) FONT_MANAGER_CATEGORY_INDEX_SYSTEM);
	g_ptr_array_add (filters, _tmp6_);
	_g_free0 (_tmp5_);
	_tmp7_ = font_manager_user_fonts_new ();
	g_ptr_array_add (filters, (FontManagerCategory*) _tmp7_);
	result = filters;
	return result;
}

void
font_manager_get_default_categories (GTask* task,
                                     GObject* source,
                                     void* data,
                                     GCancellable* cancellable)
{
	FontManagerDatabase* db = NULL;
	FontManagerDatabase* _tmp0_;
	GPtrArray* filters = NULL;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	FontManagerCategory* _tmp3_;
	GPtrArray* _tmp12_;
	FontManagerUnsorted* _tmp13_;
	GPtrArray* _tmp14_;
	FontManagerDisabled* _tmp15_;
	GPtrArray* _tmp16_;
	FontManagerLanguageFilter* _tmp17_;
	GValue return_val = {0};
	GValue _tmp18_ = {0};
	GPtrArray* _tmp19_;
	GValue _tmp20_;
	g_return_if_fail (task != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = font_manager_database_proxy_get_default_db ();
	db = _tmp0_;
	_tmp1_ = font_manager_get_base_categories ();
	filters = _tmp1_;
	_tmp2_ = filters;
	_tmp3_ = font_manager_construct_panose_filter ();
	g_ptr_array_add (_tmp2_, _tmp3_);
	{
		FontManagerFilterData* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = FONT_MANAGER_attributes;
		entry_collection_length1 = G_N_ELEMENTS (FONT_MANAGER_attributes);
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			FontManagerFilterData entry = {0};
			entry = entry_collection[entry_it];
			{
				GPtrArray* _tmp4_;
				FontManagerDatabase* _tmp5_;
				FontManagerFilterData _tmp6_;
				FontManagerCategory* _tmp7_;
				_tmp4_ = filters;
				_tmp5_ = db;
				_tmp6_ = entry;
				_tmp7_ = font_manager_construct_attribute_filter (_tmp5_, &_tmp6_);
				g_ptr_array_add (_tmp4_, _tmp7_);
			}
		}
	}
	{
		FontManagerFilterData* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = FONT_MANAGER_metadata;
		entry_collection_length1 = G_N_ELEMENTS (FONT_MANAGER_metadata);
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			FontManagerFilterData entry = {0};
			entry = entry_collection[entry_it];
			{
				GPtrArray* _tmp8_;
				FontManagerDatabase* _tmp9_;
				FontManagerFilterData _tmp10_;
				FontManagerCategory* _tmp11_;
				_tmp8_ = filters;
				_tmp9_ = db;
				_tmp10_ = entry;
				_tmp11_ = font_manager_construct_info_filter (_tmp9_, &_tmp10_);
				g_ptr_array_add (_tmp8_, _tmp11_);
			}
		}
	}
	_tmp12_ = filters;
	_tmp13_ = font_manager_unsorted_new ();
	g_ptr_array_add (_tmp12_, (FontManagerCategory*) _tmp13_);
	_tmp14_ = filters;
	_tmp15_ = font_manager_disabled_new ();
	g_ptr_array_add (_tmp14_, (FontManagerCategory*) _tmp15_);
	_tmp16_ = filters;
	_tmp17_ = font_manager_language_filter_new ();
	g_ptr_array_add (_tmp16_, (FontManagerCategory*) _tmp17_);
	g_value_init (&_tmp18_, G_TYPE_PTR_ARRAY);
	return_val = _tmp18_;
	_tmp19_ = filters;
	g_value_set_boxed (&return_val, _tmp19_);
	_tmp20_ = return_val;
	g_task_return_value (task, &_tmp20_);
	G_IS_VALUE (&return_val) ? (g_value_unset (&return_val), NULL) : NULL;
	_g_ptr_array_unref0 (filters);
	_g_object_unref0 (db);
	return;
}

static void
__lambda35_ (FontManagerCategory* child)
{
	g_return_if_fail (child != NULL);
	font_manager_font_list_filter_set_depth ((FontManagerFontListFilter*) child, 1);
}

static void
___lambda35__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda35_ ((FontManagerCategory*) data);
}

FontManagerCategory*
font_manager_construct_panose_filter (void)
{
	FontManagerCategory* panose = NULL;
	FontManagerCategory* _tmp0_;
	gchar** kind = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint kind_length1;
	gint _kind_size_;
	FontManagerCategory* _tmp24_;
	GPtrArray* _tmp25_;
	GPtrArray* _tmp26_;
	FontManagerCategory* result;
	_tmp0_ = font_manager_category_new (_ ("Family Kind"), _ ("Only fonts which include Panose information will be grouped here."), "folder-symbolic", NULL, (gint) FONT_MANAGER_CATEGORY_INDEX_PANOSE);
	panose = _tmp0_;
	_tmp1_ = g_strdup (_ ("Any"));
	_tmp2_ = g_strdup (_ ("No Fit"));
	_tmp3_ = g_strdup (_ ("Text and Display"));
	_tmp4_ = g_strdup (_ ("Script"));
	_tmp5_ = g_strdup (_ ("Decorative"));
	_tmp6_ = g_strdup (_ ("Pictorial"));
	_tmp7_ = g_new0 (gchar*, 6 + 1);
	_tmp7_[0] = _tmp1_;
	_tmp7_[1] = _tmp2_;
	_tmp7_[2] = _tmp3_;
	_tmp7_[3] = _tmp4_;
	_tmp7_[4] = _tmp5_;
	_tmp7_[5] = _tmp6_;
	kind = _tmp7_;
	kind_length1 = 6;
	_kind_size_ = kind_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gchar** _tmp10_;
				gint _tmp10__length1;
				FontManagerCategory* _tmp11_;
				GPtrArray* _tmp12_;
				GPtrArray* _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				FontManagerCategory* _tmp23_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = kind;
				_tmp10__length1 = kind_length1;
				if (!(i < _tmp10__length1)) {
					break;
				}
				_tmp11_ = panose;
				_tmp12_ = font_manager_category_get_children (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = kind;
				_tmp14__length1 = kind_length1;
				_tmp15_ = _tmp14_[i];
				_tmp16_ = kind;
				_tmp16__length1 = kind_length1;
				_tmp17_ = _tmp16_[i];
				_tmp18_ = string_to_string (FONT_MANAGER_SELECT_FROM_PANOSE_WHERE);
				_tmp19_ = g_strdup_printf ("%i", i);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat (_tmp18_, " P0 = '", _tmp20_, "';", NULL);
				_tmp22_ = _tmp21_;
				_tmp23_ = font_manager_category_new (_tmp15_, _tmp17_, "emblem-documents-symbolic", _tmp22_, i);
				g_ptr_array_add (_tmp13_, _tmp23_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
			}
		}
	}
	_tmp24_ = panose;
	_tmp25_ = font_manager_category_get_children (_tmp24_);
	_tmp26_ = _tmp25_;
	g_ptr_array_foreach (_tmp26_, ___lambda35__gfunc, NULL);
	result = panose;
	kind = (_vala_array_free (kind, kind_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
__lambda36_ (FontManagerCategory* child)
{
	g_return_if_fail (child != NULL);
	font_manager_font_list_filter_set_depth ((FontManagerFontListFilter*) child, 1);
}

static void
___lambda36__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda36_ ((FontManagerCategory*) data);
}

FontManagerCategory*
font_manager_construct_attribute_filter (FontManagerDatabase* db,
                                         FontManagerFilterData* data)
{
	gchar* name = NULL;
	FontManagerFilterData _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* comment = NULL;
	FontManagerFilterData _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	FontManagerCategory* filter = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FontManagerFilterData _tmp8_;
	FontManagerCategory* _tmp9_;
	FontManagerCategory* _tmp63_;
	GPtrArray* _tmp64_;
	GPtrArray* _tmp65_;
	GError* _inner_error0_ = NULL;
	FontManagerCategory* result;
	g_return_val_if_fail (db != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (g_dgettext (NULL, _tmp1_));
	name = _tmp2_;
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.comment;
	_tmp5_ = g_strdup (g_dgettext (NULL, _tmp4_));
	comment = _tmp5_;
	_tmp6_ = name;
	_tmp7_ = comment;
	_tmp8_ = *data;
	_tmp9_ = font_manager_category_new (_tmp6_, _tmp7_, "folder-symbolic", NULL, _tmp8_.index);
	filter = _tmp9_;
	{
		gchar* keyword = NULL;
		FontManagerFilterData _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp10_ = *data;
		_tmp11_ = _tmp10_.column;
		_tmp12_ = g_strdup (_tmp11_);
		keyword = _tmp12_;
		_tmp13_ = keyword;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = keyword;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = g_strconcat ("SELECT DISTINCT ", _tmp14_, " FROM Fonts ORDER BY ", _tmp16_, ";", NULL);
		_tmp18_ = _tmp17_;
		font_manager_database_execute_query (db, _tmp18_, &_inner_error0_);
		_g_free0 (_tmp18_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (keyword);
			if (_inner_error0_->domain == FONT_MANAGER_DATABASE_ERROR) {
				goto __catch0_font_manager_database_error;
			}
			_g_object_unref0 (filter);
			_g_free0 (comment);
			_g_free0 (name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			FontManagerDatabaseIterator* _row_it = NULL;
			FontManagerDatabaseIterator* _tmp19_;
			_tmp19_ = font_manager_database_iterator (db);
			_row_it = _tmp19_;
			while (TRUE) {
				FontManagerDatabaseIterator* _tmp20_;
				sqlite3_stmt* row = NULL;
				FontManagerDatabaseIterator* _tmp21_;
				sqlite3_stmt* _tmp22_;
				gint val = 0;
				sqlite3_stmt* _tmp23_;
				gchar* type = NULL;
				const gchar* _tmp24_;
				const gchar* _tmp36_;
				FontManagerCategory* _tmp47_;
				GPtrArray* _tmp48_;
				GPtrArray* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				FontManagerFilterData _tmp59_;
				FontManagerCategory* _tmp60_;
				_tmp20_ = _row_it;
				if (!font_manager_database_iterator_next (_tmp20_)) {
					break;
				}
				_tmp21_ = _row_it;
				_tmp22_ = font_manager_database_iterator_get (_tmp21_);
				row = _tmp22_;
				_tmp23_ = row;
				val = sqlite3_column_int (_tmp23_, 0);
				type = NULL;
				_tmp24_ = keyword;
				if (g_strcmp0 (_tmp24_, "slant") == 0) {
					const gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp25_ = font_manager_slant_to_string ((FontManagerSlant) val);
					_tmp26_ = g_strdup (_tmp25_);
					_g_free0 (type);
					type = _tmp26_;
				} else {
					const gchar* _tmp27_;
					_tmp27_ = keyword;
					if (g_strcmp0 (_tmp27_, "spacing") == 0) {
						const gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp28_ = font_manager_spacing_to_string ((FontManagerSpacing) val);
						_tmp29_ = g_strdup (_tmp28_);
						_g_free0 (type);
						type = _tmp29_;
					} else {
						const gchar* _tmp30_;
						_tmp30_ = keyword;
						if (g_strcmp0 (_tmp30_, "weight") == 0) {
							const gchar* _tmp31_;
							gchar* _tmp32_;
							_tmp31_ = font_manager_weight_to_string ((FontManagerWeight) val);
							_tmp32_ = g_strdup (_tmp31_);
							_g_free0 (type);
							type = _tmp32_;
						} else {
							const gchar* _tmp33_;
							_tmp33_ = keyword;
							if (g_strcmp0 (_tmp33_, "width") == 0) {
								const gchar* _tmp34_;
								gchar* _tmp35_;
								_tmp34_ = font_manager_width_to_string ((FontManagerWidth) val);
								_tmp35_ = g_strdup (_tmp34_);
								_g_free0 (type);
								type = _tmp35_;
							}
						}
					}
				}
				_tmp36_ = type;
				if (_tmp36_ == NULL) {
					gboolean _tmp37_ = FALSE;
					const gchar* _tmp38_;
					_tmp38_ = keyword;
					if (g_strcmp0 (_tmp38_, "slant") == 0) {
						_tmp37_ = TRUE;
					} else {
						gboolean _tmp39_ = FALSE;
						const gchar* _tmp40_;
						_tmp40_ = keyword;
						if (g_strcmp0 (_tmp40_, "width") == 0) {
							_tmp39_ = font_manager_width_defined ((FontManagerWidth) val);
						} else {
							_tmp39_ = FALSE;
						}
						_tmp37_ = _tmp39_;
					}
					if (_tmp37_) {
						gchar* _tmp41_;
						_tmp41_ = g_strdup (_ ("Normal"));
						_g_free0 (type);
						type = _tmp41_;
					} else {
						gboolean _tmp42_ = FALSE;
						const gchar* _tmp43_;
						_tmp43_ = keyword;
						if (g_strcmp0 (_tmp43_, "width") == 0) {
							_tmp42_ = TRUE;
						} else {
							gboolean _tmp44_ = FALSE;
							const gchar* _tmp45_;
							_tmp45_ = keyword;
							if (g_strcmp0 (_tmp45_, "weight") == 0) {
								_tmp44_ = !font_manager_weight_defined ((FontManagerWeight) val);
							} else {
								_tmp44_ = FALSE;
							}
							_tmp42_ = _tmp44_;
						}
						if (_tmp42_) {
							_g_free0 (type);
							continue;
						} else {
							gchar* _tmp46_;
							_tmp46_ = g_strdup (_ ("Regular"));
							_g_free0 (type);
							type = _tmp46_;
						}
					}
				}
				_tmp47_ = filter;
				_tmp48_ = font_manager_category_get_children (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = type;
				_tmp51_ = type;
				_tmp52_ = string_to_string (FONT_MANAGER_SELECT_FROM_FONTS);
				_tmp53_ = keyword;
				_tmp54_ = string_to_string (_tmp53_);
				_tmp55_ = g_strdup_printf ("%i", val);
				_tmp56_ = _tmp55_;
				_tmp57_ = g_strconcat (_tmp52_, " WHERE ", _tmp54_, "='", _tmp56_, "';", NULL);
				_tmp58_ = _tmp57_;
				_tmp59_ = *data;
				_tmp60_ = font_manager_category_new (_tmp50_, _tmp51_, "emblem-documents-symbolic", _tmp58_, _tmp59_.index);
				g_ptr_array_add (_tmp49_, _tmp60_);
				_g_free0 (_tmp58_);
				_g_free0 (_tmp56_);
				_g_free0 (type);
			}
			_g_object_unref0 (_row_it);
		}
		font_manager_database_end_query (db);
		_g_free0 (keyword);
	}
	goto __finally0;
	__catch0_font_manager_database_error:
	{
		GError* e = NULL;
		GError* _tmp61_;
		const gchar* _tmp62_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp61_ = e;
		_tmp62_ = _tmp61_->message;
		g_warning ("Categories.vala:336: %s", _tmp62_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (filter);
		_g_free0 (comment);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp63_ = filter;
	_tmp64_ = font_manager_category_get_children (_tmp63_);
	_tmp65_ = _tmp64_;
	g_ptr_array_foreach (_tmp65_, ___lambda36__gfunc, NULL);
	result = filter;
	_g_free0 (comment);
	_g_free0 (name);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
__lambda37_ (FontManagerCategory* child)
{
	g_return_if_fail (child != NULL);
	font_manager_font_list_filter_set_depth ((FontManagerFontListFilter*) child, 1);
}

static void
___lambda37__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda37_ ((FontManagerCategory*) data);
}

FontManagerCategory*
font_manager_construct_info_filter (FontManagerDatabase* db,
                                    FontManagerFilterData* data)
{
	gchar* keyword = NULL;
	FontManagerFilterData _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* name = NULL;
	FontManagerFilterData _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* comment = NULL;
	FontManagerFilterData _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	FontManagerCategory* filter = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	FontManagerFilterData _tmp14_;
	FontManagerCategory* _tmp15_;
	FontManagerCategory* _tmp47_;
	GPtrArray* _tmp48_;
	GPtrArray* _tmp49_;
	GError* _inner_error0_ = NULL;
	FontManagerCategory* result;
	g_return_val_if_fail (db != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.column;
	_tmp2_ = string_replace (_tmp1_, "\"", "\\\"");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "'", "''");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	keyword = _tmp5_;
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.name;
	_tmp8_ = g_strdup (g_dgettext (NULL, _tmp7_));
	name = _tmp8_;
	_tmp9_ = *data;
	_tmp10_ = _tmp9_.comment;
	_tmp11_ = g_strdup (g_dgettext (NULL, _tmp10_));
	comment = _tmp11_;
	_tmp12_ = name;
	_tmp13_ = comment;
	_tmp14_ = *data;
	_tmp15_ = font_manager_category_new (_tmp12_, _tmp13_, "folder-symbolic", NULL, _tmp14_.index);
	filter = _tmp15_;
	{
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp16_ = keyword;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = keyword;
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat ("SELECT DISTINCT [", _tmp17_, "] FROM Metadata ORDER BY [", _tmp19_, "];", NULL);
		_tmp21_ = _tmp20_;
		font_manager_database_execute_query (db, _tmp21_, &_inner_error0_);
		_g_free0 (_tmp21_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == FONT_MANAGER_DATABASE_ERROR) {
				goto __catch0_font_manager_database_error;
			}
			_g_object_unref0 (filter);
			_g_free0 (comment);
			_g_free0 (name);
			_g_free0 (keyword);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			FontManagerDatabaseIterator* _row_it = NULL;
			FontManagerDatabaseIterator* _tmp22_;
			_tmp22_ = font_manager_database_iterator (db);
			_row_it = _tmp22_;
			while (TRUE) {
				FontManagerDatabaseIterator* _tmp23_;
				sqlite3_stmt* row = NULL;
				FontManagerDatabaseIterator* _tmp24_;
				sqlite3_stmt* _tmp25_;
				gchar* _type = NULL;
				sqlite3_stmt* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* type = NULL;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				FontManagerCategory* _tmp31_;
				GPtrArray* _tmp32_;
				GPtrArray* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				FontManagerFilterData _tmp43_;
				FontManagerCategory* _tmp44_;
				_tmp23_ = _row_it;
				if (!font_manager_database_iterator_next (_tmp23_)) {
					break;
				}
				_tmp24_ = _row_it;
				_tmp25_ = font_manager_database_iterator_get (_tmp24_);
				row = _tmp25_;
				_tmp26_ = row;
				_tmp27_ = (const gchar*) sqlite3_column_text (_tmp26_, 0);
				_tmp28_ = g_strdup (_tmp27_);
				_type = _tmp28_;
				_tmp29_ = _type;
				_tmp30_ = g_strdup (g_dgettext (NULL, _tmp29_));
				type = _tmp30_;
				_tmp31_ = filter;
				_tmp32_ = font_manager_category_get_children (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = type;
				_tmp35_ = type;
				_tmp36_ = string_to_string (FONT_MANAGER_SELECT_FROM_METADATA_WHERE);
				_tmp37_ = keyword;
				_tmp38_ = string_to_string (_tmp37_);
				_tmp39_ = _type;
				_tmp40_ = string_to_string (_tmp39_);
				_tmp41_ = g_strconcat (_tmp36_, " [", _tmp38_, "]='", _tmp40_, "';", NULL);
				_tmp42_ = _tmp41_;
				_tmp43_ = *data;
				_tmp44_ = font_manager_category_new (_tmp34_, _tmp35_, "emblem-documents", _tmp42_, _tmp43_.index);
				g_ptr_array_add (_tmp33_, _tmp44_);
				_g_free0 (_tmp42_);
				_g_free0 (type);
				_g_free0 (_type);
			}
			_g_object_unref0 (_row_it);
		}
		font_manager_database_end_query (db);
	}
	goto __finally0;
	__catch0_font_manager_database_error:
	{
		GError* e = NULL;
		GError* _tmp45_;
		const gchar* _tmp46_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp45_ = e;
		_tmp46_ = _tmp45_->message;
		g_warning ("Categories.vala:356: %s", _tmp46_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (filter);
		_g_free0 (comment);
		_g_free0 (name);
		_g_free0 (keyword);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp47_ = filter;
	_tmp48_ = font_manager_category_get_children (_tmp47_);
	_tmp49_ = _tmp48_;
	g_ptr_array_foreach (_tmp49_, ___lambda37__gfunc, NULL);
	result = filter;
	_g_free0 (comment);
	_g_free0 (name);
	_g_free0 (keyword);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

